package ctscore.web.controller.cart;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import jd.api.request.order.JdOrderIdEntity;
import jd.api.request.product.MessageDelEntity;
import jd.api.request.product.MessageTypeEntity;
import sinomall.global.common.vo.outsideapi.OrderCancelOrderResp;
import jd.api.service.order.JdOrderApi;
import jd.api.service.product.JdProductApi;
import jd.api.vo.product.MessageGetVO;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;
import java.util.Map;

/**
 * Created by xujingfeng on 2016/12/27.
 */
@Controller
public class OrderAdminController {

    @MotanReferer
    JdOrderApi jdOrderApi;
    @MotanReferer
    JdProductApi jdProductApi;

    /**
     * 查询订单详情
     * @param orderId
     * @return
     */
    @RequestMapping("/orderMain.json")
    @ResponseBody
    public Map getOrderJson(String orderId){
        Map<String, Object> orderMainMap = jdOrderApi.queryOrder(new JdOrderIdEntity(Long.parseLong(orderId)));
        return orderMainMap;
    }


    /**
     * 取消预占库存
     * @param cancelOrderId
     * @return
     */
    @RequestMapping("/cancelOrder.json")
    @ResponseBody
    public OrderCancelOrderResp cancelOrder(String cancelOrderId){
        OrderCancelOrderResp orderCancelOrderResp = jdOrderApi.cancelOrder(new JdOrderIdEntity(Long.parseLong(cancelOrderId)));
        return orderCancelOrderResp;
    }

    @RequestMapping("/getMessage/{type}")
    @ResponseBody
    public List<MessageGetVO> getMessage(@PathVariable String type){
        List<MessageGetVO> message = jdProductApi.getMessage(new MessageTypeEntity(type));
        return message;
    }

    @RequestMapping("/delMessage/{id}")
    @ResponseBody
    public Boolean getMessage(@PathVariable Long id){
        Boolean aBoolean = jdProductApi.delMessage(new MessageDelEntity(id));
        return aBoolean;
    }



}
