package ctscore.web.controller.cart;


import activities.api.ActivityApi;
import activities.api.ActivityConfigurationApi;
import activities.api.ActivityGoodsApi;
import activities.dto.modeldto.ActivityDefinitionDto;
import cart.api.CartApi;
import cart.api.CartItemApi;
import cart.api.OrderMainApi;
import cart.api.PaymentApi;
import cart.api.dto.order.OrderItemDto;
import cart.api.dto.order.OrderMainDto;
import cart.api.dto.payment.PaymentConfigDto;
import cart.api.dto.payment.PaymentDto;
import cart.api.vo.*;
import cms.api.OrganizationApi;
import cms.api.dto.OrgAccountCtrlHistoryDto;
import cms.api.dto.OrganizationDto;
import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import ctscore.api.CtScoreApi;
import ctscore.web.config.BaseAction;
import ctscore.web.service.cart.service.CartWebService;
import ctscore.web.service.cart.service.OrderWebService;
import ctscore.web.service.login.LoginService;
import ctscore.web.service.member.ScoreUserService;
import ctscore.web.vo.SpecificationsVo;
import goods.api.GoodsApi;
import goods.api.GoodsConfigApi;
import goods.api.ProductFashionApi;
import goods.dto.goods.GoodsDto;
import goods.model.ProductFashion;
import goods.model.ProductFashionSpecification;
import goods.model.ProductStandard;
import goods.model.repository.ProductFashionRepos;
import lombok.extern.slf4j.Slf4j;
import ma.glasnost.orika.MapperFacade;
import member.api.AddressCommonApi;
import member.api.MemberAddressApi;
import member.api.MemberInvoinceApi;
import member.api.dto.core.CoreUserDto;
import member.api.dto.shop.MemberAddressDto;
import member.api.vo.MemberVo;
import message.api.Dto.VerifyCodeDto;
import message.api.sms.SmsApi;
import message.api.sms.vo.SmsReq;
import message.api.sms.vo.SmsRsp;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import outsideapi.vo.FashionStockStateVo;
import score.api.ScoreApi;
import score.api.definition.ScoreBusinessType;
import score.api.dto.entitydto.ScoreAccountDTO;
import score.api.dto.requestdto.ScoreExpenseDetailRequestDTO;
import sinomall.config.api.base.BaseResponse;
import store.api.StoreApi;
import store.api.dto.modeldto.core.StoreDto;
import store.api.dto.modeldto.core.StoreExtDto;
import utils.GlobalContants;
import utils.Lang;
import utils.data.BeanMapper;
import utils.data.Jsons;
import utils.date.DateUtils;
import utils.lock.RedisLockUtil;
import utils.rpc.motan.ApiResponseVo;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.math.BigDecimal;
import java.util.*;

/**
 * Created by Liang Wenxu on 2016/11/10.
 */
@Slf4j
@Controller
@RequestMapping("/order")
public class OrderController extends BaseAction {

    @MotanReferer
    StoreApi storeApi;
    @Autowired
    RedisLockUtil redisLockUtil;
    @Value("${ctscore.storeCode:}")
    String storeCode;
    @Value("${spring.profiles.active:}")
    private String activeEnv;

    @Value("${ctscore.score.proportion}")
    private BigDecimal scorePortion;//积分比例

    @Value("${ctscore.orgCode}")
    private String organizationCode; // 合作企业代码
    @Autowired
    ScoreUserService scoreUserService;

    @MotanReferer
    ActivityConfigurationApi activityConfigurationApi;

    @MotanReferer
    ActivityGoodsApi activityGoodsApi;

    @MotanReferer
    ActivityApi activityApi;

    @MotanReferer
    ScoreApi scoreApi;

    @Autowired
    LoginService loginService;
    @MotanReferer
    CtScoreApi ctScoreApi;
    @MotanReferer
    GoodsApi goodsApi;

    @Value("${moon-festival.activityCode}")
    String moonFestivalActivityCode;

    @Value("${secKillActivity.activityCode}")
    String secKillActivityCode;

    @Value("${tuanGouActivity.activityCode}")
    String tuanGouActivityCode;

    //ctscore 个人中心 我的商品 url
    @Value("${itaiping.usercenter.goods}")
    private String itaipingUserCenterGoods;

    //ctscore 个人中心 订单详情 url
    @Value("${itaiping.usercenter.order}")
    private String itaipingUserCenterOrder;

    @Value("${ctscore.score.proportion}")
    private String itaipingScoreProportion;

    public static final String MOBILE_SERVICE_ID = "ChengTong_SubmitOrder";//诚通积分商城

    @MotanReferer
    private GoodsConfigApi goodsConfigApi;


    /**
     * 创建临时订单
     *
     * @param request
     * @param model
     * @return
     */
    @RequestMapping(value = {"/newOrder", "/newOrder.json", "/newOrder.html"}, method = RequestMethod.POST)
    @ResponseBody
    public Map newOrder(Map model, HttpServletRequest request) {
        long methodStartTime = System.currentTimeMillis();
        log.info("### 开始创建临时订单 ... ###");
        HashMap<String, Object> rsMap = new HashMap<String, Object>();
        rsMap.put(GlobalContants.ResponseString.STATUS, GlobalContants.ResponseStatus.SUCCESS);
        rsMap.put("data", null);
        rsMap.put(GlobalContants.ResponseString.MESSAGE, "suc");
        // 使用购购物车商品生成订单
        String cartItemIdsStr = request.getParameter("cartItemIds");
        // 使用ProductFashion直接生成订单，多个productFashionId用","隔开
        String productFashionIdStr = request.getParameter("productFashionIds");
        // 当productFashionIds传值时有效，多个productFashionId时，需对应id的顺序用","隔开多个数量
        String countsStr = request.getParameter("counts");
        String areaCode = request.getParameter("areaCode");
        String goodsId = request.getParameter("goodsId");

        long organizationTime = System.currentTimeMillis();
        String organizationId = organizationApi.findOrganizationIdByOrgCode(organizationCode);
        log.info("查询机构信息耗时 {} ms", System.currentTimeMillis() - organizationTime);

        TempOrderVo tempOrder = null;

        long memberVoTime = System.currentTimeMillis();
        MemberVo memberVo = loginService.findMemberVo(request);
        log.info("获取 memberVo 耗时 {} ms", System.currentTimeMillis() - memberVoTime);

        if (!Lang.isEmpty(productFashionIdStr) && !Lang.isEmpty(countsStr)) {
            /** 使用productFashion直接生成临时订单 */
            String[] productFashionIds = productFashionIdStr.split(",");
            String[] buyCounts = countsStr.split(",");
            String[] goodsIds = goodsId.split(",");

            if(!Lang.isEmpty(goodsId)) {
                boolean isUp = goodsConfigApi.isUpGoodsIds(Arrays.asList(goodsIds), organizationCode);
                if (!isUp) {
                    rsMap.put(GlobalContants.ResponseString.STATUS, GlobalContants.ResponseStatus.ERROR);
                    rsMap.put(GlobalContants.ResponseString.ERROR_CODE, "DOWN");
                    rsMap.put(GlobalContants.ResponseString.MESSAGE, "商品已下架");
                    return rsMap;
                }
            }

            List<FashionDetailVo> fashionDetailVoList = new ArrayList<>();
            List<String> fashionIdList = new ArrayList<>();
            List<Integer> fashionCountList = new ArrayList<>();
            for (int i = 0; i < productFashionIds.length; i++) {
                if (!Lang.isEmpty(productFashionIds[i])) {
                    fashionIdList.add(productFashionIds[i].trim());
                    fashionCountList.add(Integer.parseInt(buyCounts[i]));
                    fashionDetailVoList.add(new FashionDetailVo(productFashionIds[i].trim(), goodsIds[i].trim(), Integer.parseInt(buyCounts[i])));
                }
            }

            /** 查询库存状态 */
            Long checkItemStockStatusTimer = System.currentTimeMillis();
            Map stockQueyrRes = productFashionApi.queryFashionStockStatus(mapperFacade.mapAsList(fashionDetailVoList, goods.vo.FashionIdAndCountVo.class), areaCode, organizationId);
            log.info("检查购物车商品库存耗时 {} ms", System.currentTimeMillis() - checkItemStockStatusTimer);

            boolean noStockFlag = true; // 包含无库存状态商品标志
            if (GlobalContants.ResponseStatus.SUCCESS.equals((String) stockQueyrRes.get(GlobalContants.ResponseString.STATUS))) {
                noStockFlag = noStockFlag && (Boolean) ((Map) stockQueyrRes.get(GlobalContants.ResponseString.DATA)).get("noStockFlag");
            } else {
                noStockFlag = noStockFlag && false;
            }

            boolean activityStockCheck = true;

            if (!noStockFlag) {
                Long newTempOrderByCartItemsTimer = System.currentTimeMillis();
                tempOrder = orderMainApi.newTempOrderByFasions(fashionDetailVoList, organizationCode, areaCode);
                log.info("生成临时订单耗时 {} 秒", (System.currentTimeMillis() - newTempOrderByCartItemsTimer) / 1000.0);

                //检查活动库存
                for (TempOrderStoreVo tempOrderStoreVo : tempOrder.getStoreList()) {
                    for (TempOrderItemVo tempOrderItemVo : tempOrderStoreVo.getOrderItems()) {
                        if (!Lang.isEmpty(tempOrderItemVo.getActivityId())) {
                            long activityDefinitionTime = System.currentTimeMillis();
                            ActivityDefinitionDto activityDefinition = activityApi.findById(tempOrderItemVo.getActivityId());
                            if(moonFestivalActivityCode.equals(activityDefinition.getActivityCode())) {
                                tempOrderItemVo.setActivityId(null);
                                continue;
                            }
                            log.info("查询活动场次耗时 {} ms", System.currentTimeMillis() - activityDefinitionTime);

                            int stock = activityGoodsApi.getCurrentActivityGoodsStockFromCache(organizationCode, tempOrderItemVo.getGoodsId(), tempOrderItemVo.getActivityId(), activityDefinition.getActivityCode());
                            Date now = new Date();
                            if (now.before(activityDefinition.getBeginTime()) || now.after(activityDefinition.getEndTime())) {
                                /** 错误5，不在活动时限内 */
                                request.getSession().removeAttribute(GlobalContants.ORDER_TEMP_ID);
                                rsMap.put(GlobalContants.ResponseString.STATUS, GlobalContants.ResponseStatus.ERROR);
                                rsMap.put(GlobalContants.ResponseString.ERROR_CODE, 5);
                                rsMap.put(GlobalContants.ResponseString.MESSAGE, "不在活动时限内!");
                                return rsMap;
                            }

                            /** 错误6，秒杀商品限购 */
                            if (secKillActivityCode.equals(activityDefinition.getActivityCode())) {
                                if (tempOrderItemVo.getCount() > 1) {
                                    request.getSession().removeAttribute(GlobalContants.ORDER_TEMP_ID);
                                    rsMap.put(GlobalContants.ResponseString.STATUS, GlobalContants.ResponseStatus.ERROR);
                                    rsMap.put(GlobalContants.ResponseString.ERROR_CODE, 6);
                                    rsMap.put(GlobalContants.ResponseString.MESSAGE, "对不起，该商品限购1件，请调整您的购买数量，谢谢!");
                                    return rsMap;
                                }
                            }

                            if (stock - tempOrderItemVo.getCount() < 0) {
                                activityStockCheck = false;
                                break;
                            }
                        }
                    }

                }
            }

            if (activityStockCheck && !noStockFlag) {
                tempOrder.setRealOrganizationId(organizationId);
                request.getSession().setAttribute(GlobalContants.TEMP_ORDER_SESSION_KEY_PREFIX + tempOrder.getTmpOrderNo(), JSON.toJSONString(tempOrder));
                request.getSession().setAttribute(GlobalContants.ORDER_TEMP_ID, tempOrder.getTmpOrderNo());
                Map resData = new HashMap<String, Object>();
                resData.put("orderTmpId", tempOrder.getTmpOrderNo());
                rsMap.put("data", resData);
            } else {
                /** 错误3，库存出错 */
                request.getSession().removeAttribute(GlobalContants.ORDER_TEMP_ID);
                rsMap.put(GlobalContants.ResponseString.STATUS, GlobalContants.ResponseStatus.ERROR);
                rsMap.put(GlobalContants.ResponseString.ERROR_CODE, 3);
                rsMap.put(GlobalContants.ResponseString.MESSAGE, "Overed Stock!");
            }
        } else if (!Lang.isEmpty(cartItemIdsStr)) {
            /** 从购物车生成临时订单 */

            if (memberVo != null) {

                /** 保存已选商品 */
                String[] cartItemIdsArr = cartItemIdsStr.split(",");
                List<String> cartItemIds = null;
                if (!Lang.isEmpty(cartItemIdsArr)) {
                    cartItemIds = Arrays.asList(cartItemIdsArr);
                }

                Long checkItemStockStatusTimer = System.currentTimeMillis();
                Map apiRes = cartApi.cartItemStockStatus(cartItemIds, areaCode);
                log.info("检查购物车商品库存耗时 {} ms", System.currentTimeMillis() - checkItemStockStatusTimer);

                boolean stockFlag = true; // 库存状态
                if (GlobalContants.ResponseStatus.SUCCESS.equals((String) apiRes.get(GlobalContants.ResponseString.STATUS))) {
                    List<Map> dataList = (List<Map>) apiRes.get(GlobalContants.ResponseString.DATA);
                    for (Map d : dataList) {
                        if (Lang.isEmpty(d.get("onSale"))) {
                            d.put("onSale", false);
                        }
                        if (Lang.isEmpty(d.get("stockFlag"))) {
                            d.put("stockFlag", FashionStockStateVo.STOCK_FLAG_NO_STOCK);
                        }

                        if (!((Boolean) d.get("onSale")) || (Integer) d.get("stockFlag") != FashionStockStateVo.STOCK_FLAG_HAS_STOCK) {
                            stockFlag = false;
                        }
                    }
                } else {
                    stockFlag = false;
                }

                if (stockFlag) {
                    Long newTempOrderByCartItemsTimer = System.currentTimeMillis();
                    tempOrder = orderMainApi.newTempOrderByCartItems(cartItemIds, memberVo.getUser().getId(), organizationCode, areaCode);
                    log.info("生成临时订单耗时 {} ms", System.currentTimeMillis() - newTempOrderByCartItemsTimer);

                    tempOrder.setRealOrganizationId(organizationId);
                    request.getSession().setAttribute(GlobalContants.TEMP_ORDER_SESSION_KEY_PREFIX + tempOrder.getTmpOrderNo(), JSON.toJSONString(tempOrder));
                    request.getSession().setAttribute(GlobalContants.ORDER_TEMP_ID, tempOrder.getTmpOrderNo());
                    Map resData = new HashMap<String, Object>();
                    resData.put("orderTmpId", tempOrder.getTmpOrderNo());
                    rsMap.put("data", resData);
                } else {
                    request.getSession().removeAttribute(GlobalContants.ORDER_TEMP_ID);

                    /** 错误3，库存出错 */
                    rsMap.put(GlobalContants.ResponseString.STATUS, GlobalContants.ResponseStatus.ERROR);
                    rsMap.put(GlobalContants.ResponseString.ERROR_CODE, 3);
                    rsMap.put(GlobalContants.ResponseString.MESSAGE, "Overed Stock!");
                }


            } else {
                /** 错误2，获取登录用户失败 */
                rsMap.put(GlobalContants.ResponseString.STATUS, GlobalContants.ResponseStatus.ERROR);
                rsMap.put(GlobalContants.ResponseString.ERROR_CODE, 2);
                rsMap.put(GlobalContants.ResponseString.MESSAGE, "Member Not Found!");
            }
        } else {
            /** 错误1，未提交选择的购物车商品 */
            rsMap.put(GlobalContants.ResponseString.STATUS, GlobalContants.ResponseStatus.ERROR);
            rsMap.put(GlobalContants.ResponseString.ERROR_CODE, 1);
            rsMap.put(GlobalContants.ResponseString.MESSAGE, "Required Paramter cartItemIds Is Empty!");
        }

        log.info("### 创建临时订单总耗时 {} ms ###", System.currentTimeMillis() - methodStartTime);
        return rsMap;
    }

    /**
     * 加载商品规格属性
     *
     * @param tempOrder 临时订单
     */
    private Map<String, List<SpecificationsVo>> getSpecificationMap(TempOrderVo tempOrder) {
        Map<String, List<SpecificationsVo>> specificationsMap = new HashMap<>();
        // 遍历店铺
        for (TempOrderStoreVo tempOrderStoreVo : tempOrder.getStoreList()) {
            // 遍历商品
            for (TempOrderItemVo tempOrderItemVo : tempOrderStoreVo.getOrderItems()) {
                // 获得商品规格
                ProductFashion productFashion = productFashionRepos.findOne(tempOrderItemVo.getProductFashionId());
                // 商品规格可能为空
                if (!Lang.isEmpty(productFashion.getProductFashionSpecifications())) {
                    List<SpecificationsVo> specificationsVos = new ArrayList<>();
                    if (!Lang.isEmpty(productFashion.getProduct().getProductStandards())) {
                        // 排序
                        productFashion.getProduct().getProductStandards().sort((productStandard1, productStandard2) -> {
                            if (Lang.isEmpty(productStandard1) || Lang.isEmpty(productStandard1.getShowIndex())) {
                                return -1;
                            }
                            if (Lang.isEmpty(productStandard2) || Lang.isEmpty(productStandard2.getShowIndex())) {
                                return 1;
                            }
                            return productStandard1.getShowIndex() > productStandard2.getShowIndex() ? 1 : -1;
                        });

                        for (ProductStandard productStandard : productFashion.getProduct().getProductStandards()) {
                            // 找到有效规格数据
                            for (ProductFashionSpecification productFashionSpecification : productFashion.getProductFashionSpecifications()) {
                                // 根据规格CODE找到显示名称
                                if (!Lang.isEmpty(productFashion.getProduct()) && !Lang.isEmpty(productFashion.getProduct().getProductStandards())) {
                                    if (!Lang.isEmpty(productFashionSpecification.getIsDelete()) && !productFashionSpecification.getIsDelete()) {
                                        if (!productStandard.getIsDelete() && productStandard.getStandardCode().equals(productFashionSpecification.getStandardCode())) {
                                            SpecificationsVo specificationsVo = new SpecificationsVo(productStandard.getName(), productFashionSpecification.getValue());
                                            specificationsVos.add(specificationsVo);
                                            break;
                                        }
                                    }
                                }
                            }
                        }
                    }
                    specificationsMap.put(tempOrderItemVo.getGoodsId(), specificationsVos);
                }
            }
        }
        return specificationsMap;
    }

    /**
     * 临时订单展示
     *
     * @param request
     * @param model
     * @return
     */
    @RequestMapping(value = {"/orderInfo", "/orderInfo.action", "/orderInfo.html"})
    public String orderInfo(Map model, HttpServletRequest request, HttpServletResponse response) {
        String orderTmpId = request.getParameter("rid");
        String callBack = request.getParameter("callBack");
        MemberVo memberVo = loginService.findMemberVo(request);
        model.put("error", 1);
        List<Map<String, Object>> tmpCartItems = null;
        boolean toOrderFlag = false; // 直接跳转订单标志
        if (memberVo != null) {
            /** 从Session获取暂存订单 */
            String tempOrderSessionKey = GlobalContants.TEMP_ORDER_SESSION_KEY_PREFIX + orderTmpId;
            String tempOrderJson = (String) request.getSession().getAttribute(tempOrderSessionKey);
            if (Lang.isEmpty(tempOrderJson)) {
                /** 错误1，获取已保存临时订单数据出错 */
                model.put("error", 1);
                model.put("message", "REC_NOT_FOUND");
            } else {
                TempOrderVo tempOrderVo = JSON.parseObject(tempOrderJson, TempOrderVo.class);
                List<MemberAddressDto> memberAddressList = memberAddressApi.list(memberVo.getMember().getId());
                /** 用户地址 */
                model.put("memberAddressList", memberAddressList);
                /** 计算商品总价 */
                Double sumCartPrice = 0.00;
                /** 计算商品总数量 */
                Integer sumCartItemCount = 0;
                /** 获取客户默认的地址 */
                MemberAddressDto defAddr = null;
                if (memberAddressList != null) {
                    for (MemberAddressDto memberAddress : memberAddressList) {
                        if (memberAddress != null && memberAddress.getIsDefault() != null && memberAddress.getIsDefault()) {
                            defAddr = memberAddress;
                        }
                    }
                    defAddr = defAddr == null ? (memberAddressList.size() >= 1 ? memberAddressList.get(0) : null) : defAddr;
                }
                /** 运费 */
                Double shippingFee = 0.00;
                for (TempOrderStoreVo group : tempOrderVo.getStoreList()) {
                    for (TempOrderItemVo item : group.getOrderItems()) {
                        /**Akers 2017/2/28修改： 显示总价重新计算合计，防止进位导致显示错误 START */
//                        sumCartPrice += item.getSumSalePrice().doubleValue();
                        //活动商品价格处理
                        if (activityConfigurationApi.isInActivity(organizationCode)) {
                            GoodsDto goods = goodsApi.findById(item.getGoodsId());
                            Map<String, Object> activityPrice = activityGoodsApi.isActivityGoodsAndGetActivityPrice(mapperFacade.map(goods, activities.dto.goods.GoodsDto.class), organizationCode);
                            if ((Boolean) activityPrice.get("isActivityGoods")) {
                                item.setSalePrice((BigDecimal) activityPrice.get("activityPrice"));
                            }
                        }
                        item.setSalePrice(item.getSalePrice().setScale(2, BigDecimal.ROUND_UP));
                        sumCartPrice += item.getSalePrice().multiply(BigDecimal.valueOf(item.getCount())).doubleValue();
                        /**Akers 2017/2/28修改： 显示总价重新计算合计，防止进位导致显示错误 END */
//                        sumCartPrice += item.getProductFashion().getSalePrice().doubleValue() * item.getCount();
                        sumCartItemCount++;

                        //活动场次ID不为空，检查秒杀与团购
                        if (!Lang.isEmpty(item.getActivityId())) {
                            ActivityDefinitionDto activityDefinition = activityApi.findById(item.getActivityId());
                            if (!Lang.isEmpty(activityDefinition)) {
                                if (secKillActivityCode.equals(activityDefinition.getActivityCode())) {
                                    log.info("___秒杀活动商品___ 场次ID: {}", item.getActivityId());
                                    //秒杀商品，页面积分抵扣特殊处理标记
                                    // 20180130 诚通允许秒杀积分支付
                                    //model.put("userScoreForbidden", true);
                                    //免运费
                                    tempOrderVo.setFreeShippingFee(true);
                                }
                                if (tuanGouActivityCode.equals(activityDefinition.getActivityCode())) {
                                    log.info("___团购活动商品___ 场次ID: {}", item.getActivityId());
                                    //免运费
                                    tempOrderVo.setFreeShippingFee(true);
                                }
                            }
                        } else {
                            log.info("___非活动商品___");
                        }
                    }
                    /** 获取运费 */
//                 /**注释原因： 积分商城暂时不计算运费 */
                    BigDecimal fee = BigDecimal.ZERO;
                    if (defAddr != null) {
                        fee = orderWebService.queryShippingFee(group.getStoreId(), group.getOrderItems(), defAddr.getId());
                    } else {
                        fee = orderWebService.queryShippingFee(group.getStoreId(), group.getOrderItems(), tempOrderVo.getAreaCode());
                    }
                    if (fee != null) {
                        shippingFee += fee.doubleValue();
                    }
                    group.setShippingFee(fee);
                }

                tempOrderVo.setSumShippingFee(new BigDecimal(shippingFee));
                try {
                    /**
                     * 计算用户 积分及待支付金额
                     */
                    calculateOrderScorePriceInfo(request, tempOrderSessionKey, tempOrderVo, new BigDecimal(shippingFee), new BigDecimal(sumCartPrice));
                    model.put("needPayPrice", tempOrderVo.getNeedPayPrice());
                    model.put("sumCartPrice", tempOrderVo.getSumPrice());
                    model.put("sumScore", tempOrderVo.getSumScore());
                    model.put("socrePrice", tempOrderVo.getSocrePrice());
                    if (tempOrderVo.getFreeShippingFee()) {
                        model.put("shippingFee", 0);
                    } else {
                        model.put("shippingFee", tempOrderVo.getSumShippingFee());
                    }
                    /** 登录用户的用户类型，用于判断可使用的支付方式 */
                    model.put("userType", memberVo.getUser().getUserType());
                    model.put("USER_TYPE_BUYER", CoreUserDto.USER_TYPE_BUYER);
                    model.put("USER_TYPE_MEMBER", CoreUserDto.USER_TYPE_MEMBER);
                    if (tempOrderVo.getStoreList().size() <= 0 || sumCartItemCount <= 0) {
                        /** 错误3，获取购物车商品失败 */
                        model.put("error", 3);
                        model.put("message", "CART_ITEMS_NOT_FOUND");
                    } else {
                        model.put("error", 0);
                    }
                    model.put("sumCartPrice", sumCartPrice);
                    model.put("sumGoodsCount", tempOrderVo.getSumGoodsCount());
                    model.put("sumCartItemCounts", tempOrderVo.getSumGoodsBuyCount());
//                model.put("cartItemGroups", cartItemGroups);
                    model.put("tempOrderVo", tempOrderVo);
                    //  model.put("usrCompany", memberVo.getUser().getCoreCompany());
                    model.put("rid", orderTmpId);
                    model.put("scorePortion", scorePortion);

                    // 2018-01-25 加载规格
                    Long getSpecificationTime = System.currentTimeMillis();
                    try {
                        Map<String, List<SpecificationsVo>> specificationsMap = getSpecificationMap(tempOrderVo);
                        model.put("specificationsMap", specificationsMap);
                    } catch (Exception e) {
                        log.error("加载规格参数异常", e, tempOrderVo);
                    }
                    log.info("加载规格参数耗时 {} ms", System.currentTimeMillis() - getSpecificationTime);

                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            /** 错误2，获取登录用户失败 */
            model.put("error", 2);
            model.put(GlobalContants.ResponseString.MESSAGE, "Member_Not_Found");
        }


        if (Lang.isEmpty(orderTmpId)) {
            /** 错误1，获取已保存临时订单数据出错 */
            model.put("error", 1);
            model.put("message", "REC_NOT_FOUND");
        }


        if (memberVo != null && memberVo.getUser() != null && !Lang.isEmpty(memberVo.getUser().getPhone())) {
            String phoneMask = memberVo.getUser().getPhone().substring(0, 3) + "****" + memberVo.getUser().getPhone().substring(7);
            model.put("phoneMask", phoneMask);
        }
        String email = memberVo.getUser().getEmail();
        model.put("email", email);
        model.put("callBack", callBack);
        return "cart/order/insuredOrderInfo";
    }

    /**
     * 计算刷新需支付金额
     *
     * @param request
     * @param tempOrderSessionKey
     * @param tempOrderVo
     * @param shippingFee
     * @param sumCartPrice
     */
    public void calculateOrderScorePriceInfo(HttpServletRequest request, String tempOrderSessionKey, TempOrderVo tempOrderVo, BigDecimal shippingFee, BigDecimal sumCartPrice) {
        BigDecimal proportion = new BigDecimal(itaipingScoreProportion);
        try {
//            JfVipGiftCountVo jfVipGiftCountVo = scoreApi.jfDetail((String) request.getSession().getAttribute(GlobalContants.PERIPHERY_THIRD_USER_ID));
//            Double usable = jfVipGiftCountVo.getUsable();
//            BigDecimal sumScore = new BigDecimal(usable);
            CoreUserDto coreUser = loginService.getSessionCoreUser(request);
            BigDecimal sumScore = scoreUserService.getUsebleScore(coreUser);
            BigDecimal totalPriceBigDecimal = sumCartPrice;
            if (!tempOrderVo.getFreeShippingFee()) { //非免运费
                totalPriceBigDecimal = sumCartPrice.add(shippingFee);
            }
            BigDecimal scorePrice = scoreUserService.roundScore(goodsApi.scorePriceTransform(sumScore, proportion, BigDecimal.ROUND_HALF_UP));
            BigDecimal userSumScore = scoreUserService.roundScore(goodsApi.priceScoreTransform(totalPriceBigDecimal, proportion, BigDecimal.ROUND_HALF_UP));
            BigDecimal needPayPrice = new BigDecimal(0);
            if (scorePrice.compareTo(totalPriceBigDecimal) < 0) {
                needPayPrice = totalPriceBigDecimal.subtract(scorePrice);
                userSumScore = sumScore;
            } else {
                scorePrice = totalPriceBigDecimal;
            }
            tempOrderVo.setSocrePrice(scorePrice);
            tempOrderVo.setNeedPayPrice(needPayPrice);
            tempOrderVo.setSumScore(userSumScore);
            tempOrderVo.setSumShippingFee(shippingFee);
            tempOrderVo.setSumPrice(sumCartPrice);
            request.getSession().setAttribute(tempOrderSessionKey, JSON.toJSONString(tempOrderVo));
        } catch (Exception e) {
            log.error("计算订单信息出错，tempOrderVo={}", JSON.toJSONString(tempOrderVo), e);
        }

    }


    /**
     * 生成订单
     *
     * @param request
     * @param model
     * @return
     */
    @RequestMapping(value = {"/orderSubmit", "/orderSubmit.action", "/orderSubmit.html"}, method = RequestMethod.POST)
    public String orderSubmit(OrderSubmitVo orderSubmitVo, Map model, HttpServletRequest request, RedirectAttributes attr) {
        long methodStartTime = System.currentTimeMillis();
        log.info("### 开始提交订单 ... ###");

        long memberVoTime = System.currentTimeMillis();
        MemberVo memberVo = loginService.findMemberVo(request);
        log.info("获取 memberVo 耗时 {} ms", System.currentTimeMillis() - memberVoTime);

        try {
            //同一用户排队下单
            redisLockUtil.lock(memberVo.getMember().getId());

            String orderTmpId = orderSubmitVo.getRid();
            String useScorePay = request.getParameter("useScorePay");   //获取是否使用积分支付标记
            String USE_SCORE_FOR_PAY = "1";
            String NO_USE_SCORE_FOR_PAY = "0";
            /**
             * useScorePay 0不使用积分 1使用积分
             */
            useScorePay = Lang.isEmpty(useScorePay) ? NO_USE_SCORE_FOR_PAY : useScorePay;
            String errorCode = "1";

            /** 防止表单重复提交，orderTmpId只能一次有效 */
            String rid = (String) request.getSession().getAttribute(GlobalContants.ORDER_TEMP_ID);
            log.info("rid is {}", rid);
            log.info("orderTmpId is {}", orderTmpId);
            log.info("session id{}", request.getSession().getId());
            if (!Lang.isEmpty(rid) && rid.equals(orderTmpId)) {
                log.info("before remove rid{}", (String) request.getSession().getAttribute(GlobalContants.ORDER_TEMP_ID));
                request.getSession().removeAttribute(GlobalContants.ORDER_TEMP_ID);
                log.info("after  remove rid{}", (String) request.getSession().getAttribute(GlobalContants.ORDER_TEMP_ID));
            } else {
                attr.addAttribute("error", errorCode);
                attr.addAttribute("message", "订单提交数据有误，请不要重复提交");
                return "redirect:/order/orderSubmitResult";
            }
            log.info("imcome submit order");
//        MemberAddressDto memberAddress = memberAddressApi.findById(orderSubmitVo.getAddressId());
            Map resMap = null;
            if (StringUtils.isNotBlank(orderTmpId)) {
                //创建订单，保存OrderMain
                TempOrderVo tempOrderVo = JSON.parseObject((String) request.getSession().getAttribute(GlobalContants.TEMP_ORDER_SESSION_KEY_PREFIX + rid), TempOrderVo.class);
                List<String> cartItemIds = new ArrayList<>();
                for (TempOrderStoreVo storeVo : tempOrderVo.getStoreList()) {
                    for (TempOrderItemVo itemVo : storeVo.getOrderItems()) {

                        if (!Lang.isEmpty(itemVo.getActivityId())) {
                            long activityDefinitionTime = System.currentTimeMillis();
                            ActivityDefinitionDto activityDefinition = activityApi.findById(itemVo.getActivityId());
                            log.info("查询活动场次耗时 {} ms", System.currentTimeMillis() - activityDefinitionTime);
                            if (!Lang.isEmpty(activityDefinition)) {
                                //秒杀商品
                                if (secKillActivityCode.equals(activityDefinition.getActivityCode())) {
                                    // 禁用积分抵扣
                                    //useScorePay = NO_USE_SCORE_FOR_PAY; 20180130 诚通允许秒杀积分抵扣
                                    // 超限检查
                                    long activityLimitedTime = System.currentTimeMillis();
                                    boolean activityLimited = activityGoodsApi.isActivityLimited(memberVo.getMember().getId(), itemVo.getActivityId(), 1);
                                    log.info("秒杀商品超限检查耗时 {} ms", System.currentTimeMillis() - activityLimitedTime);

                                    if (itemVo.getCount() > 1 || activityLimited) {
                                        model.put("error", GlobalContants.CREATE_ORDER_ERROR_ACTIVITY_LIMITED);
                                        attr.addAttribute("error", GlobalContants.CREATE_ORDER_ERROR_ACTIVITY_LIMITED);
                                        attr.addAttribute("message", "您已超限");
                                        return "redirect:/order/orderSubmitResult";
                                    }
                                }
                            }
                        }

                        if (!Lang.isEmpty(itemVo.getCartItemId())) {
                            cartItemIds.add(itemVo.getCartItemId());
                        }
                    }
                }
                List<String> orderMainsPaiedIds = new ArrayList<>();
                if (tempOrderVo != null) {
                    tempOrderVo.setUseScore(useScorePay);
                    if (tempOrderVo.getOrderAttrs() == null) {
                        tempOrderVo.setOrderAttrs(new ArrayList<>());
                    }
                    if (orderSubmitVo.getOrderAttrs() != null) {
                        tempOrderVo.setOrderAttrs(orderSubmitVo.getOrderAttrs());
                    }
                    /**
                     * 设置用户购买类型
                     * Roney add 20171016
                     * start
                     */
                    tempOrderVo.setBuyType(request);

                    /**
                     * 设置用户购买类型
                     * Roney add 20171016
                     * end
                     */
                    orderSubmitVo.setPayMethodCode(PaymentConfigDto.PAYMENT_CONFIG_CODE_ONLINE);

                    long createOrderTimer = System.currentTimeMillis();
                    resMap = orderMainApi.createOrder(tempOrderVo, memberAddressApi.findById(orderSubmitVo.getAddressId()).getId(), memberVo.getUser().getId(), memberVo.getMember().getId(), orderSubmitVo.getPayMethodCode());
                    log.info("创建正式订单耗时 {} ms, memberId {}, 结果 {}", System.currentTimeMillis() - createOrderTimer, memberVo.getMember().getId(), JSON.toJSONString(resMap));

                    if (!resMap.get(GlobalContants.ResponseString.STATUS).equals(GlobalContants.ResponseStatus.ERROR)) {
                        BigDecimal consumeeScore = scoreUserService.roundScore(new BigDecimal(0));
                        model.putAll(resMap);
                        Map resData = (Map) resMap.get("data");
                        if (Lang.isEmpty(resData)) {
                            attr.addAttribute("error", GlobalContants.CREATE_ORDER_ERROR_NEW_ORDER_FAIL);
                            attr.addAttribute("message", "下单失败");
                            return "redirect:/order/orderSubmitResult";
                        }

                        List<OrderMainDto> sucOrders = (List<OrderMainDto>) resData.get("sucOrderList");

                        StringBuilder orderNos = new StringBuilder();
                        if (!Lang.isEmpty(sucOrders)) {
                            for (int i = 0; i < sucOrders.size(); i++) {
                                orderNos.append(sucOrders.get(i).getOrderNo());
                                if (i < sucOrders.size() - 1) {
                                    orderNos.append(",");
                                }
                            }
                            attr.addAttribute("orderNo", orderNos.toString());
                        }

                        long makeOrderStatusNewTime = System.currentTimeMillis();
                        log.info("正在更新订单 {} 状态 ---> 新建", orderNos);
                        sucOrders.forEach(orderMainDto -> orderMainApi.updateOrderStatus(orderMainDto.getId(), OrderMainDto.order_status_neworder));
                        log.info("更新订单 {} 状态耗时 {} ms", orderNos, System.currentTimeMillis() - makeOrderStatusNewTime);

                        boolean isNeePay = true;
                        BigDecimal usableScore = null;
                        //使用积分支付
                        if (USE_SCORE_FOR_PAY.equals(useScorePay)) {
                            try {
                                CoreUserDto coreUser = loginService.getSessionCoreUser(request);
                                long usableScoreTime = System.currentTimeMillis();
                                usableScore = scoreUserService.getUsebleScore(coreUser);
                                log.info("获取用户可用积分耗时 {} ms, 订单号 {}, 用户积分 {}", System.currentTimeMillis() - usableScoreTime, orderNos, usableScore);

                                consumeeScore = scoreUserService.roundScore(tempOrderVo.getSumScore());
                                if (usableScore.compareTo(consumeeScore) < 0) {
                                    log.info("积分不足 订单号 {}, 用户积分 {}, 订单积分 {} ", orderNos, usableScore, tempOrderVo.getSumScore());
                                    //下单扣减积分前积分变少，比确认下单信息页的少
                                    attr.addAttribute("error", GlobalContants.CREATE_ORDER_ERROR_SCORE_NO_ENOUGH);
                                    attr.addAttribute("message", "剩余积分不足");
                                    for (int i = 0; i < sucOrders.size(); i++) {
                                        long updateOrderStatus = System.currentTimeMillis();
                                        orderMainApi.updateOrderStatus(sucOrders.get(i).getId(), OrderMainDto.order_status_error);
                                        log.info("更新订单状态耗时 {} ms, 订单号 {}, 状态 {} ", System.currentTimeMillis() - updateOrderStatus, sucOrders.get(i), OrderMainDto.order_status.get(OrderMainDto.order_status_error));
                                    }
                                    return "redirect:/order/orderSubmitResult";
                                }
                                if (tempOrderVo.getNeedPayPrice().compareTo(new BigDecimal(0)) == 0) {
                                    isNeePay = false;
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        long organizationTime = System.currentTimeMillis();
                        OrganizationDto organization = organizationApi.findOrganizationByOrgCode(organizationCode);
                        log.info("获取机构信息耗时 {} ms", System.currentTimeMillis() - organizationTime);

                        if (organization.getOrgScore().compareTo(consumeeScore) < 0) {
                            log.info("诚通企业积分余额不足");
                            attr.addAttribute("error", GlobalContants.CREATE_ORDER_ERROR_ORG_SCORE_NOT_ENOUHG);
                            attr.addAttribute("message", "企业积分不足");
                            for (int i = 0; i < sucOrders.size(); i++) {
                                long updateOrderStatus = System.currentTimeMillis();
                                orderMainApi.updateOrderStatus(sucOrders.get(i).getId(), OrderMainDto.order_status_error);
                                log.info("更新订单状态耗时 {} ms, 订单号 {}, 状态 {} ", System.currentTimeMillis() - updateOrderStatus, sucOrders.get(i), OrderMainDto.order_status.get(OrderMainDto.order_status_error));
                            }
                            return "redirect:/order/orderSubmitResult";
                        }

                        for (OrderMainDto orderMain : sucOrders) {
                            long storeTime = System.currentTimeMillis();
                            StoreDto store = storeApi.findByStoreId(orderMain.getStoreId());
                            log.info("获取店铺信息耗时 {} ms", System.currentTimeMillis() - storeTime);

                            StoreExtDto storeExt = store.getStoreExt();
                            //苏宁商品不能下单
                            if (!storeCode.equals(storeExt.getCode())) {
                                log.error("下单出错,苏宁商品不能下单");
                                attr.addAttribute("error", GlobalContants.CREATE_ORDER_ERROR_NEW_ORDER_FAIL);
                                for (int i = 0; i < sucOrders.size(); i++) {
                                    long updateOrderStatus = System.currentTimeMillis();
                                    orderMainApi.updateOrderStatus(sucOrders.get(i).getId(), OrderMainDto.order_status_error);
                                    log.info("更新订单状态耗时 {} ms, 订单号 {}, 状态 {} ", System.currentTimeMillis() - updateOrderStatus, sucOrders.get(i), OrderMainDto.order_status.get(OrderMainDto.order_status_error));
                                }
                                return "redirect:/order/orderSubmitResult";
                            }
                        }

                        log.info("下单订单数据：orders={},tempOrderVo={},isNeePay={},useScorePay={}", JSON.toJSONString(sucOrders), JSON.toJSONString(tempOrderVo), isNeePay, useScorePay);
                        try {
                            /** 判断是否在线支付 */
                            if (isNeePay) {
                                //去京东下单，预占库存，不是真实下单 @xujingfeng
                                Map<String, Object> returnMap = new HashMap<>();
                                //对不同商铺的订单分别预占库存
                                log.info("正在预占库存, 订单号 {}", orderNos);
                                long takeOrderTime = System.currentTimeMillis();
                                boolean takeOrderFlag = occupyStockInAdvance(sucOrders, returnMap);
                                log.info("预占库存耗时 {} ms, 订单号 {}, 结果 {}", System.currentTimeMillis() - takeOrderTime, orderNos, takeOrderFlag);

                                if (takeOrderFlag) {
                                    //减库存
                                    long stockStatusTime = System.currentTimeMillis();
                                    boolean stockStatus = changeActivityGoodsStock(sucOrders);
                                    log.info("活动商品库存检查扣减耗时 {} ms, 订单号 {}, 结果 {}", System.currentTimeMillis() - stockStatusTime, orderNos, stockStatus);

                                    if (!stockStatus) {
                                        log.info("=========活动商品下单减库存失败，库存不足========memberId={},orderNos={}", memberVo.getMember().getId(), orderNos);
                                        //扣减积分失败,返还积分，取消订单
//                                        payBackScore(sucOrders, orderMainsPaiedIds);
                                        long cancelOrdersTime = System.currentTimeMillis();
                                        cancelOrders(cartItemIds, sucOrders);
                                        log.info("取消订单耗时 {} ms, 订单号 {}", System.currentTimeMillis() - cancelOrdersTime, orderNos);

                                        model.put("error", GlobalContants.CREATE_ORDER_ERROR_NO_STOCK);
                                        attr.addAttribute("error", GlobalContants.CREATE_ORDER_ERROR_NO_STOCK);
                                        attr.addAttribute("message", "商品已抢光");
                                        return "redirect:/order/orderSubmitResult";
                                    }
                                    log.info("现金支付orderNos={}预占库存成功，useScorePay={}", orderNos, useScorePay);
                                    if (USE_SCORE_FOR_PAY.equals(useScorePay) && consumeeScore.compareTo(new BigDecimal(0)) > 0) {
                                        //先扣减企业积分
                                        long expenseOrgScoreTime = System.currentTimeMillis();
                                        boolean expenseOrgScore = expenseOrgScore(attr, consumeeScore, orderNos, organization.getId());
                                        log.info("扣减企业积分耗时 {} ms, 订单号 {}", System.currentTimeMillis() - expenseOrgScoreTime, orderNos);
                                        if (!expenseOrgScore) {
                                            // 返还活动商品库存
                                            long backSolcNumTime = System.currentTimeMillis();
                                            backActivityGoodsStockAndSolcNum(sucOrders, organizationCode);
                                            log.info("活动商品返还库存耗时 {} ms, 订单号 {}", System.currentTimeMillis() - backSolcNumTime, orderNos);

                                            // 取消订单
                                            long cancelOrdersTime = System.currentTimeMillis();
                                            cancelOrders(cartItemIds, sucOrders);
                                            log.info("取消订单耗时 {} ms, 订单号 {}", System.currentTimeMillis() - cancelOrdersTime, orderNos);
                                            //企业积分扣减失败
                                            return "redirect:/order/orderSubmitResult";
                                        }
                                        //预占库存成功，扣减积分
                                        long payScoreTime = System.currentTimeMillis();
                                        boolean isSuccessPayScore = payScore(request, attr, sucOrders, orderMainsPaiedIds, usableScore, isNeePay);
                                        log.info("扣减积分耗时 {} ms, 订单号 {}", System.currentTimeMillis() - payScoreTime, orderNos);

                                        if (!isSuccessPayScore) {
                                            // 返还活动商品库存
                                            long backSolcNumTime = System.currentTimeMillis();
                                            backActivityGoodsStockAndSolcNum(sucOrders, organizationCode);
                                            log.info("活动商品返还库存耗时 {} ms, 订单号 {}", System.currentTimeMillis() - backSolcNumTime, orderNos);

                                            //扣减积分失败,返还积分，取消订单
                                            long payBackScoreTime = System.currentTimeMillis();
                                            BigDecimal orgNeedPayBackScore = payBackScore(sucOrders, orderMainsPaiedIds);
                                            log.info("返还积分耗时 {} ms, 订单号 {}", System.currentTimeMillis() - payBackScoreTime, orderNos);

                                            //返还企业积分
                                            if (orgNeedPayBackScore.compareTo(new BigDecimal(0)) > 0) {
                                                long refundOrgScoreTime = System.currentTimeMillis();
                                                refundOrgScore(organization.getId(), orgNeedPayBackScore, orderNos);
                                                log.info("返回企业积分耗时 {} ms, 订单号 {}", System.currentTimeMillis() - refundOrgScoreTime, orderNos);
                                            }

                                            long cancelOrdersTime = System.currentTimeMillis();
                                            cancelOrders(cartItemIds, sucOrders);
                                            log.info("取消订单耗时 {} ms, 订单号 {}", System.currentTimeMillis() - cancelOrdersTime, orderNos);

                                            return "redirect:/order/orderSubmitResult";
                                        }
                                        log.info("现金支付orderNos={},积分抵扣成功", orderNos);
                                    }

                                    log.info("现金支付orderNos={},跳转现金支付页", orderNos);

                                    long makeOrderStatusNeedPayTime = System.currentTimeMillis();
                                    log.info("正在更新订单 {} 状态 ---> 待付款", orderNos);
                                    sucOrders.forEach(orderMainDto -> orderMainApi.updateOrderStatus(orderMainDto.getId(), OrderMainDto.order_status_obligation));
                                    log.info("更新订单 {} 状态耗时 {} ms", orderNos, System.currentTimeMillis() - makeOrderStatusNeedPayTime);

                                    /** 跳转在线支付页面 */
                                    return "redirect:/showPayGateWay";
                                } else {
                                    long cancelOrdersTime = System.currentTimeMillis();
                                    cancelOrders(cartItemIds, sucOrders);
                                    log.info("预占库存失败, 取消订单耗时 {} ms, 订单号 {}", System.currentTimeMillis() - cancelOrdersTime, orderNos);
                                    errorCode = (String) returnMap.get("returnCode");
                                    attr.addAttribute("resultCode", returnMap.get("returnCode"));
                                    attr.addAttribute("message", returnMap.get("returnMsg"));
//                                return "redisrect:/error.html";
                                    attr.addAttribute("error", Lang.isEmpty(errorCode) ? GlobalContants.CREATE_ORDER_ERROR_OCCUPY_STOCK_FAIL : errorCode);
                                    return "redirect:/order/orderSubmitResult";
                                }
                            } else {
                                log.info("订单号 {}, 纯积分支付", orderNos);
                                Map<String, Object> returnMap = new HashMap<>();
                                //预占库存
                                long takeOrderTime = System.currentTimeMillis();
                                boolean takeOrderFlag = occupyStockInAdvance(sucOrders, returnMap);
                                log.info("预占库存耗时 {} ms, 订单号 {}, 结果 {}", System.currentTimeMillis() - takeOrderTime, orderNos, takeOrderFlag);

                                if (takeOrderFlag) {
                                    //减库存
                                    long stockStatusTime = System.currentTimeMillis();
                                    boolean stockStatus = changeActivityGoodsStock(sucOrders);
                                    log.info("活动商品库存检查扣减耗时 {} ms, 订单号 {}, 结果 {}", System.currentTimeMillis() - stockStatusTime, orderNos, stockStatus);

                                    if (!stockStatus) {
                                        //扣减积分失败,返还积分，取消订单
//                                        payBackScore(sucOrders, orderMainsPaiedIds);

                                        long cancelOrdersTime = System.currentTimeMillis();
                                        cancelOrders(cartItemIds, sucOrders);
                                        log.info("取消订单耗时 {} ms, 订单号 {}", System.currentTimeMillis() - cancelOrdersTime, orderNos);

                                        model.put("error", GlobalContants.CREATE_ORDER_ERROR_NO_STOCK);
                                        attr.addAttribute("error", GlobalContants.CREATE_ORDER_ERROR_NO_STOCK);
                                        attr.addAttribute("message", "商品已抢光");
                                        return "redirect:/order/orderSubmitResult";
                                    }
                                    log.info("纯积分支付orderNos={}预占库存成功", orderNos);

                                    //先扣减企业积分
                                    long expenseOrgScoreTime = System.currentTimeMillis();
                                    boolean expenseOrgScore = expenseOrgScore(attr, consumeeScore, orderNos, organization.getId());
                                    log.info("扣减企业积分耗时 {} ms, 订单号 {}", System.currentTimeMillis() - expenseOrgScoreTime, orderNos);

                                    if (!expenseOrgScore) {
                                        // 返还活动商品库存
                                        long backSolcNumTime = System.currentTimeMillis();
                                        backActivityGoodsStockAndSolcNum(sucOrders, organizationCode);
                                        log.info("活动商品返还库存耗时 {} ms, 订单号 {}", System.currentTimeMillis() - backSolcNumTime, orderNos);

                                        // 取消订单
                                        long cancelOrdersTime = System.currentTimeMillis();
                                        cancelOrders(cartItemIds, sucOrders);
                                        log.info("取消订单耗时 {} ms, 订单号 {}", System.currentTimeMillis() - cancelOrdersTime, orderNos);
                                        //企业积分扣减失败
                                        return "redirect:/order/orderSubmitResult";
                                    }
                                    //预占库存成功，扣减积分
                                    long payScoreTime = System.currentTimeMillis();
                                    boolean isSuccessPayScore = payScore(request, attr, sucOrders, orderMainsPaiedIds, usableScore, isNeePay);
                                    log.info("扣减积分耗时 {} ms, 订单号 {}", System.currentTimeMillis() - payScoreTime, orderNos);
                                    if (!isSuccessPayScore) {
                                        // 返还活动商品库存
                                        long backSolcNumTime = System.currentTimeMillis();
                                        backActivityGoodsStockAndSolcNum(sucOrders, organizationCode);
                                        log.info("活动商品返还库存耗时 {} ms, 订单号 {}", System.currentTimeMillis() - backSolcNumTime, orderNos);

                                        //扣减积分失败
                                        long payBackScoreTime = System.currentTimeMillis();
                                        BigDecimal orgNeedPayBackScore = payBackScore(sucOrders, orderMainsPaiedIds);
                                        log.info("返还积分耗时 {} ms, 订单号 {}", System.currentTimeMillis() - payBackScoreTime, orderNos);

                                        //返还企业积分
                                        if (orgNeedPayBackScore.compareTo(new BigDecimal(0)) > 0) {
                                            long refundOrgScoreTime = System.currentTimeMillis();
                                            refundOrgScore(organization.getId(), orgNeedPayBackScore, orderNos);
                                            log.info("返回企业积分耗时 {} ms, 订单号 {}", System.currentTimeMillis() - refundOrgScoreTime, orderNos);
                                        }

                                        long cancelOrdersTime = System.currentTimeMillis();
                                        cancelOrders(cartItemIds, sucOrders);
                                        log.info("取消订单耗时 {} ms, 订单号 {}", System.currentTimeMillis() - cancelOrdersTime, orderNos);

                                        model.put("error", GlobalContants.CREATE_ORDER_ERROR_NO_STOCK);
                                        attr.addAttribute("error", GlobalContants.CREATE_ORDER_ERROR_NO_STOCK);
                                        attr.addAttribute("message", "商品已抢光");
                                        return "redirect:/order/orderSubmitResult";
                                    }
                                    log.info("纯积分支付orderNos={},积分抵扣成功", orderNos);
                                    //积分支付完成，确认预占库存
                                    try {
                                        for (OrderMainDto orderMain : sucOrders) {
                                            long confirmOrderTime = System.currentTimeMillis();
                                            orderMainApi.confirmOrder(orderMain.getOrderNo());
                                            log.info("确认订单耗时 {} ms, 订单号 {}", System.currentTimeMillis() - confirmOrderTime, orderNos);
                                            log.info("纯积分支付orderNo={},确认下单成功", orderMain.getOrderNo());
                                        }
                                    } catch (Exception e) {
                                        log.error("确认预占库存出错，sucOrders={}", JSON.toJSONString(sucOrders), e);
                                    }

                                } else {
                                    long cancelOrdersTime = System.currentTimeMillis();
                                    cancelOrders(cartItemIds, sucOrders);
                                    log.info("取消订单耗时 {} ms", System.currentTimeMillis() - cancelOrdersTime);
//                                model.put("error", GlobalContants.CREATE_ORDER_ERROR_OCCUPY_STOCK_FAIL);
//                                errorCode = Lang.isEmpty(errorCode) ? GlobalContants.CREATE_ORDER_ERROR_OCCUPY_STOCK_FAIL : errorCode;
//                                attr.addFlashAttribute("error", errorCode);
                                    attr.addAttribute("error", GlobalContants.CREATE_ORDER_ERROR_OCCUPY_STOCK_FAIL);
                                    return "redirect:/order/orderSubmitResult";
                                }


                                //下单成功清除活动缓存使其重载
                                /*for (TempOrderStoreVo tempOrderStoreVo : tempOrderVo.getStoreList()) {
                                    for (TempOrderItemVo tempOrderItemVo : tempOrderStoreVo.getOrderItems()) {
                                        String key = ActivityConfigurationApi.ACTIVITY_REDISKEY_ACTIVITY_GOODS + tempOrderItemVo.getActivityId();
                                        activityConfigurationApi.deleteRedisKey(key);
                                    }
                                }*/

                                attr.addAttribute("orderNos", orderNos.toString());
                                // 积分支付成功后，直接跳转下单成功页
                                return "redirect:/order/orderSubmitResult";
                            }
                        } catch (Exception e) {
                            log.error("下单出错", e);
                            attr.addAttribute("error", GlobalContants.CREATE_ORDER_ERROR_NEW_ORDER_FAIL);
                            return "redirect:/order/orderSubmitResult";
                        }
                    } else {
                        long reduceDeledCartItemsTime = System.currentTimeMillis();
                        cartApi.reduceDeledCartItems(cartItemIds);
                        log.info("删除购物车耗时 {} ms", System.currentTimeMillis() - reduceDeledCartItemsTime);
                        if ("1".equals(resMap.get("error").toString())) {
                            model.put("error", GlobalContants.CREATE_ORDER_ERROR_PRICE_ERROE);
                            attr.addAttribute("error", GlobalContants.CREATE_ORDER_ERROR_PRICE_ERROE);
                            return "redirect:/order/orderSubmitResult";
                        }
                        model.put("error", GlobalContants.CREATE_ORDER_ERROR_NEW_ORDER_FAIL);
                        attr.addAttribute("error", GlobalContants.CREATE_ORDER_ERROR_NEW_ORDER_FAIL);
                        return "redirect:/order/orderSubmitResult";
                    }
                } else {
                    attr.addAttribute("error", GlobalContants.CREATE_ORDER_ERROR_OVER_TIME);
//                return "redirect:/myCart/index";
                    return "redirect:/order/orderSubmitResult";
                }
            }
//        return "redirect:/myCart/index";
            return "redirect:/order/orderSubmitResult";
        } catch (Exception e) {
            log.error("提交订单异常", e);
            attr.addAttribute("error", GlobalContants.CREATE_ORDER_ERROR_NEW_ORDER_FAIL);
        } finally {
            redisLockUtil.unlock(memberVo.getMember().getId());
        }
        model.put("error", GlobalContants.CREATE_ORDER_ERROR_NEW_ORDER_FAIL);
        return "redirect:/order/orderSubmitResult";
    }

    // 返还活动商品库存
    private void backActivityGoodsStockAndSolcNum(List<OrderMainDto> orderMains, String organizationCode) {
        for (OrderMainDto orderMain : orderMains) {
            for (OrderItemDto orderItem : orderMain.getOrderItems()) {
                if (!Lang.isEmpty(orderItem.getActivityId())) {
                    activityGoodsApi.backActivityGoodsStockAndSolcNum(orderItem.getGoodsId(), orderItem.getActivityId(), orderItem.getCount(), organizationCode);
                }
            }
        }
    }

    private boolean refundOrgScore(String orgId, BigDecimal consumeeScore, StringBuilder orderNos) {
        try {
            ApiResponseVo apiResponseVo;
            apiResponseVo = organizationApi.refundOrganizationScore(orgId, consumeeScore, orderNos.toString());
            if (!GlobalContants.ResponseStatus.SUCCESS.equals(apiResponseVo.getStatus())) {
//                attr.addAttribute("error", GlobalContants.CREATE_ORDER_ERROR_ORG_SCORE_EXPENSE_ERROR);
//                attr.addAttribute("message", "企业积分扣减失败");
                log.error("企业返还积分失败,orderNos={}", orderNos, new RuntimeException("企业返还积分失败"));
                return false;
            }
        } catch (Exception e) {
            log.error("企业返还积分失败,orderNos={}", orderNos, e);
        }
        return true;
    }

    private boolean expenseOrgScore(RedirectAttributes attr, BigDecimal consumeeScore, StringBuilder orderNos, String orgId) {
        try {
            ApiResponseVo apiResponseVo = organizationApi.expenseOrgScore(orgId, consumeeScore, orderNos.toString());
            if (!GlobalContants.ResponseStatus.SUCCESS.equals(apiResponseVo.getStatus())) {
                log.error("企业积分扣减失败，orderNos={}", orderNos.toString(), new RuntimeException("企业积分扣减失败"));
                attr.addAttribute("error", GlobalContants.CREATE_ORDER_ERROR_ORG_SCORE_EXPENSE_ERROR);
                attr.addAttribute("message", "企业积分扣减失败");
                return false;
            }
        } catch (Exception e) {
            attr.addAttribute("error", GlobalContants.CREATE_ORDER_ERROR_ORG_SCORE_EXPENSE_ERROR);
            attr.addAttribute("message", "企业积分扣减失败");
            log.error("企业扣减积分失败", e);
            return false;
        }
        return true;
    }

    //预占库存
    public boolean occupyStockInAdvance(List<OrderMainDto> sucOrders, Map<String, Object> returnMap) {
        for (OrderMainDto orderMain : sucOrders) {
            returnMap.putAll(orderMainApi.occupyStock(orderMain));
            log.info("======{}", returnMap);
            String returnCode = returnMap.get("returnCode").toString();
            if (!returnCode.equals("success")) {
                return false;
            }
        }
        return true;
    }

    /**
     * 活动商品配置库存
     *
     * @param sucOrders
     * @return
     */
    private boolean changeActivityGoodsStock(List<OrderMainDto> sucOrders) {
        for (OrderMainDto om : sucOrders) {
            for (OrderItemDto oi : om.getOrderItems()) {
                if (!Lang.isEmpty(oi.getActivityId())) {
                    log.info("=======================活动商品减库存order_item={}", JSON.toJSONString(om));
                    if (!activityGoodsApi.changeActivityGoodsStock(oi.getGoodsId(), oi.getActivityId(), oi.getCount())) {
                        log.info("=======================活动商品减库存失败order_item={}", JSON.toJSONString(om));
                        return false;
                    }
                    log.info("=======================活动商品减库存成功order_item={}", JSON.toJSONString(om));
                }
            }
        }
        return true;
    }

    //取消订单
    public void cancelOrders(List<String> cartItemIds, List<OrderMainDto> sucOrders) {
        try {
            /**LWX 2017/1/9修改： 出错之后，恢复删除的购物车条目 START */
            cartApi.reduceDeledCartItems(cartItemIds);
            /**LWX 2017/1/9修改： 出错之后，恢复删除的购物车条目 END */
            for (OrderMainDto orderMain : sucOrders) {
                orderMainApi.cancelOrder(orderMain.getOrderNo(), OrderMainApi.CancelOrderType.ERROR);
            }
        } catch (Exception e) {
            log.error("取消订单失败 ,sucOrders={}", JSON.toJSONString(sucOrders), e);
        }
    }

    @RequestMapping(value = {"/orderSubmitResult"})
    public String orderSubmit(String orderNos, String error, String message,
                              HttpServletResponse response, Map model) {
        if (!Lang.isEmpty(orderNos)) {
            String[] orderNosArray = orderNos.split(",");
            List list = new LinkedList();
            for (String no : orderNosArray) {
                if (!StringUtils.isEmpty(no)) {
                    OrderMainDto orderMain = orderMainApi.findByOrderNo(no);
                    list.add(orderMain);
                    model.put("data", list);
                }
            }
        }
        log.info("=====================error={}", error);
        model.put("error", error);
        model.put("message", message);
        model.put("CREATE_ORDER_ERROR_PRICE_ERROE", GlobalContants.CREATE_ORDER_ERROR_PRICE_ERROE);
        model.put("CREATE_ORDER_ERROR_NEW_ORDER_FAIL", GlobalContants.CREATE_ORDER_ERROR_NEW_ORDER_FAIL);
        model.put("CREATE_ORDER_ERROR_OCCUPY_STOCK_FAIL", GlobalContants.CREATE_ORDER_ERROR_OCCUPY_STOCK_FAIL);
        model.put("CREATE_ORDER_ERROR_OVER_TIME", GlobalContants.CREATE_ORDER_ERROR_OVER_TIME);
        model.put("CREATE_ORDER_COST_CHANGED", GlobalContants.CREATE_ORDER_COST_CHANGED);
        model.put("CREATE_ORDER_ADDRESS_NOTFOUND", GlobalContants.CREATE_ORDER_ADDRESS_NOTFOUND);
        model.put("CREATE_ORDER_ERROR_PAY_SCORE", GlobalContants.CREATE_ORDER_ERROR_PAY_SCORE);
        model.put("CREATE_ORDER_ERROR_SCORE_NO_ENOUGH", GlobalContants.CREATE_ORDER_ERROR_SCORE_NO_ENOUGH);
        model.put("CREATE_ORDER_ERROR_ORG_SCORE_NOT_ENOUHG", GlobalContants.CREATE_ORDER_ERROR_ORG_SCORE_NOT_ENOUHG);
        model.put("CREATE_ORDER_ERROR_ORG_SCORE_EXPENSE_ERROR", GlobalContants.CREATE_ORDER_ERROR_ORG_SCORE_EXPENSE_ERROR);
        model.put("CREATE_ORDER_ERROR_NO_STOCK", GlobalContants.CREATE_ORDER_ERROR_NO_STOCK);
        model.put("CREATE_ORDER_ERROR_ACTIVITY_LIMITED", GlobalContants.CREATE_ORDER_ERROR_ACTIVITY_LIMITED);
        model.put("itaipingUserCenterOrder", itaipingUserCenterOrder);
        model.put("itaipingUserCenterGoods", itaipingUserCenterGoods);

        return "cart/order/orderSubmitResult";

    }

    @RequestMapping(value = {"/test/cancelOrder"})
    @ResponseBody
    public String cancelOrderTest(String orderNo, HttpServletResponse response, Map model) {
        orderMainApi.cancelOrder(orderNo, OrderMainApi.CancelOrderType.USER);
        return "suc";
    }

    @RequestMapping(value = {"/refreshTmpOrder", "/refreshTmpOrder.json"})
    @ResponseBody
    public Map refreshTempOrder(String rid, String addressId, Boolean getShippingFee, HttpServletRequest request, HttpServletResponse response) {
        long methodStartTime = System.currentTimeMillis();
        log.info("### 开始刷新临时订单 ... ###");
        Map returnMap = new HashMap();
        returnMap.put(GlobalContants.ResponseString.STATUS, GlobalContants.ResponseStatus.SUCCESS);
        returnMap.put(GlobalContants.ResponseString.MESSAGE, "SUCCESS");
        /** 从Session获取暂存订单 */
        String tempOrderSessionKey = GlobalContants.TEMP_ORDER_SESSION_KEY_PREFIX + rid;
        String tempOrderJson = (String) request.getSession().getAttribute(tempOrderSessionKey);
        if (Lang.isEmpty(tempOrderJson)) {
            /** 错误1，获取已保存临时订单数据出错 */
            returnMap.put(GlobalContants.ResponseString.STATUS, GlobalContants.ResponseStatus.ERROR);
            returnMap.put(GlobalContants.ResponseString.MESSAGE, "REC_NOT_FOUND");
        } else {
            TempOrderVo tempOrderVo = JSON.parseObject(tempOrderJson, TempOrderVo.class);
            List<FashionDetailVo> fashionDetailVoList = new ArrayList<>();

            long defAddrTime = System.currentTimeMillis();
            MemberAddressDto defAddr = memberAddressApi.findById(addressId);
            log.info("查询地址耗时 {} ms", System.currentTimeMillis() - defAddrTime);

            /** 提取fashionIdAndCountVo */
            for (TempOrderStoreVo storeVo : tempOrderVo.getStoreList()) {
                for (TempOrderItemVo itemVo : storeVo.getOrderItems()) {
                    fashionDetailVoList.add(new FashionDetailVo(itemVo.getProductFashionId(), itemVo.getGoodsId(), itemVo.getCount()));
                }
            }
            BigDecimal sumShippingFee = BigDecimal.valueOf(0);
            // 获取运费

            if (getShippingFee) {
                tempOrderVo.setSumShippingFee(sumShippingFee);
                for (TempOrderStoreVo storeVo : tempOrderVo.getStoreList()) {
                    long shippingFeeTime = System.currentTimeMillis();
                    BigDecimal shippingFee = orderWebService.queryShippingFee(storeVo.getStoreId(), storeVo.getOrderItems(), addressId);
                    log.info("查询运费耗时 {} ms", System.currentTimeMillis() - shippingFeeTime);
                    storeVo.setShippingFee(shippingFee == null ? BigDecimal.valueOf(0) : shippingFee);
                    sumShippingFee = tempOrderVo.getSumShippingFee().add(storeVo.getShippingFee());
                    for (TempOrderItemVo itemVo : storeVo.getOrderItems()) {
                        fashionDetailVoList.add(new FashionDetailVo(itemVo.getProductFashionId(), itemVo.getGoodsId(), itemVo.getCount()));
                    }
                }
            }

            long calculateOrderScorePriceInfoTime = System.currentTimeMillis();
            calculateOrderScorePriceInfo(request, tempOrderSessionKey, tempOrderVo, sumShippingFee, tempOrderVo.getSumPrice());
            log.info("计算订单积分金额耗时 {} ms", System.currentTimeMillis() - calculateOrderScorePriceInfoTime);

            // 获取库存状态
            long organizationIdTime = System.currentTimeMillis();
            String organizationId = organizationApi.findOrganizationIdByOrgCode(organizationCode);
            log.info("查询机构信息耗时 {} ms", System.currentTimeMillis() - organizationIdTime);

            long stockStatusTime = System.currentTimeMillis();
            Map stockStatusRes = productFashionApi.queryFashionStockStatus(mapperFacade.mapAsList(fashionDetailVoList, goods.vo.FashionIdAndCountVo.class), defAddr.getAreaCode(), organizationId);
            log.info("查询库存状态耗时 {} ms", System.currentTimeMillis() - stockStatusTime);

            if (stockStatusRes.get(GlobalContants.ResponseString.STATUS).equals(GlobalContants.ResponseStatus.SUCCESS)) {
                List<Map> stockStatusDetails = (List<Map>) ((Map) stockStatusRes.get("data")).get("details");
                for (TempOrderStoreVo s : tempOrderVo.getStoreList()) {
                    for (TempOrderItemVo i : s.getOrderItems()) {
                        for (Map sRes : stockStatusDetails) {
                            if (i.getProductFashionId().equals(sRes.get("fashionId"))) {
                                i.setStockCount(new Long((Integer) sRes.get("stockCount")));
                                if (!(Boolean) sRes.get("onSale")) {
                                    i.setStatus("2");
                                } else {
                                    Integer stockFlag = (Integer) sRes.get("stockFlag");
                                    i.setStatus(stockFlag == 0 ? "2" : "1");
                                }
                                break;
                            }
                        }
                    }
                }
            } else {
                /** 获取库存失败，不可购买 */
                for (TempOrderStoreVo s : tempOrderVo.getStoreList()) {
                    for (TempOrderItemVo i : s.getOrderItems()) {
                        i.setStockCount(0L);
                        i.setStatus("2");
                    }
                }
            }

            returnMap.put(GlobalContants.ResponseString.DATA, tempOrderVo);
        }
        log.info("### 刷新临时订单总耗时 {} ms", System.currentTimeMillis() - methodStartTime);
        return returnMap;
    }

    @RequestMapping(value = {"/testOrgAccountCtrl", "/testOrgAccountCtrl"})
    @ResponseBody
    public String testOrganizationAccountCtrl(Integer ts, String r) {
        final List res = new ArrayList();
        for (int i = 0; i < ts; i++) {
            final int finalI = i;
            final String finalR = r;
            new Thread(new Runnable() {
                @Override
                public void run() {
                    BigDecimal price = new BigDecimal(Math.random() * 100).setScale(0, BigDecimal.ROUND_HALF_UP);
                    log.info("测试并发接口调用（预占） -> [线程: T" + (finalI + 1) + ",消费金额：" + price + ", 处理结果: " + JSON.toJSONString(organizationApi.organizationAccountCtrl("5fc7314a-55a7-428f-a870-deab259cdb89",
                            price,
                            OrgAccountCtrlHistoryDto.OPERATION_TYPE_DEFOREHAND
                            , "吴亦凡", "5adcb26b-f3ed-48f6-8a10-55f8c94d7bcd", "TEST_ORDER_T" + finalR + (finalI + 1))) + "]");
                    log.info("测试并发接口调用（确认） -> [线程: T" + (finalI + 1) + ",消费金额：" + price + ", 处理结果: " + JSON.toJSONString(organizationApi.organizationAccountCtrl("5fc7314a-55a7-428f-a870-deab259cdb89",
                            price,
                            OrgAccountCtrlHistoryDto.OPERATION_TYPE_SURE
                            , "吴亦凡", "5adcb26b-f3ed-48f6-8a10-55f8c94d7bcd", "TEST_ORDER_T" + finalR + (finalI + 1))) + "]");
                }
            }).start();
        }

        return "suc";
    }

    @MotanReferer
    OrganizationApi organizationApi;

    @Autowired
    CartWebService cartWebService;

    @Autowired
    OrderWebService orderWebService;

    @MotanReferer
    CartItemApi cartItemApi;

    @MotanReferer
    CartApi cartApi;

    @MotanReferer
    MemberAddressApi memberAddressApi;

    @MotanReferer
    AddressCommonApi addressCommonApi;

    @MotanReferer
    MemberInvoinceApi memberInvoinceApi;

    //    @MotanReferer(group = "sinomall", directUrl = "127.0.0.1:8045")
    @MotanReferer
    OrderMainApi orderMainApi;
    //    @MotanReferer(group = "sinomall", directUrl = "127.0.0.1:8189")
    @MotanReferer
    PaymentApi paymentApi;
    @MotanReferer
    ProductFashionApi productFashionApi;
    @Autowired
    ProductFashionRepos productFashionRepos;

    @Autowired
    MapperFacade mapperFacade;

    public boolean payScore(HttpServletRequest request, RedirectAttributes attr, List<OrderMainDto> orderMains, List<String> orderMainPaiedIds, BigDecimal usableScore, boolean isNeedPay) {
        BigDecimal proportion = new BigDecimal(itaipingScoreProportion);
//        String errorCode = "1";
        try {
            //支付积分大于0调用积分扣减接口
            //扣减积分需要分店铺多笔扣减，否则取消订单时容易出现积分金额取消返还不协调问题
            for (OrderMainDto orderMain : orderMains) {
                PaymentDto payment = paymentApi.findPaymentById(orderMain.getPaymentId());
                BigDecimal orderScore = scoreUserService.roundScore(goodsApi.priceScoreTransform(orderMain.getSumPrice(), proportion, BigDecimal.ROUND_HALF_UP));
                if (usableScore.compareTo(orderScore) >= 0) {
                    payment.setScore(orderScore);
                    payment.setMoney(BigDecimal.ZERO);
                    usableScore = usableScore.subtract(orderScore);
                } else {
                    payment.setScore(usableScore);
                    payment.setMoney(orderMain.getSumPrice().subtract(scoreUserService.roundScore(goodsApi.scorePriceTransform(usableScore, proportion, BigDecimal.ROUND_HALF_UP))));
                    usableScore = BigDecimal.ZERO;
                }
                paymentApi.updatePaymentScoreAndMoney(payment.getId(), payment.getScore(), payment.getMoney());
                if (payment.getScore().compareTo(BigDecimal.ZERO) > 0) {
                    // TODO: 2017-04-28 扣减积分

                    ScoreExpenseDetailRequestDTO scoreExpenseDetailRequestDTO = new ScoreExpenseDetailRequestDTO();

                    CoreUserDto coreUser = loginService.getSessionCoreUser(request);
                    ScoreAccountDTO scoreAccount = scoreUserService.getScoreAccount(coreUser);
                    scoreExpenseDetailRequestDTO.setScoreAccountId(scoreAccount.getId());
                    scoreExpenseDetailRequestDTO.setScoreVal(payment.getScore());
                    scoreExpenseDetailRequestDTO.setTransaTime(new Date());

                    scoreExpenseDetailRequestDTO.setBusiCode(ScoreBusinessType.BUSI_EXPENSE_ENTITY_GOODS.getBusinessCode());
                    scoreExpenseDetailRequestDTO.setBusiSource(ScoreBusinessType.BUSI_EXPENSE_ENTITY_GOODS.getBusinessSource());
                    scoreExpenseDetailRequestDTO.setTransactionNo(orderMain.getOrderNo());
                    scoreExpenseDetailRequestDTO.setMemo("诚通商城订单" + orderMain.getOrderNo() + "消费" + payment.getScore() + "积分");
                    scoreApi.expenseScore(scoreExpenseDetailRequestDTO);
                    if (!isNeedPay) {
                        paymentApi.updatePaymentStatus(payment.getId(), PaymentDto.PAY_STATUS_PAID);
                    }
//                if (payment.getMoney().compareTo(new BigDecimal(0)) == 0) {//纯积分支付
//                    paymentApi.updatePaymentStatus(payment.getId(), PaymentDto.PAY_STATUS_PAID);
//                }
                    orderMainPaiedIds.add(orderMain.getId());
                }
            }
        } catch (Exception e) {
            log.error("积分平台扣减积分失败 error", e);
            attr.addAttribute("error", GlobalContants.CREATE_ORDER_ERROR_PAY_SCORE);
            attr.addAttribute("message", "积分平台扣减积分失败");
            return false;
        }
        return true;
    }

    public BigDecimal payBackScore(List<OrderMainDto> sucOrders, List<String> orderMainsPaiedIds) {
        BigDecimal orgNeedPayBackScore = new BigDecimal(0);
        for (OrderMainDto orderMain : sucOrders) {
//            AddGiftsVo addGiftsVo = new AddGiftsVo();
            try {
                OrderMainDto orderMainRecentest = orderMainApi.findById(orderMain.getId());
                //未确认下单订单状态置为错误
                if (!orderMainRecentest.getStatus().equals(OrderMainDto.order_status_ounfilled)) {
                    orderMainApi.updateOrderStatus(orderMain.getId(), OrderMainDto.order_status_error);
                }
                if (orderMainsPaiedIds != null && !orderMainsPaiedIds.isEmpty() && orderMainsPaiedIds.contains(orderMain.getId())) {
                    // TODO: 2017-04-28 下单失败 ，返还积分
//                    addGiftsVo.setOrderNo(orderMain.getOrderNo());
//                    addGiftsVo.setFirmNo("jicai");
//                    addGiftsVo.setReason("实物下单失败，返还积分:" + JSON.toJSONString(addGiftsVo));
//                    scoreApi.addGifts(addGiftsVo);
                    BaseResponse baseResponse = ctScoreApi.refundScore(orderMain.getOrderNo());
                    if (GlobalContants.ResponseStatus.SUCCESS.equals(baseResponse.getStatus())) {
                        paymentApi.updatePaymentStatus(orderMain.getPaymentId(), PaymentDto.PAY_STATUS_ERROR);
                        orgNeedPayBackScore.add(paymentApi.findPaymentById(orderMain.getPaymentId()).getScore());
                    } else {
                        log.error("=========================积分返还出错,orderNo={}", orderMain.getOrderNo(), new RuntimeException("积分返还出错"));
                    }
                }
            } catch (Exception e1) {
                log.error("=========================积分返还出错", e1);
//                log.error("=========================积分返还出错 addGiftsVo：" + JSON.toJSONString(addGiftsVo));
            }
        }
        return orgNeedPayBackScore;
    }


    @RequestMapping("/sendVerifyCode")
    public void sendVerifyCode(HttpServletRequest request, HttpServletResponse response, HttpSession session) {
        Map<String, Object> map = null;
        try {
            MemberVo memberVo = loginService.findMemberVo(request);
            //String userName = (String) request.getSession().getAttribute(GlobalContants.SESSION_USER_NAME_ITAIPING);
            String phone = memberVo.getUser().getPhone();
            String verifyCodeType = request.getParameter("verifyCodeType");
            map = new HashMap<String, Object>();
            VerifyCodeDto verifyCode = new VerifyCodeDto();
            String securityCode = utils.string.StringUtils.getSecurityCode();
            log.info("securityCode:{}", securityCode);

            int count = smsApi.sendVerifyCodeTimes(phone, verifyCodeType);
            String sendResultShort = "";
            if (count > 50) {
                sendResultShort = "0";//发送失败，重新发送
            } else {
                boolean sendResult = sendMsg(phone, securityCode, verifyCodeType);
                log.info("手机验证码发送结果", sendResult);
                if (sendResult == true) {
                    sendResultShort = "1";//发送成功
                } else {
                    sendResultShort = "0";//发送失败，重新发送
                }
            }

            verifyCode.setType(verifyCodeType);
            String memo = "诚通商城实物订单";

            verifyCode.setMemo(memo);
            verifyCode.setObjId(phone);
            verifyCode.setSendResult(sendResultShort);
            verifyCode.setVerifyCode(securityCode.trim());
            VerifyCodeDto verifyCodeDto = BeanMapper.map(verifyCode, VerifyCodeDto.class);
            saveVerifyCode(verifyCodeDto);
            map.put("result", sendResultShort);

        } catch (Exception e) {
            if (map == null) {
                map = new HashMap<String, Object>();
            }
            map.put("result", 2);//发送失败，重新发送
        }
        String json = Jsons.map2json(map);
        ajaxHtml(json, response);
    }

    @MotanReferer
    SmsApi smsApi;

    public boolean sendMsg(String objId, String verifyCode, String verifyCodeType) {
        boolean successFalg = false;
        SmsReq smsReq = new SmsReq();
        String content = "诚意通提示您，您的验证码是 " + verifyCode + " （有效期5分钟），如非本人操作请忽略本短信。";
        smsReq.setContent(content);//发送内容
        smsReq.setTos(Arrays.asList(objId));//发送手机号
        smsReq.setMobileServiceId(MOBILE_SERVICE_ID);
        smsReq.setSendTime(new Date());
        try {
            SmsRsp smsRsp = smsApi.sendSms(smsReq);
            successFalg = smsRsp.isSuccessFalg();

        } catch (Exception e) {
            e.printStackTrace();
        }
        return successFalg;
    }

    //验证码
    @ResponseBody
    @RequestMapping("/checkekVerifyCode")
    public String checkekVerifyCode(String userName, String verifyCode, HttpServletRequest request) {
        //测试环境暂时去除校验码

        if (!activeEnv.contains("prod")) {
            return "1";
        }
        MemberVo memberVo = loginService.findMemberVo(request);
        //String userName = (String) request.getSession().getAttribute(GlobalContants.SESSION_USER_NAME_ITAIPING);
        String phone = memberVo.getUser().getPhone();
        String verifyCodeType = "6";
        String result = checkCode(phone, verifyCode, verifyCodeType);
        return result;
    }

    public String checkCode(String userName, String verifyCode, String verifyCodeType) {
        String result = "1";            //验证码正确且有效
        VerifyCodeDto verifyCodes = findByObjIdAndType(userName, verifyCodeType);
        if (verifyCode.equals(verifyCodes.getVerifyCode())) {
            Date time = verifyCodes.getDateCreated();
            long minute = DateUtils.differMinute(time);
            if (userName.contains("@")) {
                if (minute > 30) {
                    result = "2";     //邮箱验证码失效
                }
            } else {
                if (minute > 5) {
                    result = "2";   //手机验证码失效
                }
            }
        } else {
            result = "0";         //手机验证码错误
        }
        return result;
    }

    public VerifyCodeDto findByObjIdAndType(String objId, String type) {
        Date date = DateUtils.getNowDateShort();
        VerifyCodeDto verifyCode = smsApi.findVerifyCode(objId, type, date);
        return verifyCode;
    }


    public void saveVerifyCode(VerifyCodeDto verifyCode) {
        smsApi.saveVerifyCode(verifyCode);
    }
}
