package ctscore.web.controller.cart;

import cart.api.QueryTradeDataApi;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import member.api.QueryOrderApi;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by GuoBenqiang on 2016/11/22.
 */
@Controller
@RequestMapping("/publicity")
public class OrderPublicityController {
    @MotanReferer
    QueryTradeDataApi queryTradeDataApi;

    @MotanReferer
    QueryOrderApi queryOrderApi;

    @RequestMapping("/queryTransactionDataUI")
    public String QueryTradeData() {
        return "orderPublicity/orderPublicity";
    }

    @RequestMapping(value = {"", "/queryTradeDetail"})
    @ResponseBody
    public Map queryTradeDetail(@RequestParam Map contidionMap) {
        Map map2 = queryTradeDataApi.queryTradeDetail(contidionMap);
        journal("detail",map2);
        return map2;
    }

    @RequestMapping("/queryTradeTotal")
    @ResponseBody
    public Map queryTradeTotal(@RequestParam Map contidionMap) {
        Map map2 = queryTradeDataApi.queryTradeTotal(contidionMap);
        journal("total",map2);
        return map2;
    }

    @RequestMapping("/queryOrganization")
    @ResponseBody
    public Map queryCompany(@RequestParam Integer level, String companyId) {
        return queryTradeDataApi.queryCompany(level, companyId);
    }

    @RequestMapping("/orderPublicityParticulars")
    public String orderPublicityParticulars(Map map, String orderId, String memberName, String realCompany, String memberId) {
        Map<String, Object> params = new HashMap<>();
        params.put("orderId", orderId);
        params.put("memberId", null);
        map.put("memberName", memberName);
        map.put("realCompany", realCompany);
        Map<String, Object> stringObjectMap = queryOrderApi.queryOrderDetail(params);
        map.putAll(stringObjectMap);
        return "orderPublicity/orderPublicityDetails";
    }

    /**
     * 打印信息
     *
     * @param key
     * @param o
     */
    public void journal(String key, Object o) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            System.out.println(key + "=====" + mapper.writerWithDefaultPrettyPrinter().writeValueAsString(o));
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
