package ctscore.web.controller.cart;

import cart.api.OrderMainApi;
import cart.api.dto.order.OrderMainDto;
import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by xujingfeng on 2016/12/18.
 */
@Controller
public class TestTakeOrderController {

    final static Logger logger = LoggerFactory.getLogger(TestTakeOrderController.class);

    @RequestMapping("/testTakeOrderOnServer")
    public String testTakeOrderOnServer(RedirectAttributes redirectAttributes) {
        Map<String, Object> returnMap = new HashMap<>();
        OrderMainDto orderMain = orderMainApi.findById("645e6e2e-3bc8-40f2-8614-0d7ccc81e0ec");
        returnMap = orderMainApi.occupyStock(orderMain);
        if ("success".equals(returnMap.get("returnCode"))) {
            redirectAttributes.addAttribute("orderNo", orderMain.getOrderNo());
            redirectAttributes.addAttribute("orderTotalFare", "0.03");
            return "redirect:/showPayGateWay";
        }
        logger.info("{}", JSON.toJSONString(returnMap, true));
        return "redirect:/error.html";
    }

    @RequestMapping("/testTakeOrderLocal/{orderNo}")
    public String testTakeOrderLocal(@PathVariable String orderNo, RedirectAttributes redirectAttributes) {
        redirectAttributes.addAttribute("orderNo", orderNo);
        redirectAttributes.addAttribute("orderTotalFare", "0.03");
        return "redirect:/testShowPayGateWay";
    }

    @RequestMapping("/api/splitOrder")
    @ResponseBody
    public String splitOrder(String id) {
        orderMainApi.splitOrderById(id);
        return "splitOrder";
    }


    @MotanReferer
    OrderMainApi orderMainApi;


}
