package ctscore.web.controller.cms;

import cms.api.AnnouncementApi;
import cms.api.MemberReadAnnouncementApi;
import cms.api.dto.AnnouncementDto;
import cms.api.dto.MemberReadAnnouncementDto;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import utils.GlobalContants;
import utils.Lang;
import utils.log.Log;
import utils.log.Logs;
import utils.sql.PageVo;

import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Map;

/**
 * 作用:前台公告控制类
 * @author 林志强
 */
@Controller
@RequestMapping("notice")
public class AnnouncementController {
    private final static Log log = Logs.getLog(AnnouncementController.class.getName());
    @MotanReferer(basicReferer = "motanClientBasicConfig")
    AnnouncementApi announcementApi;

    @MotanReferer(basicReferer = "motanClientBasicConfig")
    MemberReadAnnouncementApi memberReadAnnouncementApi;

    @Value("${ctscore.orgCode}")
    private String organizationCode;//机构code值

    @Value("${ctscore.storeCode}")
    private String storeCode;//店铺code
    //get方法的公告列表查询
    @RequestMapping(value = {"","list"},method = RequestMethod.GET)
    public String index(){
        return "notice/notice";
    }

    //post方法的公告列表查询
    @RequestMapping(value = {"","list"},method = RequestMethod.POST)
    @ResponseBody
    public Map query(String title ,Pageable pageable,HttpServletRequest request){
        String memberId = (String) request.getSession().getAttribute(GlobalContants.SESSION_USER_ID_ITAIPING);
        pageable = new PageRequest(pageable.getPageNumber(),pageable.getPageSize(),new Sort(Sort.Direction.DESC,"publishDate"));
        Map returnModel = new HashMap();
        PageVo pageVo=announcementApi.getUserZAnnouncement(pageable,memberId,title,organizationCode);
        returnModel.put("title",title==null?"":title.trim());
        returnModel.put("data",pageVo.getResult());
        returnModel.put("totalPages",pageVo.getPageNum());
        returnModel.put("size",pageVo.getPageSize());
        return returnModel;
    }

    /**
     * 公告详情
     * @param model
     * @param noticeId
     * @return
     */
    @RequestMapping(value = {"detail"},method = RequestMethod.GET)
    public String articleDetail(@RequestParam(value ="noticeId") String noticeId, Map model,HttpServletRequest request){
        AnnouncementDto notice = new AnnouncementDto();
        String memberId = (String) request.getSession().getAttribute(GlobalContants.SESSION_USER_ID_ITAIPING);
        if(!Lang.isEmpty(noticeId)){
            MemberReadAnnouncementDto m = memberReadAnnouncementApi.getReadAnnounceByReadId(noticeId);
            notice =announcementApi.getAnnouncement(noticeId);
            if(!Lang.isEmpty(m)){
                if(m.getReadAnnouncement()==false){
                    m.setReadAnnouncement(true);
                    memberReadAnnouncementApi.updateIsRead(m);
                }
            }else{
                MemberReadAnnouncementDto memberReadAnnouncement=new MemberReadAnnouncementDto();
                memberReadAnnouncement.setReadAnnouncement(true);
                memberReadAnnouncement.setAnnouncementId(noticeId);
                memberReadAnnouncement.setMemberId(memberId);
                memberReadAnnouncementApi.updateIsRead(memberReadAnnouncement);
            }
            if(notice.getJumpUrl()!=null || notice.getJumpUrl()==""){
                model.put("notice",notice);
                return "redirect:"+notice.getJumpUrl();
            }else{
                model.put("notice",notice);
                return "notice/noticeDetails";
            }
        }
        return "notice/notice";
    }
}
