package ctscore.web.controller.cms;

import cms.api.ArticleApi;
import cms.api.ChannelApi;
import cms.api.dto.ArticleDto;
import cms.api.dto.ChannelDto;
import cms.api.vo.ArticleVo;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import utils.Lang;
import utils.data.Beans;
import utils.log.Log;
import utils.log.Logs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by xhz on 2016/11/25.
 * 栏目文章控制层
 */
@Controller
@RequestMapping("channelArticle")
public class ChannelArticleController {

    private final static Log log = Logs.getLog(ChannelArticleController.class.getName());



    @MotanReferer
    ChannelApi channelApi;

    @MotanReferer
    ArticleApi articleApi;

    @Value("${ctscore.orgCode}")
    private String organizationCode;//机构code值

    @Value("${ctscore.storeCode}")
    private String storeCode;//店铺code

    @RequestMapping(value = {"","list.do"},method = RequestMethod.GET )
    public String index(@RequestParam(value ="channelId" ) String channelId,String key,Map model){
        ChannelDto channel = channelApi.findByChannelId(channelId);
        String channelName =channel.getName();
        model.put("channelId",channelId);
        model.put("channelName",channelName);
        model.put("queryKey",key);
        return "cms/article/articles";
    }

    /**
     * 获取栏目文章列表
     * @param pageable
     * @param title
     * @param channelId
     * @return
     */
    @RequestMapping(value = {"getArticles.do"},method = RequestMethod.POST)
    @ResponseBody
    public Map getChannelArticle(@RequestParam(value = "channelId") String channelId,String title ,Pageable pageable){
        Map articleMap =new HashMap();
        List<ArticleVo> articleVoList =new ArrayList<>();
        pageable = new PageRequest(pageable.getPageNumber(),pageable.getPageSize(),new Sort(Sort.Direction.DESC,"publishDate"));
        Page<ArticleDto> articlePage =articleApi.findArticleByChannel(channelId,title,organizationCode,pageable);
        if(!Lang.isEmpty(articlePage.getContent())){
            for(ArticleDto article :articlePage.getContent()) {
                ArticleVo articleVo =new ArticleVo();
                Beans.from(article).to(articleVo);
                articleVoList.add(articleVo);
            }
        }
        articleMap.put("title",title==null?"":title.trim());
        articleMap.put("data",articleVoList);
        articleMap.put("totalPages",articlePage.getTotalPages());
        articleMap.put("size",articlePage.getSize());
        return articleMap;
    }

    /**
     * 文章详情
     * @param model
     * @param articleId
     * @return
     */
    @RequestMapping(value = {"detail.do"},method = RequestMethod.GET)
    public String articleDetail(@RequestParam(value ="articleId") String articleId,String key,Map model){
        ArticleDto article = new ArticleDto();
        if(!Lang.isEmpty(articleId)){
            article =articleApi.findArticleById(articleId);
        }
        model.put("article",article);
        model.put("queryKey",key);
        return "cms/article/article-detail";
    }
}
