package ctscore.web.controller.goods;

import cms.api.OrganizationApi;
import cms.api.dto.OrganizationDto;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import goods.api.GoodsApi;
import goods.api.GoodsConfigApi;
import goods.api.GoodsPictureApi;
import goods.api.SalesPriceRateQueryApi;
import goods.dto.goods.GoodsConfigDto;
import goods.dto.goods.GoodsDto;
import goods.dto.goods.GoodsPictureDto;
import goods.dto.product.ProductCategoryDto;
import goods.vo.SalesPriceQueryVo;
import jd.api.service.product.JdProductApi;
import jd.dto.StockStateDto;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import store.api.StoreApi;
import store.api.dto.modeldto.core.StoreDto;
import suning.api.SnCommonConvertApi;
import utils.Lang;
import utils.data.BeanMapper;

import java.math.BigDecimal;
import java.util.*;

/**
 * Created by bande on 2018/1/12.
 */
@Controller
@RequestMapping("addGoods")
public class AddGoodsControlleer {


    @MotanReferer
    OrganizationApi organizationApi;

    @MotanReferer
    GoodsApi goodsApi;

    @MotanReferer
    GoodsConfigApi goodsConfigApi;

    @RequestMapping(value = {""}, method = RequestMethod.GET)
    public String getOrgnization(Map model){
        List<OrganizationDto> organizationAll = organizationApi.findOrganizationAll();
        model.put("orgnizations",organizationAll);
        return "goods/addGoods";
    }

    @RequestMapping(value = {"addGoods.do"}, method = RequestMethod.POST)
    @ResponseBody
    public Map addGoodsForSkuAndOrg(String sku,String orgCode){
        Map returnMap=new HashMap<>();
        Set<Long> productNoSet = new HashSet<Long>();
        if(sku.isEmpty()){
            returnMap.put("result","0");
            returnMap.put("message","请输入sku");
            return returnMap;
        }
        productNoSet.add(Long.parseLong(sku));
        List<Long> productNosList;
        int totalNum;
        productNosList = new ArrayList<Long>(productNoSet);
        totalNum = productNosList.size();

        //更新索引和goods_config
        jdProductApi.executorsPoolAdd(productNosList,totalNum,false,50);
        snCommonConvertApi.addProdBySkus(null,sku,null,null,null);
        if(productNosList.size()==0){
            returnMap.put("result","0");
            returnMap.put("message","商品池不存在该sku");
            return returnMap;
        }else{
            //查询goods表有则上架，无则返回
            List<GoodsDto> goods = goodsApi.findBySku(sku);
            if(goods.size()==0){
                returnMap.put("result","0");
                returnMap.put("message","商品池不存在该sku");
                return returnMap;
            }else{
               for(GoodsDto good:goods){
                   if(good.getState().equals("0")){
                       goodsApi.updateGoods(good.getId());
                   }
               }
            }
            //查询goodsConfig表，有则上架，无则插入
            List<GoodsConfigDto> goodsConfigs = goodsConfigApi.findBySkuAndOrganizationCode(sku, orgCode);
            if(!Lang.isEmpty(goodsConfigs)){
                //上架
                for(GoodsConfigDto gc:goodsConfigs){
                    if(!gc.getIsUp()){
                        gc.setIsUp(true);
                    }
                }
            }else{
                //插入
                GoodsConfigDto goodsConfig=new GoodsConfigDto();
                GoodsDto good=goods.get(0);
                String category="";
                String CategoryTextIndex="";
                ProductCategoryDto productCategory = good.getProduct().getProductCategory();
                category=productCategory.getId();
                CategoryTextIndex=productCategory.getName();
                ProductCategoryDto parent = productCategory.getParent();
                if(parent!=null){
                    category=category+","+parent.getId();
                    ProductCategoryDto parent1 = parent.getParent();
                    if(parent1!=null){
                        category=category+","+parent1.getId();
                        ProductCategoryDto parent2 = parent1.getParent();
                        if(parent2!=null){
                            category=category+","+parent2.getId();
                            ProductCategoryDto parent3 = parent2.getParent();
                            if(parent3!=null){
                                category=category+","+parent3.getId();
                                ProductCategoryDto parent4 = parent3.getParent();
                                if(parent4!=null){
                                    category=category+","+parent4.getId();
                                }
                            }
                        }
                    }
                }
                String storeId= good.getStoreId();
                StoreDto store = storeApi.findByStoreId(storeId);
                goodsConfig.setCategory(category);
                goodsConfig.setCreateDate(System.currentTimeMillis());
                goodsConfig.setGoodsId(good.getId());
                goodsConfig.setIsUp(true);

                GoodsPictureDto goodsPicture = goodsPictureApi.findGoodsPicture(good.getId());
                goodsConfig.setLogoUrl(goodsPicture.getBigPicturePath());
                OrganizationDto organization = organizationApi.findOrganizationByOrgCode(orgCode);
                goodsConfig.setOrganizationId(organization.getId());
                SalesPriceQueryVo salesPriceQueryVo = new SalesPriceQueryVo(orgCode, store.getStoreExt().getCode(), good);
                List<Map> mapList = salesPriceRateQueryApi.getSalesPriceListByParams(Arrays.asList(salesPriceQueryVo));
                if (!Lang.isEmpty(mapList) && mapList.size() == 1) {
                    BigDecimal salePrice = (BigDecimal) mapList.get(0).get("salePrice");
                    goodsConfig.setPrice(salePrice);
                }
                goodsConfig.setSku(sku);
                goodsConfig.setStoreLevel("1");
                goodsConfig.setStoreName(store.getStoreExt().getStoreName());
                goodsConfig.setTitle(good.getName());
                goodsConfig.setCategoryTextIndex(CategoryTextIndex);
                goodsConfig.setType("product");
                goodsConfig.setUserId(storeId);
                goodsConfig.setUpTime(new Date());
                goodsConfig.setOrganizationCode(orgCode);
                goodsConfig.setParam(good.getParam());
                goodsConfig.setLastUpdated(new Date());
                goodsConfigApi.save(goodsConfig);
            }
            if("chengtongrenli".equals(orgCode)) {
                //查询CT_STOCK_STATE表，有则上架，无则插入
                List<StockStateDto> stockStates = jdProductApi.findBySku(sku);
                if (stockStates.size() == 0) {
                    StockStateDto stock = new StockStateDto();
                    stock.setSkuId(Long.parseLong(sku));
                    stock.setAreaId("1_2802_2821_0");
                    jdProductApi.save(stock);
                }
            }
            returnMap.put("result","1");
            returnMap.put("message","处理成功");
            return returnMap;
        }

    }


    @MotanReferer
    StoreApi storeApi;

    @MotanReferer
    GoodsPictureApi goodsPictureApi;

    @MotanReferer
    SalesPriceRateQueryApi salesPriceRateQueryApi;
    
    @MotanReferer
    JdProductApi jdProductApi;

    @MotanReferer
    SnCommonConvertApi snCommonConvertApi;
}
