package ctscore.web.controller.goods;

import activities.api.ActivityApi;
import activities.api.ActivityConfigurationApi;
import activities.api.ActivityGoodsApi;
import activities.dto.modeldto.ActivityDefinitionDto;
import activities.dto.modeldto.ActivityGoodsDto;
import activities.vo.ActivityVo;
import cms.api.OrganizationApi;
import cms.api.dto.OrganizationDto;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import ctscore.web.service.area.AreaService;
import ctscore.web.service.goods.GoodWebService;
import ctscore.web.utils.AddressUtil;
import ctscore.web.vo.ActivityProductDetailsVo;
import goods.api.*;
import goods.dto.goods.GoodsConfigDto;
import goods.dto.goods.GoodsDto;
import goods.dto.product.ProductCategoryDto;
import goods.dto.product.ProductDto;
import goods.dto.product.ProductFashionDto;
import goods.model.Goods;
import goods.model.Product;
import goods.model.ProductCategory;
import goods.model.repository.GoodsRepos;
import goods.model.repository.ProductRepos;
import goods.vo.*;
import lombok.extern.slf4j.Slf4j;
import member.api.*;
import member.api.dto.common.AddressCodeDTO;
import member.api.dto.shop.MemberDto;
import member.api.dto.shop.MemberFavoriteDto;
import member.api.dto.shop.MemberViewHisDto;
import member.api.vo.MemberVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import outsideapi.api.OutsideProductApi;
import outsideapi.vo.FashionPriceParamVo;
import outsideapi.vo.FashionPriceRequestVo;
import outsideapi.vo.FashionPriceVo;
import outsideapi.vo.HandlerRespVo;
import search.api.SearchApi;
import search.vo.CommonDoc;
import search.vo.SearchQueryVo;
import search.vo.SearchResultVo;
import store.api.StoreApi;
import sysmg.api.SystemConfigApi;
import sysmg.dto.SystemConfigDto;
import utils.GlobalContants;
import utils.Lang;
import utils.data.BeanMapper;
import utils.data.Jsons;
import utils.lang.Copys;
import utils.web.ResponseMapUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.*;

import static outsideapi.api.OutsideProductApi.SPIDER_TRIGGER_TYPE_PD;

/**
 * Created by Roney on 2016/11/3.
 * @author Roney
 */
@Slf4j
@Controller
@RequestMapping("goodsdetails")
public class GoodsDetailsController {

    @Autowired
    GoodWebService getGoodWebService;

    @MotanReferer
    ShareApi shareApi;

    @MotanReferer
    QueryFootprintsApi queryFootprintsApi;

    @Autowired
    GoodWebService goodWebService;

    @MotanReferer
    ViewHistoryApi viewHistoryApi;

    @MotanReferer
    OutsideProductApi outsideProductApi;

    @MotanReferer
    GoodsApi goodsApi;

    @Autowired
    GoodsRepos goodsRepos;

    @MotanReferer
    PriceParityApi priceParityApi;

    @MotanReferer
    SystemConfigApi systemConfigApi;

    @Value("${ctscore.orgCode}")
    private String organizationCode;

    @Value("${ctscore.storeCode}")
    private String storeCode;

    @MotanReferer
    SalesPriceRateApi salesPriceRateApi;

    @MotanReferer
    SalesPriceRateQueryApi salesPriceRateQueryApi;

    @MotanReferer
    MemberFavoriteApi memberFavoriteApi;

    @MotanReferer
    StoreApi storeApi;

    @MotanReferer
    OrganizationApi organizationApi;

    @MotanReferer
    ProductFashionApi productFashionApi;

    @MotanReferer(basicReferer = "motanClientBasicConfig")
    SearchApi searchApi;

    @MotanReferer
    ProductTaxRateApi productTaxRateApi;

    @MotanReferer
    ProductApi productApi;

    @Autowired
    ProductRepos productRepos;

    @Autowired
    RedisTemplate redisTemplate;

    @MotanReferer
    ActivityGoodsApi activityGoodsApi;

    @MotanReferer
    ActivityConfigurationApi activityConfigurationApi;

    @MotanReferer
    ActivityApi activityApi;

    @MotanReferer
    ProductSpecigicationsApi productSpecigicationsApi;

    @MotanReferer
    GoodsConfigApi goodsConfigApi;

    @MotanReferer
    AddressCommonApi addressCommonApi;

    final static String GOODS_DETAILS_VO_KEY = "goodsDetailsVo";

    @ResponseBody
    @RequestMapping("/getSystemTime")
    public Map<String, Object> getSystemTime() {
        Date systemTime = new Date();
        Map<String, Object> map = new HashMap<>(1);
        map.put("systemTime", systemTime);
        return map;
    }

    @Autowired
    AreaService areaService;

    @Value("${secKillActivity.activityCode}")
    String secKillActivityCode;

    @Value("${tuanGouActivity.activityCode}")
    String tuanGouActivityCode;


    private void base(String goodsId, Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) {
        if (log.isInfoEnabled()) {
            log.info("商品goodsId={}", goodsId);
        }
        Boolean hasCollect = false;
        GoodsDetailsVo goodsDetailsVo;

        long getIpAddressIdsTime = System.currentTimeMillis();
        AddressCodeDTO addressCodeDTO = AddressUtil.getAddressCode(request, addressCommonApi);
        Map addressMap = addressCodeDTO.getAddressCodeMap();
        log.info("获取地址省市区镇代码耗时 {} ms", System.currentTimeMillis() - getIpAddressIdsTime);

        if (Lang.isEmpty(goodsId)) {
            model.put(GlobalContants.ResponseString.MESSAGE, "产品id或者商品ID不能为空");
        } else {
            if (!Lang.isEmpty(goodsId)) {
                long time = System.currentTimeMillis();
                Goods goodsPO = goodsRepos.findOne(goodsId);
                GoodsDto goods = new GoodsDto();
                Copys.create().from(goodsPO).excludes("product", "goodsAttrs", "goodsPictures", "goodsFashions", "goodsParams", "productFashion").to(goods);
                ProductDto productDTO = new ProductDto();
                Copys.create().from(goodsPO.getProduct()).excludes("productCategory", "productStandards", "goodses", "productAttrs", "productFashions", "productParameters").to(productDTO);

                // 依次获取上级分类
                ProductCategory productCategoryPO = goodsPO.getProduct().getProductCategory();
                ProductCategoryDto lastProductCategory = null;
                // 防止无限循环
                int maxLoop = 5;
                while(!Lang.isEmpty(productCategoryPO) && maxLoop > 0) {
                    ProductCategoryDto productCategoryDTO = new ProductCategoryDto();
                    Copys.create().from(productCategoryPO).excludes("parent", "child", "productModel", "productBrands", "productStandards", "productExtendPropertys").to(productCategoryDTO);
                    if(!Lang.isEmpty(lastProductCategory)) {
                        lastProductCategory.setParent(productCategoryDTO);
                    }
                    lastProductCategory = productCategoryDTO;
                    if(Lang.isEmpty(productDTO.getProductCategory())) {
                        productDTO.setProductCategory(productCategoryDTO);
                    }
                    productCategoryPO = productCategoryPO.getParent();
                    maxLoop--;
                }

                goods.setProduct(productDTO);
                log.info("查询 goods 耗时 {} 秒", (System.currentTimeMillis() - time) / 1000.00);

                if (!Lang.isEmpty(goods)) {
                    model.put("goods", goods);
                    if (Lang.isEmpty(goods.getProduct())) {
                        model.put(GlobalContants.ResponseString.MESSAGE, "商品ID未关联产品，无法确定分类，请联系管理员");
                    } else {
                        model = getGoodsDetails(model, goods, request);
                    }
                }
            }
            Object memberId = request.getSession().getAttribute(GlobalContants.SESSION_MEMBER_ID_ITAIPING);
            if (!Lang.isEmpty(memberId)) {
                String collectProductId = model.get("productId").toString();
                List<MemberFavoriteDto> memberFavorites = memberFavoriteApi.listHasFavoriteProducts(memberId.toString(), collectProductId);
                if (!Lang.isEmpty(memberFavorites) && memberFavorites.size() > 0) {
                    hasCollect = true;
                }
            }
            model.put("memberId", memberId);
        }

        goodsDetailsVo = (GoodsDetailsVo) model.get(GOODS_DETAILS_VO_KEY);
        if (goodsDetailsVo.getGoodsVo().getProduct() != null) {
            List<ProductDto> productList = new ArrayList<>();
            productList.add(goodsDetailsVo.getGoodsVo().getProduct());
            List<ProductTaxInfoVo> productTaxInfoVos = productTaxRateApi.getProductTaxInfo(productList);
            if (productTaxInfoVos != null && productTaxInfoVos.size() >= 1) {
                ProductTaxInfoVo productTaxInfoVo = productTaxInfoVos.get(0);
                /** 计算税额 */
                if (productTaxInfoVo != null && productTaxInfoVo.getTaxRate() != null) {
                    BigDecimal taxRate = new BigDecimal(productTaxInfoVo.getTaxRate());
                    // 税费 = [商品金额/(1+税率)] *税率
                    BigDecimal taxPrice = goodsDetailsVo.getGoodsVo().getSalePrice().divide(BigDecimal.ONE.add(taxRate), 2, BigDecimal.ROUND_HALF_UP).multiply(taxRate);
                    model.put("taxPrice", taxPrice);
                } else {
                    model.put("taxPrice", BigDecimal.ZERO);
                }
                model.put("taxRate", productTaxInfoVo == null ? null : productTaxInfoVo.getTaxRate());
            }
        }

        /** 开启前台价展示配置 */
        String trdPriceSwitch = systemConfigApi.getConfigValue(SystemConfigDto.ORG_CODE_COMMON,
                "TRD_PRICE_SHOW_ID_PD_SWITCH",
                "STORE_" + (Lang.isEmpty(storeCode) ? "" : storeCode).toUpperCase(), true, true, true);

        String showPrice = "1";
        if (!Lang.isEmpty(trdPriceSwitch) && showPrice.equals(trdPriceSwitch)) {
            model.put("showPrice", true);
        } else {
            model.put("showPrice", false);
        }

        /** 根据爬虫配置，获取第三方商户的PD页 */
        String pdPageConfigs = systemConfigApi.getConfigValue(
                "" + SystemConfigDto.ORG_CODE_COMMON,
                "" + SystemConfigDto.CONFIG_CODE_STORE_PAGE_CONFIGS,
                "" + SystemConfigDto.CONFIG_VALUE_TYPE_STORE_PD_PAGE_CONFIGS,
                true, true, true
        );

        String pdPageUrl = "javascript:void(0)";
        if (!Lang.isEmpty(pdPageConfigs)) {
            try {
                Map pdPageConfigMap = JSON.parseObject(pdPageConfigs, HashMap.class);
                pdPageUrl = (String) pdPageConfigMap.get(storeCode);
                if (!Lang.isEmpty(pdPageUrl)) {
                    pdPageUrl = pdPageUrl.replace("{sku}", goodsDetailsVo.getGoodsVo().getSku());
                }
            } catch (Exception e) {
                log.error(SystemConfigDto.CONFIG_CODE_STORE_PAGE_CONFIGS + ":" + SystemConfigDto.CONFIG_VALUE_TYPE_STORE_PD_PAGE_CONFIGS + "配置有误，请检查", e);
            }
        }

        model.put("pdPageUrl", pdPageUrl);
        String returnProvoiceId = (String) addressMap.get("provoiceId");
        String returnCityId = (String) addressMap.get("cityId");
        String returnAreaId = (String) addressMap.get("areaId");
        String returnTownId = (String) addressMap.get("townId");
        //区分从店铺页面 页面头部
        String fromStore = request.getParameter("from");
        model.put("provoiceId", returnProvoiceId);
        model.put("cityId", returnCityId);
        model.put("areaId", returnAreaId);
        model.put("townId", returnTownId);
        model.put("fromStore", fromStore);
        model.put("hasCollect", hasCollect);
    }

    @RequestMapping(value = {"", "list"}, method = RequestMethod.GET)
    public String index(String goodsId, String productId, Map model, HttpServletRequest request, HttpServletResponse response) {
        Long startTime = System.currentTimeMillis();
        if (goodsId == null) {
            Product productPO = productRepos.findOne(productId);
            if (!Lang.isEmpty(productPO)) {
                if (!Lang.isEmpty(productPO.getGoodses())) {
                    goodsId = productPO.getGoodses().get(0).getId();
                } else {
                    log.error("productId {} 下没有商品数据");
                    return "redirect:500";
                }
            } else {
                return "redirect:500";
            }
            log.info("查询product耗时{}秒", (System.currentTimeMillis() - startTime) / 1000.00);
        }
        //判断当前是否正处活动场次，如果是则重定向至对应活动页面
        String currentSecKillActivityId = activityConfigurationApi.getCurrentActivityId(organizationCode, goodsId, secKillActivityCode);
        if (!Lang.isEmpty(currentSecKillActivityId)) {
            return "redirect:/goodsdetails/secKill?goodsId=" + goodsId + "&activityId=" + currentSecKillActivityId;
        }
        String currentTuanGouActivityId = activityConfigurationApi.getCurrentActivityId(organizationCode, goodsId, tuanGouActivityCode);
        if (!Lang.isEmpty(currentTuanGouActivityId)) {
            return "redirect:/goodsdetails/tuanGou?goodsId=" + goodsId + "&activityId=" + currentTuanGouActivityId;
        }


        base(goodsId, model, request, response);
        GoodsDetailsVo goodsDetailsVo = (GoodsDetailsVo) model.get(GOODS_DETAILS_VO_KEY);
        if (goodsDetailsVo == null && goodsDetailsVo.getGoodsVo().getState() == 0) {
            //商品已下架，跳转下架页
            return "redirect:500";
        }
        log.info("加载 productDetails 页面 总耗时：{} 秒", (System.currentTimeMillis() - startTime) / 1000.00);
        return "goods/productDetails";
    }

    @RequestMapping(value = {"secKill", "seckill"}, method = RequestMethod.GET)
    public String secKill(String goodsId, String activityId, Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) {
        Long startTime = System.currentTimeMillis();
        base(goodsId, model, request, response);
        if (model.containsKey(GOODS_DETAILS_VO_KEY)) {
            List<ActivityGoodsDto> activityGoodsList = activityGoodsApi.findActivityGoodsByGoodsIdAndActivityId(goodsId, activityId);
            if (activityGoodsList.size() == 1) {
                ActivityGoodsDto activityGoods = activityGoodsList.get(0);
                if (secKillActivityCode.equals(activityGoods.getActivityDefinition().getActivityCode())) {
                    ActivityProductDetailsVo activityProductDetailsVo = new ActivityProductDetailsVo(activityGoods);
                    //开启秒杀商品限购检查
                    activityProductDetailsVo.setCheckGoodsLimited(true);
                    //设置秒杀商品限购1个
                    activityProductDetailsVo.setGoodsLimitedCount(1);
                    //开启秒杀商品库存检查
                    activityProductDetailsVo.setCheckStockLimited(true);
                    //库存数量
                    int activityStock = activityGoodsApi.getCurrentActivityGoodsStockFromCache(organizationCode, goodsId, activityId, secKillActivityCode);
                    //设置秒杀商品库存状态
                    activityProductDetailsVo.setStockLimited(activityStock <= 0);
                    //开启秒杀场次限购检查
                    activityProductDetailsVo.setCheckActivityLimited(true);
                    //秒杀活动限制一个场次只能买一个商品
                    int activityLimitedCount = 1;
                    BigDecimal effectiveOrderCount = activityGoodsApi.getEffectiveOrderCount(request.getSession().getAttribute(GlobalContants.SESSION_MEMBER_ID_ITAIPING) + "", activityId);
                    //设置秒杀场次限购状态
                    activityProductDetailsVo.setActivityLimited(effectiveOrderCount.intValue() >= activityLimitedCount);

                    model.put("activityProductDetailsVo", activityProductDetailsVo);
                } else {
                    log.error("根据商品ID {} 与场次ID {} 找到数据不属于秒杀活动商品", goodsId, activityId, activityGoodsList.size());
                }
            } else {
                log.error("根据商品ID {} 与场次ID {} 找到数据集合大小不是期望值[1]实际大小[{}]", goodsId, activityId, activityGoodsList.size());
            }
        }
        model.put("goodsId", goodsId);
        model.put("activityId", activityId);
        model.put("activityCode", secKillActivityCode);
        log.info("加载 productDetailsSecKill 页面 总耗时：{} 秒", (System.currentTimeMillis() - startTime) / 1000.00);
        return "goods/productDetailsSecKill";
    }

    @RequestMapping(value = {"tuanGou", "tuangou"}, method = RequestMethod.GET)
    public String tuanGou(String goodsId, String activityId, Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) {
        Long startTime = System.currentTimeMillis();
        base(goodsId, model, request, response);
        if (model.containsKey(GOODS_DETAILS_VO_KEY)) {
            List<ActivityGoodsDto> activityGoodsList = activityGoodsApi.findActivityGoodsByGoodsIdAndActivityId(goodsId, activityId);
            if (activityGoodsList.size() == 1) {
                ActivityGoodsDto activityGoods = activityGoodsList.get(0);
                if (tuanGouActivityCode.equals(activityGoods.getActivityDefinition().getActivityCode())) {
                    ActivityProductDetailsVo activityProductDetailsVo = new ActivityProductDetailsVo(activityGoods);
                    //开启商品库存检查
                    activityProductDetailsVo.setCheckStockLimited(true);
                    //库存数量
                    int activityStock = activityGoodsApi.getCurrentActivityGoodsStockFromCache(organizationCode, goodsId, activityId, tuanGouActivityCode);
                    //设置商品库存状态
                    activityProductDetailsVo.setStockLimited(activityStock <= 0);
                    model.put("activityProductDetailsVo", activityProductDetailsVo);
                } else {
                    log.error("根据商品ID {} 与场次ID {} 找到数据不属于团购活动商品", goodsId, activityId, activityGoodsList.size());
                }
            } else {
                log.error("根据商品ID {} 与场次ID {} 找到数据集合大小不是期望值[1]实际大小[{}]", goodsId, activityId, activityGoodsList.size());
            }
        }
        model.put("goodsId", goodsId);
        model.put("activityId", activityId);
        model.put("activityCode", tuanGouActivityCode);
        log.info("加载 productDetailsTuanGou 页面 总耗时：{} 秒", (System.currentTimeMillis() - startTime) / 1000.00);
        return "goods/productDetailsTuanGou";
    }

    /**
     * 动态查询商品价格
     *
     * @return
     */
    @RequestMapping(value = {"queryFashionPrice"}, method = RequestMethod.GET)
    @ResponseBody
    public Map<String, Object> queryFashionPrice(String factionId, String storeCode, String productCode,
                                 String provinceCode, String cityCode, String countyCode, String townCode, Integer count) {
        FashionPriceRequestVo fashionPriceRequestVo = new FashionPriceRequestVo();
        fashionPriceRequestVo.setProvinceCode(provinceCode);
        fashionPriceRequestVo.setCityCode(cityCode);
        fashionPriceRequestVo.setCountyCode(countyCode);
        fashionPriceRequestVo.setTownCode(townCode);
        List<FashionPriceParamVo> fashionPriceParamVos = new ArrayList<>();
        FashionPriceParamVo fashionPriceParamVo = new FashionPriceParamVo();
        fashionPriceParamVo.setFactionId(factionId);
        fashionPriceParamVo.setProductCode(productCode);
        fashionPriceParamVos.add(fashionPriceParamVo);
        fashionPriceRequestVo.setFashionPriceParamVos(fashionPriceParamVos);
        HandlerRespVo<List<FashionPriceVo>> outsideApiRes = outsideProductApi.queryFashionPrice(storeCode, fashionPriceRequestVo);

        Map<String, Object> model = new HashMap<>();
        ProductFashionDto productFashion = productFashionApi.findById(factionId);

        if (outsideApiRes.getStatus() == HandlerRespVo.RESPONSE_STATUS_SUCCESS) {
            model.put(GlobalContants.ResponseString.STATUS, GlobalContants.ResponseStatus.SUCCESS);
            /** 如果是京东的话，返回结果集为空，需标记不进行处理 */
            if (Lang.isEmpty(outsideApiRes.getData())) {
                model.put("priceFlag", 0);
            } else {
                model.put("priceFlag", 1);
                model.put("data", outsideApiRes.getData().get(0));
                FashionPriceVo data = (FashionPriceVo) model.get("data");
                productFashion.setSalePrice(data.getSalePrice());
                productFashion.setMarketPrice(data.getMarketPrice());
                productFashion.setCostPrice(data.getCostPrice());
                /** 使用费率表计算第三方价格 */
                if (!Lang.isEmpty(organizationCode)) {
                    OrganizationDto organization = organizationApi.findOrganizationByOrgCode(organizationCode);
                    if (organization != null) {

                        if (productFashion != null) {
                            BigDecimal rateCalRs = salesPriceRateApi.calSalesPrice(new SalesPriceCalVo(factionId, productFashion.getProduct().getStoreId(),
                                    storeApi.getStoreCode(productFashion.getProduct().getStoreId()), organization.getId(),
                                    productFashion.getSalePrice(),
                                    productFashion.getCostPrice(), productFashion.getMarketPrice(),
                                    productFashion.getCostPrice(), count, organizationCode));
                            if (rateCalRs != null) {
                                if (!Lang.isEmpty(data)) {
                                    data.setSalePrice(rateCalRs);
                                    List<ProductDto> productList = new ArrayList<>();
                                    productList.add(productFashion.getProduct());
                                    /** 计算税额 */
                                    List<ProductTaxInfoVo> productTaxInfoVos = productTaxRateApi.getProductTaxInfo(productList);
                                    if (productTaxInfoVos != null && productTaxInfoVos.size() >= 1) {
                                        ProductTaxInfoVo productTaxInfoVo = productTaxInfoVos.get(0);
                                        if (productTaxInfoVo != null && productTaxInfoVo.getTaxRate() != null) {
                                            BigDecimal taxRate = new BigDecimal(productTaxInfoVo.getTaxRate());
                                            // 税费 = [商品金额/(1+税率)] *税率
                                            BigDecimal taxPrice = data.getSalePrice().divide(BigDecimal.ONE.add(taxRate), 2, BigDecimal.ROUND_HALF_UP).multiply(taxRate);
                                            data.setTaxPrice(taxPrice);
                                        } else {
                                            data.setTaxPrice(BigDecimal.ZERO);
                                        }
                                    }

                                    model.put("data", data);
                                }
                            }
                        }

                    }
                }
            }

        } else {
            model.put(GlobalContants.ResponseString.STATUS, GlobalContants.ResponseStatus.ERROR);
            model.put(GlobalContants.ResponseString.MESSAGE, outsideApiRes.getMessage());
        }
        return model;
    }

    /**
     * 实时查询第三方前台价
     *
     * @return
     */
    @RequestMapping(value = {"trdSalePrice"}, method = RequestMethod.GET)
    @ResponseBody
    public Map queryTrdSalePrice(String goodsId, String fashionId, String areaCode) throws IOException {
        Map respMap = null;
        String sku = null;
        String storeId = null;
        if (Lang.isEmpty(fashionId)) {
            if (!Lang.isEmpty(goodsId)) {
                GoodsDto goods = goodsApi.findById(goodsId);
                sku = goods.getSku();
                storeId = goods.getStoreId();
            }
        } else {
            ProductFashionDto fashion = productFashionApi.findById(fashionId);
            sku = fashion.getProduct().getCode();
            storeId = fashion.getProduct().getStoreId();
        }

        if (!Lang.isEmpty(sku) && !Lang.isEmpty(storeId)) {
            FashionPriceParamVo priceParamVo = new FashionPriceParamVo();
            priceParamVo.setProductCode(sku);
            HandlerRespVo<BigDecimal> respVo = outsideProductApi.runPriceSpider(storeId, priceParamVo, areaCode, SPIDER_TRIGGER_TYPE_PD, false);
            if (respVo.getStatus().equals(HandlerRespVo.RESPONSE_STATUS_SUCCESS)) {
                respMap = ResponseMapUtils.success(respVo.getData());
            } else {
                respMap = ResponseMapUtils.error(respVo.getMessage());
            }
        }

        return respMap;
    }

    /**
     * 比价商品查找
     *
     * @param goodsId
     * @return
     */
    @RequestMapping(value = {"parityGoods"}, method = RequestMethod.GET)
    @ResponseBody
    public Map parityGoods(String goodsId, String provoiceId, String cityId, String areaId) {
        Map rtnMap = null;
        Map rtnData = new HashMap();
        GoodsDto goods = goodsApi.findById(goodsId);
        Map addrMap = new HashMap();
        addrMap.put("provoiceId", provoiceId);
        addrMap.put("cityId", cityId);
        addrMap.put("areaId", areaId);
        rtnMap = ResponseMapUtils.error("NO_PRICE");
        if (goods != null) {
            List<ParityPriceGoodsVo> parityPriceGoodsVos = priceParityApi.parityPrice(goods, organizationCode, addrMap);
            rtnMap = ResponseMapUtils.success(parityPriceGoodsVos);
        }
        return rtnMap;
    }

    /**
     * 动态查询商品价格（主要针对苏宁等需要动态获取价格的商品调用，目前用于比较商品刷新苏宁售价）
     *
     * @return
     */
    @RequestMapping(value = {"goodsPrice"}, method = RequestMethod.GET)
    @ResponseBody
    public Map getSnPrice(String goodsId, String provinceCode, String cityCode, String countyCode, String townCode) {
        Map rtnMap = null;
        Map rtnData = new HashMap();
        GoodsDto goods = goodsApi.findById(goodsId);
        rtnMap = ResponseMapUtils.error("NO_PRICE");
        if (goods != null) {
            String storeCode = storeApi.getStoreCode(goods.getStoreId());
            if (!Lang.isEmpty(storeCode)) {
                OrganizationDto organization = organizationApi.findOrganizationByOrgCode(organizationCode);
                ProductDto product = productApi.findById(goods.getProduct().getId());
                if (product != null) {
                    List<ProductFashionDto> productFashions = product.getProductFashions();
                    if (productFashions.size() > 0) {
                        String fashionId = productFashions.get(0).getId();
                        FashionPriceRequestVo fashionPriceRequestVo = new FashionPriceRequestVo();
                        fashionPriceRequestVo.setProvinceCode(provinceCode);
                        fashionPriceRequestVo.setCityCode(cityCode);
                        fashionPriceRequestVo.setCountyCode(countyCode);
                        fashionPriceRequestVo.setTownCode(townCode);

                        FashionPriceParamVo fashionPriceParamVo = new FashionPriceParamVo();
                        fashionPriceParamVo.setFactionId(fashionId);
                        fashionPriceParamVo.setProductCode(goods.getProduct().getCode());


                        List<FashionPriceParamVo> fashionPriceParamVos = new ArrayList();
                        fashionPriceParamVos.add(fashionPriceParamVo);
                        fashionPriceRequestVo.setFashionPriceParamVos(fashionPriceParamVos);
                        HandlerRespVo<List<FashionPriceVo>> outsideApiRes = outsideProductApi.queryFashionPrice(storeCode, fashionPriceRequestVo);

                        if (outsideApiRes.getStatus() == HandlerRespVo.RESPONSE_STATUS_SUCCESS) {
                            if (!Lang.isEmpty(outsideApiRes.getData())) {
                                FashionPriceVo data = outsideApiRes.getData().get(0);
                                if (!Lang.isEmpty(data)) {
                                    BigDecimal rateCalRs = salesPriceRateApi.calSalesPrice(new SalesPriceCalVo(fashionId, goods.getStoreId(),
                                            storeCode, organization.getId(),
                                            data.getSalePrice(),
                                            data.getCostPrice(), data.getMarketPrice(),
                                            data.getCostPrice(), 1, organizationCode));
                                    if (!Lang.isEmpty(rateCalRs)) {
                                        rtnData.put("salePrice", rateCalRs);
                                        rtnData.put("costPrice", data.getCostPrice());
                                        rtnData.put("marketPrice", data.getMarketPrice());

                                        SalesPriceQueryVo salesPriceQueryVo = new SalesPriceQueryVo(organizationCode, storeCode, goods);
                                        List<Map> mapList = salesPriceRateQueryApi.getSalesPriceListByParams(Arrays.asList(salesPriceQueryVo));
                                        if (!Lang.isEmpty(mapList) && mapList.size() == 1) {
                                            BigDecimal salePrice = (BigDecimal) mapList.get(0).get("salePrice");
                                            if (!Lang.isEmpty(salePrice)) {
                                                rtnData.put("salePrice", salePrice);
                                            }
                                        }

                                        rtnMap = ResponseMapUtils.success(rtnData);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return rtnMap;
    }

    /**
     * 更新产品的价格
     *
     * @return
     */
    @RequestMapping(value = {"updateGoodsPrice"}, method = RequestMethod.GET)
    @ResponseBody
    private Map updateGoodsPrice(String storeCode, String goodsId, String activityId, String factionId, String productCode,
                                 String provinceCode, String cityCode, String countyCode, String townCode, Integer count) {
        Map model = new HashMap();
        BigDecimal oldCostPrice = null;
        BigDecimal oldMarketPrice = null;
        List<ActivityVo> activityVoList = null;
        String key = null;
        //根据factionId找到goodsId
        //判断是否是活动商品，是的话查询价格
        if (!Lang.isEmpty(goodsId)) {
            if (!Lang.isEmpty(activityId)) {
                ActivityDefinitionDto activityDefinition = activityApi.findById(activityId);
                activityVoList = activityConfigurationApi.getGoodsListByActivityId(organizationCode, activityId, activityDefinition.getActivityCode(), storeCode);
                if (!Lang.isEmpty(activityVoList) && activityVoList.size() > 0) {
                    for (ActivityVo activityVo : activityVoList) {
                        if (goodsId.equals(activityVo.getGoodsPicture().getGoods().getId())) {
                            key = activityConfigurationApi.buildKeyForActivityGoods(organizationCode, activityId, activityDefinition.getActivityCode());
                            oldCostPrice = activityVo.getGoodsPicture().getGoods().getCostPrice();
                            oldMarketPrice = activityVo.getGoodsPicture().getGoods().getMarketPrice();
                            break;
                        }
                    }
                }
            } else {
                Goods goods = goodsRepos.findOne(goodsId);
                oldCostPrice = goods.getCostPrice();
                oldMarketPrice = goods.getMarketPrice();
            }
            //更新价格
            Long queryFashionPriceTimer = System.currentTimeMillis();
            goodsApi.queryFashionPrice(organizationCode, factionId, storeCode, productCode, provinceCode, cityCode, countyCode, townCode, count);
            log.info("queryFashionPrice 耗时 {} ms", System.currentTimeMillis() - queryFashionPriceTimer);

            // map goods 耗时 11s 左右
            /*GoodsDto newGoods = goodsApi.findById(goodsId);*/

            // findOne goods 耗时 151ms 左右
            Goods newGoods = goodsRepos.findOne(goodsId);

            BigDecimal newCostPrice = newGoods.getCostPrice();
            BigDecimal newMarketPrice = newGoods.getMarketPrice();
            //比较价格 不同的话刷新缓存
            if (oldMarketPrice != null && oldCostPrice != null && newMarketPrice != null && newCostPrice != null) {
                if (!(oldMarketPrice.toString()).equals(newMarketPrice.toString()) || !oldCostPrice.toString().equals(newCostPrice.toString())) {
                    if (!Lang.isEmpty(key)) {
                        activityConfigurationApi.deleteRedisKey(key);
                    }
                    model.put("update", true);
                }
            }
            model.put("success", "success");
        }
        return model;
    }


    private void createViewHistory(String goodsId, HttpServletRequest request) {
        /** 用户信息 */
        MemberVo memberVo = goodWebService.findMemberVo(request);
        if (memberVo != null) {
            Boolean isAddViewHisFlag = true;
            List<MemberViewHisDto> memberViewHises = viewHistoryApi.getViewHisByMemberId(memberVo.getMember().getId());
            if (!Lang.isEmpty(memberViewHises)) {
                for (MemberViewHisDto memberViewHis : memberViewHises) {
                    if (memberViewHis.getTargetId().equals(goodsId)) {
                        memberViewHis.setDateCreated(new Date());
                        viewHistoryApi.saveViewHis(memberViewHis);
                        isAddViewHisFlag = false;
                        break;
                    } else {
                        continue;
                    }
                }
            }

            if (isAddViewHisFlag) {
                MemberViewHisDto memberViewHis = new MemberViewHisDto(memberVo.getMember(), MemberViewHisDto.VIEHISTORY_TYPE_PRODUCT_ID, goodsId);
                MemberViewHisDto memberViewHis1 = viewHistoryApi.saveViewHis(memberViewHis);
                int maxSize = 50;
                if (memberViewHises.size() == maxSize) {
                    //如果足迹已满50条记录，新增一条记录成功时，删除最早的一条记录
                    if (!Lang.isEmpty(memberViewHis1)) {
                        try {
                            viewHistoryApi.deleteById(memberViewHises.get(0).getId());
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
    }

    private Map<String, Object> getIpAddressIds(HttpServletRequest request) {
        String sessionProvoiceId = (String) request.getSession().getAttribute(GlobalContants.AREA_LEVEL_PROVINCE_ID);
        return areaService.getAddressIdSByParams(request, sessionProvoiceId);
    }

    private Map<String, Object> getGoodsDetails(Map<String, Object> model, GoodsDto goods, HttpServletRequest request) {
        long methodStart = System.currentTimeMillis();
        log.info("### 开始封装 model ... ###");
        ProductDto product = goods.getProduct();
        // 热销商品分类id
        ProductCategoryDto productCategory = product.getProductCategory();
        // Akers Liang 2017-04-21修改： 适配多店铺的费率查询 START */

        long storeCodeTime = System.currentTimeMillis();
        String storeCode = storeApi.findStoreCodeById(goods.getStoreId());
        log.info("查询 storeCode 耗时 {} ms", System.currentTimeMillis() - storeCodeTime);

        List<Map<String, String>> categoryList = new ArrayList<>();
        Map<String, String> map = Maps.newHashMap();
        map.put(productCategory.getId(), productCategory.getName());
        categoryList.add(map);
        while (productCategory.getParent() != null && !productCategory.getParent().getId().equals(productCategory.getId())) {
            productCategory = productCategory.getParent();
            Map<String, String> mapt = Maps.newHashMap();
            mapt.put(productCategory.getId(), productCategory.getName());
            categoryList.add(mapt);
        }
        categoryList = Lists.reverse(categoryList);
        model.put("categoryList", categoryList);
        model.put("productCategory", productCategory);

        Long goodsDetailsVoTime = System.currentTimeMillis();
        GoodsDetailsVo goodsDetailsVo = null;
        if (Lang.isEmpty(goods)) {
            model.put(GlobalContants.ResponseString.MESSAGE, "商品信息不存在，或者商品已经下架了，请返回首页重新购买");
        } else {
            goodsDetailsVo = shareApi.getGoodsDetails(goods.getId());
        }
        model.put(GOODS_DETAILS_VO_KEY, goodsDetailsVo);
        log.info("获取 GoodsDetailsVo 耗时 {} ms", System.currentTimeMillis() - goodsDetailsVoTime);

        long salePriceTime = System.currentTimeMillis();
        BigDecimal salePrice = activityGoodsApi.getActivityPrice(goods.getId(), organizationCode, storeCode).setScale(2, BigDecimal.ROUND_UP);
        goodsDetailsVo.getGoodsVo().setSalePrice(salePrice);
        log.info("获取售价耗时 {} ms", System.currentTimeMillis() - salePriceTime);

        Object memberJson = request.getSession().getAttribute(GlobalContants.SESSION_MEMBER_JSON_ITAIPING);
        if (memberJson != null) {
            MemberDto member = JSON.parseObject(memberJson.toString(), MemberDto.class);
            Sort.Order order = new Sort.Order(Sort.Direction.DESC, "dateCreated");
            List<Sort.Order> sortList = new ArrayList<>();
            sortList.add(order);
            Sort sort = new Sort(sortList);
            Pageable pageable = new PageRequest(0, 2, sort);

            long memberViewHisesTime = System.currentTimeMillis();
            List<MemberViewHisDto> memberViewHises = queryFootprintsApi.getMemberViewHis(member, MemberViewHisDto.VIEHISTORY_TYPE_PRODUCT_ID, pageable);
            log.info("查询用户浏览历史耗时 {} ms", System.currentTimeMillis() - memberViewHisesTime);

            List<String> goodsIds = new ArrayList<>();
            if (!Lang.isEmpty(memberViewHises)) {
                for (MemberViewHisDto memberViewHis : memberViewHises) {
                    goodsIds.add(memberViewHis.getTargetId());
                }
            }

            long commonDocListTime = System.currentTimeMillis();
            List<CommonDoc> commonDocList = getGoodWebService.setCommonDocList(goodsIds);
            model.put("commonDocList", commonDocList);
            log.info("查询我的足迹耗时 {} ms", System.currentTimeMillis() - commonDocListTime);
        }

        long hotSalesTime = System.currentTimeMillis();
        SearchQueryVo searchQueryVo = new SearchQueryVo();
        searchQueryVo.setType(SearchQueryVo.TYPE_PRODUCT);
        searchQueryVo.putQueryArgs("category", productCategory.getId());

        SearchQueryVo hotq = BeanMapper.map(searchQueryVo, SearchQueryVo.class);
        hotq.setSale(true);
        if (!StringUtils.isEmpty(goods.getStoreId())) {
            hotq.putQueryArgs("userId", goods.getStoreId());
        }
        hotq.setOrganizationCode(organizationCode);

        SearchResultVo hotSales = searchApi.query(hotq, 6, 0);
        log.info("查询热卖商品耗时 {} ms", System.currentTimeMillis() - hotSalesTime);

        model.put("hotSales", hotSales);
        model.put("storeCode", storeCode);
        model.put("productId", product.getId());
        model.put("storeId", goods.getStoreId());
        model.put("goodsId", goods.getId());

        long productFasionIdTime = System.currentTimeMillis();
        String productFasionId = productFashionApi.findIdByGoodsId(goods.getId());
        if (Lang.isEmpty(productFasionId)) {
            List<String> productFashionIds = productFashionApi.findIdsByProductId(product.getId());
            log.info("查询 ProductFashionIds 耗时 {} ms", System.currentTimeMillis() - productFasionIdTime);
            productFasionId = productFashionIds.get(0);
        }
        model.put("productFashId", productFasionId);

        long goodsConfigCheckTime = System.currentTimeMillis();
        // 2018-01-25 下架处理
        List<GoodsConfigDto> goodsConfigs = new ArrayList<>();
        List<GoodsConfigDto> goodsConfigsTemp = goodsConfigApi.findBySkuAndOrganizationCode(goods.getSku(), organizationCode);
        // 过滤无效数据
        if (!Lang.isEmpty(goodsConfigsTemp)) {
            for (GoodsConfigDto goodsConfig : goodsConfigsTemp) {
                if (Lang.isEmpty(goodsConfig.getIsDelete()) || !goodsConfig.getIsDelete()) {
                    goodsConfigs.add(goodsConfig);
                }
            }
        }

        if (Lang.isEmpty(goodsConfigs)) {
            model.put("isDown", "非当前渠道商品");
            log.info("非当前渠道商品。 渠道代码: {}, SKU: {}", organizationCode, goods.getSku());
        } else {

            GoodsConfigDto goodsConfig = goodsConfigs.get(0);
            if (!goodsConfig.getUp()) {
                model.put("isDown", "渠道商品已下架");
                log.info("渠道商品已下架。 渠道代码: {}, SKU: {}", organizationCode, goods.getSku());
            }
        }
        log.info("商品上下架状态校验耗时 {} ms ", System.currentTimeMillis() - goodsConfigCheckTime);

        long createViewHistoryTime = System.currentTimeMillis();
        createViewHistory(goodsDetailsVo.getGoodsVo().getId(), request);
        log.info("创建历史浏览记录耗时 {} ms", System.currentTimeMillis() - createViewHistoryTime);

        log.info("### 封装 model 总耗时 {} ms ###", System.currentTimeMillis() - methodStart);
        return model;
    }

    @ResponseBody
    @RequestMapping(value = {"loadProductSpecifications"}, method = RequestMethod.POST)
    public String loadPproductSpecifications(String goodsId) {
        Map<String, Object> map = new HashMap<>();
        long start = System.currentTimeMillis();
        ProductSpecificationsVo productSpecificationsVo;
        productSpecificationsVo = productSpecigicationsApi.getProductSpecificationsVo(goodsId, organizationCode);
        log.info("查询商品规格耗时 {} ms", System.currentTimeMillis() - start);
        map.put("productSpecificationsVo", productSpecificationsVo);
        map.put(GlobalContants.ResponseString.STATUS, GlobalContants.ResponseStatus.SUCCESS);
        return Jsons.map2json(map);
    }

}