package ctscore.web.controller.goods;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import ctscore.web.service.area.AreaService;
import ctscore.web.service.goods.CategroyService;
import ctscore.web.service.goods.GoodWebService;
import goods.api.*;
import goods.dto.GoodsStateDto;
import goods.dto.product.ProductBrandDto;
import goods.dto.product.ProductCategoryDto;
import goods.dto.product.ProductStandardDto;
import goods.model.ProductCategory;
import goods.model.repository.ProductCategoryRepos;
import goods.utils.HttpHeaderUtils;
import goods.vo.SearchKeywordsHisDto;
import jd.api.request.product.StockForOrderEntity;
import jd.api.service.product.JdProductApi;
import jd.api.vo.product.ProductStateVO;
import jd.api.vo.product.StockNewResultVo;
import jd.api.vo.product.StockVO;
import ma.glasnost.orika.MapperFacade;
import member.api.*;
import member.api.dto.common.AddressDto;
import member.api.dto.core.CoreCompDepartUserDto;
import member.api.dto.core.CoreCompanyDto;
import member.api.dto.core.CoreUserDto;
import member.api.dto.shop.MemberAddressDto;
import member.api.vo.CoreCompDepartUserVo;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import outsideapi.api.OutsideProductApi;
import outsideapi.vo.HandlerRespVo;
import search.api.SearchApi;
import search.vo.CommonDoc;
import search.vo.CommonDocVo;
import search.vo.SearchQueryVo;
import search.vo.SearchResultVo;
import store.api.StoreApi;
import store.api.dto.modeldto.core.StoreDto;
import utils.GlobalContants;
import utils.Lang;
import utils.ip.IPtoLong;
import utils.lang.Copys;
import utils.web.Webs;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.*;


/**
 * Created by xiaoqian on 2016/11/22.
 */
@Controller
@RequestMapping("search")
public class SearchController {

    private static final Logger logger = LoggerFactory.getLogger(SearchController.class);


    //    @MotanReferer(directUrl = "127.0.0.1:8029", group = "sinomall")
    @MotanReferer
    SearchApi searchApi;
    @Autowired
    GoodWebService goodWebService;
    @MotanReferer
    SearchKeyWordsApi searchKeyWordsApi;
    @Autowired
    CategroyService categroyService;
    @MotanReferer(basicReferer = "motanClientBasicConfig")
    StoreApi storeApi;

    @MotanReferer(basicReferer = "motanClientBasicConfig")
    CoreCompanyApi coreCompanyApi;

    @MotanReferer(basicReferer = "motanClientBasicConfig")
    CoreUserApi coreUserApi;

    @MotanReferer
    ProductBrandApi productBrandApi;

    @MotanReferer
    JdProductApi jdProductApi;

    @MotanReferer
    MemberAddressApi memberAddressApi;

    @MotanReferer
    AddressCommonApi addressCommonApi;

    @MotanReferer
    OutsideProductApi outsideProductApi;

    @Value("${ctscore.score.proportion}")
    String scorePortion;

    @Value("${ctscore.orgCode}")
    private String organizationCode;//机构code值

    @Value("${ctscore.storeCode}")
    private String storeCode;//店铺code

    @Autowired
    MapperFacade mapperFacade;

    private static final String countSaleSql = "SELECT * FROM (SELECT A.*, ROWNUM RN FROM (SELECT COUNT(oi.id) total, oi.goods_id FROM order_main om , order_item oi, goods g WHERE oi.order_id=om.id AND om.status IN(1,2,3,4,5,7) AND oi.goods_id IS NOT NULL and g.id=oi.goods_id and instr(g.sku, 'JDE') <=0 GROUP BY oi.goods_id ORDER BY total DESC )A ) WHERE RN BETWEEN 1 AND 6 ";


    private static final String randomNumSql = "SELECT * FROM ( SELECT A.*, ROWNUM RN FROM ( select g.id from goods g)A) WHERE RN BETWEEN ? AND ? ";

    @Autowired
    JdbcTemplate jdbcTemplate;

    @Autowired
    AreaService areaService;


    //费率计算
    @MotanReferer
    SalesPriceRateQueryApi salesPriceRateQueryApi;
//    @MotanReferer
//    CoreRelateInfoApi coreRelateInfoApi;

    @MotanReferer
    CoreCompDepartUserApi compDepartUserApi;

    //    @MotanReferer(directUrl = "127.0.0.1:8029", group = "sinomall")
    @MotanReferer
    ShareApi shareApi;

    @MotanReferer
    ProductCategoryApi productCategoryApi;

    @Autowired
    ProductCategoryRepos productCategoryRepos;

    @MotanReferer
    GoodsApi goodsApi;

    @RequestMapping(method = RequestMethod.GET, value = {"/", ""})
    public String index(HttpServletRequest request, Map model) {
        Long startTime = System.currentTimeMillis();
        search(request, null, model);
        logger.info("###############index方法向服务器请求总用时##############：" + (System.currentTimeMillis() - startTime) + "ms");
        return "goods/goodsSearch";
    }

    @RequestMapping(method = RequestMethod.GET, value = {"/{category}", "/{category}/"})
    public String category(HttpServletRequest request, @PathVariable String category, Map model) {
        Long startTime = System.currentTimeMillis();
        search(request, category, model);
        logger.info("###############index方法向服务器请求总用时##############：" + (System.currentTimeMillis() - startTime) + "ms");
        return "goods/goodsSearch";
    }


    private void search(HttpServletRequest request, String category, Map model) {
        Long startTime = System.currentTimeMillis();
        String userid = (String) request.getSession().getAttribute(GlobalContants.SESSION_USER_ID_ITAIPING);

        SearchQueryVo searchQueryVo = new SearchQueryVo();
        model.put("searchQueryVo", searchQueryVo);
        //只查询配置店铺
        if (!StringUtils.isEmpty(storeCode)) {
            String storeIds = "";
            String[] storeCodes = storeCode.split(",");
            for (String code : storeCodes) {
                if (!StringUtils.isEmpty(code)) {
                    StoreDto store = storeApi.findByCode(code);
                    String storeId = store.getId();
                    storeIds = storeIds + storeId + "-";
                }
            }
            if (!StringUtils.isEmpty(storeIds)) {
                storeIds = storeIds.substring(0, storeIds.length() - 1);
                searchQueryVo.putQueryArgs("userId", storeIds);
            }
        }
        if (StringUtils.isBlank(category) || StringUtils.isNotBlank(request.getParameter("category"))) {
            category = request.getParameter("category");
        }
        String def = request.getParameter("default");

        //排序参数处理
        if (StringUtils.equals("true", request.getParameter("price"))) {
            searchQueryVo.setPrice(true);
        } else if (StringUtils.equals("false", request.getParameter("price"))) {
            searchQueryVo.setPrice(false);
        } else if (StringUtils.equals("true", request.getParameter("sale"))) {
            searchQueryVo.setSale(true);
        } else if (StringUtils.equals("false", request.getParameter("sale")) || !Lang.isEmpty(def)) {
            searchQueryVo.setSale(false);
        } else if (StringUtils.equals("true", request.getParameter("newProduct"))) {
            searchQueryVo.setNewProduct(true);
        } else if (StringUtils.equals("false", request.getParameter("newProduct"))) {
            searchQueryVo.setNewProduct(false);
        } else if (StringUtils.equals("true", request.getParameter("new"))) {
            searchQueryVo.setNewProduct(true);
        } else if (StringUtils.equals("false", request.getParameter("new"))) {
            searchQueryVo.setNewProduct(false);
        } else if (StringUtils.equals("true", request.getParameter("comments"))) {
            searchQueryVo.setComments(true);
        } else if (StringUtils.equals("false", request.getParameter("comments"))) {
            searchQueryVo.setComments(false);
        } else if (StringUtils.equals("true", request.getParameter("view"))) {
            searchQueryVo.setView(true);
        } else if (StringUtils.equals("false", request.getParameter("view"))) {
            searchQueryVo.setView(false);
        } else {
            searchQueryVo.setDefaultSort(true);
            def = "true";
        }

        // 二级筛选
        searchQueryVo.setHasStock(request.getParameter("hasStock"));

        //url 筛选条件处理
        List<Map<String, String>> list = Lists.newArrayList();
        StringBuilder storeIds = new StringBuilder();
        StringBuffer brandIds = new StringBuffer();
        for (Map.Entry<String, String[]> stringEntry : request.getParameterMap().entrySet()) {
            if ("price|sale|newProduct|new|comments|view|start|pagesize|pageSize|_time|category|default|hasStock".indexOf(stringEntry.getKey()) < 0) {
                Map map = Maps.newHashMap();
                //只处理4个，以免显示过长
                if (list.size() < 5 && stringEntry.getKey().toLowerCase().indexOf("keyword") < 0) {
                    if (stringEntry.getValue() != null) {
                        String valueStr = null;
                        if (stringEntry.getValue().length > 1) {
                            for (String s : stringEntry.getValue()) {
                                valueStr += s + "|";
                            }
                        } else {
                            valueStr = stringEntry.getValue()[0];
                        }
                        if (valueStr.length() > 20) {
                            valueStr = valueStr.substring(0, 17) + "...";
                        }
                        map.put(stringEntry.getKey(), valueStr);
                        if (!StringUtils.equals("brand", stringEntry.getKey()) && stringEntry.getKey().indexOf("store") < 0) {
                            list.add(map);
                        }
                    }
                }

                //查询条件整理
                String str = request.getParameter(stringEntry.getKey());
                if (StringUtils.isBlank(str)) {
                    continue;
                }
                if (StringUtils.equals("priceRange", stringEntry.getKey())) {
                    if (str.indexOf("以上") >= 0) {
                        searchQueryVo.putQueryArgs("price", str.replaceAll("以上", "") + "-" + 99999999);
                        model.put("pricestart", str.replaceAll("以上", ""));
                        model.put("priceend", "99999999");
                    } else if (str.indexOf("-") > 0) {
                        searchQueryVo.putQueryArgs("price", str);
                        String[] temps = str.split("-");
                        model.put("pricestart", temps[0]);
                        model.put("priceend", temps[1]);
                    }
                } else if (stringEntry.getKey().indexOf("store") >= 0) {
                    if (str.indexOf(",") >= 0) {
                        String[] arrayStr = str.split(",");
                        StringBuffer sbStr = new StringBuffer();
                        for (int i = 0; i < arrayStr.length; i++) {
                            StoreDto store = storeApi.findByStoreId(arrayStr[i]);
                            if (!Lang.isEmpty(store)) {
                                if (i == 0) {
                                    sbStr.append(store.getStoreExt().getShortName());
                                } else {
                                    sbStr.append("、").append(store.getStoreExt().getShortName());
                                }

                            }
                            storeIds.append(arrayStr[i] + "|");
                        }
                        map.put(stringEntry.getKey(), sbStr.toString());
                        list.add(map);
                    } else {
                        StoreDto store = storeApi.findByStoreId(str);
                        if (!Lang.isEmpty(store)) {
                            map.put(stringEntry.getKey(), store.getStoreExt().getShortName());
                            list.add(map);
                        }
                        storeIds.append(str + "|");
                    }

                } else if (stringEntry.getKey().indexOf("brand") >= 0) {

                    if (str.indexOf(",") >= 0) {
                        String[] arrayStr = str.split(",");
                        StringBuffer sbStr = new StringBuffer();
                        for (int i = 0; i < arrayStr.length; i++) {
                            ProductBrandDto productBrand = productBrandApi.findDataById(arrayStr[i]);
                            if (!Lang.isEmpty(productBrand)) {
                                if (i == 0) {
                                    sbStr.append(productBrand.getName());
                                } else {
                                    sbStr.append("、").append(productBrand.getName());
                                }

                            }
                            brandIds.append(arrayStr[i] + "|");
                        }
                        map.put(stringEntry.getKey(), sbStr.toString());
                        list.add(map);
                    } else {
                        ProductBrandDto productBrand = productBrandApi.findDataById(str);
                        if (!Lang.isEmpty(productBrand)) {
                            map.put(stringEntry.getKey(), productBrand.getName());
                            list.add(map);
                        }
                        brandIds.append(str + "|");
                    }

                } else if (stringEntry.getKey().toLowerCase().indexOf("keyword") < 0) {
                    searchQueryVo.putQueryArgs(stringEntry.getKey(), str);
                }
            }
        }
        String storeStr = storeIds.toString();
        if (StringUtils.isNotBlank(storeStr) && storeStr.length() > 1) {
            if (storeStr.endsWith("|")) {
                searchQueryVo.putQueryArgs("userId", storeStr.substring(0, storeStr.length() - 1));
            } else {
                searchQueryVo.putQueryArgs("userId", storeStr);
            }
        }

        /**
         * 品牌
         */
        String brandStr = brandIds.toString();
        if (StringUtils.isNotBlank(brandStr) && brandStr.length() > 1) {
            if (brandStr.endsWith("|")) {
                searchQueryVo.putQueryArgs("brand", brandStr.substring(0, brandStr.length() - 1).replaceAll("\\/", ","));//.replaceAll("-","").replaceAll("\\|",","));
            } else {
                searchQueryVo.putQueryArgs("brand", brandStr);//.replaceAll("-",""));
            }
        }

        model.put("queryKeyword", list);

        searchQueryVo.setType(SearchQueryVo.TYPE_PRODUCT);
        //如果有分类参数，使用分类参数
        ProductCategoryDto productCategory = null;
        ProductCategoryDto productCategoryBrand = null;
        if (!Lang.isEmpty(category)) {
            productCategory = categroyService.findCategory(category);
            productCategoryBrand = productCategory;
            if (!Lang.isEmpty(productCategory)) {
                List<Map<String, String>> categoryList = new ArrayList<>();
                Map<String, String> map = Maps.newHashMap();
                map.put(productCategory.getId(), productCategory.getName());
                categoryList.add(map);
                while (productCategory.getParent() != null && !productCategory.getParent().getId().equals(productCategory.getId())) {
                    productCategory = productCategory.getParent();
                    Map<String, String> mapt = Maps.newHashMap();
                    mapt.put(productCategory.getId(), productCategory.getName());
                    categoryList.add(mapt);
                }

                categoryList = Lists.reverse(categoryList);
                model.put("categoryList", categoryList);
                model.put("productCategory", productCategory);

                searchQueryVo.putQueryArgs("category", category);
            }
        }

        //查询关键字处理
        String keyWord = request.getParameter("keyWord");
        if (Strings.isNullOrEmpty(keyWord)) {
            keyWord = request.getParameter("keyword");
        }
        if (!Strings.isNullOrEmpty(keyWord)) {
            keyWord = keyWord.trim();
            searchQueryVo.setKeyWord(keyWord);
            if (checkWordLength(keyWord)) {
                goodWebService.putKeyWords(GlobalContants.SEARCH_KEYWORD_CT, keyWord);
            }
        }

        //分页处理
        Integer pageSize = 20;
        //pageSize = 1;
        if (request.getParameter("pageSize") != null && StringUtils.isNumeric(request.getParameter("pageSize"))) {
            pageSize = Integer.parseInt(request.getParameter("pageSize"));
        }
        Integer start = 0;
        if (request.getParameter("start") != null && StringUtils.isNumeric(request.getParameter("start"))) {
            start = Integer.parseInt(request.getParameter("start"));
        }

        if (StringUtils.isNotBlank(userid)) {
            CoreUserDto coreUsers = coreUserApi.findById(userid);
//            List<String> relateTypes= utils.string.StringUtils.getStringList(CoreRelateInfo.RELATE_TYPE_COMPANY_USER,CoreRelateInfo.RELATE_TYPE_DDEPARTMENT_USER,CoreRelateInfo.RELATE_TYPE_POSITION_USER);
//            Map orgMap=coreRelateInfoApi.findUserOrgInfo(coreUsers.getId(),relateTypes,false,CoreRelateInfo.DIRECT_RIGHT);

            CoreCompDepartUserDto examp = new CoreCompDepartUserDto();
            examp.setUserId(userid);
            List<CoreCompDepartUserVo> relatedVoList = compDepartUserApi.findRelatedVoByExample(examp);

            if (!Lang.isEmpty(relatedVoList)) {
                CoreCompanyDto company = relatedVoList.get(0).getCoreCompany();
                if (company != null) {
                    //searchQueryVo.setStoreLevel(relatedVoList.get(0).getCoreCompany().getCompanyLevel().toString());
                }
            }

            CoreCompanyDto coreCompany = null;
//            if(!Lang.isEmpty(orgMap)){
//                if(!Lang.isEmpty(orgMap.get("companyList"))){
//                    List<CoreCompanyDto> coreCompanies= (List<CoreCompanyDto>) orgMap.get("companyList");
//                    coreCompany=coreCompanies.get(0);
//                    if(!Lang.isEmpty(coreCompany)) {
//                        searchQueryVo.setStoreLevel(coreCompany.getCompanyLevel().toString());
//
//                    }
//                }
//            }

        }


        //取店铺数据
//        List<StoreDto> stores = storeApi.getStoreList();
//        if (stores != null && stores.size() > 0) {
//            List<CoreCompanyDto> coreCompanies = coreCompanyApi.findAllCompany();
//            Map leve1 = Maps.newHashMap();
//            Map leve2 = Maps.newHashMap();
//            Map leve3 = Maps.newHashMap();
//            Map leve4 = Maps.newHashMap();
//            for (CoreCompanyDto coreCompany : coreCompanies) {
//                if (coreCompany != null && coreCompany.getCompanyLevel() != null) {
//                    switch (coreCompany.getCompanyLevel()) {
//                        case 1:
//                            leve1.put(coreCompany.getId(), coreCompany);
//                        case 2:
//                            leve2.put(coreCompany.getId(), coreCompany);
//                        case 3:
//                            leve3.put(coreCompany.getId(), coreCompany);
//                        case 4:
//                            leve4.put(coreCompany.getId(), coreCompany);
//                    }
//                }
//            }
//            List<StoreDto> stores1 = Lists.newArrayList();
//            List<StoreDto> stores2 = Lists.newArrayList();
//            List<StoreDto> stores3 = Lists.newArrayList();
//            List<StoreDto> stores4 = Lists.newArrayList();
//            for (StoreDto store : stores) {
//                if (leve1.containsKey(store.getCompanyId())) {
//                    stores1.add(store);
//                } else if (leve2.containsKey(store.getCompanyId())) {
//                    stores2.add(store);
//                } else if (leve3.containsKey(store.getCompanyId())) {
//                    stores3.add(store);
//                } else if (leve4.containsKey(store.getCompanyId())) {
//                    stores4.add(store);
//                }
//            }
//            if (!Lang.isEmpty(request.getParameter("stores1")) || !Lang.isEmpty(request.getParameter("stores2")) || !Lang.isEmpty(request.getParameter("stores3")) || !Lang.isEmpty(request.getParameter("stores4"))) {
//                stores1 = Lists.newArrayList();
//                stores2 = Lists.newArrayList();
//                stores3 = Lists.newArrayList();
//                stores4 = Lists.newArrayList();
//            }
//            model.put("stores1", stores1);
//            model.put("stores2", stores2);
//            model.put("stores3", stores3);
//            model.put("stores4", stores4);
//        }


        //整理页面查询条件
        String queryStr = request.getParameter("query");
        if (StringUtils.isNotBlank(queryStr)) {
            String[] querys = queryStr.split("[,|;]");
            for (String query : querys) {
                if (query != null) {
                    String[] keywords = query.split(":");
                    if (keywords != null && keywords.length == 2) {
                        searchQueryVo.putQueryArgs(keywords[0], keywords[1]);
                    }
                }
            }
        }
        SearchQueryVo hotq = new SearchQueryVo();
        try {
            BeanUtils.copyProperties(hotq, searchQueryVo);
            hotq.setQueryMap(Maps.<String, String>newHashMap());
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
        if (StringUtils.isBlank(hotq.getKeyWord()) && (hotq.getQueryMap() == null || hotq.getQueryMap().size() == 0)) {
            //hotq.setKeyWord("*");
            hotq.putQueryArgs("price", "0-9999999");
        }
        //添加店铺发起人id
        if (searchQueryVo.getQueryMap().containsKey("userId")) {
            hotq.putQueryArgs("userId", searchQueryVo.getQueryMap().get("userId"));
        }
        hotq.setPrice(null);
        //改为false  兼容按销量筛选
        hotq.setSale(false);
        hotq.setNewProduct(null);
        hotq.setView(null);
        hotq.setOrganizationCode(organizationCode);
        SearchResultVo hotSales = searchApi.query(hotq, 6, 0);
        logger.info("###############hotSales方法向服务器请求总用时##############：" + (System.currentTimeMillis() - startTime) + "ms");
        startTime = System.currentTimeMillis();
        /**
         * 没有热销商品的时候，做成跟京东类似
         * 1.从订单里面进行查询
         * 2.随机获取数据
         */
        if (!Lang.isEmpty(hotSales) && hotSales.getResult().size() == 0) {
            List rows = jdbcTemplate.queryForList(countSaleSql);
            List<CommonDoc> resultList = new ArrayList<>();
            List<String> idList = new ArrayList<>();
            if (!Lang.isEmpty(rows) && rows.size() > 0) {
                Iterator it = rows.iterator();
                while (it.hasNext()) {
                    Map rowMap = (Map) it.next();
                    String goodsId = (String) rowMap.get("goods_id");
                    logger.info("goodsId{}", goodsId);
                    idList.add(goodsId);
                }
                List<goods.dto.search.CommonDoc> commonDocs = shareApi.setCommonDocList(idList);
                hotSales.setResult(mapperFacade.mapAsList(commonDocs, CommonDoc.class));
            } else {//随机获取
                int max = 13000;
                int min = 0;
                Random random = new Random();

                int pageStart = random.nextInt(max) % (max - min + 1) + min;
                int pageEnd = pageStart + 5;
                List rondomRows = jdbcTemplate.queryForList(randomNumSql, pageStart, pageEnd);
                if (!Lang.isEmpty(rondomRows) && rondomRows.size() > 0) {
                    Iterator it = rondomRows.iterator();
                    while (it.hasNext()) {
                        Map rowMap = (Map) it.next();
                        String goodsId = (String) rowMap.get("id");
                        logger.info("goodsId{}", goodsId);
                        idList.add(goodsId);
                    }
                    List<goods.dto.search.CommonDoc> commonDocs = shareApi.setCommonDocList(idList);
                    hotSales.setResult(mapperFacade.mapAsList(commonDocs, CommonDoc.class));
                }

            }

        }
        //费率
        // convertSalePrice(hotSales);
        model.put("hotSales", hotSales);
        transformPicture(hotSales);
        logger.info("###############hotsale##############：" + (System.currentTimeMillis() - startTime) + "ms");
        startTime = System.currentTimeMillis();

        if (StringUtils.isBlank(searchQueryVo.getKeyWord()) && (searchQueryVo.getQueryMap() == null || searchQueryVo.getQueryMap().size() == 0)) {
            //hotq.setKeyWord("*");
            searchQueryVo.putQueryArgs("price", "0-9999999");
        }
        searchQueryVo.setOrganizationCode(organizationCode);


        SearchResultVo searchResultVo;
        List<CommonDoc> commonDocsCheck;
        searchResultVo = searchApi.query(searchQueryVo, 200, 0);
        commonDocsCheck = searchResultVo.getResult();
        if (StringUtils.equals("1", searchQueryVo.getHasStock())) {
            String area = "";//TODO 获取页面的三级地址
            String storeId = storeApi.findStoreIdByCode(storeCode);

            Map addressMap = areaService.getAddressIdSByParams(request, (String) request.getSession().getAttribute(GlobalContants.AREA_LEVEL_PROVINCE_ID));
            String proviceId = (String) addressMap.get("provoiceId");
            String cityId = (String) addressMap.get("cityId");
            String areaId = (String) addressMap.get("areaId");
            String townId = (String) addressMap.get("townId");

            Map<Integer, String> comAddrMap = new HashMap<>();
            comAddrMap.put(AddressCommonApi.AddressLevel.PROVINCE.getValue(), proviceId);
            comAddrMap.put(AddressCommonApi.AddressLevel.CITY.getValue(), cityId);
            comAddrMap.put(AddressCommonApi.AddressLevel.AREA.getValue(), areaId);
            comAddrMap.put(AddressCommonApi.AddressLevel.TOWN.getValue(), townId);

            HandlerRespVo<Map<Integer, String>> jdAddrResp = outsideProductApi.transAreaCodeMap(storeId, comAddrMap);
            if (!Lang.isEmpty(jdAddrResp.getData())) {
                StringBuilder areaTemp = new StringBuilder();
                for (int i = 1; i <= 4; i++) {
                    areaTemp.append(jdAddrResp.getData().get(i));
                    if (i != 4) {
                        areaTemp.append("_");
                    }
                }
                area = areaTemp.toString();
            }

            long t = System.currentTimeMillis();
            List<StockNewResultVo> resultVos;
            Map<String, CommonDoc> skuMap = new HashMap<>();
            if (!Lang.isEmpty(area)) {
                logger.info("转换地址: {}", area);
                List<String> skus = new ArrayList<>();
                for (CommonDoc commonDoc : commonDocsCheck) {
                    if(!Lang.isEmpty(commonDoc.getSku())) {
                        skuMap.put(commonDoc.getSku(), commonDoc);
                        skus.add(commonDoc.getSku());
                    } else {
                        logger.error("索引文件 SKU 为空 DATA : {}", JSON.toJSONString(commonDoc));
                    }
                }
                resultVos = stockState(skus, area);
            } else {
                resultVos = new ArrayList<>();
                logger.info("转换地址为空");
            }
            logger.info("库存过滤耗费时间 {} ms", System.currentTimeMillis() - t);
            List<CommonDoc> newResult = new ArrayList<>();

            // 保持原有顺序
            for (CommonDoc commonDoc : commonDocsCheck) {
                for (StockNewResultVo resultVo : resultVos) {
                    if(!Lang.isEmpty(commonDoc.getSku())) {
                        if (resultVo.hasStock() && commonDoc.getSku().equals(resultVo.getSkuId() + "")) {
                            newResult.add(skuMap.get(resultVo.getSkuId() + ""));
                            break;
                        }
                    }
                }
            }

            //计算新的分页结果
            searchResultVo.setStart(start);
            searchResultVo.setPageSize(pageSize);
            searchResultVo.setTotal(newResult.size());
            int l = pageSize * start;
            int r = l + pageSize;
            List<CommonDoc> commonDocPage = new ArrayList<>();
            for (int i = l; i < r && i < newResult.size(); i++) {
                commonDocPage.add(newResult.get(i));
            }
            searchResultVo.setResult(commonDocPage);
        } else {
            searchResultVo = searchApi.query(searchQueryVo, pageSize, start);
        }
        //最多200条记录展示
        if (searchResultVo.getTotal() > 200) {
            searchResultVo.setTotal(200);
        }

        transformPicture(searchResultVo);
//        if (start == 0 && !Lang.isEmpty(keyWord)) {//如果是第一页,并且关键字是不为空
//            String sku = keyWord;
//            String orgCode = organizationCode;
//            goods.dto.search.SearchResultVo returnSearchResultVo = shareApi.convertSearchResultVo(sku, orgCode, mapperFacade.map(searchResultVo, goods.dto.search.SearchResultVo.class));
//            searchResultVo = mapperFacade.map(returnSearchResultVo, SearchResultVo.class);
//        }
        //费率
        // convertSalePrice(searchResultVo);
        model.put("searchResultVo", searchResultVo);
        logger.info("###############searchResult##############：" + (System.currentTimeMillis() - startTime) + "ms");
        startTime = System.currentTimeMillis();
        //计算出过滤条件
        List<ProductBrandDto> brands = Lists.newArrayList();
        List<ProductStandardDto> standards = Lists.newArrayList();
        Double maxPrice = 0d;
        searchQueryVo.setOrganizationCode(organizationCode);
        SearchResultVo searchResultVoTemp = searchApi.query(searchQueryVo, 100, 0);
        if (searchResultVoTemp != null && searchResultVoTemp.getResult() != null && searchResultVoTemp.getResult().size() > 0) {
            List<CommonDoc> commonDocs = searchResultVoTemp.getResult();
            Map<String, Integer> map = Maps.newHashMap();
            List<String> brandIdList = new ArrayList<>();

            List<String> goodsIdList = new ArrayList<>();
            for (CommonDoc commonDoc : commonDocs) {

                if (commonDoc.getPrice() != null && maxPrice < commonDoc.getPrice()) {
                    maxPrice = commonDoc.getPrice();
                }

                if (!Lang.isEmpty(commonDoc.getBrand())) {
                    brandIdList.add(commonDoc.getBrand());
                } else {
                    goodsIdList.add(commonDoc.getGoodsId());
                }

            }
            brands = setBrandsByIds(brandIdList);
            if (Lang.isEmpty(brands)) {
                brands = setBrandsByGoodsIds(goodsIdList);
            }
            if (!Lang.isEmpty(productCategoryBrand)) {
                //是分类入口，过滤条件直接从分类中取
                brands = productCategoryBrand.getProductBrands();
                if (Lang.isEmpty(brands) && brands.size() == 0) {
                    List<ProductBrandDto> brands1 = Lists.newArrayList();
                    List<ProductBrandDto> brands2 = Lists.newArrayList();

                    /*List<ProductCategoryDto> productCategoryBrandChild = productCategoryApi.findByParentIdAndIsDeleteOrderByShowIndexAsc(productCategoryBrand.getId(), false);*/
                    List<ProductCategoryDto> productCategoryBrandChild = new ArrayList<>();
                    List<ProductCategory> productCategoryBrandChildPO = productCategoryRepos.findByParentIdAndIsDeleteOrderByShowIndexAsc(productCategoryBrand.getId(), false);
                    Copys copys = Copys.create();
                    productCategoryBrandChildPO.forEach(productCategoryPO -> {
                        ProductCategoryDto productCategoryDTO = new ProductCategoryDto();
                        copys.from(productCategoryPO).excludes("parent", "child", "productModel", "productBrands", "productStandards", "productExtendPropertys").to(productCategoryDTO).clear();
                        List<ProductBrandDto> productBrandDTOs = new ArrayList<>();
                        productCategoryPO.getProductBrands().forEach(productBrandPO -> {
                            ProductBrandDto productBrandDTO = new ProductBrandDto();
                            copys.from(productBrandPO).excludes("parent", "child").to(productBrandDTO).clear();
                            productBrandDTOs.add(productBrandDTO);
                        });
                        productCategoryDTO.setProductBrands(productBrandDTOs);
                        productCategoryBrandChild.add(productCategoryDTO);
                    });

                    if(!Lang.isEmpty(productCategoryBrandChild)) {
                        for (ProductCategoryDto productCategoryChild : productCategoryBrandChild) {
                            brands1.addAll(productCategoryChild.getProductBrands());
                        }
                    }
                    if (Lang.isEmpty(brands1)) {
                        for (ProductCategoryDto productCategoryChild : productCategoryBrand.getChild()) {

                            /*List<ProductCategoryDto> productCategoryChildChilds = productCategoryApi.findByParentIdAndIsDeleteOrderByShowIndexAsc(productCategoryChild.getId(), false);*/

                            List<ProductCategoryDto> productCategoryChildChilds = new ArrayList<>();
                            List<ProductCategory> productCategoryChildChildsPO = productCategoryRepos.findByParentIdAndIsDeleteOrderByShowIndexAsc(productCategoryChild.getId(), false);
                            productCategoryBrandChildPO.forEach(productCategoryPO -> {
                                ProductCategoryDto productCategoryDTO = new ProductCategoryDto();
                                copys.from(productCategoryPO).excludes("parent", "child", "productModel", "productBrands", "productStandards", "productExtendPropertys").to(productCategoryDTO).clear();
                                List<ProductBrandDto> productBrandDTOs = new ArrayList<>();
                                productCategoryPO.getProductBrands().forEach(productBrandPO -> {
                                    ProductBrandDto productBrandDTO = new ProductBrandDto();
                                    copys.from(productBrandPO).excludes("parent", "child").to(productBrandDTO).clear();
                                    productBrandDTOs.add(productBrandDTO);
                                });
                                productCategoryDTO.setProductBrands(productBrandDTOs);
                                productCategoryBrandChild.add(productCategoryDTO);
                            });


                            if(!Lang.isEmpty(productCategoryChildChilds)) {
                                for (ProductCategoryDto productCategoryChildChild : productCategoryChildChilds) {
                                    brands2.addAll(productCategoryChildChild.getProductBrands());
                                }
                            }
                        }
                        if (Lang.isEmpty(brands2)) {
                            Pageable pageable = new PageRequest(0, 20);
                            brands = productBrandApi.listAllBrands(pageable).getContent();
                        } else {
                            brands = brands2;
                        }
                    } else {
                        brands = brands1;
                    }


                }
                List newList = new ArrayList(new HashSet(brands));
                brands = newList;
                standards = productCategoryBrand.getProductStandards();
            } else {
                //取出最多相同，其它的排到后面
                String categoryId = null;
                Integer max = -1;
                for (Map.Entry<String, Integer> entry : map.entrySet()) {
                    if (entry.getValue() > max) {
                        max = entry.getValue();
                        categoryId = entry.getKey();
                    }
                }
                if (categoryId != null) {
                    logger.info("categoryId=" + categoryId);
                    if (categoryId.indexOf(",") >= 0) {
                        String[] arrayCategory = categoryId.split(",");
                        List<String> categoryIdList = new ArrayList();
                        for (int i = 0; i < arrayCategory.length; i++) {
                            categoryIdList.add(arrayCategory[i]);

                        }
                        List<ProductCategoryDto> productCategorys = setProductCategoryList(categoryIdList);
                        for (ProductCategoryDto category1 : productCategorys) {
                            if (category1 != null) {
                                brands.addAll(category1.getProductBrands());
                                standards.addAll(category1.getProductStandards());
                            }
                        }
                    } else {
                        ProductCategoryDto category1 = productCategoryApi.findOne(categoryId);//(addMatchStr(categoryId));
                        if (category1 != null) {
                            brands.addAll(category1.getProductBrands());
                            standards.addAll(category1.getProductStandards());
                        }
                    }
                }
                if (Lang.isEmpty(brands)) {
                    for (String cstr : map.keySet()) {
                        logger.info("categoryId cstr  =" + cstr);
                        //已经加过
                        if (cstr.equals(categoryId)) {
                            continue;
                        }
                        if (cstr.indexOf(",") >= 0) {
                            String[] arrayCategory = cstr.split(",");
                            List<String> categoryIdList = new ArrayList();
                            for (int i = 0; i < arrayCategory.length; i++) {
                                categoryIdList.add(arrayCategory[i]);

                            }
                            List<ProductCategoryDto> productCategorys = setProductCategoryList(categoryIdList);
                            for (ProductCategoryDto category1 : productCategorys) {
                                if (category1 != null) {
                                    brands.addAll(category1.getProductBrands());
                                    standards.addAll(category1.getProductStandards());
                                }
                            }
                        } else {
                            ProductCategoryDto category1 = productCategoryApi.findOne(cstr);
                            if (category1 != null) {
                                brands.addAll(category1.getProductBrands());
                                standards.addAll(category1.getProductStandards());
                            }
                        }


                    }
                }

            }
        }
        //  }

        logger.info("###############queryParams##############：" + (System.currentTimeMillis() - startTime) + "ms");
        startTime = System.currentTimeMillis();
        //大于100和数据量多的时候才产生价格区间
        if (maxPrice > 10 && searchResultVo.getResult().size() != 1 && Lang.isEmpty(request.getParameter("priceRange"))) {
            Double tem = (maxPrice / 6);
            List<String> priceRange = new ArrayList<>();
            for (int i = 0; i < 6; i++) {
                if (i == 0) {
                    priceRange.add((0 + (i * tem.intValue())) + "-" + (tem.intValue() + (i * tem.intValue())));
                } else if (i < 5) {
                    priceRange.add((1 + (i * tem.intValue())) + "-" + (tem.intValue() + (i * tem.intValue())));
                } else {
                    priceRange.add(((i * tem.intValue())) + "以上");
                }
            }
            model.put("priceRange", priceRange);
        }

        //关键词搜索，直接拿20条数据的的品牌
        if (!Lang.isEmpty(searchResultVo) && !Lang.isEmpty(searchResultVo.getResult()) && (Lang.isEmpty(brands))) {
            List<CommonDoc> commonDocs = searchResultVo.getResult();
            List<String> brandIdList = new ArrayList<>();

            List<String> goodsIdList = new ArrayList<>();
            for (CommonDoc commonDoc : commonDocs) {
                if (!Lang.isEmpty(commonDoc.getBrand())) {
                    brandIdList.add(commonDoc.getBrand());
                } else {
                    goodsIdList.add(commonDoc.getGoodsId());
                }

            }
            brands = setBrandsByIds(brandIdList);
            if (Lang.isEmpty(brands)) {

                brands = setBrandsByGoodsIds(goodsIdList);
            }
            logger.info("###############keywords##############：" + (System.currentTimeMillis() - startTime) + "ms");
            startTime = System.currentTimeMillis();

            try {
                if (Lang.isEmpty(brands)) {
                    Pageable pageable = new PageRequest(0, 20);
                    brands = productBrandApi.listAllBrands(pageable).getContent();
                }
            } catch (Exception ex) {
                logger.error("ex:{}", ex);
            }
        }

        /**
         * 去掉重复的品牌
         */
        if (brands != null) {
            List newList = new ArrayList(new HashSet(brands));
            brands = newList;
        }
        if (!Lang.isEmpty(request.getParameter("brand")) || Lang.isEmpty(searchResultVo) || (!Lang.isEmpty(searchResultVo) && searchResultVo.getResult().size() == 0)) {
            //进行品牌查询，不显示品牌
            //查询不到数据，不显示品牌
            brands = Lists.newArrayList();
        }


        /**
         * 新增，按照费率进行排序，不生成索引文件，直接使用查询结果来排序
         * Roney add 2017-2-21
         */
//        if(!Lang.isEmpty(searchQueryVo.getDefaultSort())&& searchQueryVo.getDefaultSort()) {//默认排序的时候使用费率进行排序
//            int totalPageSize=500;
//            if(!Lang.isEmpty(searchResultVo.getTotal())&& searchResultVo.getTotal()<totalPageSize){//只获取500条数据
//                totalPageSize=searchResultVo.getTotal();
//            }
//            SearchResultVo searchResultVoTemp2 = searchApi.query(searchQueryVo, totalPageSize, 0);
//            searchResultVo.setResult(ListSplit(searchResultVoTemp2.getResult(), searchResultVoTemp2.getTotal(), start + 1, pageSize));
//
//            model.put("searchResultVo", searchResultVo);
//        }

        /**
         * 新增，按照费率进行排序，不生成索引文件，直接使用查询结果来排序
         * Roney add 2017-2-21
         */

        if (!Lang.isEmpty(def)) {
            searchQueryVo.setSale(null);
            searchQueryVo.setDefaultSort(true);
        }

        /**Akers 2017-10-19修改： 记录搜索信息 START */
        SearchKeywordsHisDto searchKeywordsHisDto = new SearchKeywordsHisDto();
        searchKeywordsHisDto.setSearchId(userid);
        searchKeywordsHisDto.setKeyWord(keyWord);
        searchKeywordsHisDto.setOrganizationCode(organizationCode);
        searchKeywordsHisDto.setHttpHeaderInfo(HttpHeaderUtils.getHeaderInfo(request));
        searchKeyWordsApi.saveHis(searchKeywordsHisDto);
        /**Akers 2017-10-19修改： 记录搜索信息 END */

        model.put("brands", brands);
        model.put("standards", standards);
        // model.put("scorePortion", new BigDecimal(scorePortion));
        // setSaleCount(searchResultVo);  //设置商品售出数量
    }

    public Map getCityAndAreaId(String provoiceId) {
        Map returnAddressIdMap = new HashMap();

        String returnCityId = null;
        String returnAreaId = null;
        AddressDto a = addressCommonApi.findFirstChild(provoiceId, true);
        if (a != null) {
            returnCityId = a.getId();
            if (!Lang.isEmpty(a.getChild())) {
                returnAreaId = a.getChild().get(0).getId();
            }
        }
        returnAddressIdMap.put("cityId", returnCityId);
        returnAddressIdMap.put("areaId", returnAreaId);
        return returnAddressIdMap;
    }

    public Map getAddressId(HttpServletRequest request, String cityId, String areaId, String provoiceId) {
        Map returnAddressIdMap = new HashMap();

        String returnCityId = null;
        String returnAreaId = null;
        String returnTownId = null;
        String remoteIp = Webs.getIp(request);
//        remoteIp = "183.43.167.15";
        if (!Lang.isEmpty(remoteIp)) {
            Long ipL = IPtoLong.ipToLong(remoteIp);
            AddressDto currentAaddress = null;
            if (Lang.isEmpty(areaId)) {//直接定位到当前位置所在的第三级
                currentAaddress = addressCommonApi.findAreaByIp(ipL, GlobalContants.AREA_LEVEL_AREA);

                if (!Lang.isEmpty(currentAaddress)) {//查询第2级
//                    currentAaddress = addressCommonApi.findAreaByIp(ipL, GlobalContants.AREA_LEVEL_CITY);
//                    if (Lang.isEmpty(currentAaddress)) {
//                        Map<String, Object> areaMap = getCityAndAreaId(provoiceId);
//                        returnCityId = (String) areaMap.get("cityId");
//                        returnAreaId = (String) areaMap.get("areaId");
//                        returnTownId = (String) areaMap.get("townId");
//                    } else {
//                        returnCityId = currentAaddress.getId();
////                        List<AddressDto> areaAddressList=addressCommonApi.addressList(AddressCommonApi.AddressLevel.AREA,returnCityId,false);
//                        AddressDto a = addressCommonApi.findFirstChild(returnCityId, false);
//                        if (a != null) {
//                            returnAreaId = a.getId();
//                            if (!Lang.isEmpty(returnAreaId)) {
//                                AddressDto c = addressCommonApi.findFirstChild(returnAreaId, false);
//                                if (c != null) {
//                                    returnTownId = c.getId();
//                                }
//                            }
//                        }
//                    }
//                } else {
                    returnAreaId = currentAaddress.getId();
                    returnCityId = currentAaddress.getParent().getId();
                }
            }
        }
        if (Lang.isEmpty(returnAreaId)) {
            AddressDto cityAddress = addressCommonApi.findFirstChild(provoiceId, true);
            returnCityId = "110100";
            returnAreaId = "110101";
            returnTownId = "d8a15c70-9c8a-44b6-bc34-06b457ecfaaf";
        }

        request.getSession().setAttribute(GlobalContants.AREA_LEVEL_CITY_ID, returnCityId);
        request.getSession().setAttribute(GlobalContants.AREA_LEVEL_AREA_ID, returnAreaId);
        request.getSession().setAttribute(GlobalContants.AREA_LEVEL_TOWN_ID, returnTownId);

        returnAddressIdMap.put("cityId", returnCityId);
        returnAddressIdMap.put("areaId", returnAreaId);
        returnAddressIdMap.put("townId", returnTownId);
        return returnAddressIdMap;
    }

    //获取默认地址省id
    private String getDefaultProvinceId(HttpServletRequest request) {
        String provinceId = null;  //默认上海
        Object memberId = request.getSession().getAttribute(GlobalContants.SESSION_MEMBER_ID);
        MemberAddressDto defaultAddress = null;
        if (!Lang.isEmpty(memberId)) {
            defaultAddress = memberAddressApi.defaultAddress(memberId.toString());
        }
        if (!Lang.isEmpty(defaultAddress)) {
            provinceId = defaultAddress.getProvinceCode();
        }
        return provinceId;
    }

    /*public Map getAddressIdSByParams(HttpServletRequest request, String proviceId) {
        Map returnAddressIdMap = new HashMap();
        String returnProvoiceId = null;
        String returnCityId = null;
        String returnAreaId = null;
        String sessionProvoiceId = (String) request.getSession().getAttribute(GlobalContants.AREA_LEVEL_PROVINCE_ID);
        String cityId = (String) request.getSession().getAttribute(GlobalContants.AREA_LEVEL_CITY_ID);
        String areaId = (String) request.getSession().getAttribute(GlobalContants.AREA_LEVEL_AREA_ID);
        String tonwId = (String) request.getSession().getAttribute(GlobalContants.AREA_LEVEL_TOWN_ID);
        if (Lang.isEmpty(proviceId)) {
            if (!Lang.isEmpty(sessionProvoiceId)) {
                returnProvoiceId = sessionProvoiceId;
            } else if (!Lang.isEmpty(getDefaultProvinceId(request))) {
                returnProvoiceId = getDefaultProvinceId(request);
            } else {
                String remoteIp = Webs.getIp(request);
                logger.info("getAddressIdsByParams -> remoteIp: " + remoteIp);
                if (!Lang.isEmpty(remoteIp)) {
                    Long ipL = IPtoLong.ipToLong(remoteIp);
                    AddressDto currentAaddress = null;
                    currentAaddress = addressCommonApi.findAreaByIp(ipL, GlobalContants.AREA_LEVEL_PROVINCE);
                    if (!Lang.isEmpty(currentAaddress)) {
                        returnProvoiceId = currentAaddress.getId();
                    } else {
                        returnProvoiceId = "110000";
                    }

                } else {
                    returnProvoiceId = "110000";
                }
            }
        } else {
            if (!Lang.isEmpty(sessionProvoiceId)) {
                if (!proviceId.equals(sessionProvoiceId)) {
                    returnProvoiceId = proviceId;

                } else {
                    returnProvoiceId = sessionProvoiceId;
                }
            } else {
                returnProvoiceId = proviceId;
            }
        }

        Map<String, String> adressIdMap = getAddressId(request, cityId, areaId, returnProvoiceId);

        returnCityId = adressIdMap.get("cityId");
        if (Lang.isEmpty(returnCityId)) {
            returnCityId = "110100";
        }
        returnAreaId = adressIdMap.get("areaId");
        if (Lang.isEmpty(returnAreaId)) {
            returnAreaId = "110101";
        }
        String returnTownId = adressIdMap.get("townId");
        returnTownId = tonwId;

        returnAddressIdMap.put("provoiceId", returnProvoiceId);
        returnAddressIdMap.put("cityId", returnCityId);
        returnAddressIdMap.put("areaId", returnAreaId);
        returnAddressIdMap.put("townId", returnTownId);
        return returnAddressIdMap;
    }*/

    private List<StockNewResultVo> stockState(List<String> skus, String area) {
        List<StockNewResultVo> result = new ArrayList<>();
        int count = 0;
        List<StockVO> skuNums = new ArrayList<>();
        List<Long> longSkus = new ArrayList<>();
        for (String sku : skus) {
            skuNums.add(new StockVO(Long.parseLong(sku), 1));
            longSkus.add(Long.parseLong(sku));
            count++;
            //京东接口每次只能查询100个
            if (count % 100 == 0 || count == skus.size()) {
                StockForOrderEntity stockForOrderEntity = new StockForOrderEntity();
                stockForOrderEntity.setSkuNums(skuNums);
                stockForOrderEntity.setArea(area);
                List<StockNewResultVo> stockNewResultVos = jdProductApi.getStockForOrder(stockForOrderEntity);
                long startTime = System.currentTimeMillis();
                //查询商品京东是否已下架
                List<ProductStateVO> productStateVOS = jdProductApi.getProductState(longSkus);
                Set<Long> saleOutSkus = new HashSet<>();//下架商品sku收集列表
                for (ProductStateVO productStateVO : productStateVOS) {
                    if (productStateVO.getState() == 0) {
                        //商品已下架
                        saleOutSkus.add(productStateVO.getSku());
                    }
                }
                //查询商品内部是否已下架
                List<GoodsStateDto> goodsStateDtos = goodsApi.queryGoodsState(skus);
                if (goodsStateDtos != null && !goodsStateDtos.isEmpty()) {
                    for (GoodsStateDto goodsStateDto : goodsStateDtos) {
                        if (goodsStateDto.getDelete() != null && goodsStateDto.getState() != null && (goodsStateDto.getDelete() || "0".equals(goodsStateDto.getState()))) {
                            saleOutSkus.add(Long.parseLong(goodsStateDto.getSku()));
                        }
                    }
                }
                logger.info("查询商品上下架耗时：{}", System.currentTimeMillis() - startTime);
                if (!saleOutSkus.isEmpty()) {
                    //存在下架商品
                    for (StockNewResultVo stockNewResultVo : stockNewResultVos) {
                        if (!saleOutSkus.contains(stockNewResultVo.getSkuId())) {
                            result.add(stockNewResultVo);
                        }
                    }
                } else if (!Lang.isEmpty(stockNewResultVos)) {
                    result.addAll(stockNewResultVos);
                }
                longSkus.clear();
                skuNums.clear();
            }
        }
        return result;

    }

    public void transformPicture(SearchResultVo searchResultVo) {
        if (searchResultVo != null && searchResultVo.getResult() != null && !searchResultVo.getResult().isEmpty()) {
            for (CommonDoc commonDoc : searchResultVo.getResult()) {
                if (!StringUtils.isEmpty(commonDoc.getLogoUrl())) {
                    commonDoc.setLogoUrl(commonDoc.getLogoUrl().replace("vc", "n7"));
                }
            }
        }
    }

    private List<ProductCategoryDto> setProductCategoryList(List<String> categoryIdList) {
        List<ProductCategoryDto> returnProductCategorys = new ArrayList<>();
        returnProductCategorys = productCategoryApi.findByIdIn(categoryIdList);
        return returnProductCategorys;
    }

    //@Autowired
    //GoodsRepos goodsRepos;

    private List<ProductBrandDto> setBrandsByGoodsIds(List<String> goodsIdList) {
        List<ProductBrandDto> returnBrands = new ArrayList<>();
        // List<String> brandsName=new ArrayList<>();
        List<String> brandsName = goodsApi.findByBrandNameByIds(goodsIdList);
//        for(Goods goods:goodses){
//            if(!Lang.isEmpty(goods.getBrandName())){
//                brandsName.add(goods.getBrandName());
//            }
//        }
        returnBrands = productBrandApi.findByNameIn(brandsName);
        return returnBrands;
    }
//    private List<ProductBrandDto> setBrandsByGoodsIds(List<String> goodsIdList) {
//        List<ProductBrandDto> returnBrands = new ArrayList<>();
//        List<String> brandsName = new ArrayList<>();
//        List<Goods> goodses = goodsApi.findByIdIn(goodsIdList);
//        for (Goods goods : goodses) {
//            if (!Lang.isEmpty(goods.getBrandName())) {
//                brandsName.add(goods.getBrandName());
//            }
//        }
//        returnBrands = productBrandApi.findByNameIn(brandsName);
//        return returnBrands;
//    }

    private List<ProductBrandDto> setBrandsByIds(List<String> brandIdList) {
        List<ProductBrandDto> returnBrands = new ArrayList<>();
        returnBrands = productBrandApi.findByIdIn(brandIdList);
        return returnBrands;
    }

 /*   public SearchResultVo convertSalePrice(SearchResultVo searchResultVo) {

        List<SalesPriceQueryVo> salesPriceQueryVos = new ArrayList<>();

        for (CommonDoc commonDoc : searchResultVo.getResult()) {
            Goods goods = goodsApi.findGoodsById(commonDoc.getId());
            *//**Akers Liang 2017-04-21修改： 多店铺适配，根据产品所属店铺获取StoreCode START *//*
            StoreDto store = storeApi.getStoreInfo(goods.getStoreId());
            storeCode = store.getStoreExt().getCode();
            */

    /**
     * Akers Liang 2017-04-21修改： 多店铺适配，根据产品所属店铺获取StoreCode END
     *//*
            SalesPriceQueryVo salesPriceQueryVo = new SalesPriceQueryVo(organizationCode, storeCode, goods);
            salesPriceQueryVos.add(salesPriceQueryVo);
        }

        List<Map> mapList = salesPriceRateQueryApi.getSalesPriceListByParams(salesPriceQueryVos);
        if (!Lang.isEmpty(mapList)) {
            for (int i = 0; i < mapList.size(); i++) {
                BigDecimal salePrice = (BigDecimal) mapList.get(i).get("salePrice");
                if (!Lang.isEmpty(salePrice)) {
                    searchResultVo.getResult().get(i).setPrice(salePrice.doubleValue());
                }
            }
            // goodsDetailsVo.getGoodsVo().setSalePrice((BigDecimal) mapList.get(0).get(goods.getId()));
        }

        return searchResultVo;
    }

    public List<CommonDoc> ListSplit(List<CommonDoc> listResult, Integer total, Integer page, Integer rows) {

        List<CommonDoc> newList = null;
        List<CommonDoc> list = compareList(listResult);
        newList = list.subList(rows * (page - 1), ((rows * page) > total ? total : (rows * page)));
        return newList;
    }
*/
/*
    private List<CommonDoc> compareList(List<CommonDoc> listResult) {
        List<CommonDocVo> commonDocVos = new ArrayList<>();

        for (CommonDoc commonDoc : listResult) {
            CommonDocVo commonDocVo = new CommonDocVo();
            Beans.from(commonDoc).to(commonDocVo);
            Goods goods = goodsApi.findGoodsById(commonDoc.getId());
            if (!Lang.isEmpty(goods)) {
                commonDocVo.setRangeVal(goods.getCostPrice().divide(goods.getMarketPrice(), 2, BigDecimal.ROUND_DOWN));
            } else {
                commonDocVo.setRangeVal(new BigDecimal(0));
            }
            commonDocVos.add(commonDocVo);
        }

        listSort(commonDocVos);

        List<CommonDoc> returnList = new ArrayList<>();
        for (CommonDocVo commonDocVo : commonDocVos) {
            CommonDoc commonDoc = new CommonDoc();
            Beans.from(commonDocVo).to(commonDoc);
            returnList.add(commonDoc);
        }
        return returnList;

    }
*/
    public void listSort(List<CommonDocVo> resultList) {
        Collections.sort(resultList, new Comparator() {
            public int compare(Object a, Object b) {
                BigDecimal rangeVal1 = ((CommonDocVo) a).getRangeVal();
                BigDecimal rangeVal2 = ((CommonDocVo) b).getRangeVal();
                return rangeVal2.subtract(rangeVal1).compareTo(new BigDecimal(0));//从大到小排序
            }
        });

    }

    //过滤关键字长度
    private Boolean checkWordLength(String keyWord) {
        Boolean canAdd = false;
        String chinese = "[\u4e00-\u9fa5]";
        Integer length = 0;
        if (keyWord.length() <= 12) {
            for (int i = 0; i < keyWord.length(); i++) {
                String temp = keyWord.substring(i, i + 1);
                // 判断是否为中文字符
                if (temp.matches(chinese)) {
                    length += 2;
                } else {
                    length++;
                }
            }
        }
        if (length <= 12) {
            canAdd = true;
        }
        return canAdd;
    }


  /*  private void setSaleCount(SearchResultVo searchResultVo) {
        if (!Lang.isEmpty(searchResultVo) && !Lang.isEmpty(searchResultVo.getResult())) {
            int size = searchResultVo.getResult().size();
            String[] goodsId = new String[size];
            String params = "(";
            int i = 0;
            for (CommonDoc commonDoc : searchResultVo.getResult()) {
                goodsId[i] = commonDoc.getId();
                if (i < size - 1) {
                    params += "?,";
                } else {
                    params += "?)";
                }
                i++;
            }
            String countGoodsSaleSql = "select ot.goods_id gid,sum(ot.count) saleCount from order_item  ot ,order_main om where ot.goods_id in " + params + " and om.status in(1,2,3,4,5,7) and om.id=ot.order_id GROUP by ot.goods_id";
            List saleCountList = jdbcTemplate.queryForList(countGoodsSaleSql, goodsId);
            for (CommonDoc commonDoc : searchResultVo.getResult()) {
                if (!Lang.isEmpty(saleCountList)) {
                    for (Object o : saleCountList) {
                        String goodId = (String) ((Map) o).get("GID");
                        Integer saleNum = ((BigDecimal) ((Map) o).get("SALECOUNT")).intValue();
                        if (commonDoc.getId().equals(goodId)) {
                            commonDoc.setSaleCount(saleNum);
                            break;
                        }
                    }
                }
            }
        }
    }*/
}
