package ctscore.web.controller.goods;


import aftersale.api.DiscussApi;
import aftersale.api.dto.DiscussDto;
import cart.api.OrderItemApi;
import cart.api.dto.order.OrderItemDto;
import cart.api.dto.order.OrderMainDto;
import cms.api.OrganizationApi;
import cms.api.dto.OrganizationDto;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import ctscore.web.service.goods.GoodWebService;
import goods.api.ProductFashionApi;
import goods.dto.product.ProductFashionDto;
import goods.vo.BuyHistoryVo;
import member.api.CoreUserApi;
import member.api.MemberApi;
import member.api.MemberFavoriteApi;
import member.api.dto.shop.MemberFavoriteDto;
import member.api.vo.MemberVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import utils.GlobalContants;
import utils.Lang;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by Roney on 2016/11/24.
 */

@Controller
@RequestMapping("share")
public class ShareController {
    private static final Logger logger = LoggerFactory.getLogger(ShareController.class);
    @Autowired
    GoodWebService goodWebService;
    @MotanReferer
    MemberFavoriteApi memberFavoriteApi;
    @MotanReferer(basicReferer = "motanClientBasicConfig")
    CoreUserApi coreUserApi;

    //@Autowired
    //TestDataRepos testDataRepos;

    @MotanReferer(basicReferer = "motanClientBasicConfig")
    DiscussApi discussApi;
    @MotanReferer(basicReferer = "motanClientBasicConfig")
    OrderItemApi orderItemApi;

    @MotanReferer
    MemberApi memberApi;

    @MotanReferer
    OrganizationApi organizationApi;

    @MotanReferer
    ProductFashionApi productFashionApi;

    @Value("${ctscore.orgCode}")
    private String organizationCode;//机构code值

    @Value("${ctscore.storeCode}")
    private String storeCode;//店铺code
    @RequestMapping(value = {"addFavorite.do"},method = RequestMethod.POST)
    @ResponseBody
    public Map addFavorite(@RequestParam String productId, Map model,HttpServletRequest request){
        Map returnMap=new HashMap();
        /** 获取当前用户的购物车信息 */
        MemberVo memberVo = goodWebService.findMemberVo(request);
        Boolean isAddFavoriteFlag=true;
        List<MemberFavoriteDto> memberFavorites=memberFavoriteApi.list(memberVo.getMember().getId());
        if(!Lang.isEmpty(memberFavorites)) {
            for (MemberFavoriteDto memberFavorite : memberFavorites) {
                if (memberFavorite.getTargetId().equals(productId)) {
                    isAddFavoriteFlag = false;
                    break;
                } else {
                    continue;
                }
            }
        }
        String responseMessage=null;
        if(!isAddFavoriteFlag){//直接信息提示
            responseMessage="您已经收藏我啦！";
            returnMap.put(GlobalContants.ResponseString.STATUS,GlobalContants.ResponseStatus.SUCCESS);
            returnMap.put(GlobalContants.ResponseString.MESSAGE,responseMessage);
        }else{
            /** 新增收藏记录 */
            MemberFavoriteDto favorite = memberFavoriteApi.addFavorite(memberVo.getMember().getId(), MemberFavoriteDto.FAVORITE_TYPE_PRODUCT_ID, productId);
            responseMessage="您的商品已经收藏成功！";
            returnMap.put(GlobalContants.ResponseString.STATUS,GlobalContants.ResponseStatus.SUCCESS);
            returnMap.put(GlobalContants.ResponseString.MESSAGE,responseMessage);
        }
        return returnMap;
    }

    /**
     * 评论记录
     * @param goodsId
     * @param pageable
     * @return
     */
    @RequestMapping(value = {"getDiscuss.do"})
    @ResponseBody
    public Map getDiscussPage(String goodsId, Pageable pageable){
        Map returnMap=new HashMap();
        Page<DiscussDto> discussPage=discussApi.findDiscussByValidFlagAndIsDeleteAndParamsPage(goodsId,1,false,pageable);
        returnMap.put("data",discussPage);
        returnMap.put("totalPages",getTotalPages((int)discussPage.getTotalElements(),pageable.getPageSize()));
        return returnMap;
    }

    /**
     * 购买记录
     * @param goodsId
     * @param pageable
     * @return
     */
    @RequestMapping(value = {"buyHistory.do"})
    @ResponseBody
    public Map buyHistory(String goodsId, Pageable pageable){
        Map returnMap=new HashMap();
//        Page<TestData> coreUserPage=testDataRepos.findAll(pageable);
        List<String> statusList = new ArrayList();

//        statusList.add(OrderMain.order_status_obligation);
        //statusList.add(OrderMain.order_status_ounfilled);
        //statusList.add(OrderMain.order_status_notdeliver);
        //statusList.add(OrderMain.order_status_evaluate);
        statusList.add(OrderMainDto.order_status_finish);
        // statusList.add(OrderMain.order_status_cancel);
        //statusList.add(OrderMain.order_status_refuse);

        List<BuyHistoryVo> list = new ArrayList<>();
        OrganizationDto organization= organizationApi.findOrganizationByOrgCode(organizationCode);
        if(Lang.isEmpty(organization)){
            returnMap.put("data",null);
            returnMap.put("totalPages",null);
            returnMap.put("size",null);
            return returnMap;
        }
        Sort.Order order = new Sort.Order(Sort.Direction.DESC, "order.dateCreated");
        List<Sort.Order> sortList=new ArrayList<>();
        sortList.add(order);
        Sort sort=new Sort(sortList);
        Pageable pageableQuery = new PageRequest(pageable.getPageNumber(),  pageable.getPageSize(),  sort);

        Page<OrderItemDto> orderItems=orderItemApi.findOrderItemByGoodsIdAndStatusAndIsDelete(goodsId,statusList,false,organization.getId(),pageableQuery);
        for(int i=0;i<orderItems.getContent().size();i++){
            BuyHistoryVo buyHistoryVo = new BuyHistoryVo();
            MemberVo memberVo = memberApi.getMemberInfo(orderItems.getContent().get(i).getOrder().getMemberId());//获取买家信息
            ProductFashionDto productFashion = productFashionApi.findById(orderItems.getContent().get(i).getProductFashId());//获取产品规格信息
            //优先级 名称 > 手机 > 邮箱
            String memberName;
            memberName = memberVo.getMember().getRealName();
            if(!Lang.isEmpty(memberName)) {
                Integer num = memberName.length() / 2;
                memberName = memberName.substring(0, num);
                for (int a = 0; a < num; a++) {
                    memberName += "*";
                }
            }
            if(Lang.isEmpty(memberName)) {
                memberName = memberVo.getUser().getPhone();
                if(!Lang.isEmpty(memberName)) {
                    memberName = memberName.substring(0, 3) + "****" + memberName.substring(memberName.length() - 4);
                }
            }
            if(Lang.isEmpty(memberName)) {
                memberName = memberVo.getUser().getEmail();
                if(!Lang.isEmpty(memberName)) {
                    if (memberName.indexOf("@") > 2) {
                        memberName = memberName.substring(0, 3) + "****" + memberName.substring(memberName.indexOf("@"));
                    } else if (memberName.indexOf("@") > 0) {
                        memberName = memberName.substring(0, memberName.indexOf("@")) + "****" + memberName.substring(memberName.indexOf("@"));
                    }
                }
            }
            buyHistoryVo.setMemberName(memberName);
            buyHistoryVo.setStyleName(productFashion.getFieldName());
            buyHistoryVo.setSalePrice(orderItems.getContent().get(i).getFinalPrice());
            buyHistoryVo.setCount(orderItems.getContent().get(i).getCount());
            buyHistoryVo.setCreateTime(orderItems.getContent().get(i).getOrder().getCreateTime());
            list.add(buyHistoryVo);
        }

        returnMap.put("data",list);
        returnMap.put("totalPages",getTotalPages((int)orderItems.getTotalElements(),pageable.getPageSize()));
        returnMap.put("size",orderItems.getSize());
        return returnMap;
    }

    public int getTotalPages(int total ,int size){
            int totalpage = (total + size -1)/size ;
            return totalpage;
        }
}
