package ctscore.web.controller.index;


import cms.api.ChannelApi;
import cms.api.dto.ArticleDto;
import cms.api.dto.ChannelDto;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import utils.Lang;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by xiaoqian on 2016/11/30.
 */
@Controller
@RequestMapping("footer")
public class FooterNavController {
    Logger logger = LoggerFactory.getLogger(getClass());
    @MotanReferer(basicReferer = "motanClientBasicConfig")
    private ChannelApi channelApi;

    @Value("${ctscore.orgCode}")
    private String organizationCode;//机构code值

    @Value("${ctscore.storeCode}")
    private String storeCode;//店铺code

    @RequestMapping(value = {"", "/"})
    public String index(Map model, HttpServletRequest request) {
        long methodStart = System.currentTimeMillis();
        logger.info("### 开始加载 INDEX FOOTER ... ###");
        //登录的session
        List<ChannelDto> channelList = new ArrayList<>();  //栏目列表
        Map<String, List<ArticleDto>> articleMap = new HashMap<>();   //文章map

        long channelTime = System.currentTimeMillis();
        getChannelArticle(channelList, articleMap);  //获取栏目文章
        logger.info("查询栏目耗时 {} ms", System.currentTimeMillis() - channelTime);

        model.put("channelList", channelList);  //栏目
        model.put("articleMap", articleMap);  //栏目文章
        logger.info("### 加载 INDEX FOOTER 总耗时 {} ms ###", System.currentTimeMillis() - methodStart);
        return "/index/footer";
    }


    /**
     * 封装栏目文章
     */
    private void getChannelArticle(List<ChannelDto> channelList, Map<String, List<ArticleDto>> articleListMap) {
        Map map = channelApi.findChannelArticle(0, 2, 6, organizationCode);
        if (map.size() > 0) {
            List<ChannelDto> channelsTemp = (List<ChannelDto>) map.get("channelList");  //栏目列表
            if (!Lang.isEmpty(channelsTemp) && channelsTemp.size() > 0) {
                channelList.addAll(channelsTemp);
            }
            if (!Lang.isEmpty(channelList) && channelList.size() > 0) {
                map.remove("channelList");
                if (!Lang.isEmpty(map) && map.size() > 0) {
                    articleListMap.putAll(map);
                }
            }
        }
    }
}
