package ctscore.web.controller.index;

import activities.api.ActivityConfigurationApi;
import cms.api.AnnouncementApi;
import cms.api.BannerApi;
import cms.api.FloorApi;
import cms.api.MemberReadAnnouncementApi;
import cms.api.dto.BannerDto;
import cms.api.dto.FloorContentDto;
import cms.api.dto.FloorDto;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import goods.api.ProductCategoryApi;
import member.api.CoreCompanyApi;
import member.api.CoreUserApi;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import store.api.StoreExtApi;
import utils.Lang;
import utils.freemarker.FreeMarkers;
import utils.log.Log;
import utils.log.Logs;

import javax.servlet.http.HttpServletRequest;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * Created by Roney on 2016/11/1.
 */
@Controller
@RequestMapping("")
public class IndexController {
    private final static Log log = Logs.getLog(IndexController.class.getName());

    @MotanReferer(basicReferer = "motanClientBasicConfig")
    private ProductCategoryApi productCategoryApi;

    @MotanReferer(basicReferer = "motanClientBasicConfig")
    private AnnouncementApi announcementApi;

    @MotanReferer(basicReferer = "motanClientBasicConfig")
    private MemberReadAnnouncementApi memberReadAnnouncementApi;

    @MotanReferer(basicReferer = "motanClientBasicConfig")
    private BannerApi bannerApi;

    @MotanReferer(basicReferer = "motanClientBasicConfig")
    private FloorApi floorApi;

    @MotanReferer(basicReferer = "motanClientBasicConfig")
    private StoreExtApi storeExtApi;

    @MotanReferer(basicReferer = "motanClientBasicConfig")
    private CoreCompanyApi coreCompanyApi;

    @MotanReferer(basicReferer = "motanClientBasicConfig")
    private CoreUserApi coreUserApi;

    private static final Integer ANNOUNCEMENTSHOWNUM = 6;//前台公告展示数据

    @Value("${ctscore.orgCode}")
    private String organizationCode;//机构code值

    @Value("${ctscore.storeCode}")
    private String storeCode;//店铺code

    //秒杀
    @Value("${secKillOrganization.code}")
    private String secKillOrganizationCode;
    @Value("${secKillActivity.activityCode}")
    private String secKillActivityCode;
    @Value("${secKillStore.code}")
    private String secKillStoreCode;

    //团购
    @Value("${tuanGouOrganization.code}")
    private String tuanGouOrganizationCode;
    @Value("${tuanGouActivity.activityCode}")
    private String tuanGouActivityCode;
    @Value("${tuanGouStore.code}")
    private String tuanGouStoreCode;

    @MotanReferer
    //@MotanReferer(directUrl = "127.0.0.1:8030",group = "sinomall")
            ActivityConfigurationApi activityConfigurationApi;

    @RequestMapping(value = {"", "/", "index.html", "index.htm"}, method = RequestMethod.GET)

    public String index(HttpServletRequest request, Map model) {
        long methodStart = System.currentTimeMillis();
        log.info("### 开始加载 INDEX ... ###");

        long bannerTime = System.currentTimeMillis();
        List<BannerDto> bannerList = bannerApi.findBannerListByType(1, null, organizationCode);
        log.info("查询 banner 耗时 {} ms", System.currentTimeMillis() - bannerTime);

        long floorTimr = System.currentTimeMillis();
        List<FloorDto> floorList = floorApi.findFloorList(1, null, organizationCode);
        log.info("查询 floor 耗时 {} ms", System.currentTimeMillis() - floorTimr);

        // 获取楼层内容
        String floorString = getFloorList(floorList);


        model.put("bannerList", bannerList);  //banner列表
    /*  model.put("firstCategoryMap",firstCategoryMap);   //一级商品分类
        model.put("secondLayer",secondLayerMap);  //二级商品分类
        model.put("thirdLayer",thirdLayerMap); //三级商品分类
        model.put("announceList",announcementVoList);  //公告列表*/
        model.put("floorString", floorString);  //楼层内容
        model.put("floorList", floorList);  //楼层列表

        long activityTime = System.currentTimeMillis();
        try {
            //秒杀团购活动初始化
            activityConfigurationApi.getActivityByCode(tuanGouOrganizationCode, tuanGouActivityCode);
            activityConfigurationApi.getActivityByCode(secKillOrganizationCode, secKillActivityCode);
            model.put("secKillActivityCode", secKillActivityCode);
            model.put("tuanGouActivityCode", tuanGouActivityCode);
        } catch (Exception e) {
            log.error("初始化活动异常", e);
        }
        log.info("活动初始化耗时 {} ms", System.currentTimeMillis() - activityTime);

        log.info("### 加载 INDEX 总耗时 {} ms ###", System.currentTimeMillis() - methodStart);
        return "index/index";
    }


    /**
     * 封装楼层列表
     */
    private String getFloorList(List<FloorDto> floorList) {
        StringBuilder floorStringBuffer = new StringBuilder();
        if(!Lang.isEmpty(floorList)) {
            for (int i = 0; i < floorList.size(); i++) {
                FloorDto floor = floorList.get(i);
                Map<String, Object>  floorContentMap = new HashMap<>();
                floorContentMap.put("floorName", floor.getName());
                floorContentMap.put("floorIndex", i);
                if(!Lang.isEmpty(floor.getFloorContents())) {
                    List<FloorContentDto> sortFloorContents = floor.getFloorContents().stream().filter(floorContentDto -> !floorContentDto.getIsDelete()).sorted(Comparator.comparing(FloorContentDto::getShowIndex)).collect(Collectors.toList());
                    for (int j = 0; j < sortFloorContents.size(); j++) {
                        FloorContentDto content = sortFloorContents.get(j);
                        floorContentMap.put("image" + (j + 1), content.getContentImageUrl());
                        floorContentMap.put("path" + (j + 1), content.getLinkUrl());
                    }
                }
                if (!Lang.isEmpty(floor.getFloorTemplate())) {
                    String turnResult = FreeMarkers.renderString(floor.getFloorTemplate().getTemplateContent(), floorContentMap);
                    floorStringBuffer.append(turnResult);
                    floorStringBuffer.append("\n");
                }
            }
        }
        return floorStringBuffer.toString();

        /*StringBuilder floorStringBuffer = new StringBuilder();
        long floorContentTime = System.currentTimeMillis();
        Map<String, List<FloorContentDto>> floorContent = floorApi.findFloorContent(1, null, organizationCode);
        log.info("查询 floorContent 耗时 {} ms", System.currentTimeMillis() - floorContentTime);

        if (!Lang.isEmpty(floorList) && floorList.size() > 0) {
            int n = 0;
            for (FloorDto floor : floorList) {
                Map floorContentMap = new HashMap();
                floorContentMap.put("floorName", floor.getName());
                floorContentMap.put("floorIndex", n++);
                if (!Lang.isEmpty(floorContent) && floorContent.size() > 0) {
                    List<FloorContentDto> contentList = floorContent.get(floor.getId());
                    if (!Lang.isEmpty(contentList) && contentList.size() > 0) {
                        int i = 1;
                        for (FloorContentDto content : contentList) {
                            floorContentMap.put("image" + i, content.getContentImageUrl());
                            floorContentMap.put("path" + i, content.getLinkUrl());
                            i++;
                        }
                    }
                }
                if (!Lang.isEmpty(floor.getFloorTemplate())) {
                    String turnResult = FreeMarkers.renderString(floor.getFloorTemplate().getTemplateContent(), floorContentMap);
                    floorStringBuffer.append(turnResult + "\n");
                }
            }
        }
        return floorStringBuffer.toString();*/
    }

    /**
     * 提现
     *
     * @param model
     * @return
     */
    @RequestMapping(value = {"upGrade"}, method = RequestMethod.GET)
    public String upGrade(Map model) {
        return "index/upGrade";
    }

    /**
     * 卡卷兑换
     *
     * @param model
     * @return
     */
    @RequestMapping(value = {"upGrade2"}, method = RequestMethod.GET)
    public String upGrade2(Map model) {
        return "index/upGrade2";
    }

    @RequestMapping(value = {"getCategory"}, method = RequestMethod.GET)
    @Profile("local")
    @ResponseBody
    public Map testGetCategory(HttpServletRequest request, Map model) {
        Long startTime = System.currentTimeMillis();
        Map returnModel = new HashMap();
        List<Map<String, Object>> categoryList = productCategoryApi.findCategoryByLayerLessThanEqual(3, organizationCode, true);
        returnModel.put("categoryList", categoryList);
        log.info("###############方法向服务器请求总用时##############：" + (System.currentTimeMillis() - startTime) + "ms");
        return returnModel;
    }

    @RequestMapping(value = {"getCacheCategory"}, method = RequestMethod.GET)
    @Profile("local")
    @ResponseBody
    public Map testCacheGetCategory(HttpServletRequest request, Map model) {
        Long startTime = System.currentTimeMillis();
        Map returnModel = new HashMap();
        List<Map<String, Object>> categoryList = productCategoryApi.findCategoryByLayerLessThanEqual(3, organizationCode, true);
        returnModel.put("categoryList", categoryList);
        log.info("###############方法向服务器请求总用时##############：" + (System.currentTimeMillis() - startTime) + "ms");
        return returnModel;
    }

    @RequestMapping(value = {"getBrand"}, method = RequestMethod.GET)
    @Profile("local")
    @ResponseBody
    public Map getBrand(HttpServletRequest request, Map model) {
        Long startTime = System.currentTimeMillis();
        Map returnModel = new HashMap();
        List<Map<String, Object>> categoryList = productCategoryApi.findCategoryByLayerLessThanEqual(3, organizationCode, true);
        returnModel.put("categoryList", categoryList);
        log.info("###############方法向服务器请求总用时##############：" + (System.currentTimeMillis() - startTime) + "ms");
        return returnModel;
    }

    /* *//**
     * 封装店铺
     * @param storeExtList
     *//*
    private void getStoreList(List<StoreExt> storeExtList,List<StoreExt> firstLevelList,List<StoreExt> secondLevelList,List<StoreExt> thirdLevelList){
        if(!Lang.isEmpty(storeExtList)&&storeExtList.size()>0){
            for(StoreExt storeExt: storeExtList){
                if(storeExt.getStoreHierarchy()==StoreExt.FIRSTSTOREHIERARCHY){
                    firstLevelList.add(storeExt);
                }else if(storeExt.getStoreHierarchy()==StoreExt.SECONDSTOREHIERARCHY){
                    secondLevelList.add(storeExt);
                }else{
                    thirdLevelList.add(storeExt);
                }
            }
        }
     }
*/

}
