package ctscore.web.controller.index;


import cart.api.CartApi;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import ctscore.web.service.area.AreaService;
import ctscore.web.service.member.ScoreUserService;
import ctscore.web.utils.AddressUtil;
import goods.api.ProductCategoryApi;
import goods.dto.product.ProductCategoryDto;
import goods.vo.ProductCategoryVo;
import member.api.AddressCommonApi;
import member.api.MemberApi;
import member.api.dto.common.AddressCodeDTO;
import member.api.dto.common.AddressDto;
import member.api.dto.core.CoreUserDto;
import member.api.dto.shop.MemberDto;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import score.api.ScoreApi;
import store.api.StoreApi;
import store.api.dto.modeldto.core.StoreDto;
import sysmg.api.SystemConfigApi;
import sysmg.dto.SystemConfigDto;
import sysmg.response.SystemConfigValueDto;
import utils.GlobalContants;
import utils.Lang;
import utils.ip.IPtoLong;
import utils.log.Log;
import utils.log.Logs;
import utils.web.AddressUtils;
import utils.web.Webs;

import javax.annotation.Resource;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;

/**
 * Created by xiaoqian on 2016/11/30.
 */
@Controller
@RequestMapping("top")
public class MallTopController {
    private final static Log log = Logs.getLog(MallTopController.class.getName());

    @MotanReferer(basicReferer = "motanClientBasicConfig")
    private AddressCommonApi addressCommonApi;

    @MotanReferer(basicReferer = "motanClientBasicConfig")
    private CartApi cartApi;

    @MotanReferer(basicReferer = "motanClientBasicConfig")
    private MemberApi memberApi;

    @MotanReferer(basicReferer = "motanClientBasicConfig")
    private ProductCategoryApi productCategoryApi;
    @MotanReferer
    private SystemConfigApi systemConfigApi;

    @Value("${ctscore.orgCode}")
    private String organizationCode;//机构code值

    @Value("${ctscore.storeCode}")
    private String storeCode;//店铺code

    //ctscore 个人中心 url
    @Value("${itaiping.usercenter.index}")
    private String itaipingUserCenterIndex;

    //ctscore 个人中心 我的积分 url
    @Value("${itaiping.usercenter.luckyDou}")
    private String itaipingUserCenterLuckyDou;

    //ctscore 个人中心 我的商品 url
    @Value("${itaiping.usercenter.goods}")
    private String itaipingUserCenterGoods;

    //ctscore 集团首页 url
    @Value("${itaiping.companyHome}")
    private String itaipingCompanyHome;

    //ctscore 联系客服 url
    @Value("${itaiping.contacts}")
    private String itaipingContacts;

    @Autowired
    AreaService areaService;

    @Autowired
    ScoreUserService scoreUserService;

    @RequestMapping(value = {"", "/"})

    public String index(HttpServletRequest request, Map<String, Object> model) {
        long methodStart = System.currentTimeMillis();
        log.info("### 开始加载 INDEX TOP ... ###");
        //登录的session
        Object memberObj = request.getSession().getAttribute(GlobalContants.SESSION_MEMBER_JSON_ITAIPING);
        Object coreUserObj = request.getSession().getAttribute(GlobalContants.SESSION_USER_JSON_ITAIPING);
        CoreUserDto sessionCoreUser = JSON.parseObject(coreUserObj.toString(), CoreUserDto.class);
        MemberDto sessionMember = JSON.parseObject(memberObj.toString(), MemberDto.class);

        //取地址列表
        long addressTime = System.currentTimeMillis();
        List<AddressDto> addresses = addressCommonApi.addressList(AddressCommonApi.AddressLevel.PROVINCE, null, false);
        log.info("查询地址耗时 {} ms", System.currentTimeMillis() - addressTime);

        //取店铺信息
       /* long storeTime = System.currentTimeMillis();
        Map<String, List<StoreDto>> stores = storeApi.listStoreForIndex();
        log.info("查询店铺耗时 {} ms", System.currentTimeMillis() - storeTime);*/

        String provinceId = (String) request.getSession().getAttribute(GlobalContants.AREA_LEVEL_PROVINCE_ID);

        String currentPage = request.getParameter("currentPage");
        if (!Lang.isEmpty(currentPage) && "index".equals(currentPage)) {  //识别首页
            model.put("currentPage", currentPage);
        }

        String categoryRedisKey = organizationCode + ":index:category";
        BoundValueOperations categoryOperations = redisTemplate.boundValueOps(categoryRedisKey);
        Object category = categoryOperations.get();
        List<Map<String, Object>> categoryList;
        if (category == null) {
            long categoryTime = System.currentTimeMillis();
            categoryList = productCategoryApi.findCategoryByLayerLessThanEqual(3, organizationCode, true);  //查询3级及3级内的分类
            log.info("查询分类耗时 {} ms", System.currentTimeMillis() - categoryTime);
            categoryOperations.set(categoryList);
        } else {
            categoryList = (List<Map<String, Object>>) category;
        }

        //一级分类
        Map<String, List<ProductCategoryVo>> firstCategoryMap = new LinkedHashMap<>();
        Map<String, List<ProductCategoryVo>> secondLayerMap = new HashMap<>();
        Map<String, List<ProductCategoryVo>> thirdLayerMap = new HashMap<>();

        String categoryMapRedisKey = organizationCode + ":index:categoryMap";
        BoundValueOperations categoryMapOperations = redisTemplate.boundValueOps(categoryMapRedisKey);
        Object categoryMap = categoryMapOperations.get();
        Map map = null;
        if (categoryMap == null) {
            // 封装商品分类
            long getProductCategoryTime = System.currentTimeMillis();
            map = getProductCategory(categoryList);
            log.info("封装商品分类耗时 {} ms", System.currentTimeMillis() - getProductCategoryTime);
            categoryMapOperations.set(map);
        } else {
            map = (Map) categoryMap;
        }
        if (!Lang.isEmpty(map)) {
            firstCategoryMap = (Map<String, List<ProductCategoryVo>>) map.get("firstCategoryMap");
            secondLayerMap = (Map<String, List<ProductCategoryVo>>) map.get("secondLayerMap");
            thirdLayerMap = (Map<String, List<ProductCategoryVo>>) map.get("thirdLayerMap");
        }

        long userScoreTime = System.currentTimeMillis();
        BigDecimal usebleScore = scoreUserService.getUsebleScore(sessionCoreUser);
        log.info("查询用户积分耗时 {} ms", System.currentTimeMillis() - userScoreTime);

        model.put("firstCategoryMap", firstCategoryMap);   //一级商品分类
        model.put("secondLayer", secondLayerMap);  //二级商品分类
        model.put("thirdLayer", thirdLayerMap); //三级商品分类
        model.put("provinceId", provinceId);
        model.put("addresses", addresses);
        //model.put("stores", stores);
        model.put("itaipingUserCenterIndex", itaipingUserCenterIndex);
        model.put("itaipingUserCenterLuckyDou", itaipingUserCenterLuckyDou);
        model.put("itaipingUserCenterGoods", itaipingUserCenterGoods);
        model.put("itaipingCompanyHome", itaipingCompanyHome);
        model.put("itaipingContacts", itaipingContacts);
        model.put("score", usebleScore);
        model.put("isAdmin", sessionMember.getAdmin());

        log.info("### 加载 INDEX TOP 总耗时 {} ms ###", System.currentTimeMillis() - methodStart);
        return "index/top";
    }

    @Resource(name = "redisTemplate")
    private ZSetOperations<String, String> zSetOperations;

    @RequestMapping(value = "info", method = RequestMethod.GET)
    @ResponseBody
    public Map loadTopInfo(HttpServletRequest request, HttpServletResponse response) {
        Map<String, Object> model = Maps.newHashMap();
        String userId = (String) request.getSession().getAttribute(GlobalContants.SESSION_USER_ID_ITAIPING);
        String provinceId = (String) request.getSession().getAttribute(GlobalContants.AREA_LEVEL_PROVINCE_ID);

        long addressCodeDTOTime = System.currentTimeMillis();
        AddressCodeDTO addressCodeDTO = AddressUtil.getAddressCode(request, addressCommonApi);
        log.info("获取地址代码耗时 {} ms ", System.currentTimeMillis() - addressCodeDTOTime);

        if (StringUtils.isBlank(provinceId)) {
            response.addCookie(new Cookie(GlobalContants.AREA_LEVEL_PROVINCE_ID, addressCodeDTO.getProviceCode()));
        }
        model.put("provinceId", addressCodeDTO.getProviceCode());

        //热词
        List<String> hotKeyWords = new ArrayList<>();

        //热词
        Set<String> keywords;

        String isOpen = systemConfigApi.getConfigValue(organizationCode, SystemConfigDto.CONFIG_CODE_OPEN_CONFIG_HOTWORDS, SystemConfigValueDto.CONFIG_VALUE_TYPE_OPEN_HOTWORDS, true, true);
        if (!Lang.isEmpty(isOpen)) {
            if (isOpen.equals("true")) {
                String valus = systemConfigApi.getConfigValue(organizationCode, SystemConfigDto.CONFIG_CODE_HOTWORDS, SystemConfigValueDto.CONFIG_VALUE_TYPE_HOTWORDS, true, true);
                JSONArray jsonArray = JSON.parseArray(valus);
                for (Object aJsonArray : jsonArray) {
                    JSONObject obj = (JSONObject) aJsonArray;
                    hotKeyWords.add((String) obj.get("name"));
                }
            } else {
                keywords = zSetOperations.reverseRangeByScore(GlobalContants.SEARCH_KEYWORD_CT, Double.MIN_VALUE, Double.MAX_VALUE, 0L, 3L);
                hotKeyWords.addAll(keywords);//zSetOperations.incrementScore(type,keyWord,1)

            }
        } else {
            keywords = zSetOperations.reverseRangeByScore(GlobalContants.SEARCH_KEYWORD_CT, Double.MIN_VALUE, Double.MAX_VALUE, 0L, 3L);
            hotKeyWords.addAll(keywords);
        }
        model.put("hotKeyWords", hotKeyWords);

        String username = memberApi.findRealNameByCoreUserId(userId);
        model.put("username", username);

        // 购物车物品数
        Integer carts = 0;
        if (StringUtils.isNotBlank(userId)) {
            carts = cartApi.getCartSize(userId);
        }
        model.put("carts", carts);
        return model;
    }

    @RequestMapping("changeProvince/{provoiceId}")
    @ResponseBody
    public Map changeProvince(@PathVariable("provoiceId") String provoiceId, HttpServletRequest request, HttpServletResponse response) {
        Map<String, Object> map = Maps.newHashMap();
        map.put("result", "success");
        setProvinceId(provoiceId, request, response);
        return map;
    }

    @RequestMapping("changeArea/{areaId}")
    @ResponseBody
    public Map changeArea(@PathVariable("areaId") String areaId, HttpServletRequest request, HttpServletResponse response) {
        Map<String, Object> map = Maps.newHashMap();
        map.put("result", "success");
        setAddressIdSByParams(request, response, areaId);
        return map;
    }


    public void setProvinceId(String provoiceId, HttpServletRequest request, HttpServletResponse response) {
        String sessionProvoiceId = (String) request.getSession().getAttribute(GlobalContants.AREA_LEVEL_PROVINCE_ID);
        if (Lang.isEmpty(sessionProvoiceId) || !sessionProvoiceId.equals(provoiceId)) {
            Map<String, Object> areas = getCityAndAreaId(provoiceId);
            areas.put("provoiceId", provoiceId);
            AddressUtils.setAddressIdToSession(request, response, areas);
        }
    }

    private Map<String, Object> setAddressIdSByParams(HttpServletRequest request, HttpServletResponse response, String areaId) {
        if (Lang.isEmpty(areaId)) {
            throw new NullPointerException("areaId not null");
        } else {
            Map<String, Object> addressMap = Maps.newHashMap();
            String returnProvoiceId = null;
            String returnCityId = null;
            String returnAreaId = areaId;
            String returnTownId = null;
            Map<Integer, String> areaNodeList = addressCommonApi.areaCodeNodeList(areaId);
            if (!Lang.isEmpty(areaNodeList)) {
                returnProvoiceId = areaNodeList.get(1);
                returnCityId = areaNodeList.get(2);
                returnAreaId = areaNodeList.get(3);
                returnTownId = areaNodeList.get(4);
                log.info("ChangeArea areaNodeList -> returnProvoiceId:" + returnProvoiceId + ",returnCityId" + returnCityId + ",returnAreaId:" + returnAreaId + ",returnTownId:" + returnTownId);
            }

            addressMap.put("provoiceId", returnProvoiceId);
            addressMap.put("cityId", returnCityId);
            addressMap.put("areaId", returnAreaId);
            addressMap.put("townId", returnTownId);
            AddressUtils.setAddressIdToSession(request, response, addressMap);
            log.info("reseted session addressId -> " +
                    "proviceId: " + request.getSession().getAttribute(GlobalContants.AREA_LEVEL_PROVINCE_ID)
                    + "cityId: " + request.getSession().getAttribute(GlobalContants.AREA_LEVEL_CITY_ID)
                    + "areaId: " + request.getSession().getAttribute(GlobalContants.AREA_LEVEL_AREA_ID)
                    + "townId: " + request.getSession().getAttribute(GlobalContants.AREA_LEVEL_TOWN_ID));
            return addressMap;
        }
    }

    private Map<String, Object> getCityAndAreaId(String provoiceId) {
        Map<String, Object> returnAddressIdMap = new HashMap<>();

        String returnCityId = null;
        String returnAreaId = null;
        String returnTownId = null;
        AddressDto a = addressCommonApi.findFirstChild(provoiceId, false);
        if (a != null) {
            returnCityId = a.getId();
            AddressDto addr = addressCommonApi.findFirstChild(returnCityId, false);
            if(Lang.isEmpty(addr)){
                returnAreaId = addr.getId();
            }
            AddressDto c = addressCommonApi.findFirstChild(returnAreaId, false);
            if (c != null) {
                returnTownId = c.getId();
            }
        }
        returnAddressIdMap.put("cityId", returnCityId);
        returnAddressIdMap.put("areaId", returnAreaId);
        returnAddressIdMap.put("townId", returnTownId);
        return returnAddressIdMap;
    }

    @Autowired
    RedisTemplate redisTemplate;

    //封装商品分类
    private Map<String, Object> getProductCategory(List<Map<String, Object>> categoryList) {
        BoundValueOperations boundValueOperations = redisTemplate.boundValueOps("category:map" + organizationCode);
        Map<String, Object> returnMap = new HashMap<>();

        long configTime = System.currentTimeMillis();
        String isOpen = systemConfigApi.getConfigValue(organizationCode, SystemConfigDto.CONFIG_CODE_OPEN_CACHE, SystemConfigValueDto.CONFIG_VALUE_TYPE_CACHE_CATEGORY_VO, true, true);
        log.info("获取配置耗时 {} ms", System.currentTimeMillis() - configTime);

        Boolean isOpenFlag = false;
        if (!Lang.isEmpty(isOpen)) {
            if (isOpen.equals("true")) {
                isOpenFlag = true;
            }
        }
        if (isOpenFlag) {
            if (!Lang.isEmpty(boundValueOperations) && !Lang.isEmpty(boundValueOperations.get())) {
                returnMap = (Map) boundValueOperations.get();
                return returnMap;

            }
        }
        Map<String, List<ProductCategoryVo>> firstCategoryMap = new LinkedHashMap<>();
        Map<String, List<ProductCategoryVo>> secondLayerMap = new HashMap<>();
        Map<String, List<ProductCategoryVo>> thirdLayerMap = new HashMap<>();
        List<ProductCategoryVo> firstLayer = new ArrayList<>();
        List<ProductCategoryVo> secondLayer = new ArrayList<>(); //二级分类
        List<ProductCategoryVo> thirdLayer = new ArrayList<>(); //三级分类
        if (!Lang.isEmpty(categoryList) && categoryList.size() > 0) {
            for (Map<String, Object> category : categoryList) {
                String layer = category.get(ProductCategoryDto.LAYERINDEX) == null ? "" : category.get(ProductCategoryDto.LAYERINDEX).toString();
                if (layer.equals("1")) {
                    //                    if(firstLayer.size()<12) {    //限制前台输出条数
                    ProductCategoryVo firstVo = new ProductCategoryVo();
                    firstVo.setId(category.get(ProductCategoryDto.ID) + "");
                    firstVo.setName(category.get(ProductCategoryDto.NAME) + "");
                    firstVo.setCategoryType(category.get(ProductCategoryDto.CATEGORYTYPE) + "");
                    firstLayer.add(firstVo);
                    if (!Lang.isEmpty(firstCategoryMap.get(firstVo.getCategoryType()))) {
                        firstCategoryMap.get(firstVo.getCategoryType()).add(firstVo);
                    } else {
                        List<ProductCategoryVo> categoryVoList = new ArrayList<ProductCategoryVo>();
                        categoryVoList.add(firstVo);
                        firstCategoryMap.put(firstVo.getCategoryType(), categoryVoList);
                    }

                    //                    }
                } else if (layer.equals("2")) {
                    ProductCategoryVo secondVo = new ProductCategoryVo();
                    secondVo.setId(category.get(ProductCategoryDto.ID) + "");
                    secondVo.setName(category.get(ProductCategoryDto.NAME) + "");
                    secondVo.setParentId(category.get(ProductCategoryDto.PARENTID) + "");
                    secondVo.setParentName(category.get(ProductCategoryDto.PARENTNAME) + "");
                    secondLayer.add(secondVo);
                } else if (layer.equals("3")) {
                    ProductCategoryVo thirdVo = new ProductCategoryVo();
                    thirdVo.setId(category.get(ProductCategoryDto.ID) + "");
                    thirdVo.setName(category.get(ProductCategoryDto.NAME) + "");
                    thirdVo.setParentId(category.get(ProductCategoryDto.PARENTID) + "");
                    thirdVo.setParentName(category.get(ProductCategoryDto.PARENTNAME) + "");
                    thirdLayer.add(thirdVo);
                }
            }
            for (ProductCategoryVo first : firstLayer) {
                String firstId = first.getId();
                if (!Lang.isEmpty(secondLayer) && secondLayer.size() > 0) {
                    List<ProductCategoryVo> secondLayerList = new ArrayList<>();
                    for (ProductCategoryVo second : secondLayer) {
                        String secondId = second.getId();
                        String parentId = second.getParentId();
                        if (!Lang.isEmpty(parentId)) {
                            if (parentId.equals(firstId)) {
                                //                                if(secondLayerList.size()<8) { //限制前台输出条数
                                ProductCategoryVo secondItem = new ProductCategoryVo();
                                secondItem.setId(second.getId());
                                secondItem.setName(second.getName());
                                secondLayerList.add(secondItem);
                                //                                }
                            }
                        }
                        if (!Lang.isEmpty(thirdLayer) && thirdLayer.size() > 0) {
                            List<ProductCategoryVo> thirdLayerList = new ArrayList<>();
                            for (ProductCategoryVo third : thirdLayer) {
                                if (third.getParentId().equals(secondId)) {
                                    ProductCategoryVo thirdItem = new ProductCategoryVo();
                                    thirdItem.setId(third.getId());
                                    thirdItem.setName(third.getName());
                                    thirdLayerList.add(thirdItem);
                                }
                            }
                            if (thirdLayerList.size() > 0) {
                                thirdLayerMap.put(secondId, thirdLayerList);
                            }
                        }
                    }
                    if (secondLayerList.size() > 0) {
                        secondLayerMap.put(firstId, secondLayerList);
                    }
                }
            }
        }
        Map<String, List<ProductCategoryVo>> firstCategoryRepMap = new LinkedHashMap<>();

        int count = 0;
        for (String key : firstCategoryMap.keySet()) {
            if (++count <= 12) {
                firstCategoryRepMap.put(key, firstCategoryMap.get(key));
            }
        }

        returnMap.put("firstCategoryMap", firstCategoryRepMap);
        returnMap.put("secondLayerMap", secondLayerMap);
        returnMap.put("thirdLayerMap", thirdLayerMap);

        if (!Lang.isEmpty(returnMap)) {
            boundValueOperations.set(returnMap);
        }

        return returnMap;
    }

}
