package ctscore.web.controller.index;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import ctscore.web.controller.index.entity.AccountInfo;
import ctscore.web.controller.index.entity.AccountRequest;
import ctscore.web.controller.index.entity.AccountResponse;
import ctscore.web.controller.index.utils.HttpUtilslwl;
import ctscore.web.controller.index.utils.MD5;
import ctscore.web.controller.index.utils.MyAESUtil;
import jdek.api.request.JdekGetBalanceEntity;
import jdek.api.service.JdekApi;
import jdek.api.vo.JdekBalanceVo;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import utils.excel.ReadExcelUtil;

import javax.servlet.http.HttpServletRequest;
import java.io.*;
import java.util.*;

/**
 * Created by xiaoqian on 2016/11/30.
 */
@Controller

public class OtherController {



    @RequestMapping(value = {"404","404.html"})
    public String notFound(HttpServletRequest request,Map model){

        return "other/notfound";
    }

    @RequestMapping(value = {"500","500.html"})
    public String error(HttpServletRequest request,Map model){

        return "other/500";
    }

    @RequestMapping(value = {"tempUse"})
    public String temp3(HttpServletRequest request,Map model){
        return "other/tempUse";
    }

    @RequestMapping(value = {"registerStart"})
    @ResponseBody
    public String temp(@RequestParam("file") MultipartFile file,HttpServletRequest request){

        if (!file.isEmpty()) {
            try {
                BufferedOutputStream out = new BufferedOutputStream(
                        new FileOutputStream(new File("/tpdata/log/temp/"+file.getOriginalFilename())));
                out.write(file.getBytes());
                out.flush();
                out.close();
            } catch (FileNotFoundException e) {
                e.printStackTrace();
                return "上传失败," + e.getMessage();
            } catch (IOException e) {
                e.printStackTrace();
                return "上传失败," + e.getMessage();
            }
            return "上传成功";
        } else {
            return "上传失败，因为文件是空的.";
        }
    }

    @RequestMapping(value = {"Start"})
    @ResponseBody
    public Map temp2(){
        Map map=new HashMap<>();

        HttpUtilslwl httpUtilslwl;

        Map<String, String> headers;

        //AES密钥,必须为 16位字符串
        String aesKey = "abcdefghijklmnop";

        String testHost = "http://10.4.8.133:8005/ssoapi";

        int successNim=0;
        File file=new File("/tpdata/log/temp/shuju.xlsx");
        try {
            List list = ReadExcelUtil.readExcel(file);
            for(int i=0;i<list.size();i++){
                List list1=(List) list.get(i);
                for(int j=1;j<list1.size();j++){
                    List list2=(List)list1.get(j);
                    List list4=new ArrayList<>();
                    for(int t=0;t<list2.size();t++){
                        list4.add(list2.get(t));
                    }
                    httpUtilslwl = new HttpUtilslwl();
                    headers = new HashMap<>();
                    headers.put("Content-Type", "text/html");
                    headers.put("--uid--", "10002"); // 客户端ID 必填,否则出现505错误
                    headers.put("--requestId--", UUID.randomUUID().toString().replaceAll("-", ""));
                    String strUrl = testHost+"/api/addAccount";
                    // 请求参数对象
                    AccountRequest requestBody = new AccountRequest();
                    // 用户信息参数
                    AccountInfo accountInfo = new AccountInfo();
                    accountInfo.setSource("itpAct88y");
                    MD5 mmd5 = new MD5();
                    String pw = mmd5.getMD5Str((String)list4.get(1));
                    accountInfo.setPassword(pw);
                    accountInfo.setPhone((String) list4.get(0));
                    requestBody.setAccountInfo(accountInfo);
                    String body = JSON.toJSONString(requestBody);
                    String ciphertext = MyAESUtil.encrypt(body, aesKey);
                    // 发送请求
                    String rtn = httpUtilslwl.httpdoPostBodyHeader(strUrl, ciphertext, headers, null);
                    // 解密,得到返回的json数据
                    String text = MyAESUtil.decrypt(rtn, aesKey);
                    AccountResponse result= JSONObject.parseObject(text,AccountResponse.class);
                    if("0".equals(result.getReturnCode())){
                        successNim++;
                        continue;
                    }else{
                        System.out.println(result.getReturnMessage());
                        RandomAccessFile raf=null;
                        String info="手机号："+(String) list4.get(0)+"密码："+(String)list4.get(1)+"原因："+result.getReturnMessage();
                        try{
                            //以读、写方式打开一个RandomAccessFile对象
                            raf=new RandomAccessFile("/tpdata/log/temp/fail.txt","rw");
                            //将记录指针移动到out.txt文件的最后
                            raf.seek(raf.length());
                            raf.write((info+"\r\n").getBytes());
                        }catch(IOException e){
                            e.printStackTrace();
                        }finally{
                            try{
                                if(raf!=null){
                                    raf.close();
                                }
                            }catch(IOException e){
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }
            map.put("result","1");
            map.put("num",successNim);
            map.put("resultMessage","成功");
            return map;
        } catch (Exception e) {
            e.printStackTrace();
            map.put("result","0");
            map.put("resultMessage","系统异常");
            return map;
        }
    }

    @MotanReferer
    JdekApi jdekApi;

    @RequestMapping(value = "getJdekBalance")
    @ResponseBody
    public String getJdekBalance(){
        JdekGetBalanceEntity request=new JdekGetBalanceEntity();
        request.setType(4);
        JdekBalanceVo balance = jdekApi.getBalance(request);
        return JSON.toJSONString(balance);
    }


}



