package ctscore.web.controller.index;

import cms.api.OrganizationApi;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import goods.api.ProductSalesApi;
import goods.api.SalesPriceRateQueryApi;
import goods.dto.goods.GoodsDto;
import goods.vo.GoodsVo;
import goods.vo.SalesPriceQueryVo;
import lombok.extern.slf4j.Slf4j;
import ma.glasnost.orika.MapperFacade;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import utils.Lang;
import utils.data.Beans;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Created by laizc on 2016/12/5.
 */
@Slf4j
@Controller
@RequestMapping("salesRanking")
public class SalesRankingController {
    @MotanReferer(basicReferer = "motanClientBasicConfig")
    ProductSalesApi productSalesApi;

    @Value("${ctscore.score.proportion}")
    private BigDecimal scorePortion;//积分比例
    @Value("${ctscore.orgCode}")
    private String organizationCode;//机构code值
    @Value("${ctscore.storeCode}")
    private String storeCode;//店铺code

    @MotanReferer
    OrganizationApi organizationApi;

    @MotanReferer
    SalesPriceRateQueryApi salesPriceRateQueryApi;

    @Autowired
    MapperFacade mapperFacade;

    /**
     * 周排行
     */
    final static String HOT_SALE_WEEK = "week";

    /**
     * 月排行
     */
    final static String HOT_SALE_MONTH = "month";

    /**
     * 总排行
     */
    final static String HOT_SALE_TOTAL = "total";

    @RequestMapping(value = {""}, method = RequestMethod.GET)
    public String index(Map<String, Object> model, String type) {
        long methodStart = System.currentTimeMillis();
        log.info("### 开始加载排行榜... ###");

        long organizationTime = System.currentTimeMillis();
        String organizationId = organizationApi.findOrganizationIdByOrgCode(organizationCode);
        log.info("查询机构信息耗时 {} ms", System.currentTimeMillis() - organizationTime);

        long goodsListTime = System.currentTimeMillis();
        List<GoodsDto> list;
        if (HOT_SALE_WEEK.equals(type)) {
            list = productSalesApi.findHotSalesLastWeek(organizationCode);
        } else if (HOT_SALE_MONTH.equals(type)) {
            list = productSalesApi.findHotSalesLastMonth(organizationCode);
        } else {
            list = productSalesApi.findHotSalesTotal(organizationCode);
            type = HOT_SALE_TOTAL;
        }
        log.info("查询商品列表类型为 {} 耗时 {} ms", type, System.currentTimeMillis() - goodsListTime);

        long getSalePriceTimer = System.currentTimeMillis();
        List<GoodsVo> listVo = new ArrayList<>();
        if(!Lang.isEmpty(list)) {
            Map<String, BigDecimal> salePriceMap = salesPriceRateQueryApi.getSaleRatePriceBatchByGoodsList(list, storeCode, organizationId);
                for (GoodsDto goodsDTO : list) {
                    BigDecimal salePrice = salePriceMap.get(goodsDTO.getId()).setScale(2, BigDecimal.ROUND_UP);
                    goodsDTO.setSalePrice(salePrice);
                }
            listVo = mapperFacade.mapAsList(list, GoodsVo.class);
        }
        log.info("批量查询费率价格耗时 {} ms", System.currentTimeMillis() - getSalePriceTimer);
        model.put("salesRanking", listVo);
        model.put("type", type);
        model.put("scorePortion", 1);

        log.info("### 加载排行榜总耗时 {} ms ###", System.currentTimeMillis() - methodStart);
        return "index/sales/ranking";
    }


}
