package ctscore.web.controller.index.entity;

/**
 * Created by GuoShun on 2017-09-11.
 */
public class AccountInfo extends BaseDomain {

	// 与用户中心同步时需传递数据,可选
    private String userId;        // sso统一认证系统userID,<br/>(根据规则判断调用者传入的是sso系统生成的userId,还是老系统userId)
    private String userName;    //用户名(登录账号),唯一
    private String email;       //电子邮箱唯一
    private String phone;       //手机号唯一
    private String password;    //密码,需要加密
    private String source;      //系统来源,不可为空,枚举值见文档
    private String oldUserId;   //旧认证系统主键,存储老系统用户userid，<br/>此参数仅在同步老系统用户信息是使用,其他使用userId<br/>新认证系统注册用户此字段为空
    private String authenticated; //是否完成实名认证,
    private String oldEmail; //原邮箱
    private String emailActived; //邮箱激活状态,0.未激活 1.已激活
    private String userType; //用户类型
    private String oldPhone; //原手机号
    private String phoneActived; //手机激活状态 0.未激活 1.已激活
    private String userStatus;	//用户状态 0.未激活 1.已激活
    private String ownerSystem; //0.线下1.线上

    //----------如下字段可选传递-------------------
    private String oldPassword; //修改密码时需要验证密码是否正确,
    private String certificationTime;  //身份认证时间
    private String currentLoginTime;   //当前登录时间
    private String disabled; //是否禁用
    private String emailActivedTime; //邮箱激活时间
    private String errCount; //登录错误次数
    private String loginCount; //总共登录次数
    private String pwdChangeDate;//密码最后修改时间
    private String phoneActivedTime; //手机激活时间
    private String telPhone; //联系电话 既可以是手机号,有可以是固定电话

    /**旧密码,修改密码时需要验证密码是否正确*/
    public String getOldPassword() {
        return oldPassword;
    }

    /**旧密码,修改密码时需要验证密码是否正确*/
    public void setOldPassword(String oldPassword) {
        this.oldPassword = oldPassword;
    }

    /**get  sso统一认证系统userID,<br/>(根据规则判断调用者传入的是sso系统生成的userId,还是老系统userId)**/
    public String getUserId(){
        return userId;
    }
    /**set  sso统一认证系统userID,<br/>(根据规则判断调用者传入的是sso系统生成的userId,还是老系统userId)**/
    public void setUserId(String userId){
        this.userId = userId;
    }
    /**get 用户名(登录账号),唯一**/
    public String getUserName(){
        return userName;
    }
    /**set 用户名(登录账号),唯一**/
    public void setUserName(String userName){
        this.userName = userName;
    }
    /**get 电子邮箱唯一**/
    public String getEmail(){
        return email;
    }
    /**set 电子邮箱唯一**/
    public void setEmail(String email){
        this.email = email;
    }
    /**get 手机号唯一**/
    public String getPhone(){
        return phone;
    }
    /**set 手机号唯一**/
    public void setPhone(String phone){
        this.phone = phone;
    }
    /**get 密码,需要加密**/
    public String getPassword(){
        return password;
    }
    /**set 密码,需要加密**/
    public void setPassword(String password){
        this.password = password;
    }
    /**get 系统来源,不可为空,枚举值见文档**/
    public String getSource(){
        return source;
    }
    /**set 系统来源,不可为空,枚举值见文档**/
    public void setSource(String source){
        this.source = source;
    }
    /**get 旧认证系统主键,存储老系统用户userid，<br/>此参数仅在同步老系统用户信息是使用,其他使用userId<br/>新认证系统注册用户此字段为空**/
    public String getOldUserId(){
        return oldUserId;
    }
    /**set 旧认证系统主键,存储老系统用户userid，<br/>此参数仅在同步老系统用户信息是使用,其他使用userId<br/>新认证系统注册用户此字段为空**/
    public void setOldUserId(String oldUserId){
        this.oldUserId = oldUserId;
    }
    /**get 是否完成实名认证**/
    public String  getAuthenticated(){
        return authenticated;
    }
    /**set 是否完成实名认证**/
    public void setAuthenticated(String authenticated){
        this.authenticated = authenticated;
    }
    /**get 身份认证时间**/
    public String getCertificationTime(){
        return certificationTime;
    }
    /**set 身份认证时间**/
    public void setCertificationTime(String certificationTime){
        this.certificationTime = certificationTime;
    }
    /**get 当前登录时间**/
    public String getCurrentLoginTime(){
        return currentLoginTime;
    }
    /**set 当前登录时间**/
    public void setCurrentLoginTime(String currentLoginTime){
        this.currentLoginTime = currentLoginTime;
    }
    /**get 是否禁用**/
    public String getDisabled(){
        return disabled;
    }
    /**set 是否禁用**/
    public void setDisabled(String disabled){
        this.disabled = disabled;
    }
    /**get 原邮箱**/
    public String getOldEmail(){
        return oldEmail;
    }
    /**set 原邮箱**/
    public void setOldEmail(String oldEmail){
        this.oldEmail = oldEmail;
    }
    /**get 邮箱激活状态,0.未激活 1.已激活**/
    public String getEmailActived(){
        return emailActived;
    }
    /**set 邮箱激活状态,0.未激活 1.已激活**/
    public void setEmailActived(String emailActived){
        this.emailActived = emailActived;
    }
    /**get 邮箱激活时间**/
    public String getEmailActivedTime(){
        return emailActivedTime;
    }
    /**set 邮箱激活时间**/
    public void setEmailActivedTime(String emailActivedTime){
        this.emailActivedTime = emailActivedTime;
    }
    /**get 登录错误次数**/
    public String getErrCount(){
        return errCount;
    }
    /**set 登录错误次数**/
    public void setErrCount(String errCount){
        this.errCount = errCount;
    }
    /**get 总共登录次数**/
    public String getLoginCount(){
        return loginCount;
    }
    /**set 总共登录次数**/
    public void setLoginCount(String loginCount){
        this.loginCount = loginCount;
    }
    /**get 用户类型**/
    public String getUserType(){
        return userType;
    }
    /**set 用户类型**/
    public void setUserType(String userType){
        this.userType = userType;
    }
    /**get 密码最后修改时间**/
    public String getPwdChangeDate(){
        return pwdChangeDate;
    }
    /**set 密码最后修改时间**/
    public void setPwdChangeDate(String pwdChangeDate){
        this.pwdChangeDate = pwdChangeDate;
    }
    /**get 原手机号**/
    public String getOldPhone(){
        return oldPhone;
    }
    /**set 原手机号**/
    public void setOldPhone(String oldPhone){
        this.oldPhone = oldPhone;
    }
    /**get 手机激活状态 0.未激活 1.已激活**/
    public String getPhoneActived(){
        return phoneActived;
    }
    /**set 手机激活状态 0.未激活 1.已激活**/
    public void setPhoneActived(String phoneActived){
        this.phoneActived = phoneActived;
    }
    /**get 手机激活时间**/
    public String getPhoneActivedTime(){
        return phoneActivedTime;
    }
    /**set 手机激活时间**/
    public void setPhoneActivedTime(String phoneActivedTime){
        this.phoneActivedTime = phoneActivedTime;
    }
    /**get 联系电话 既可以是手机号,有可以是固定电话**/
    public String getTelPhone(){
        return telPhone;
    }
    /**set 联系电话 既可以是手机号,有可以是固定电话**/
    public void setTelPhone(String telPhone){
        this.telPhone = telPhone;
    }
    /**get 用户状态 0.未激活 1.已激活**/
    public String getUserStatus(){
        return userStatus;
    }
    /**set 用户状态 0.未激活 1.已激活**/
    public void setUserStatus(String userStatus){
        this.userStatus = userStatus;
    }

    /**get 0.线下1.线上**/
    public String getOwnerSystem(){
        return ownerSystem;

    }
    /**set 0.线下1.线上**/
    public void setOwnerSystem(String ownerSystem){
        this.ownerSystem = ownerSystem;
    }


}
