package ctscore.web.controller.index.entity;

import org.springframework.util.StringUtils;

import java.util.List;

/**
 * Created by GuoShun on 2017-09-11.
 */
public class AccountResponse {

	 /**操作成功 **/
    public final static String STATUS_CODE_SUCCESS = "0";
    /**操作失败**/
    public final static String STATUS_CODE_ERROR = "1";
    /**参数类型错误**/
    public final static String STATUS_CODE_TYPE_ERROR="1000";
    /**参数为空**/
    public final static String  STATUS_CODE_PARAMETER_EMPTY="1001";
    /**缺少用户名 uid**/
    public final static String STATUS_CODE_LACK_UID="1002";
    /**缺少密码**/
    public final static String STATUS_CODE_LACK_PASSWORD="1003";
    /**缺少手机号**/
    public final static String STATUS_CODE_LACK_MOBILE="1004";
    /**缺少邮箱**/
    public final static String STATUS_CODE_LACK_EMAIL="1005";
    /**缺少系统来源**/
    public final static String STATUS_CODE_LACK_OWNER_SYSTEM="1006";
    /**手机号 ,用户名,邮箱为空**/
    public final static  String STATUS_CODE_MOBILE_UID_EMAIL_EMPTY="1007";

    /**手机号 ,用户名,邮箱其中一项已经被注册**/
    public final static  String STATUS_CODE_HAS_REG="1008";

    /**该老系统用户ID已经存在**/
    public final static  String STATUS_CODE_HAS_OLDUSERID="1009";

    //用户id不正确
    public final static  String STATUS_CODE_USER_ID_ERROR="1010";

    /**非手机号格式**/
    public final static  String STATUS_CODE_NOT_PHONE="1011";

    /**非邮箱格式**/
    public final static  String STATUS_CODE_NOT_EMAIL="1012";

    /**非邮箱格式**/
    public final static  String STATUS_CODE_USER_NOTFOUND="1013";

    //请求唯一标识
    private String requestID;
    //处理结果标识 true:处理成功  false:处理失败
    private boolean returnFlag;
    //返回结果编号  0或1  当returnFlag为true时，returnCode为0；当returnFlag为false时，returnCode为错误编码
    private String returnCode;
    //返回结果信息  ：自行定义
    private String returnMessage;
    //账号对象的个数
    private int accountInfoSize;
    //账号对象集合
    private List<AccountInfo> accountInfoList;

    public AccountResponse(String requestID, boolean returnFlag, String returnCode, String returnMessage, int accountInfoSize, List<AccountInfo> accountInfoList) {
        this.requestID = requestID;
        this.returnFlag = returnFlag;
        this.returnCode = returnCode;
        this.returnMessage = returnMessage;
        this.accountInfoSize = accountInfoSize;
        this.accountInfoList = accountInfoList;
    }

    public AccountResponse(String requestID, boolean returnFlag, String returnCode, String returnMessage) {
        this.requestID = requestID;
        this.returnFlag = returnFlag;
        this.returnCode = returnCode;
        this.returnMessage = returnMessage;
    }

    public AccountResponse(){};


    public String getRequestID() {
        return requestID;
    }

    public void setRequestID(String requestID) {
        this.requestID = requestID;
    }

    public boolean isReturnFlag() {
        return returnFlag;
    }

    public void setReturnFlag(boolean returnFlag) {
        this.returnFlag = returnFlag;
    }

    public String getReturnCode() {
        return returnCode;
    }

    public void setReturnCode(String returnCode) {
        this.returnCode = returnCode;
    }

    public String getReturnMessage() {
        if(StringUtils.isEmpty(returnMessage)){
            if(STATUS_CODE_SUCCESS.equals(returnCode)){
                return "操作成功";
            }

            if(STATUS_CODE_TYPE_ERROR.equals(returnCode)){
                return "参数类型错误";
            }
            if(STATUS_CODE_PARAMETER_EMPTY.equals(returnCode)){
                return "参数为空";
            }
            if(STATUS_CODE_LACK_UID.equals(returnCode)){
                return "缺少用户名uid";
            }
            if(STATUS_CODE_LACK_PASSWORD.equals(returnCode)){
                return "缺少密码";
            }
            if(STATUS_CODE_LACK_MOBILE.equals(returnCode)){
                return "缺少手机号";
            }
            if(STATUS_CODE_LACK_EMAIL.equals(returnCode)){
                return "缺少邮箱";
            }
            if(STATUS_CODE_LACK_OWNER_SYSTEM.equals(returnCode)){
                return "缺少系统来源";
            }
            if(STATUS_CODE_MOBILE_UID_EMAIL_EMPTY.equals(returnCode)){
                return "用户名/手机号/邮箱为空";
            }
            if(STATUS_CODE_HAS_OLDUSERID.equals(returnCode)){
                return "该老系统用户ID已经存在";
            }
        }
        return returnMessage;
    }

    public int getAccountInfoSize() {
        return accountInfoSize;
    }

    public void setAccountInfoSize(int accountInfoSize) {
        this.accountInfoSize = accountInfoSize;
    }

    public List<AccountInfo> getAccountInfoList() {
        return accountInfoList;
    }

    public void setAccountInfoList(List<AccountInfo> accountInfoList) {
        this.accountInfoList = accountInfoList;
    }

    public void setReturnMessage(String returnMessage) {
        this.returnMessage = returnMessage;
    }
}
