package ctscore.web.controller.index.utils;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

/**
 * http请求工具
 * @author bruce(liwenlong)  2016年9月9日 上午11:53:31
 */
public class HttpUtilslwl {
	

	/**
	 * Post方式请求网络数据,
	 * 
	 * @param strUrl          网络地址
	 * @param body            发送的请求体
	 * @param headers         发送的请求头
	 * @param encoding        请求编码方式,默认 UTF-8
	 */
	public String httpdoPostBodyHeader(String strUrl, String body, Map<String, String> headers, String encoding) {
		if (encoding == null) {  encoding = "UTF-8";  }
		StringBuilder builder = null;
		try {
			URL url = new URL(strUrl);
			HttpURLConnection httpURLConn = (HttpURLConnection) url.openConnection();
			// 设置编码方式
			httpURLConn.addRequestProperty("encoding", encoding);
			httpURLConn.setDoInput(true); // 使httpURLConn可以从网络获取数据
			httpURLConn.setDoOutput(true); // 使httpURLConn可以向互联网传输数据
			httpURLConn.setRequestMethod("POST"); // 设置POST请求方式
			if (headers != null) {
				Iterator<String> iteHeaders = headers.keySet().iterator();
				while (iteHeaders.hasNext()) {
					String header = iteHeaders.next();
					//设置请求头
					httpURLConn.addRequestProperty(header, headers.get(header));
				}
			}
			//httpURLConn.setRequestProperty("Content-Length", body.getBytes().length + "");  //设置文件请求的长度         
			if (body != null) {
				// 获取输出流
				OutputStream outStream = httpURLConn.getOutputStream();
				writeStrToOutputStream(body, outStream);
			}
			int responseCode = httpURLConn.getResponseCode();
			if(responseCode==200){
				// 获取输入流
				InputStream inStream = httpURLConn.getInputStream();
				builder = readSrtFromInputStream(inStream,encoding);
			}else{
				String responseMessage = httpURLConn.getResponseMessage();
				Logger.getLogger("lwl").info("responseCode: "+responseCode+", message: "+responseMessage);
				return responseCode+"";
			}
		} catch (MalformedURLException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return builder.toString().trim();
	}

	/**
	 * 输出字符串到输出流
	 */
	private void writeStrToOutputStream(String body, OutputStream outStream){
		OutputStreamWriter outWriter = null;
		BufferedWriter bufWriter = null;
		try {
		    outWriter = new OutputStreamWriter(outStream);
		    bufWriter = new BufferedWriter(outWriter);
			// 输出请求体
			bufWriter.write(body);
			bufWriter.flush();
			// 关闭输出流
		} catch (IOException e) {
			e.printStackTrace();
		}finally{
			try {
				bufWriter.close();
				outWriter.close();
				outStream.close();
			} catch (Exception e2) {
				e2.printStackTrace();
			}
		}
		
	}
    /**
     * 从输入流中读取字符串
     */
	private StringBuilder readSrtFromInputStream(InputStream inStream,String encoding) {
		StringBuilder builder = new StringBuilder();
		InputStreamReader inReader = null;
		BufferedReader bufReader = null;
		try {
			 inReader = new InputStreamReader(inStream, encoding);
			 bufReader = new BufferedReader(inReader);
			 String line;
			 while ((line = bufReader.readLine()) != null) {
				builder.append(line + "\n");
			 }
		} catch (Exception e) {
			e.printStackTrace();
		}finally{
			try {
				if(bufReader!=null) bufReader.close();
				if(inReader!=null) inReader.close();
				if(inStream!=null) inStream.close();
			} catch (IOException e2) {
				e2.printStackTrace();
			}
		}
		return builder;
	}

}
