package ctscore.web.controller.login;

import cms.api.OrganizationApi;
import cms.api.dto.OrganizationDto;
import com.alibaba.fastjson.JSONObject;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import ctscore.web.service.login.LoginService;
import member.api.CoreUserApi;
import member.api.MemberApi;
import member.api.PeripheryApi;
import member.api.dto.core.CoreUserDto;
import member.api.dto.shop.MemberDto;
import member.api.vo.MemberVo;
import message.api.Dto.VerifyCodeDto;
import message.api.mail.MailApi;
import message.api.mail.vo.MailReq;
import message.api.mail.vo.MailRsp;
import message.api.sms.SmsApi;
import message.api.sms.vo.SmsReq;
import message.api.sms.vo.SmsRsp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import utils.GlobalContants;
import utils.Lang;
import utils.data.BeanMapper;
import utils.data.CookiesTool;
import utils.data.SmsUtil;
import utils.data.ValidateUtil;
import utils.date.DateUtils;
import utils.kaptcha.CheckUtils;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;

/**
 * Created by xiaoqian on 2016/10/20.
 * 积分会员登录
 */
@Controller
public class LoginIndexController {
    final static Logger logger = LoggerFactory.getLogger(LoginIndexController.class);

    final static String checkType = "login";
    final static String updatePasswdType = "updatePasswd";

    final static String SESSION_ACCOUNT_CODE = "SESSION_ACCOUNT_CODE";

    @Value("${spring.profiles.active}")
    private String profile;//是否开发环境

    //缓存
    final static String SESSION_SMS_CODE = "SESSION_SMS_CODE";
    private String smsTestCode = "123456";

    @Value("${ctscore.emailsender}")
    private String emailsender;

    @Autowired
    CheckUtils checkUtils;

    @Autowired
    LoginService loginService;

    @MotanReferer
    SmsApi smsApi;
    @MotanReferer
    MemberApi memberApi;

    @MotanReferer
    CoreUserApi coreUserApi;
    @MotanReferer(basicReferer = "motanClientBasicConfig")
    private MailApi mailApi;

    @Value("${ctscore.orgCode}")
    private String organizationCode;//机构code值

    @Value("${ctscore.storeCode}")
    private String storeCode;//店铺code

    @MotanReferer
    OrganizationApi organizationApi;
    @MotanReferer
    PeripheryApi peripheryApi;
    //登录用户session
    //public static final String LOGIN_USER_SESSION = "LOGIN_USER_SESSION";
    //重定向回来源页面
    public static final String REDIRECT_SOURCE_URL = "REDIRECT_SOURCE_URL";

    //登录错误信息
    public static final String LOGIN_ERROR_CODE = "LOGIN_ERROR_CODE";
    public static final String LOGIN_ERROR_TIMES = "LOGIN_ERROR_TIMES";//错位次数

    public static final String MOBILE_SERVICE_ID="ChengTong_FindPassword";//诚通积分商城


    /**
     * 登录首页
     *
     * @param model
     * @param request
     * @return
     */
    @RequestMapping(value = {"login"}, method = RequestMethod.GET)
    public String login(Map model, HttpServletRequest request, HttpServletResponse response) {
        logger.info("积分会员登录");

        //带回上次的手机号码
        Object accountObj = request.getSession().getAttribute("account");
        String account = null;
        if (accountObj == null) {
            Cookie accountCookie = CookiesTool.getCookieByName(request, "account");
            if (accountCookie != null) {
                account = accountCookie.getValue();
            }
        } else {
            account = accountObj.toString();
        }


        if (account != null) {
            model.put("account", account);
            request.getSession().removeAttribute("account");

            //查询用户是不是错误一次
            CoreUserDto coreUser = null;

            long getOrganizationTime = System.currentTimeMillis();
            String organizationId = organizationApi.findOrganizationIdByOrgCode(organizationCode);
            logger.info("获取机构信息耗时 {} ms", System.currentTimeMillis() - getOrganizationTime);

            if (Lang.isEmpty(organizationId)) {
                model.put("accountError", "");
                return "login/login";
            } else {

                long getCoreUserTime = System.currentTimeMillis();
                if (!ValidateUtil.isEmail(account)) {
                    coreUser = loginService.findByPhoneAndOrganizationIdAndUserType(account, organizationId, CoreUserDto.USER_TYPE_MEMBER, false);
                } else {
                    coreUser = loginService.findByEmailAndOrganizationIdAndUserType(account, organizationId, CoreUserDto.USER_TYPE_MEMBER, false);
                }
                if (Lang.isEmpty(coreUser)) {
                    coreUser = loginService.findByEmailAndOrganizationIdAndUserType(account, organizationId, CoreUserDto.USER_TYPE_CT_SCORE_ACTIVITY, false);
                }
                /*诚通端午活动*/
                /*if (coreUser == null) {
                    coreUser = loginService.findByUsernameAndIsDeleteAndOrganizationIdAndUserType(account, false, organizationId, CoreUserDto.USER_TYPE_DoannGoA);
                }
                if (coreUser == null) {
                    coreUser = loginService.findByUsernameAndIsDeleteAndOrganizationIdAndUserType(account, false, organizationId, CoreUserDto.USER_TYPE_DoannGoB);
                }
                if (coreUser == null) {
                    coreUser = loginService.findByUsernameAndIsDeleteAndOrganizationIdAndUserType(account, false, organizationId, CoreUserDto.USER_TYPE_DoannGoC);
                }*/
                logger.info("查询用户信息耗时 {} ms", System.currentTimeMillis() - getCoreUserTime);

                if (coreUser != null) {
                    Long errCount = coreUser.getErrCount();
                    if (errCount != null && errCount >= 1L) {
                        //启用验证码登录
                        model.put("validateFlag", 1);
                    }
                }
            }
        }

        Object errorObj = request.getSession().getAttribute(LOGIN_ERROR_CODE);//错误信息
        if (errorObj != null) {
            int errorMsg = Integer.parseInt(errorObj.toString());
            if (errorMsg == 1) {//密码错误
                Object errorTimesObj = request.getSession().getAttribute(LOGIN_ERROR_TIMES);//错误信息
                if (errorTimesObj != null) {
                    int errorTimes = Integer.parseInt(errorTimesObj.toString());
                    model.put("passwordError", "您输入的手机号或密码有误，登录错误" + errorTimes + "次");
                } else {
                    model.put("passwordError", "您输入的手机号或密码有误");
                }
            } else if (errorMsg == 2) {//您尚未注册，请确认账号是否录入正确
                model.put("accountError", "您尚未注册，请确认账号是否录入正确");
            } else if (errorMsg == 3) {//您的验证码已超时，请刷新验证码
                model.put("imageCodeError", "您的验证码已超时，请刷新验证码");
            } else if (errorMsg == 4) {//您的验证码错误
                model.put("imageCodeError", "验证码错误，请点击图片验证码进行刷新");
            } else if (errorMsg == 5) {//输入密码错误5次，请1小时之后再登录
                model.put("passwordError", "您输入密码错误超过5次，请1小时后再登录");
            } else if (errorMsg == 6) {//请输入登录账号
                model.put("accountError", "请输入登录账号");
            } else if (errorMsg == 7) {//请输入登录密码
                model.put("passwordError", "请输入登录密码");
            } else if (errorMsg == 8) {//请输入图片验证码
                model.put("imageCodeError", "请输入图片验证码");
            } else {//登录失败
                model.put("imageCodeError", "登录失败");
            }
        } else {
            model.put("accountError", "");
            model.put("passwordError", "");
            model.put("imageCodeError", "");
        }

        //移除错误代码
        request.getSession().removeAttribute(LOGIN_ERROR_CODE);
        request.getSession().removeAttribute(LOGIN_ERROR_TIMES);

        return "login/login";
    }

    /**
     * 登录校验
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "dologin", method = RequestMethod.POST)
    public String login(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        logger.info("会员登录...");
        //=====================校验参数
        String account = request.getParameter("account");
        if (Lang.isEmpty(account)) {
            request.getSession().setAttribute(LOGIN_ERROR_CODE, 6);//请输入登录账号
            return "redirect:login";
        }
        //保存登录账号
        request.getSession().setAttribute("account", account);
        CookiesTool.addCookie(response, "account", account, 60 * 60);


        String password = request.getParameter("password");
        if (Lang.isEmpty(password)) {
            request.getSession().setAttribute(LOGIN_ERROR_CODE, 7);//请输入登录密码
            return "redirect:login";
        }
        String validateFlag = request.getParameter("validateFlag");
        String validateCode = "";
        if (validateFlag != null) {
            validateCode = request.getParameter("validateCode");
            if (Lang.isEmpty(validateCode)) {
                request.getSession().setAttribute(LOGIN_ERROR_CODE, 8);//请输入图片验证码
                return "redirect:login";
            }
            Object capTextObj = request.getSession().getAttribute(checkType + ":code");
            if (Lang.isEmpty(capTextObj)) {
                request.getSession().setAttribute(LOGIN_ERROR_CODE, 3);//您的验证码已超时，请刷新验证码
                return "redirect:login";
            }
            String capText = capTextObj.toString();
            if (!capText.equals(validateCode)) {
                request.getSession().setAttribute(LOGIN_ERROR_CODE, 4);//验证码错误，请点击图片验证码进行刷新
                return "redirect:login";
            }

            request.getSession().removeAttribute(checkType + ":code");
        }

        //==============校验是否手机或者邮件登录

        HttpSession session = request.getSession();
        //查询用户
        CoreUserDto coreUser = null;

        long getOrganizationTime = System.currentTimeMillis();
        String organizationId = organizationApi.findOrganizationIdByOrgCode(organizationCode);
        logger.info("获取机构信息耗时 {} ms", System.currentTimeMillis() - getOrganizationTime);

        if (Lang.isEmpty(organizationId)) {
            request.getSession().setAttribute(LOGIN_ERROR_CODE, 9);//登录失败
            return "redirect:login";
        } else {
            long getCoreUserTime = System.currentTimeMillis();
            CoreUserDto loginCoreUser = new CoreUserDto();
            if (!ValidateUtil.isEmail(account)) {
                loginCoreUser.setPhone(account);
                loginCoreUser.setUsername(account);
                coreUser = loginService.findByPhoneAndOrganizationIdAndUserType(account, organizationId, CoreUserDto.USER_TYPE_MEMBER, false);
            } else {
                loginCoreUser.setEmail(account);
                loginCoreUser.setUsername(account);
                coreUser = loginService.findByEmailAndOrganizationIdAndUserType(account, organizationId, CoreUserDto.USER_TYPE_MEMBER, false);
            }
            if (Lang.isEmpty(coreUser)) {
                coreUser = loginService.findByEmailAndOrganizationIdAndUserType(account, organizationId, CoreUserDto.USER_TYPE_CT_SCORE_ACTIVITY, false);
            }
            logger.info("查询用户信息耗时 {} ms", System.currentTimeMillis() - getCoreUserTime);
           /* String uid = null;
            if ("13800138000".equals(account)) {
                //对应用户中心18600090006
                uid = "5c0716bf9c78e81c5f834224b29da822";
            } else if ("13800138010".equals(account)) {
                //对应用户中心18600090009
                uid = "6805ec301b52b43c0fef6e849de3a594";
            } else if ("13800138011".equals(account)) {
                //对应用户中心18600090001
                uid = "64a6fa9c852115d44a5a75faa01d69f7";
            } else if ("13800138012".equals(account)) {
                //对应用户中心18600090005
                uid = "4cc32451d720d9cb16d14eb37a78263a";
            } else if ("13800138013".equals(account)) {
                //对应用户中心18600090003
                uid = "f770024b7d25948378758277a2812551";
            }*/
//            PeripheryUserVo peripheryUserVo = new PeripheryUserVo();
          /*  peripheryUserVo.setOpenId(uid);
            peripheryUserVo.setSourceType(CoreUserSocial.TYPE_CNTP_USERCENTER);
            peripheryUserVo.setChannelCode(organizationCode);
//                        username = "18392883090";
            loginCoreUser.setUserType(CoreUserDto.USER_TYPE_MEMBER);
            peripheryUserVo.setUser(coreUser);
            Map<String, Object> userMap = peripheryApi.syncPeripherySysUser(peripheryUserVo);

            String message = (String) userMap.get(GlobalContants.ResponseString.ERROR_CODE);
            if (message.equals(GlobalContants.ResponseStatus.SUCCESS)) {
                session.setAttribute(GlobalContants.PERIPHERY_USER_ID, userMap.get(GlobalContants.PERIPHERY_USER_ID));
                String userId = (String) userMap.get(GlobalContants.PERIPHERY_USER_ID);
                List<MemberDto> members = memberApi.findByCoreUserId(userId);
                session.setAttribute(GlobalContants.SESSION_MEMBER_ID_ITAIPING, members.get(0).getId());
                session.setAttribute(GlobalContants.PERIPHERY_THIRD_USER_ID, uid);
                System.out.println("SESSION_MEMBER_ID" + members.get(0).getId());
            }*/
        }

        if (coreUser == null) {//会员未注册
            request.getSession().setAttribute(LOGIN_ERROR_CODE, 2);//您尚未注册，请确认账号是否录入正确
            return "redirect:login";
        }

        String loginTime = DateUtils.dateToStr(new Date(), "yyyy-MM-dd HH:mm:ss");

        Long errorCount = coreUser.getErrCount();//登录错误次数
        String currentLoginTime = coreUser.getCurrentLoginTime();//上次记录的当前登录时间
        Boolean disabled = coreUser.getDisabled();//是否被禁止
        errorCount = errorCount == null ? 0 : errorCount;
        disabled = disabled == null ? false : disabled;

        String coreUserPassword = coreUser.getPassword();//获取用户密码

        //加密密码
        String encryptPasswd = loginService.encryptPasswd(password);

        //====================判断是否已经登录错误超过5次
        if (currentLoginTime != null && disabled == true) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date cLoginTime = formatter.parse(currentLoginTime);
            long minute = DateUtils.differMinute(cLoginTime);
            if (minute >= 60) {//解锁 登录
                logger.info("超过1小时，自动解锁");

                coreUser.setCurrentLoginTime(loginTime);//记录当前登录时间

                if (!Lang.isEmpty(coreUserPassword) && !coreUserPassword.equals(encryptPasswd)) {//判断密码是否相等
                    errorCount = 1L;//解锁后登录错误次数1次
                    coreUser.setErrCount(errorCount);
                    coreUser.setDisabled(false);//解锁

                    request.getSession().setAttribute(LOGIN_ERROR_TIMES, errorCount);//错误次数

                    //更新用户登录信息
                    long updateCoreUserTime = System.currentTimeMillis();
                    CoreUserDto result = loginService.updateCoreUser(coreUser);
                    logger.info("更新用户信息耗时 {} ms", System.currentTimeMillis() - updateCoreUserTime);
                    logger.info("更新用户登录错误信息结果:{}", result);
                    if (result == null) {
                        request.getSession().setAttribute(LOGIN_ERROR_CODE, 9);//登录失败
                        return "redirect:login";
                    }
                    request.getSession().setAttribute(LOGIN_ERROR_CODE, 1);//密码错误
                    return "redirect:login";
                }
                //====登录成功

                Long loginCount = coreUser.getLoginCount();
                loginCount = loginCount == null ? 0L : loginCount;
                loginCount++;//总登录次数

                errorCount = 0L;//登录成功，清除错误次数

                //更新用户信息
                coreUser.setErrCount(errorCount);
                coreUser.setDisabled(false);
                coreUser.setLoginCount(loginCount);

                //更新用户登录信息
                long updateCoreUserTime = System.currentTimeMillis();
                CoreUserDto result = loginService.updateCoreUser(coreUser);
                logger.info("更新用户信息耗时 {} ms", System.currentTimeMillis() - updateCoreUserTime);
                logger.info("更新用户登录信息结果:{}", result);
                if (result == null) {
                    request.getSession().setAttribute(LOGIN_ERROR_CODE, 9);//登录失败
                    return "redirect:login";
                }

                //记录到session
                long loadMemeberTime = System.currentTimeMillis();
                MemberVo memberVo = loginService.loadMemberVo(coreUser);//??有可能会有错误
                logger.info("获取 memberVo 耗时 {} ms", System.currentTimeMillis() - loadMemeberTime);
                //request.getSession().setAttribute(LOGIN_USER_SESSION,memberVo);
                loginService.saveInfotoSession(request, memberVo);

                //查询会员是否第一次登录
                MemberDto member = memberVo.getMember();
                if (member == null) {
                    logger.error("会员未录入,登录失败");
                    request.getSession().setAttribute(LOGIN_ERROR_CODE, 9);//会员未录入,登录失败
                    return "redirect:login";
                }

                Integer isFirstLogin = member.getIsFirstLogin();
                isFirstLogin = isFirstLogin == null ? 0 : isFirstLogin;
                if (isFirstLogin == 0) {//第一次登录
                    request.getSession().removeAttribute("account");
                    CookiesTool.addCookie(response, "account", "", 0);

                    return "redirect:../score";
                }

                request.getSession().removeAttribute("account");
                CookiesTool.addCookie(response, "account", "", 0);

                //重定向回来源页
                Object redirectUrl = request.getSession().getAttribute(REDIRECT_SOURCE_URL);
                if (redirectUrl != null) {
                    String url = redirectUrl.toString();
                    request.getSession().removeAttribute(REDIRECT_SOURCE_URL);
                    return "redirect:" + url;//重定向回来源页
                }

                redirectUrl = request.getSession().getAttribute(GlobalContants.SESSION_LOGIN_BACK_URL_ITAIPING);
                if (redirectUrl != null) {
                    String url = redirectUrl.toString();
                    request.getSession().removeAttribute(GlobalContants.SESSION_LOGIN_BACK_URL_ITAIPING);
                    return "redirect:" + url;//重定向回来源页
                }

                return "redirect:index";//会员中心
            }
        }

        if (errorCount == 5 || disabled == true) {
            request.getSession().setAttribute(LOGIN_ERROR_CODE, 5);//您输入密码错误超过5次，请1小时后再登录
            return "redirect:login";
        }

        //===================正常登录（登录错误未超过5次）
        if (!coreUserPassword.equals(encryptPasswd)) {//判断密码是否相等
            errorCount++;//解锁后登录错误次数1次
            coreUser.setErrCount(errorCount);
            coreUser.setCurrentLoginTime(loginTime);


            if (errorCount == 5) {//错误次数超过5次
                coreUser.setDisabled(true);//解锁

                //更新用户登录信息
                long updateCoreUserTime = System.currentTimeMillis();
                CoreUserDto result = loginService.updateCoreUser(coreUser);
                logger.info("更新用户信息耗时 {} ms", System.currentTimeMillis() - updateCoreUserTime);

                logger.info("更新用户登录错误信息结果:{}", result);
                if (result == null) {
                    request.getSession().setAttribute(LOGIN_ERROR_CODE, 9);//登录失败
                    return "redirect:login";
                }
                request.getSession().setAttribute(LOGIN_ERROR_CODE, 5);//您输入密码错误超过5次，请1小时后再登录
                return "redirect:login";
            }

            coreUser.setDisabled(false);//解锁
            request.getSession().setAttribute(LOGIN_ERROR_TIMES, errorCount);//错误次数

            //更新用户登录信息
            long updateCoreUserTime = System.currentTimeMillis();
            CoreUserDto result = loginService.updateCoreUser(coreUser);
            logger.info("更新用户信息耗时 {} ms", System.currentTimeMillis() - updateCoreUserTime);
            logger.info("更新用户登录错误信息结果:{}", result);
            if (result == null) {
                request.getSession().setAttribute(LOGIN_ERROR_CODE, 9);//登录失败
                return "redirect:login";
            }
            request.getSession().setAttribute(LOGIN_ERROR_CODE, 1);//密码错误
            return "redirect:login";
        }

        //============登录成功

        Long loginCount = coreUser.getLoginCount();
        loginCount = loginCount == null ? 0L : loginCount;
        loginCount++;//总登录次数

        errorCount = 0L;//登录成功，清除错误次数4

        //更新用户信息
        coreUser.setErrCount(errorCount);
        coreUser.setDisabled(false);
        coreUser.setLoginCount(loginCount);

        //更新用户登录信息
        long updateCoreUserTime = System.currentTimeMillis();
        CoreUserDto result = loginService.updateCoreUser(coreUser);
        logger.info("更新用户信息耗时 {} ms", System.currentTimeMillis() - updateCoreUserTime);
        logger.info("更新用户登录信息结果:{}", result);
        if (result == null) {
            request.getSession().setAttribute(LOGIN_ERROR_CODE, 9);//登录失败
            return "redirect:login";
        }

        //记录到session
        //??有可能会有错误
        long loadMemeberTime = System.currentTimeMillis();
        MemberVo memberVo = loginService.loadMemberVo(coreUser);
        logger.info("获取 memberVo 耗时 {} ms", System.currentTimeMillis() - loadMemeberTime);
        //request.getSession().setAttribute(LOGIN_USER_SESSION,memberVo);
        loginService.saveInfotoSession(request, memberVo);

        //查询会员是否第一次登录
        MemberDto member = memberVo.getMember();

        if (member == null) {
            logger.error("会员未录入,登录失败");
            request.getSession().setAttribute(LOGIN_ERROR_CODE, 9);//会员未录入,登录失败
            return "redirect:login";
        }

        CookiesTool.addCookie(response, "account", "", 0);
        Integer isFirstLogin = member.getIsFirstLogin();
        isFirstLogin = isFirstLogin == null ? 0 : isFirstLogin;
        //判断是端午活动的用户
        if (CoreUserDto.USER_TYPE_CT_SCORE_ACTIVITY.equals(memberVo.getUser().getUserType())) {
            return "redirect:../activities-web/control.html";
        }
        //第一次登录
        if (isFirstLogin == 0) {
            request.getSession().removeAttribute("account");
            CookiesTool.addCookie(response, "account", "", 0);
            return "redirect:../score";
        }

        //重定向回来源页
        Object redirectUrl = request.getSession().getAttribute(REDIRECT_SOURCE_URL);
        if (redirectUrl != null) {
            String url = redirectUrl.toString();
            request.getSession().removeAttribute(REDIRECT_SOURCE_URL);
            return "redirect:" + url;//重定向回来源页
        }

        redirectUrl = request.getSession().getAttribute(GlobalContants.SESSION_LOGIN_BACK_URL_ITAIPING);
        if (redirectUrl != null) {
            String url = redirectUrl.toString();
            request.getSession().removeAttribute(GlobalContants.SESSION_LOGIN_BACK_URL_ITAIPING);
            return "redirect:" + url;//重定向回来源页
        }

        request.getSession().removeAttribute("account");
        return "redirect:../score";//会员中心
    }


    //退出登录（会员中心）
    @RequestMapping(value = "dologout", method = RequestMethod.GET)
    public String dologout(HttpServletRequest request, HttpServletResponse response) {
        //检测是否已经登录
        /*
        Object loginMemberSession = request.getSession().getAttribute(LOGIN_USER_SESSION);
        if(loginMemberSession == null){
            return "redirect:login";
        }
        request.getSession().removeAttribute(LOGIN_USER_SESSION);
        */
        response.addCookie(new Cookie(GlobalContants.SESSION_USER_NAME_LOGOUT_ITAIPING, (String) request.getSession().getAttribute(GlobalContants.SESSION_USER_NAME_LOGOUT_ITAIPING)));
        loginService.removeLoginAttr(request);
        String service = request.getParameter("service");
        service = service == null || "".equals(service) ? request.getHeader("Referer") : service;
    /*    if (service == null) {
            service = "http://smarket.tp95589.com/ctscore";
        }
        try {
            return "redirect:http://baoxian.itaiping.com/sso/logout?service=" + URLEncoder.encode(service, "utf-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }*/
        //return "redirect:/logout";
//        return null;
        return "redirect:/login";
    }


    //=========================================修改密码
    //修改密码,发送手机验证码 或者 邮箱
    @RequestMapping(value = "forget/sendSmsOrEmail", method = RequestMethod.POST)
    @ResponseBody
    public JSONObject updatePasswdSendSms(HttpServletRequest request) {
        logger.info("修改密码 发送手机验证码 或者 邮箱");
        JSONObject jsonObject = new JSONObject();
        String account = request.getParameter("account");
        String imageValidateCode = request.getParameter("imageValidateCode");
        String verifyCodeType = request.getParameter("verifyCodeType");
        if (Lang.isEmpty(account)) {
            jsonObject.put("code", "-1");
            jsonObject.put("msg", "请填写登录名");
            return jsonObject;
        }

        Object capTextObj = request.getSession().getAttribute(updatePasswdType + ":code");
        if (Lang.isEmpty(capTextObj)) {
            jsonObject.put("code", "-2");
            jsonObject.put("msg", "您的验证码已超时，请刷新验证码");
            return jsonObject;
        }
        String capText = capTextObj.toString();
        if (!capText.equals(imageValidateCode)) {
            jsonObject.put("code", "-3");
            jsonObject.put("msg", "验证码错误，请点击图片验证码进行刷新");
            return jsonObject;
        }

        request.getSession().removeAttribute(updatePasswdType + ":code");

        //查询用户
        CoreUserDto coreUser = null;
        boolean isPhone = true;
        OrganizationDto organization = organizationApi.findOrganizationByOrgCode(organizationCode);
        if (Lang.isEmpty(organization)) {
            jsonObject.put("code", "1");
            jsonObject.put("msg", "机构不存在");
            return jsonObject;
        } else {
            if (!ValidateUtil.isEmail(account)) {
                coreUser = loginService.findByPhoneAndOrganizationIdAndUserType(account, organization.getId(), CoreUserDto.USER_TYPE_MEMBER, false);
                isPhone = true;
            } else {
                coreUser = loginService.findByEmailAndOrganizationIdAndUserType(account, organization.getId(), CoreUserDto.USER_TYPE_MEMBER, false);
                isPhone = false;
            }
        }

        if (Lang.isEmpty(coreUser)) {
            jsonObject.put("code", "1");
            jsonObject.put("msg", "登录名称不存在");
            return jsonObject;
        }

        //======================
        if (!profile.contains("product") && !profile.contains("prod")) {
            logger.info("发送测试验证码:{} 至账号:{}", smsTestCode, account);
            JSONObject smsContent = SmsUtil.smsCodeJson(smsTestCode);
            request.getSession().setAttribute(SESSION_ACCOUNT_CODE + account, smsContent);
            jsonObject.put("code", "0");
            jsonObject.put("msg", "发送测试手机/邮箱验证码成功");
            return jsonObject;
        }


        String smsCode = SmsUtil.smsCode();
        logger.info("发送验证码:{} 至账号:{}", smsCode, account);
        String content = "诚意通商城忘记密码手机校验码：" + smsCode + " ";


        if (isPhone) {//发送短信
            SmsReq smsReq = new SmsReq();
            smsReq.setContent(content);//发送内容
            smsReq.setTos(Arrays.asList(account));//发送手机号
            smsReq.setSendTime(new Date());
            int count = smsApi.sendVerifyCodeTimes(account, verifyCodeType);
            if (count > 50) {
                jsonObject.put("code", "2");
                jsonObject.put("msg", "一天最多只能发送50次短信");
                return jsonObject;
            }
            smsReq.setMobileServiceId(MOBILE_SERVICE_ID);
            SmsRsp smsRsp = smsApi.sendSms(smsReq);
            String sendResultShort = "";
            if (!smsRsp.isSuccessFalg()) {
                jsonObject.put("code", "2");
                jsonObject.put("msg", "发送手机验证码失败");
                return jsonObject;
            } else {
                sendResultShort = "1";

                //保存在session
                request.getSession().setAttribute(SESSION_ACCOUNT_CODE + account, SmsUtil.smsCodeJson(smsCode));
                //短信落库

                VerifyCodeDto verifyCode = new VerifyCodeDto();
                verifyCode.setType(verifyCodeType);
                String memo = "诚通商城忘记密码短信验证";
                verifyCode.setMemo(memo);
                verifyCode.setObjId(account);
                verifyCode.setSendResult(sendResultShort);
                verifyCode.setVerifyCode(smsCode.trim());
                VerifyCodeDto verifyCodeDto = BeanMapper.map(verifyCode, VerifyCodeDto.class);
                smsApi.saveVerifyCode(verifyCodeDto);
                jsonObject.put("code", "0");
                jsonObject.put("msg", "发送手机验证码成功");
                return jsonObject;
            }

        } else {//发送邮箱
            MailReq mailReq = new MailReq();
            mailReq.setFrom(emailsender);
            mailReq.setTo(new String[]{account});
            mailReq.setText(content);
            mailReq.setSubject("忘记密码验证码");
            mailReq.setSentDate(new Date());
            mailReq.setChannel(MailReq.CHANNEL_CTJF);
            MailRsp mailRsp = mailApi.sendMail(mailReq);
            if (!mailRsp.getSuccesFlag()) {
                jsonObject.put("code", "2");
                jsonObject.put("msg", "发送邮箱验证码失败");
                return jsonObject;
            }
            jsonObject.put("code", "0");
            jsonObject.put("msg", "发送邮箱验证码成功，请登录邮箱获取验证码");
            return jsonObject;
        }
    }


    //修改密码信息 第一步
    @RequestMapping(value = "forget/first", method = RequestMethod.POST)
    @ResponseBody
    public JSONObject updatePasswdFirstCheckInfo(HttpServletRequest request) {
        logger.info("修改密码第一步");
        JSONObject jsonObject = new JSONObject();
        String account = request.getParameter("account");
        String checkCode = request.getParameter("checkCode");
        if (Lang.isEmpty(account)) {
            jsonObject.put("code", "-1");
            jsonObject.put("msg", "请填写登录名");
            return jsonObject;
        }
        if (Lang.isEmpty(checkCode)) {
            jsonObject.put("code", "-2");
            jsonObject.put("msg", "请填写校验码");
            return jsonObject;
        }

        Object phoneCodeObj = request.getSession().getAttribute(SESSION_ACCOUNT_CODE + account);
        int result = SmsUtil.checkPhoneCode(checkCode, phoneCodeObj);
        if (result == -2) {
            jsonObject.put("code", "1");
            jsonObject.put("msg", "验证码超时，请重新获取");
            return jsonObject;
        } else if (result == -1) {
            jsonObject.put("code", "2");
            jsonObject.put("msg", "请输入验证码");
            return jsonObject;
        } else if (result == 0) {
            //成功
            request.getSession().removeAttribute(SESSION_ACCOUNT_CODE + account);
        } else if (result == 1) {
            jsonObject.put("code", "3");
            jsonObject.put("msg", "验证码错误");
            return jsonObject;
        } else if (result == 2) {
            jsonObject.put("code", "1");
            jsonObject.put("msg", "验证码超时，请重新获取");
            return jsonObject;
        }

        //保存账号
        request.getSession().setAttribute("UPDATE_PASSWD", account);
        jsonObject.put("code", "0");
        jsonObject.put("msg", "验证通过");
        return jsonObject;
    }


    //修改密码信息 第二步修改密码
    @RequestMapping(value = "forget/second", method = RequestMethod.POST)
    @ResponseBody
    public JSONObject updatePasswdSecondCheckInfo(HttpServletRequest request) {
        JSONObject jsonObject = new JSONObject();
        logger.info("修改登录密码...");

        Object accountObject = request.getSession().getAttribute("UPDATE_PASSWD");
        if (accountObject == null) {
            jsonObject.put("code", "-1");
            jsonObject.put("msg", "验证失败，请返回上一步重新校验");
            return jsonObject;
        }

        String account = accountObject.toString();

        String newPwd = request.getParameter("newPwd");
        String newRePwd = request.getParameter("newRePwd");

        if (Lang.isEmpty(newPwd)) {
            jsonObject.put("code", "-2");
            jsonObject.put("msg", "新密码为空");
            return jsonObject;
        }
        if (Lang.isEmpty(newRePwd)) {
            jsonObject.put("code", "-3");
            jsonObject.put("msg", "确定密码为空");
            return jsonObject;
        }
        if (!newPwd.equals(newRePwd)) {
            jsonObject.put("code", "-4");
            jsonObject.put("msg", "密码不一致");
            return jsonObject;
        }

        CoreUserDto coreUser = null;
        OrganizationDto organization = organizationApi.findOrganizationByOrgCode(organizationCode);
        if (Lang.isEmpty(organization)) {
            jsonObject.put("code", "1");
            jsonObject.put("msg", "机构不存在");
            return jsonObject;
        } else {
            if (!ValidateUtil.isEmail(account)) {
                coreUser = loginService.findByPhoneAndOrganizationIdAndUserType(account, organization.getId(), CoreUserDto.USER_TYPE_MEMBER, false);

            } else {
                coreUser = loginService.findByEmailAndOrganizationIdAndUserType(account, organization.getId(), CoreUserDto.USER_TYPE_MEMBER, false);

            }
        }


        MemberDto member = loginService.findByCoreUser(coreUser);
        member.setIsFirstLogin(1);
        MemberDto tmpMember = loginService.updateMember(member);
        if (Lang.isEmpty(tmpMember)) {
            jsonObject.put("code", "1");
            jsonObject.put("msg", "修改密码失败");
            return jsonObject;
        }
        //设置新密码
        String encryptPasswd = loginService.encryptPasswd(newPwd);
        coreUser.setPassword(encryptPasswd);
        CoreUserDto user = loginService.updateCoreUser(coreUser);

        if (Lang.isEmpty(user)) {
            jsonObject.put("code", "1");
            jsonObject.put("msg", "修改密码失败");
            return jsonObject;
        }

        //移除session
        jsonObject.put("code", "0");
        jsonObject.put("msg", "修改密码成功");
        return jsonObject;
    }


    //首页
    @RequestMapping(value = "index", method = RequestMethod.GET)
    public String index(HttpServletRequest request, HttpServletResponse response) {
        CookiesTool.addCookie(response, "account", "", 0);
        //检测是否已经登录
     /*   Object loginMemberSession = request.getSession().getAttribute(LOGIN_USER_SESSION);
        if(loginMemberSession == null){
            return "redirect:login";
        }*/
        return "redirect:../score";
    }

    @RequestMapping("loginValidate")  //校验是否登录,ajax请求倩校验
    @ResponseBody
    public Boolean loginValidate(HttpServletRequest request) {
        Object memberId = request.getSession().getAttribute(GlobalContants.SESSION_MEMBER_ID_ITAIPING);
        if (Lang.isEmpty(memberId)) {  //未登录
            String currentUrl = request.getParameter("currentUrl");
            if (!org.springframework.util.StringUtils.isEmpty(currentUrl)) {
                request.getSession().setAttribute(GlobalContants.SESSION_LOGIN_BACK_URL_ITAIPING, currentUrl);
            }
            return false;
        }
        return true;
    }
}
