package ctscore.web.controller.login;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import message.api.sms.SmsApi;
import message.api.sms.vo.SmsReq;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import utils.kaptcha.CheckUtils;

import javax.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by xiaoqian on 2016/10/24.
 */
@RequestMapping("sms")
@Controller
public class SmsController {

    public static final String LOGIN_SMS_CHECK_PHONE = "login_sms_check_phone";


    @MotanReferer(basicReferer = "motanClientBasicConfig")
    SmsApi smsApi;

    @Autowired
    CheckUtils checkUtils;
    @Value("${ctscore.orgCode}")
    private String organizationCode;//机构code值

    @Value("${ctscore.storeCode}")
    private String storeCode;//店铺code

    @RequestMapping("sendLoginSms")
    @ResponseBody
    public Map sendSms(HttpServletRequest request,String phone){
        Map returnMap =new HashMap();
        //String phone = request.getParameter("phone");
        request.getSession().setAttribute(LOGIN_SMS_CHECK_PHONE,phone);

        //first 生成校验码
        //send the smscheckcode
        String smscode =  checkUtils.getValidateCode("smslogin",request.getSession());
        //todo send sms @huang

        SmsReq smsReq = new SmsReq();
        smsReq.setTos(Arrays.asList("18665713868"));
        smsReq.setSignName("太平采购测试站");
        smsReq.setTemplateCode("SMS_23580033");
        Map map = new HashMap();
        map.put("code",String.valueOf(System.currentTimeMillis()));
        map.put("time",",5分钟");
        smsReq.setTemplateParams(map);

        smsApi.sendSms(smsReq);

        //
        return returnMap;
    }
}
