package ctscore.web.controller.login;

import com.google.code.kaptcha.Producer;
import com.google.code.kaptcha.util.Config;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.annotation.PostConstruct;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;

/**
 * Created by xiaoqian on 2016/10/24.
 */
@RequestMapping("kaptcha")
@Controller
public class ValidateController {

    @Autowired
    @Qualifier("kaptchaProperties")
    private Properties props = new Properties();

    private Producer kaptchaProducer = null;

    private String sessionKeyValue = "LOGIN";

    private String sessionKeyDateValue = "DATE";

    public void setProps(Properties props) {
        this.props = props;
    }


    @PostConstruct
    public void init() throws ServletException{
        // Switch off disk based caching.
        ImageIO.setUseCache(false);

        Config config = new Config(this.props);
        this.kaptchaProducer = config.getProducerImpl();
        this.sessionKeyValue = config.getSessionKey();
        this.sessionKeyDateValue = config.getSessionDate();
    }

    @RequestMapping("/image")
    public void index(HttpServletRequest req, HttpServletResponse resp,String type)  throws ServletException, IOException {
        //todo 需要type 的类型个数，以免被session 攻击

        // Set standard HTTP/1.1 no-cache headers.
        resp.setHeader("Cache-Control", "no-store, no-cache");

        // return a jpeg
        resp.setContentType("image/jpeg");

        // create the text for the image
        String capText = this.kaptchaProducer.createText();
        // fixes issue #69: set the attributes after we write the image in case the image writing fails.

        // store the text in the session
        // store the date in the session so that it can be compared
        // against to make sure someone hasn't taken too long to enter
        // their kaptcha
        if(StringUtils.hasText(type)){
            req.getSession().setAttribute(type +":code", capText);
            req.getSession().setAttribute(type +":date", new Date());
        }else{
            req.getSession().setAttribute(this.sessionKeyValue, capText);
            req.getSession().setAttribute(this.sessionKeyDateValue, new Date());
        }

        // create the image with the text
        BufferedImage bi = this.kaptchaProducer.createImage(capText);

        ServletOutputStream out = resp.getOutputStream();

        // write the data out
        ImageIO.write(bi, "jpg", out);
    }

}
