package ctscore.web.controller.member;

import com.google.common.collect.Maps;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import ctscore.web.service.area.AreaService;
import member.api.AddressCommonApi;
import member.api.dto.common.AddressDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import utils.GlobalContants;
import utils.Lang;
import utils.ip.IPtoLong;
import utils.log.Log;
import utils.log.Logs;
import utils.web.AddressUtils;
import utils.web.Webs;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by Liang Wenxu on 2016/11/14.
 */
@Controller
@RequestMapping("/areaCommon")
public class AddressController {

    @Autowired
    AreaService areaService;

    private final static Log log = Logs.getLog(AddressController.class.getName());


    @RequestMapping("/findAllByParent")
    @ResponseBody
    public Map<String, Object> findAddressByParent(
            Integer level, String parent, Boolean withChildren,
            Map model, HttpServletRequest request, HttpServletResponse response) {
        Map<String, Object> resData = new HashMap<String, Object>();
        resData.put(GlobalContants.ResponseString.STATUS, GlobalContants.ResponseStatus.SUCCESS);
        resData.put(GlobalContants.ResponseString.MESSAGE, GlobalContants.ResponseStatus.SUCCESS);
        AddressCommonApi.AddressLevel addrLevel = level == null ? null : AddressCommonApi.AddressLevel.getLevel(level);
        withChildren = withChildren == null ? false : withChildren;

//        List<Address> apiRes = null;
        List<member.api.vo.AddressVo> apiRes = null;
        if(Lang.isEmpty(parent)) {
//            apiRes = addressCommonApi.addressList(addrLevel, withChildren);
            apiRes = addressCommonApi.addressVoList(addrLevel, null, withChildren);
        } else {
//            apiRes = addressCommonApi.addressList(addrLevel, parent, withChildren);
            apiRes = addressCommonApi.addressVoList(addrLevel, parent, withChildren);
        }

//        resData.put(GlobalContants.ResponseString.DATA, transAddressListToVoList(apiRes, withChildren));
        resData.put(GlobalContants.ResponseString.DATA, apiRes);
        return resData;
    }

    @RequestMapping("/findAll")
    @ResponseBody
    public Map<String, Object> findAddress(
            String id, Integer level, String parentId, Boolean withChildren,
            Map model, HttpServletRequest request, HttpServletResponse response) {
        Map<String, Object> resData = new HashMap<String, Object>();
        resData.put(GlobalContants.ResponseString.STATUS, GlobalContants.ResponseStatus.SUCCESS);
        resData.put(GlobalContants.ResponseString.MESSAGE, GlobalContants.ResponseStatus.SUCCESS);
        AddressCommonApi.AddressLevel addrLevel = level == null ? null : AddressCommonApi.AddressLevel.getLevel(level);
        withChildren = withChildren == null ? false : withChildren;

//        List<Address> apiRes = null;
        List<member.api.vo.AddressVo> apiRes = null;
        if(!Lang.isEmpty(id)) {
            apiRes = new ArrayList<>();
//            apiRes.add(addressCommonApi.findById(id));
            apiRes.add(addressCommonApi.findVoById(id,true));
        } else if(Lang.isEmpty(parentId)) {
//            apiRes = addressCommonApi.addressList(addrLevel, withChildren);
            apiRes = addressCommonApi.addressVoList(addrLevel, null, withChildren);
        } else {
            String[] pidArr;
            if(parentId.contains(",")) {
                pidArr = parentId.split(",");
                for(String pid : pidArr) {
//                    apiRes.addAll(addressCommonApi.addressList(addrLevel, pid, withChildren));
                    apiRes.addAll(addressCommonApi.addressVoList(addrLevel, pid, withChildren));
                }
            } else {
//                apiRes = addressCommonApi.addressList(addrLevel, parentId, withChildren);
                apiRes = addressCommonApi.addressVoList(addrLevel, parentId, withChildren);
            }
        }

//        List<AddressVo> voList = transAddressListToVoList(apiRes, withChildren);



//        resData.put(GlobalContants.ResponseString.DATA, voList);
        resData.put(GlobalContants.ResponseString.DATA, apiRes);

        return resData;
    }

    @RequestMapping("/ipAddress")
    @ResponseBody
    public Map<String, Object> findIpAddressIds(
            Map model, HttpServletRequest request, HttpServletResponse response) {
        Map<String, Object> resData = new HashMap<String, Object>();
        resData.put(GlobalContants.ResponseString.STATUS, GlobalContants.ResponseStatus.SUCCESS);
        resData.put(GlobalContants.ResponseString.MESSAGE, GlobalContants.ResponseStatus.SUCCESS);
        resData.put(GlobalContants.ResponseString.DATA, getIpAddressIds(request, response));
        log.info("reseted session addressId -> " +
                "proviceId: " + request.getSession().getAttribute(GlobalContants.AREA_LEVEL_PROVINCE_ID)
                + "cityId: " + request.getSession().getAttribute(GlobalContants.AREA_LEVEL_CITY_ID)
                + "areaId: " + request.getSession().getAttribute(GlobalContants.AREA_LEVEL_AREA_ID)
                + "townId: " + request.getSession().getAttribute(GlobalContants.AREA_LEVEL_TOWN_ID));
        return resData;
    }

    /**
     * 获取Session中保存地区代码
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/savedArea", method = RequestMethod.GET)
    @ResponseBody
    Map<String, Object> getSavedArea(HttpServletRequest request, HttpServletResponse response) {
        Map model = Maps.newHashMap();
        String provinceId = (String) request.getSession().getAttribute(GlobalContants.AREA_LEVEL_PROVINCE_ID);
        String cityId = (String) request.getSession().getAttribute(GlobalContants.AREA_LEVEL_CITY_ID);
        String areaId = (String) request.getSession().getAttribute(GlobalContants.AREA_LEVEL_AREA_ID);
        String townId = (String) request.getSession().getAttribute(GlobalContants.AREA_LEVEL_TOWN_ID);

        if(!Lang.isEmpty(provinceId)){
            Map returnAddressIdMap = areaService.getAddressIdSByParams(request, provinceId);
            cityId = (String) returnAddressIdMap.get("cityId");
            areaId = (String) returnAddressIdMap.get("areaId");
            townId = (String) returnAddressIdMap.get("townId");
        }
        if(Lang.isEmpty(provinceId)){
            //默认北京
            provinceId = "110000";
            cityId = "110100";
            areaId = "110120";
        }
        model.put("provinceId",provinceId);
        model.put("cityId",cityId);
        model.put("areaId",areaId);
        model.put("townId",townId);

        return model;
    }

    /**
     * 修改保存的省份ID
     * @param provoiceId
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "changeProvince/{provoiceId}", method = RequestMethod.GET)
    @ResponseBody
    public Map changeProvince(@PathVariable("provoiceId") String provoiceId , HttpServletRequest request, HttpServletResponse response){
        Map map = Maps.newHashMap();
        map.put("result","success");
        setAddressId(provoiceId,request,response);
        return map;
    }

    /**
     * 修改保存的地区ID（传最末级地区ID）
     * @param areaId
     * @param request
     * @param response
     * @return
     */
    @RequestMapping("changeArea/{areaId}")
    @ResponseBody
    public Map changeArea(@PathVariable("areaId") String areaId , HttpServletRequest request,HttpServletResponse response){
        Map map = Maps.newHashMap();
        map.put("result","success");
        //    addressCommonApi.getIpAddressIds(request,response);
        //  request.getSession().setAttribute(GlobalContants.AREA_LEVEL_PROVINCE_ID, provoiceId);
        //   response.addCookie(new Cookie(GlobalContants.AREA_LEVEL_PROVINCE_ID,provoiceId));
        setAddressIdSByParams(request, response, areaId);
        return map;
    }

    @RequestMapping("/cleanAreas")
    @ResponseBody
    Map<String, Object> cleanSessionAreas(
            Map model, HttpServletRequest request, HttpServletResponse response) {
        Map<String, Object> resData = new HashMap<String, Object>();
        resData.put(GlobalContants.ResponseString.STATUS, GlobalContants.ResponseStatus.SUCCESS);
        resData.put(GlobalContants.ResponseString.MESSAGE, GlobalContants.ResponseStatus.SUCCESS);
        request.getSession().setAttribute(GlobalContants.AREA_LEVEL_PROVINCE_ID, null);
        request.getSession().setAttribute(GlobalContants.AREA_LEVEL_CITY_ID, null);
        request.getSession().setAttribute(GlobalContants.AREA_LEVEL_AREA_ID, null);
        request.getSession().setAttribute(GlobalContants.AREA_LEVEL_TOWN_ID, null);
        log.info("reseted session addressId -> " +
                "proviceId: " + request.getSession().getAttribute(GlobalContants.AREA_LEVEL_PROVINCE_ID)
                + ", cityId: " + request.getSession().getAttribute(GlobalContants.AREA_LEVEL_CITY_ID)
                + ", areaId: " + request.getSession().getAttribute(GlobalContants.AREA_LEVEL_AREA_ID)
                + ", townId: " + request.getSession().getAttribute(GlobalContants.AREA_LEVEL_TOWN_ID));
        return resData;
    }

    /** 临时获取当前地区 */
    public void setAddressId( String provoiceId , HttpServletRequest request,HttpServletResponse response){
        Map returnAddressIdMap=new HashMap();
        String returnProvoiceId=null;
        String returnCityId=null;
        String returnAreaId=null;
        String sessionProvoiceId = (String) request.getSession().getAttribute(GlobalContants.AREA_LEVEL_PROVINCE_ID);
        String cityId = (String) request.getSession().getAttribute(GlobalContants.AREA_LEVEL_CITY_ID);
        String areaId = (String) request.getSession().getAttribute(GlobalContants.AREA_LEVEL_AREA_ID);
        if(!Lang.isEmpty(sessionProvoiceId)) {
            if (!provoiceId.equals(sessionProvoiceId)) {
                returnProvoiceId=provoiceId;
                /**LWX 2017/1/5修改： 当省份改变时，修改已保存的2级3级4级地区 START */
                request.getSession().setAttribute(GlobalContants.AREA_LEVEL_CITY_ID, null);
                request.getSession().setAttribute(GlobalContants.AREA_LEVEL_AREA_ID, null);
                request.getSession().setAttribute(GlobalContants.AREA_LEVEL_TOWN_ID, null);
                /**LWX 2017/1/5修改： 当省份改变时，修改已保存的2级3级4级地区 END */
            }else{
                returnProvoiceId=sessionProvoiceId;
                /**LWX 2017/1/5修改： 当省份改变时，修改已保存的2级3级4级地区 START */
                request.getSession().setAttribute(GlobalContants.AREA_LEVEL_CITY_ID, null);
                request.getSession().setAttribute(GlobalContants.AREA_LEVEL_AREA_ID, null);
                request.getSession().setAttribute(GlobalContants.AREA_LEVEL_TOWN_ID, null);
                /**LWX 2017/1/5修改： 当省份改变时，修改已保存的2级3级4级地区 END */
            }
        }else{
            returnProvoiceId=provoiceId;

        }

        Map addressMap = areaService.getAddressIdSByParams(request, returnProvoiceId);
        returnCityId= (String)addressMap.get("cityId");
        returnAreaId=(String) addressMap.get("areaId");
        String returnTownId=(String) addressMap.get("townId");

        returnAddressIdMap.put("provoiceId",returnProvoiceId);
        returnAddressIdMap.put("cityId",returnCityId);
        returnAddressIdMap.put("areaId",returnAreaId);
        returnAddressIdMap.put("townId",returnTownId);

        /**
         * 设置缓存信息
         */
        AddressUtils.setAddressIdToSession(request,response,returnAddressIdMap);
        log.info("reseted session addressId -> " +
                "proviceId: " + request.getSession().getAttribute(GlobalContants.AREA_LEVEL_PROVINCE_ID)
                + "cityId: " + request.getSession().getAttribute(GlobalContants.AREA_LEVEL_CITY_ID)
                + "areaId: " + request.getSession().getAttribute(GlobalContants.AREA_LEVEL_AREA_ID)
                + "townId: " + request.getSession().getAttribute(GlobalContants.AREA_LEVEL_TOWN_ID)
        );
    }

    public Map getIpAddressIds(HttpServletRequest request,HttpServletResponse response){
        String sessionProvoiceId = (String) request.getSession().getAttribute(GlobalContants.AREA_LEVEL_PROVINCE_ID);
        Map returnMap = areaService.getAddressIdSByParams(request, sessionProvoiceId);
        return returnMap;
    }


    /*public Map getAddressIdSByParams(HttpServletRequest request, HttpServletResponse response, String proviceId) {
        Map returnAddressIdMap=new HashMap();
        String returnProvoiceId=null;
        String returnCityId=null;
        String returnAreaId=null;
        String returnTownId=null;
        String sessionProvoiceId = (String) request.getSession().getAttribute(GlobalContants.AREA_LEVEL_PROVINCE_ID);
        String cityId = (String) request.getSession().getAttribute(GlobalContants.AREA_LEVEL_CITY_ID);
        String areaId = (String) request.getSession().getAttribute(GlobalContants.AREA_LEVEL_AREA_ID);
        String townId = (String) request.getSession().getAttribute(GlobalContants.AREA_LEVEL_TOWN_ID);
        if(Lang.isEmpty(proviceId)){
            if(!Lang.isEmpty(sessionProvoiceId)){
                returnProvoiceId=sessionProvoiceId;
            }else{
                String remoteIp = Webs.getIp(request);
//                remoteIp = "183.43.167.15";
                log.info("getAddressIdsByParams -> remoteIp: " + remoteIp);
                if(!Lang.isEmpty(remoteIp)) {
                    Long ipL = IPtoLong.ipToLong(remoteIp);
                    Address currentAaddress = null;
                    currentAaddress = addressCommonApi.findAreaByIp(ipL, GlobalContants.AREA_LEVEL_PROVINCE);
                    if(!Lang.isEmpty(currentAaddress)){
                        returnProvoiceId=currentAaddress.getId();
                    }else{
                        returnProvoiceId = "110000";
                        *//**LWX 2017/1/10修改： 当省份改变时，修改已保存的2级3级4级地区 START *//*
                        request.getSession().setAttribute(GlobalContants.AREA_LEVEL_CITY_ID, null);
                        request.getSession().setAttribute(GlobalContants.AREA_LEVEL_AREA_ID, null);
                        request.getSession().setAttribute(GlobalContants.AREA_LEVEL_TOWN_ID, null);
                        *//**LWX 2017/1/10修改： 当省份改变时，修改已保存的2级3级4级地区 END *//*
                    }

                }else {
                    returnProvoiceId = "110000";
                    *//**LWX 2017/1/10修改： 当省份改变时，修改已保存的2级3级4级地区 START *//*
                    request.getSession().setAttribute(GlobalContants.AREA_LEVEL_CITY_ID, null);
                    request.getSession().setAttribute(GlobalContants.AREA_LEVEL_AREA_ID, null);
                    request.getSession().setAttribute(GlobalContants.AREA_LEVEL_TOWN_ID, null);
                    *//**LWX 2017/1/10修改： 当省份改变时，修改已保存的2级3级4级地区 END *//*
                }
            }
        }else{
            if(!Lang.isEmpty(sessionProvoiceId)) {
                if (!proviceId.equals(sessionProvoiceId)) {
                    returnProvoiceId=proviceId;
                    *//**LWX 2017/1/10修改： 当省份改变时，修改已保存的2级3级4级地区 START *//*
                    request.getSession().setAttribute(GlobalContants.AREA_LEVEL_CITY_ID, null);
                    request.getSession().setAttribute(GlobalContants.AREA_LEVEL_AREA_ID, null);
                    request.getSession().setAttribute(GlobalContants.AREA_LEVEL_TOWN_ID, null);
                    *//**LWX 2017/1/10修改： 当省份改变时，修改已保存的2级3级4级地区 END *//*
                }else{
                    returnProvoiceId=sessionProvoiceId;

                }
            }else{
                returnProvoiceId=proviceId;
                *//**LWX 2017/1/10修改： 当省份改变时，修改已保存的2级3级4级地区 START *//*
                request.getSession().setAttribute(GlobalContants.AREA_LEVEL_CITY_ID, null);
                request.getSession().setAttribute(GlobalContants.AREA_LEVEL_AREA_ID, null);
                request.getSession().setAttribute(GlobalContants.AREA_LEVEL_TOWN_ID, null);
                *//**LWX 2017/1/10修改： 当省份改变时，修改已保存的2级3级4级地区 END *//*
            }
        }
        if(Lang.isEmpty(areaId)) {
            Map<String, Object> areaMap = getAddressId(request,cityId,areaId,returnProvoiceId);
            returnCityId= (String) areaMap.get("cityId");
            returnAreaId=(String) areaMap.get("areaId");
            returnTownId =(String) areaMap.get("townId");
        } else {
            returnCityId = cityId;
            returnAreaId = areaId;
            returnTownId = townId;
        }

        returnAddressIdMap.put("provoiceId",returnProvoiceId);
        returnAddressIdMap.put("cityId",returnCityId);
        returnAddressIdMap.put("areaId",returnAreaId);
        returnAddressIdMap.put("townId",returnTownId);

        return returnAddressIdMap;
    }*/


    public void setAddressIdSByParams(HttpServletRequest request, HttpServletResponse response, String areaId) {
        if(Lang.isEmpty(areaId)){
            throw  new NullPointerException("areaId not null");
        }else{
            Map addressMap= Maps.newHashMap();
            String returnProvoiceId=null;
            String returnCityId=null;
            String returnAreaId=areaId;
            String returnTownId = null;
            Map<Integer, String> areaNodeList = addressCommonApi.areaCodeNodeList(areaId);
            if(!Lang.isEmpty(areaNodeList)) {
                returnProvoiceId = areaNodeList.get(1);
                returnCityId = areaNodeList.get(2);
                returnAreaId = areaNodeList.get(3);
                returnTownId = areaNodeList.get(4);
                log.info("ChangeArea areaNodeList -> returnProvoiceId:"+returnProvoiceId+",returnCityId"+returnCityId+",returnAreaId:"+returnAreaId+",returnTownId:"+returnTownId);
            }

            addressMap.put("provoiceId",returnProvoiceId);
            addressMap.put("cityId",returnCityId);
            addressMap.put("areaId",returnAreaId);
            addressMap.put("townId",returnTownId);
            AddressUtils.setAddressIdToSession(request,response,addressMap);
            log.info("reseted session addressId -> " +
                    "proviceId: " + request.getSession().getAttribute(GlobalContants.AREA_LEVEL_PROVINCE_ID)
                    + "cityId: " + request.getSession().getAttribute(GlobalContants.AREA_LEVEL_CITY_ID)
                    + "areaId: " + request.getSession().getAttribute(GlobalContants.AREA_LEVEL_AREA_ID)
                    + "townId: " + request.getSession().getAttribute(GlobalContants.AREA_LEVEL_TOWN_ID));
        }
    }

    public Map getCityAndAreaId(String provoiceId){
        Map returnAddressIdMap=new HashMap();

        String returnCityId=null;
        String returnAreaId=null;
        String returnTownId = null;
        AddressDto a = addressCommonApi.findFirstChild(provoiceId, true);
//        List<Address> areaAddressList=addressCommonApi.addressList(
//                AddressCommonApi.AddressLevel.CITY,provoiceId,true);
//        if(!Lang.isEmpty(areaAddressList)){
//            returnCityId=areaAddressList.get(0).getId();
//            if(!Lang.isEmpty(areaAddressList.get(0).getChild())){
//                returnAreaId=areaAddressList.get(0).getChild().get(0).getId();
//            }
//        }
        if(a != null) {
            returnCityId = a.getId();
            AddressDto addr = addressCommonApi.findFirstChild(returnCityId, false);
            if(Lang.isEmpty(addr)){
                returnAreaId = addr.getId();
            }
            AddressDto c = addressCommonApi.findFirstChild(returnAreaId, true);
            if(c != null) {
                returnTownId = c.getId();
            }
        }
        returnAddressIdMap.put("cityId",returnCityId);
        returnAddressIdMap.put("areaId",returnAreaId);
        returnAddressIdMap.put("townId",returnTownId);
        return returnAddressIdMap;
    }

    public Map getAddressId(HttpServletRequest request, String cityId, String areaId, String provoiceId){
        Map returnAddressIdMap=new HashMap();

        String returnCityId=null;
        String returnAreaId=null;
        String returnTownId = null;
        String remoteIp = Webs.getIp(request);
//        remoteIp = "183.43.167.15";
        if(!Lang.isEmpty(remoteIp)) {
            Long ipL = IPtoLong.ipToLong(remoteIp);
            AddressDto currentAaddress = null;
            if (Lang.isEmpty(areaId)) {//直接定位到当前位置所在的第三级
                currentAaddress = addressCommonApi.findAreaByIp(ipL, GlobalContants.AREA_LEVEL_AREA);

                if (!Lang.isEmpty(currentAaddress)) {//查询第2级
//                    currentAaddress = addressCommonApi.findAreaByIp(ipL, GlobalContants.AREA_LEVEL_CITY);
//                    if (Lang.isEmpty(currentAaddress)) {
//                        Map<String, Object> areaMap = getCityAndAreaId(provoiceId);
//                        returnCityId = (String) areaMap.get("cityId");
//                        returnAreaId = (String) areaMap.get("areaId");
//                        returnTownId = (String) areaMap.get("townId");
//                    } else {
//                        returnCityId = currentAaddress.getId();
////                        List<Address> areaAddressList=addressCommonApi.addressList(AddressCommonApi.AddressLevel.AREA,returnCityId,false);
//                        Address a = addressCommonApi.findFirstChild(returnCityId, false);
//                        if (a != null) {
//                            returnAreaId = a.getId();
//                            if (!Lang.isEmpty(returnAreaId)) {
//                                Address c = addressCommonApi.findFirstChild(returnAreaId, false);
//                                if (c != null) {
//                                    returnTownId = c.getId();
//                                }
//                            }
//                        }
//                    }
//                } else {
                    returnAreaId = currentAaddress.getId();
                    returnCityId = currentAaddress.getParent().getId();
                }
            }
        }

        if(Lang.isEmpty(returnAreaId)){
            AddressDto cityAddress = addressCommonApi.findFirstChild(provoiceId, true);
            returnCityId = "110100";
            returnAreaId = "110101";
            returnTownId = "d8a15c70-9c8a-44b6-bc34-06b457ecfaaf";
        }

        request.getSession().setAttribute(GlobalContants.AREA_LEVEL_CITY_ID, returnCityId);
        request.getSession().setAttribute(GlobalContants.AREA_LEVEL_AREA_ID, returnAreaId);
        request.getSession().setAttribute(GlobalContants.AREA_LEVEL_TOWN_ID, returnTownId);

        returnAddressIdMap.put("cityId",returnCityId);
        returnAddressIdMap.put("areaId",returnAreaId);
        returnAddressIdMap.put("townId", returnTownId);
        return returnAddressIdMap;
    }




    @MotanReferer
    AddressCommonApi addressCommonApi;
}
