package ctscore.web.controller.member;

import aftersale.api.AfterSaleApplyApi;
import aftersale.api.Vo.ApplyParamsVo;
import aftersale.api.Vo.OrderAndSkuVO;
import aftersale.api.Vo.WareReturnJdCompVO;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import jd.api.request.aftersale.OrderSkuEntity;
import jd.api.response.aftersale.WareReturnJdCompResp;
import jd.api.service.aftersale.JdAftersaleApi;
import ma.glasnost.orika.MapperFacade;
import member.api.AddressCommonApi;
import member.api.dto.common.AddressDto;
import member.api.dto.shop.MemberAddressDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * Created by Guo Benqiang on 2016/11/4.
 */
@Controller
public class AfterSaleApplyController {

    @MotanReferer
    AfterSaleApplyApi afterSaleApplyApi;

    @MotanReferer
    AddressCommonApi addressCommonApi;

    @MotanReferer
    JdAftersaleApi jdAftersaleApi;

    @Autowired
    MapperFacade mapperFacade;

    //    @MotanReferer
//    AddressServiceByDb addressByDatabase;

    @RequestMapping("/afterSaleTest")
    public String test() {
        return "myMsg/demoTest";
    }

    /**
     * 跳转申请售后页面
     *
     * @param orderAndSkuVO
     * @param map
     * @return
     */
    @RequestMapping("/salesApply")
    public String afterSaleApplyPage(OrderAndSkuVO orderAndSkuVO, Map<String, Object> map) {
        orderAndSkuVO = afterSaleApplyApi.QueryApplyCondition(orderAndSkuVO);
        aftersale.api.dto.MemberAddressDto memberAddress = afterSaleApplyApi.QueryMemberAddress(orderAndSkuVO.getAddressId());

        // 获取可用的售后方式
        //TODO: 目前只有京东支持售后，如其它商户也支持售后接口，请将售后接口加入到OutsideApi里，做成适配器形式
        OrderSkuEntity orderSkuEntity = new OrderSkuEntity();
        orderSkuEntity.setJdOrderId(orderAndSkuVO.getJdOrderId());
        orderSkuEntity.setSkuId(orderAndSkuVO.getSkuId());

        WareReturnJdCompResp wareReturnJdCompResp = jdAftersaleApi.getWareReturnJd(orderSkuEntity);
        if(wareReturnJdCompResp.getSuccess()) {
            // 退货方式列表 -> [{code:<code>, name:<name>}]
            List<Map> returnMethodList = new ArrayList<>();
            Map returnMethodMap = null;
            orderAndSkuVO.setReturnTypes(mapperFacade.mapAsList(wareReturnJdCompResp.getResult(), WareReturnJdCompVO.class));
//            for(WareReturnJdCompVO wrjcVo : wareReturnJdCompResp.getResult()) {
//                returnMethodMap = new HashMap();
//                returnMethodMap.put("code", wrjcVo.getCode());
//                returnMethodMap.put("name", wrjcVo.getName());
//                returnMethodList.add(returnMethodMap);
//            }
//
//            map.put("returnMethodList", returnMethodList);
        }
        map.put("orderAndSkuVO", orderAndSkuVO);
        map.put("memberAddress", memberAddress);
        journal("orderAndSkuVO", orderAndSkuVO);
        journal("memberAddress", memberAddress);
        return "myMsg/myAfterSalesApply";
    }

    /**
     * 跳转申请售后成功页面
     *
     * @return
     */
    @RequestMapping("/applySuccess")
    public String returnApplyUI() {
        return "myMsg/myAfterSalesApplySuc";
    }


    /**
     * 申请售后
     *
     * @param applyParamsVo
     * @return
     */
    @RequestMapping("/returnApplyResult")
    @ResponseBody
    public Map<String, Boolean> returnApplyResult(ApplyParamsVo applyParamsVo) {
        journal("applyParamsVo", applyParamsVo);
        Map result = afterSaleApplyApi.applyAfterSale(applyParamsVo);
        return result;
    }


    /**
     * 查询四级地址
     * 通过数据库
     *
     * @param level
     * @param addressId
     * @return
     */
//    @RequestMapping("/getLevelAddressByDb")
//    @ResponseBody
//    public Map<String, Integer> getLevelAddressByDb(Integer level, Integer addressId) {
//        AddressEntity addressEntity = new AddressEntity();
//        addressEntity.setId(addressId);
//        Map<String, Integer> address = null;
//        switch (level) {
//            case 0:
//                address = addressByDatabase.getLevelOneAddress();
//                System.out.print("一级地址 省 数据库");
//                break;
//            case 1:
//                address = addressByDatabase.getLevelTwoAddress(addressEntity);
//                System.out.print("二级地址 市 数据库");
//                break;
//            case 2:
//                address = addressByDatabase.getLevelThreeAddress(addressEntity);
//                System.out.print("三级地址 区县 数据库");
//                break;
//            case 3:
//                address = addressByDatabase.getLevelFourAddress(addressEntity);
//                System.out.print("四级地址 镇 ");
//                break;
//        }
//        if(address != null) {
//            for (Map.Entry<String, Integer> entry : address.entrySet()) {
//                System.out.println(entry.getKey() + "--->" + entry.getValue());
//            }
//        }
//        return address;
//
//    }
    @RequestMapping("/getLevelAddressByDb")
    @ResponseBody
    public Map<String, String> getLevelAddressByDb(Integer level, String addressId) {
        Map<String, String> addressList = new HashMap<>();
        List<AddressDto> list = null;
        switch (level) {
            case 0:
                list = addressCommonApi.addressList(AddressCommonApi.AddressLevel.PROVINCE, null, false);
                System.out.print("一级地址 省 数据库" + list);
                break;
            case 1:
                list = addressCommonApi.addressList(AddressCommonApi.AddressLevel.CITY, addressId, false);
                System.out.print("二级地址 市 数据库");
                break;
            case 2:
                list = addressCommonApi.addressList(AddressCommonApi.AddressLevel.AREA, addressId, false);
                System.out.print("三级地址 区县 数据库");
                break;
            case 3:
                list = addressCommonApi.addressList(AddressCommonApi.AddressLevel.TOWN, addressId, false);
                System.out.print("四级地址 镇 ");
                break;
        }
        for (AddressDto address : list) {
            addressList.put(address.getName(), address.getId());
        }
        if (addressList.isEmpty()) {
            return null;
        }
        for (Map.Entry<String, String> entry : addressList.entrySet()) {
            System.out.println(entry.getKey() + "--->" + entry.getValue());
        }
        return addressList;

    }


    /**
     * 打印信息
     *
     * @param key
     * @param o
     */
    public void journal(String key, Object o) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            System.out.println(key + "=====" + mapper.writerWithDefaultPrettyPrinter().writeValueAsString(o));
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
    }

}
