package ctscore.web.controller.member;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import member.api.AddressCommonApi;
import member.api.MemberAddressApi;
import member.api.MemberApi;
import member.api.dto.shop.MemberAddressDto;
import member.api.vo.MemberVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import utils.GlobalContants;
import utils.Lang;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by Liang Wenxu on 2016/11/25.
 */
@Controller
@RequestMapping("memberAddress")
public class MemberAddressController {
    @RequestMapping(value = {"list", "list.json"})
    @ResponseBody
    public Map list(Map model, HttpServletRequest request, HttpServletResponse response) {
        MemberVo memberVo = findMemberVo(request);
        String noMask = request.getParameter("noMask");
        HashMap<String, Object> rsMap = new HashMap<String, Object>();
        rsMap.put(GlobalContants.ResponseString.STATUS, GlobalContants.ResponseStatus.SUCCESS);
        rsMap.put(GlobalContants.ResponseString.ERROR_CODE, 0);
        try {
            List<MemberAddressDto> memberAddressList = memberAddressApi.list(memberVo.getMember().getId());
            StringBuffer sb;
            if (!Lang.isEmpty(memberAddressList)) {
                for (MemberAddressDto ma : memberAddressList) {
                    sb = new StringBuffer(ma.getPhone());
                    ma.setMember(null);
                    if (Lang.isEmpty(noMask)) {
                        ma.setPhone(sb.replace(3, 8, "*****").toString());
                    }
                }
            } else {
                memberAddressList = new ArrayList<>(1);
            }
            rsMap.put(GlobalContants.ResponseString.DATA, memberAddressList);
            rsMap.put(GlobalContants.ResponseString.MESSAGE, "suc");
        } catch (Exception e) {
            rsMap.put(GlobalContants.ResponseString.STATUS, GlobalContants.ResponseStatus.ERROR);
            rsMap.put(GlobalContants.ResponseString.ERROR_CODE, 1);
            rsMap.put(GlobalContants.ResponseString.MESSAGE, e.getMessage());
            e.printStackTrace();
        }

        return rsMap;
    }

    @RequestMapping(value = {"delete", "delete.json"})
    @ResponseBody
    public Map delete(@RequestParam(value = "ids[]") String[] ids, Map model, HttpServletRequest request, HttpServletResponse response) {
        MemberVo memberVo = findMemberVo(request);
        HashMap<String, Object> rsMap = new HashMap<String, Object>();
        rsMap.put(GlobalContants.ResponseString.STATUS, GlobalContants.ResponseStatus.SUCCESS);
        rsMap.put(GlobalContants.ResponseString.ERROR_CODE, 0);
        if (!Lang.isEmpty(ids)) {
            List<Map<String, Object>> delResList = new ArrayList<>();
            Map<String, Object> delRes;
            try {
                for (String id : ids) {
                    delRes = new HashMap<String, Object>();
                    delRes.put("id", id);
                    delRes.put("success", memberAddressApi.delete(id));
                    delResList.add(delRes);
                }

                rsMap.put(GlobalContants.ResponseString.DATA, delResList);
            } catch (Exception e) {
                rsMap.put(GlobalContants.ResponseString.STATUS, GlobalContants.ResponseStatus.ERROR);
                rsMap.put(GlobalContants.ResponseString.ERROR_CODE, 1);
                rsMap.put(GlobalContants.ResponseString.MESSAGE, e.getMessage());
                e.printStackTrace();
            }
        }
        return rsMap;
    }

    @RequestMapping(value = {"update", "update.json"})
    @ResponseBody
    public Map update(MemberAddressDto memberAddress, Map model, HttpServletRequest request, HttpServletResponse response) {
        MemberVo memberVo = findMemberVo(request);
        HashMap<String, Object> rsMap = new HashMap<String, Object>();
        rsMap.put(GlobalContants.ResponseString.STATUS, GlobalContants.ResponseStatus.SUCCESS);
        rsMap.put(GlobalContants.ResponseString.ERROR_CODE, 0);
        try {
            memberAddress.setMember(memberVo.getMember());
            MemberAddressDto res = memberAddressApi.saveOrUpdateAddress(memberAddress);
            res.setMember(null);
            rsMap.put(GlobalContants.ResponseString.DATA, res);

        } catch (Exception e) {
            e.printStackTrace();
            rsMap.put(GlobalContants.ResponseString.STATUS, GlobalContants.ResponseStatus.ERROR);
            rsMap.put(GlobalContants.ResponseString.ERROR_CODE, 1);
            rsMap.put(GlobalContants.ResponseString.MESSAGE, e.getLocalizedMessage());
        }


        return rsMap;
    }


    private MemberVo findMemberVo(HttpServletRequest request) {
        String memberId = (String) request.getSession().getAttribute(GlobalContants.SESSION_MEMBER_ID_ITAIPING);
        String userId = (String) request.getSession().getAttribute(GlobalContants.SESSION_USER_ID_ITAIPING);

        /** 优先使用memberID获取 */
        MemberVo memberVo = null;
        if (StringUtils.isNotBlank(memberId)) {
            memberVo = memberApi.getMemberInfo(memberId);
        } else if (StringUtils.isNotBlank(userId)) {
            memberVo = memberApi.getMemberInfoByUserId(userId);
        }

        return memberVo;
    }

    @MotanReferer
    MemberAddressApi memberAddressApi;

    @MotanReferer
    MemberApi memberApi;

    @MotanReferer
    AddressCommonApi addressCommonApi;
}
