package ctscore.web.controller.member;

import cms.api.OrganizationApi;
import cms.api.dto.OrganizationDto;
import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import ctscore.web.service.member.MemberBatchService;
import ctscore.web.service.member.MemberLoginService;
import ctscore.web.vo.AdminScoreIncomeExpenseDetailVo;
import ctscore.web.vo.AdminScoreOverViewVo;
import lombok.extern.slf4j.Slf4j;
import member.api.CoreUserApi;
import member.api.MemberApi;
import member.api.MemberCreditsTranApi;
import member.api.dto.core.CoreUserDto;
import member.api.dto.shop.MemberCreditsTranDto;
import member.api.dto.shop.MemberDto;
import member.api.vo.MemberCredisCheckVo;
import org.apache.poi.hssf.usermodel.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.*;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import score.api.ScoreApi;
import score.api.definition.ScoreBusinessType;
import score.api.dto.entitydto.ScoreAccountDTO;
import score.api.dto.entitydto.ScoreIncomeExpenseDetailDTO;
import score.api.dto.requestdto.ScoreAccountRequestDTO;
import score.api.dto.requestdto.ScoreDetailQueryDTO;
import score.api.dto.requestdto.ScoreStatisticsRequestDTO;
import score.api.dto.responsedto.PageResponseDTO;
import score.api.dto.responsedto.ScoreStatisticsResponseDTO;
import utils.GlobalContants;
import utils.Lang;
import utils.date.DateUtils;
import utils.excel.ExcelUtil;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.text.Collator;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * Created by DixonLim on 2016/12/1.
 */

@Slf4j
@Controller
@RequestMapping("memberCreditsCheck")
public class MemberCreditsCheckController {

    @MotanReferer(basicReferer = "motanClientBasicConfig")
    MemberApi memberApi;

    @MotanReferer(basicReferer = "motanClientBasicConfig")
    CoreUserApi coreUserApi;

    @MotanReferer(basicReferer = "motanClientBasicConfig")
    MemberCreditsTranApi memberCreditsTranApi;

    @MotanReferer(basicReferer = "motanClientBasicConfig")
    OrganizationApi organizationApi;

    @Autowired
    MemberBatchService memberBatchService;

    @Autowired
    MemberLoginService memberLoginService;

    @MotanReferer
    ScoreApi scoreApi;

    @Value("${ctscore.organization.code}")
    String organizationCode;

    @RequestMapping(value = {"", "index.do", "index.htm"}, method = RequestMethod.GET)
    public String index(HttpServletRequest request, Model model) {
        return "member/manager/adOperaCheckScoreView";
    }

    /**
     * 列表查询
     *//*
    @ResponseBody
    @RequestMapping(value = "list", method = RequestMethod.POST)
    public Map list(String username, String phone, String email, Pageable pageable, HttpServletRequest request) {
        long methodStartTIme = System.currentTimeMillis();
        log.info("积分概览查询开始...");
        Map returnMap = new HashMap(5);

        long getOrganizationInfoTime = System.currentTimeMillis();
        String organizationId = organizationApi.findOrganizationIdByOrgCode(organizationCode);
        String organizationName = organizationApi.findOrganizationNameByOrgCode(organizationCode);
        log.info("获取机构信息耗时 {} 秒", (System.currentTimeMillis() - getOrganizationInfoTime) / 1000F);

        List<MemberDto> members = null;
        List<CoreUserDto> coreUsers = null;
        long totalElements;

        // 查询条件处理
        if (!Lang.isEmpty(username) || !Lang.isEmpty(phone) || !Lang.isEmpty(email)) {
            if (!Lang.isEmpty(username)) {
                MemberDto memberExample = new MemberDto();
                memberExample.setRealName(username);
                CoreUserDto coreUserExample = new CoreUserDto();
                coreUserExample.setUserType(CoreUserDto.USER_TYPE_MEMBER);
                coreUserExample.setOrganizationId(organizationId);
                coreUserExample.setErrCount(null);
                coreUserExample.setLoginCount(null);
                if (!Lang.isEmpty(phone)) {
                    coreUserExample.setPhone(phone);
                }
                if (!Lang.isEmpty(email)) {
                    coreUserExample.setPhone(email);
                }
                memberExample.setCoreUser(coreUserExample);
                long getMembersTime = System.currentTimeMillis();
                Page<MemberDto> memberPage = memberApi.findMemberByExample(memberExample, pageable);
                log.info("查询条件筛选-查询 member {} 条数据, 耗时 {} 秒", memberPage.getContent().size(), (System.currentTimeMillis() - getMembersTime) / 1000F);
                totalElements = memberPage.getTotalElements();
                members = memberPage.getContent();
            } else {
                CoreUserSerachVo coreUserSerach = new CoreUserSerachVo();
                coreUserSerach.setPhone(phone);
                coreUserSerach.setEmail(email);
                coreUserSerach.setUserType(CoreUserDto.USER_TYPE_MEMBER);
                coreUserSerach.setOrganizationId(organizationId);
                coreUserSerach.setFuzzySearch(true);
                long getCoreUserTime = System.currentTimeMillis();
                Page<CoreUserDto> coreUserPage = coreUserApi.findCoreUser(coreUserSerach, pageable);
                log.info("查询条件筛选-查询 coreUser {} 条数据, 耗时 {} 秒", coreUserPage.getContent().size(), (System.currentTimeMillis() - getCoreUserTime) / 1000F);
                totalElements = coreUserPage.getTotalElements();
                coreUsers = coreUserPage.getContent();
            }
        } else {
            // 查询机构下所有成员
            CoreUserSerachVo coreUserSerach = new CoreUserSerachVo();
            coreUserSerach.setUserType(CoreUserDto.USER_TYPE_MEMBER);
            coreUserSerach.setOrganizationId(organizationId);
            long getCoreUserTime = System.currentTimeMillis();
            Page<CoreUserDto> coreUserPage = coreUserApi.findCoreUser(coreUserSerach, pageable);
            log.info("查询条件筛选(默认机构下所有成员)-查询 coreUser {} 条数据, 耗时 {} 秒, ", coreUserPage.getContent().size(), (System.currentTimeMillis() - getCoreUserTime) / 1000F);
            totalElements = coreUserPage.getTotalElements();
            coreUsers = coreUserPage.getContent();
        }

        // 批量获取 member
        Map<String, MemberDto> memberDTOMap = new HashMap<>(1);
        List<String> coreUserIds = new ArrayList<>();
        if (!Lang.isEmpty(coreUsers)) {
            coreUsers.forEach(coreUserDto -> {
                if (!Lang.isEmpty(coreUserDto.getId()) && !coreUserIds.contains(coreUserDto.getId())) {
                    coreUserIds.add(coreUserDto.getId());
                }
            });
        }
        if (!Lang.isEmpty(coreUserIds)) {
            memberDTOMap = memberBatchService.findMembersByCoreUserIds(coreUserIds);
        }

        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        List<AdminScoreOverViewVo> adminScoreOverViewVoList = new ArrayList<>();
        if (!Lang.isEmpty(members)) {
            for (MemberDto member : members) {
                ScoreAccountRequestDTO scoreAccountRequestDTO = new ScoreAccountRequestDTO();
                scoreAccountRequestDTO.setOrganizationCode(organizationCode);
                scoreAccountRequestDTO.setUserId(member.getCoreUser().getId());
                if (!Lang.isEmpty(phone)) {
                    scoreAccountRequestDTO.setPhone(phone);
                }
                if (!Lang.isEmpty(email)) {
                    scoreAccountRequestDTO.setEmail(email);
                }
                ScoreAccountDTO scoreAccountDTO = scoreApi.queryScoreAccount(scoreAccountRequestDTO);
                AdminScoreOverViewVo adminScoreOverViewVo = new AdminScoreOverViewVo();
                adminScoreOverViewVo.setUserName(member.getRealName());
                adminScoreOverViewVo.setEmail(member.getCoreUser().getEmail());
                adminScoreOverViewVo.setPhone(member.getCoreUser().getPhone());
                adminScoreOverViewVo.setIdCard(member.getCoreUser().getIdCard());
                if (!Lang.isEmpty(scoreAccountDTO.getLastUpdated())) {
                    adminScoreOverViewVo.setLastUpdated(dateFormat.format(scoreAccountDTO.getLastUpdated()));
                }
                adminScoreOverViewVo.setOrganizationName(organizationName);
                adminScoreOverViewVo.setScore(scoreAccountDTO.getIncomeScoreVal().subtract(scoreAccountDTO.getExpendedScoreVal()).toString());
                adminScoreOverViewVo.setScoreSpent(scoreAccountDTO.getExpendedScoreVal().toString());
                adminScoreOverViewVo.setMemberId(member.getId());
                adminScoreOverViewVo.setAdmin(member.getAdmin());

                adminScoreOverViewVoList.add(adminScoreOverViewVo);
            }
        } else if (!Lang.isEmpty(coreUsers)) {
            for (CoreUserDto coreUser : coreUsers) {
                //封装积分账号查询参数
                ScoreAccountRequestDTO scoreAccountRequestDTO = new ScoreAccountRequestDTO();
                scoreAccountRequestDTO.setOrganizationCode(organizationCode);
                scoreAccountRequestDTO.setUserId(coreUser.getId());
                if (!Lang.isEmpty(phone)) {
                    scoreAccountRequestDTO.setPhone(phone);
                }
                if (!Lang.isEmpty(email)) {
                    scoreAccountRequestDTO.setEmail(email);
                }
                ScoreAccountDTO scoreAccountDTO = scoreApi.queryScoreAccount(scoreAccountRequestDTO);
                AdminScoreOverViewVo adminScoreOverViewVo = new AdminScoreOverViewVo();
                if(memberDTOMap.containsKey(coreUser.getId())) {
                    MemberDto member = memberDTOMap.get(coreUser.getId());
                    adminScoreOverViewVo.setMemberId(member.getId());
                    adminScoreOverViewVo.setAdmin(member.getAdmin());
                    adminScoreOverViewVo.setUserName(member.getRealName());
                }
                adminScoreOverViewVo.setEmail(coreUser.getEmail());
                adminScoreOverViewVo.setPhone(coreUser.getPhone());
                adminScoreOverViewVo.setIdCard(coreUser.getIdCard());
                if (!Lang.isEmpty(scoreAccountDTO.getLastUpdated())) {
                    adminScoreOverViewVo.setLastUpdated(dateFormat.format(scoreAccountDTO.getLastUpdated()));
                }
                adminScoreOverViewVo.setOrganizationName(organizationName);
                adminScoreOverViewVo.setScore(scoreAccountDTO.getIncomeScoreVal().subtract(scoreAccountDTO.getExpendedScoreVal()).toString());
                adminScoreOverViewVo.setScoreSpent(scoreAccountDTO.getExpendedScoreVal().toString());

                adminScoreOverViewVoList.add(adminScoreOverViewVo);
            }
        }
        Page<AdminScoreOverViewVo> adminScoreOverViewPage = new PageImpl<>(adminScoreOverViewVoList, pageable, totalElements);
        returnMap.put("data", adminScoreOverViewPage);
        returnMap.put("orgName", organizationName);
        returnMap.put("totalPages", adminScoreOverViewPage.getTotalPages());
        returnMap.put(GlobalContants.ResponseString.STATUS, GlobalContants.ResponseStatus.SUCCESS);
        returnMap.put(GlobalContants.ResponseString.MESSAGE, "数据获取成功");
        log.info("积分概览查询完成, 总耗时 {} 秒", (System.currentTimeMillis() - methodStartTIme) / 1000F);
        return returnMap;
    }*/

    /**
     * 列表查询
     */
    @ResponseBody
    @RequestMapping(value = "list", method = RequestMethod.POST)
    public Map list(String username, String phone, String email, Pageable pageable, HttpServletRequest request) {
        long methodStartTIme = System.currentTimeMillis();
        log.info("积分概览查询开始...");
        Map returnMap = new HashMap(5);

        long getOrganizationInfoTime = System.currentTimeMillis();
        String organizationId = organizationApi.findOrganizationIdByOrgCode(organizationCode);
        String organizationName = organizationApi.findOrganizationNameByOrgCode(organizationCode);
        log.info("获取机构信息耗时 {} 秒", (System.currentTimeMillis() - getOrganizationInfoTime) / 1000F);

        Map<String, MemberDto> memberDTOMap;
        MemberDto memberDTO = new MemberDto();
        if (!Lang.isEmpty(username)) {
            memberDTO.setRealName(username);
        }
        CoreUserDto coreUserDTO = new CoreUserDto();
        coreUserDTO.setUserType(CoreUserDto.USER_TYPE_MEMBER);
        coreUserDTO.setOrganizationId(organizationId);
        if (!Lang.isEmpty(phone)) {
            coreUserDTO.setPhone(phone);
        }
        if (!Lang.isEmpty(email)) {
            coreUserDTO.setEmail(email);
        }
        memberDTO.setCoreUser(coreUserDTO);

        pageable = new PageRequest(pageable.getPageNumber(), pageable.getPageSize(), new Sort(Sort.Direction.DESC, "coreUser.username"));
        List<String> coreUserIdSort = new ArrayList<>();
        memberDTOMap = memberBatchService.findMember(memberDTO, pageable, coreUserIdSort);

        List<ScoreAccountDTO> scoreAccountDTOs = memberBatchService.queryScoreAccount(organizationCode, memberDTOMap);

        // 封装展示数据
        // 按照顺序
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        List<AdminScoreOverViewVo> adminScoreOverViewVoList = new ArrayList<>();
        coreUserIdSort.forEach(coreUserId -> {
            List<ScoreAccountDTO> scoreAccountDTOList = scoreAccountDTOs.stream().filter(scoreAccountDTO -> coreUserId.equals(scoreAccountDTO.getUserId())).collect(Collectors.toList());
            if(scoreAccountDTOList.size() == 1) {
                ScoreAccountDTO scoreAccountDTO = scoreAccountDTOList.get(0);
                AdminScoreOverViewVo adminScoreOverViewVo = new AdminScoreOverViewVo();
                if(!Lang.isEmpty(scoreAccountDTO.getUserId()) && memberDTOMap.containsKey(scoreAccountDTO.getUserId())) {
                    MemberDto member = memberDTOMap.get(scoreAccountDTO.getUserId());
                    adminScoreOverViewVo.setUserName(member.getRealName());
                    adminScoreOverViewVo.setEmail(member.getCoreUser().getEmail());
                    adminScoreOverViewVo.setPhone(member.getCoreUser().getPhone());
                    adminScoreOverViewVo.setIdCard(member.getCoreUser().getIdCard());
                    adminScoreOverViewVo.setMemberId(member.getId());
                    adminScoreOverViewVo.setAdmin(member.getAdmin());
                }
                if (!Lang.isEmpty(scoreAccountDTO.getLastUpdated())) {
                    adminScoreOverViewVo.setLastUpdated(dateFormat.format(scoreAccountDTO.getLastUpdated()));
                }
                adminScoreOverViewVo.setOrganizationName(organizationName);
                adminScoreOverViewVo.setScore(scoreAccountDTO.getIncomeScoreVal().subtract(scoreAccountDTO.getExpendedScoreVal()).toString());
                adminScoreOverViewVo.setScoreSpent(scoreAccountDTO.getExpendedScoreVal().toString());
                adminScoreOverViewVoList.add(adminScoreOverViewVo);
            }
        });

        Page<AdminScoreOverViewVo> adminScoreOverViewPage = new PageImpl<>(adminScoreOverViewVoList, pageable, memberBatchService.getMemberCount(memberDTO));
        returnMap.put("data", adminScoreOverViewPage);
        returnMap.put("orgName", organizationName);
        returnMap.put("totalPages", adminScoreOverViewPage.getTotalPages());
        returnMap.put(GlobalContants.ResponseString.STATUS, GlobalContants.ResponseStatus.SUCCESS);
        returnMap.put(GlobalContants.ResponseString.MESSAGE, "数据获取成功");
        log.info("积分概览查询完成, 总耗时 {} 秒", (System.currentTimeMillis() - methodStartTIme) / 1000F);
        return returnMap;
    }

    /**
     * 列表查询
     */
    @ResponseBody
    @RequestMapping(value = "listExport")
    public void listExport(String username, String phone, String email, HttpServletResponse response) {
        long methodStartTime = System.currentTimeMillis();
        log.info("积分概览导出开始...");

        long getOrganizationInfoTime = System.currentTimeMillis();
        String organizationId = organizationApi.findOrganizationIdByOrgCode(organizationCode);
        String organizationName = organizationApi.findOrganizationNameByOrgCode(organizationCode);
        log.info("获取机构信息耗时 {} 秒", (System.currentTimeMillis() - getOrganizationInfoTime) / 1000F);

        Map<String, MemberDto> memberDTOMap;
        MemberDto memberDTO = new MemberDto();
        if (!Lang.isEmpty(username)) {
            memberDTO.setRealName(username);
        }
        CoreUserDto coreUserDTO = new CoreUserDto();
        coreUserDTO.setUserType(CoreUserDto.USER_TYPE_MEMBER);
        coreUserDTO.setOrganizationId(organizationId);
        if (!Lang.isEmpty(phone)) {
            coreUserDTO.setPhone(phone);
        }
        if (!Lang.isEmpty(email)) {
            coreUserDTO.setEmail(email);
        }
        memberDTO.setCoreUser(coreUserDTO);

        // 多线程下保持原始查询顺序
        List<String> coreUserIdSort = new ArrayList<>();

        /*long countTime = System.currentTimeMillis();
        int total = memberBatchService.getMemberCount(memberDTO);
        log.info("查询总数量耗时 {} ms", System.currentTimeMillis() - countTime);*/

        //memberDTOMap = memberBatchService.findMember(memberDTO, new PageRequest(0, total, new Sort(Sort.Direction.DESC, "coreUser.username")), coreUserIdSort);

        // 多线程查询
        memberDTOMap = memberBatchService.findMember(memberDTO, new Sort(Sort.Direction.DESC, "coreUser.username"), coreUserIdSort);

        List<ScoreAccountDTO> scoreAccountDTOs = memberBatchService.queryScoreAccount(organizationCode, memberDTOMap);

        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        List<List<String>> rows = new ArrayList<>();
        List<String> header = new ArrayList<>();
        header.add("姓名");
        header.add("公司");
        header.add("手机号");
        header.add("邮箱");
        header.add("身份证");
        header.add("变动时间");
        header.add("可用积分 (Ct)");
        header.add("消费积分 (Ct)");
        rows.add(header);

        // 按照顺序
        coreUserIdSort.forEach(coreUserId -> {
            List<ScoreAccountDTO> scoreAccountDTOList = scoreAccountDTOs.stream().filter(scoreAccountDTO -> coreUserId.equals(scoreAccountDTO.getUserId())).collect(Collectors.toList());
            if(scoreAccountDTOList.size() == 1) {
                ScoreAccountDTO scoreAccountDTO = scoreAccountDTOList.get(0);
                if(!Lang.isEmpty(scoreAccountDTO.getUserId())) {
                    List<String> row = new ArrayList<>();
                    String memberRealName = "";
                    String coreUserPhone = "";
                    String coreUserEmail = "";
                    String coreUserIdCard = "";
                    if(!Lang.isEmpty(scoreAccountDTO.getUserId()) && memberDTOMap.containsKey(scoreAccountDTO.getUserId())) {
                        MemberDto member = memberDTOMap.get(scoreAccountDTO.getUserId());
                        memberRealName = member.getRealName();
                        coreUserEmail = member.getCoreUser().getEmail();
                        coreUserPhone = member.getCoreUser().getPhone();
                        coreUserIdCard = member.getCoreUser().getIdCard();
                    }
                    String rowLastUpdated = "";
                    if (!Lang.isEmpty(scoreAccountDTO.getLastUpdated())) {
                        rowLastUpdated = dateFormat.format(scoreAccountDTO.getLastUpdated());
                    }
                    row.add(memberRealName);
                    row.add(organizationName);
                    row.add(coreUserPhone);
                    row.add(coreUserEmail);
                    row.add(coreUserIdCard);
                    row.add(rowLastUpdated);
                    row.add(scoreAccountDTO.getIncomeScoreVal().subtract(scoreAccountDTO.getExpendedScoreVal()).toString());
                    row.add(scoreAccountDTO.getExpendedScoreVal().toString());
                    rows.add(row);
                }
            }
        });
        /*scoreAccountDTOs.forEach(scoreAccountDTO -> {
            List<String> row = new ArrayList<>();
            String memberRealName = "";
            String coreUserPhone = "";
            String coreUserEmail = "";
            String coreUserIdCard = "";
            if(!Lang.isEmpty(scoreAccountDTO.getUserId()) && memberDTOMap.containsKey(scoreAccountDTO.getUserId())) {
                MemberDto member = memberDTOMap.get(scoreAccountDTO.getUserId());
                memberRealName = member.getRealName();
                coreUserEmail = member.getCoreUser().getEmail();
                coreUserPhone = member.getCoreUser().getPhone();
                coreUserIdCard = member.getCoreUser().getIdCard();
            }
            String rowLastUpdated = "";
            if (!Lang.isEmpty(scoreAccountDTO.getLastUpdated())) {
                rowLastUpdated = dateFormat.format(scoreAccountDTO.getLastUpdated());
            }
            row.add(memberRealName);
            row.add(organizationName);
            row.add(coreUserPhone);
            row.add(coreUserEmail);
            row.add(coreUserIdCard);
            row.add(rowLastUpdated);
            row.add(scoreAccountDTO.getIncomeScoreVal().subtract(scoreAccountDTO.getExpendedScoreVal()).toString());
            row.add(scoreAccountDTO.getExpendedScoreVal().toString());
            rows.add(row);
        });*/

        try {
            response.setHeader("Content-disposition", "attachment; filename=" + "Member" + ".xls");
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream out = response.getOutputStream();
            ExcelUtil.createHSSFWorkBook(rows, "Member").write(out);
            out.flush();
            out.close();
        } catch (Exception e) {
            e.printStackTrace();
        }

        log.info("积分概览导出完成, 共 {} 条数据, 耗时 {} 秒", rows.size() - 1, (System.currentTimeMillis() - methodStartTime) / 1000F);
    }

    /**
     * 列表查询
     */
    /*@ResponseBody
    @RequestMapping(value = "listExport", method = RequestMethod.GET)
    public void listExport(String username, String phone, String email, HttpServletResponse response) {
        long methodStartTime = System.currentTimeMillis();
        log.info("积分概览导出开始...");

        long getOrganizationInfoTime = System.currentTimeMillis();
        String organizationId = organizationApi.findOrganizationIdByOrgCode(organizationCode);
        String organizationName = organizationApi.findOrganizationNameByOrgCode(organizationCode);
        log.info("获取机构信息耗时 {} 秒", (System.currentTimeMillis() - getOrganizationInfoTime) / 1000F);

        int page = 0;
        int pageSize = 200;
        int totalPage;
        long totalElements;

        List<MemberDto> members = new ArrayList<>();
        List<CoreUserDto> coreUsers = new ArrayList<>();

        long queryFilterTime = System.currentTimeMillis();
        do {
            Pageable pageable = new PageRequest(page, pageSize);
            if (!Lang.isEmpty(username) || !Lang.isEmpty(phone) || !Lang.isEmpty(email)) {
                if (!Lang.isEmpty(username)) {
                    MemberDto memberExample = new MemberDto();
                    memberExample.setRealName(username);
                    CoreUserDto coreUserExample = new CoreUserDto();
                    coreUserExample.setUserType(CoreUserDto.USER_TYPE_MEMBER);
                    coreUserExample.setOrganizationId(organizationId);
                    coreUserExample.setErrCount(null);
                    coreUserExample.setLoginCount(null);
                    if (!Lang.isEmpty(phone)) {
                        coreUserExample.setPhone(phone);
                    }
                    if (!Lang.isEmpty(email)) {
                        coreUserExample.setPhone(email);
                    }
                    memberExample.setCoreUser(coreUserExample);
                    Page<MemberDto> memberPage = memberApi.findMemberByExample(memberExample, pageable);
                    totalElements = memberPage.getTotalElements();
                    members.addAll(memberPage.getContent());
                } else {
                    CoreUserSerachVo coreUserSerach = new CoreUserSerachVo();
                    coreUserSerach.setPhone(phone);
                    coreUserSerach.setEmail(email);
                    coreUserSerach.setUserType(CoreUserDto.USER_TYPE_MEMBER);
                    coreUserSerach.setOrganizationId(organizationId);
                    coreUserSerach.setFuzzySearch(true);
                    Page<CoreUserDto> coreUserPage = coreUserApi.findCoreUser(coreUserSerach, pageable);
                    totalElements = coreUserPage.getTotalElements();
                    coreUsers.addAll(coreUserPage.getContent());
                }
            } else {
                CoreUserSerachVo coreUserSerach = new CoreUserSerachVo();
                coreUserSerach.setUserType(CoreUserDto.USER_TYPE_MEMBER);
                coreUserSerach.setOrganizationId(organizationId);
                Page<CoreUserDto> coreUserPage = coreUserApi.findCoreUser(coreUserSerach, pageable);
                totalElements = coreUserPage.getTotalElements();
                coreUsers.addAll(coreUserPage.getContent());
            }

            totalPage = (int) totalElements % pageSize == 0 ? (int) totalElements / pageSize : (int) totalElements / pageSize + 1;
            page++;
        } while (page < totalPage);

        Map<String, String> mmp = new HashMap<>();
        coreUsers.forEach(coreUserDto -> mmp.put(coreUserDto.getId(), null));
        log.info("mmp size = {}", mmp.size());

        log.info("导出用户过滤耗时 {} 秒", (System.currentTimeMillis() - queryFilterTime) / 1000F);

        // 批量获取 member
        Map<String, MemberDto> memberDTOMap = new HashMap<>(1);
        List<String> coreUserIds = new ArrayList<>();
        if (!Lang.isEmpty(coreUsers)) {
            coreUsers.forEach(coreUserDto -> {
                if (!Lang.isEmpty(coreUserDto.getId()) && !coreUserIds.contains(coreUserDto.getId())) {
                    coreUserIds.add(coreUserDto.getId());
                }
            });
        }
        if (!Lang.isEmpty(coreUserIds)) {
            memberDTOMap = memberBatchService.findMembersByCoreUserIds(coreUserIds);
        }

        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        List<List<String>> rows = new ArrayList<>();
        List<String> header = new ArrayList<>();
        header.add("姓名");
        header.add("公司");
        header.add("手机号");
        header.add("邮箱");
        header.add("身份证");
        header.add("变动时间");
        header.add("可用积分 (Ct)");
        header.add("消费积分 (Ct)");
        rows.add(header);

        long queryScoreAccountTime = System.currentTimeMillis();
        if (!Lang.isEmpty(members)) {
            for (MemberDto member : members) {
                //封装积分账号查询参数
                ScoreAccountRequestDTO scoreAccountRequestDTO = new ScoreAccountRequestDTO();
                scoreAccountRequestDTO.setOrganizationCode(organizationCode);
                scoreAccountRequestDTO.setUserId(member.getCoreUser().getId());
                if (!Lang.isEmpty(phone)) {
                    scoreAccountRequestDTO.setPhone(phone);
                }
                if (!Lang.isEmpty(email)) {
                    scoreAccountRequestDTO.setEmail(email);
                }
                ScoreAccountDTO scoreAccountDTO = scoreApi.queryScoreAccount(scoreAccountRequestDTO);

                List<String> row = new ArrayList<>();
                String rowLastUpdated = "";
                if (!Lang.isEmpty(scoreAccountDTO.getLastUpdated())) {
                    rowLastUpdated = dateFormat.format(scoreAccountDTO.getLastUpdated());
                }
                row.add(member.getRealName());
                row.add(organizationName);
                row.add(member.getCoreUser().getPhone());
                row.add(member.getCoreUser().getEmail());
                row.add(member.getCoreUser().getIdCard());
                row.add(rowLastUpdated);
                row.add(scoreAccountDTO.getIncomeScoreVal().subtract(scoreAccountDTO.getExpendedScoreVal()).toString());
                row.add(scoreAccountDTO.getExpendedScoreVal().toString());
                rows.add(row);
            }
        } else if (!Lang.isEmpty(coreUsers)) {
            for (CoreUserDto coreUser : coreUsers) {
                //封装积分账号查询参数
                ScoreAccountRequestDTO scoreAccountRequestDTO = new ScoreAccountRequestDTO();
                scoreAccountRequestDTO.setOrganizationCode(organizationCode);
                scoreAccountRequestDTO.setUserId(coreUser.getId());
                if (!Lang.isEmpty(phone)) {
                    scoreAccountRequestDTO.setPhone(phone);
                }
                if (!Lang.isEmpty(email)) {
                    scoreAccountRequestDTO.setEmail(email);
                }
                ScoreAccountDTO scoreAccountDTO = scoreApi.queryScoreAccount(scoreAccountRequestDTO);

                List<String> row = new ArrayList<>();
                String rowUserName = "";
                String rowLastUpdated = "";

                if(memberDTOMap.containsKey(coreUser.getId())) {
                    MemberDto member = memberDTOMap.get(coreUser.getId());
                    rowUserName = member.getRealName();
                }

                if (!Lang.isEmpty(scoreAccountDTO.getLastUpdated())) {
                    rowLastUpdated = dateFormat.format(scoreAccountDTO.getLastUpdated());
                }
                row.add(rowUserName);
                row.add(organizationName);
                row.add(coreUser.getPhone());
                row.add(coreUser.getEmail());
                row.add(coreUser.getIdCard());
                row.add(rowLastUpdated);
                row.add(scoreAccountDTO.getIncomeScoreVal().subtract(scoreAccountDTO.getExpendedScoreVal()).toString());
                row.add(scoreAccountDTO.getExpendedScoreVal().toString());
                rows.add(row);
            }
        }
        log.info("查询积分账户数据耗时 {} 秒", (System.currentTimeMillis() - queryScoreAccountTime) / 1000F);

        try {
            response.setHeader("Content-disposition", "attachment; filename=" + "Member" + ".xls");
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream out = response.getOutputStream();
            ExcelUtil.createHSSFWorkBook(rows, "Member").write(out);
            out.flush();
            out.close();
        } catch (Exception e) {
            e.printStackTrace();
        }

        log.info("积分概览导出完成, 共 {} 条数据, 耗时 {} 秒", rows.size() - 1, (System.currentTimeMillis() - methodStartTime) / 1000F);
    }*/

    @RequestMapping(value = "exportMember.do")

    @ResponseBody
    public void exportMember(String username, String phone, String email, HttpServletResponse response, HttpServletRequest request) {
        Pageable pageable = null;
        Object memberJson = request.getSession().getAttribute(GlobalContants.SESSION_MEMBER_JSON_ITAIPING);
        MemberDto theMember = JSON.parseObject(memberJson.toString(), MemberDto.class);
        Object userId = request.getSession().getAttribute(GlobalContants.SESSION_USER_ID_ITAIPING);
        String id = userId.toString();
        CoreUserDto coreUserSession = memberLoginService.findById(id);//获取当前用户信息
        OrganizationDto organization = organizationApi.findOrganizationById(coreUserSession.getOrganizationId());

        CoreUserDto coreUserExp = new CoreUserDto(CoreUserDto.USER_TYPE_MEMBER, organization.getId());
        if (!Lang.isEmpty(username)) {
            coreUserExp.setUsername(username.trim());
        }

        if (!Lang.isEmpty(phone)) {
            coreUserExp.setPhone(phone.trim());
        }
        if (!Lang.isEmpty(email)) {
            coreUserExp.setEmail(email.trim());
        }
        coreUserExp.setErrCount(null);
        coreUserExp.setLoginCount(null);
        coreUserExp.setDisabled(null);
        List<CoreUserDto> coreUsers = coreUserApi.findByExample(coreUserExp);
        List<MemberDto> members = memberApi.findByUsers(coreUsers);

//        List<CoreUser> coreUsers = coreUserApi.findByUsernameAndPhoneAndEmail(username,phone,email);
//        Page<Member> memberPage = memberApi.findMemberByOrganizationIdAndCoreUsers(theMember.getCoreUser().getOrganizationId(),coreUsers,pageable);
//        List<Member> members = memberPage.getContent();
        List<MemberCredisCheckVo> memberCredisCheckVos = new ArrayList<>();
        for (int i = 0; i < members.size(); i++) {
            MemberDto member = members.get(i);
            CoreUserDto coreUser = member.getCoreUser();
            MemberCredisCheckVo memberCredisCheckVo = new MemberCredisCheckVo();
            memberCredisCheckVo.setName(coreUser.getUsername());
            memberCredisCheckVo.setCompanyName("诚通人力资源有限公司");
            memberCredisCheckVo.setPhone(coreUser.getPhone());
            memberCredisCheckVo.setEmail(coreUser.getEmail());
            memberCredisCheckVo.setChangeTime(DateUtils.dateToStrLong(coreUser.getLastUpdated()));
            memberCredisCheckVo.setScore(member.getScore().toString());
            memberCredisCheckVos.add(memberCredisCheckVo);
        }
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet();
        wb.setSheetName(0, "Member");
        setContentColumnWidth(sheet);
        HSSFCellStyle cellStyle = setContentCellStyle(wb);
        createCellHead(sheet.createRow(0), cellStyle, sheet.createRow(0).createCell(0));
        createCellContent(memberCredisCheckVos, cellStyle, sheet);
        // 将文件存到指定位置
        try {
            response.setHeader("Content-disposition", "attachment; filename=" + "Member" + ".xls");
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream out = response.getOutputStream();
            wb.write(out);
            out.flush();
            out.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value = "getMember.do", method = RequestMethod.POST)

    @ResponseBody
    public Map getMember(String username, String phone, String email, Pageable pageable, HttpServletRequest request) {
        Map returnMap = new HashMap();
        Object memberJson = request.getSession().getAttribute(GlobalContants.SESSION_MEMBER_JSON_ITAIPING);
        MemberDto member = JSON.parseObject(memberJson.toString(), MemberDto.class);
        Object userId = request.getSession().getAttribute(GlobalContants.SESSION_USER_ID_ITAIPING);
        String id = userId.toString();
        CoreUserDto coreUser = memberLoginService.findById(id);//获取当前用户信息
        OrganizationDto organization = organizationApi.findOrganizationById(coreUser.getOrganizationId());

        CoreUserDto coreUserExp = new CoreUserDto(CoreUserDto.USER_TYPE_MEMBER, organization.getId());
        if (!Lang.isEmpty(username)) {
            coreUserExp.setUsername(username.trim());
        }

        if (!Lang.isEmpty(phone)) {
            coreUserExp.setPhone(phone.trim());
        }
        if (!Lang.isEmpty(email)) {
            coreUserExp.setEmail(email.trim());
        }
        coreUserExp.setErrCount(null);
        coreUserExp.setLoginCount(null);
        coreUserExp.setDisabled(null);

        Page<CoreUserDto> coreUsers = coreUserApi.findByExample(coreUserExp, pageable);
        List<MemberDto> members = memberApi.findByUsers(coreUsers.getContent());
        Page<MemberDto> memberPage = new PageImpl<MemberDto>(members, pageable, coreUsers.getTotalElements());

//        List<CoreUser> coreUsers = coreUserApi.findByUsernameAndPhoneAndEmail(username,phone,email);
//        Page<Member> memberPage = memberApi.findMemberByOrganizationIdAndCoreUsers(member.getCoreUser().getOrganizationId(),coreUsers,pageable);
        returnMap.put("data", memberPage);
        returnMap.put("orgName", organization.getOrgName());
        returnMap.put("totalPages", getTotalPages((int) memberPage.getTotalElements(), pageable.getPageSize()));
        returnMap.put(GlobalContants.ResponseString.STATUS, GlobalContants.ResponseStatus.SUCCESS);
        returnMap.put(GlobalContants.ResponseString.MESSAGE, "数据获取成功");
        return returnMap;
    }

    @RequestMapping(value = "memberDetail.do", method = RequestMethod.GET)
    public String memberDetail(String memberId, Model model) {
        /*Member member = memberApi.findMemberById(memberId);

        CoreUser coreUser = member.getCoreUser();
        Organization organization = organizationApi.findOrganizationById(member.getCoreUser().getOrganizationId());
        Integer scoreAward = memberCreditsTranApi.findScoreAwardByMemberId(member.getId());
        Integer scoreGive = memberCreditsTranApi.findScoreGiveByMemberId(member.getId());
        Integer scoreGet = memberCreditsTranApi.findScoreGetByMemberId(member.getId());
        Integer scoreConsume = memberCreditsTranApi.findScoreConsumeByMemberId(member.getId());
        String sa;
        String sgi;
        String sge;
        String sc;
        if(scoreAward == null){
            sa = "0";
        }else {
            sa = scoreAward.toString();
        }
        if(scoreGive == null){
            sgi = "0";
        }else {
            sgi = scoreGive.toString();
        }
        if(scoreGet == null){
            sge = "0";
        }else {
            sge = scoreGet.toString();
        }
        if(scoreConsume == null){
            sc = "0";
        }else {
            sc = scoreConsume.toString();
        }
        model.addAttribute("member",member);
        model.addAttribute("coreUser",coreUser);
        model.addAttribute("organization",organization);
        model.addAttribute("awardScore",sa);
        model.addAttribute("scoreGive",sgi);
        model.addAttribute("scoreGet",sge);
        model.addAttribute("scoreConsume",sc);*/

        MemberDto member = memberApi.findMemberById(memberId);
        CoreUserDto coreUser = member.getCoreUser();
        OrganizationDto organization = organizationApi.findOrganizationById(member.getCoreUser().getOrganizationId());

        ScoreAccountRequestDTO scoreAccountRequestDTO = new ScoreAccountRequestDTO();
        scoreAccountRequestDTO.setOrganizationCode(organizationCode);
        scoreAccountRequestDTO.setUserId(coreUser.getId());
        ScoreAccountDTO scoreAccountDTO = scoreApi.queryScoreAccount(scoreAccountRequestDTO);

        AdminScoreOverViewVo adminScoreOverViewVo = new AdminScoreOverViewVo();
        adminScoreOverViewVo.setMemberId(memberId);
        adminScoreOverViewVo.setUserName(member.getRealName());
        adminScoreOverViewVo.setPhone(coreUser.getPhone());
        adminScoreOverViewVo.setEmail(coreUser.getEmail());
        adminScoreOverViewVo.setOrganizationName(organization.getOrgName());
        adminScoreOverViewVo.setScore(scoreAccountDTO.getIncomeScoreVal().subtract(scoreAccountDTO.getExpendedScoreVal()).toString());
        adminScoreOverViewVo.setScoreSpent(scoreAccountDTO.getExpendedScoreVal().toString());
        adminScoreOverViewVo.setScoreGetAll(scoreAccountDTO.getIncomeScoreVal().toString());

        //授予
        ScoreStatisticsRequestDTO scoreStatisticsRequestDTO = new ScoreStatisticsRequestDTO();
        scoreStatisticsRequestDTO.setBusiCode(ScoreBusinessType.BUSI_INCOME_AWARD.getBusinessCode());
        scoreStatisticsRequestDTO.setOrganizationCode(scoreAccountRequestDTO.getOrganizationCode());
        scoreStatisticsRequestDTO.setScoreAccountId(scoreAccountDTO.getId());
        ScoreStatisticsResponseDTO scoreStatisticsResponseDTO = scoreApi.scoreIncomeStatics(scoreStatisticsRequestDTO);
        adminScoreOverViewVo.setScoreGrant(scoreStatisticsResponseDTO.getScoreVal().toString());

        //赠送
        scoreStatisticsRequestDTO.setBusiCode(ScoreBusinessType.BUSI_EXPENSE_GIVE_AWAY.getBusinessCode());
        scoreStatisticsResponseDTO = scoreApi.scoreExpenseStatics(scoreStatisticsRequestDTO);
        adminScoreOverViewVo.setScoreGiveAll(scoreStatisticsResponseDTO.getScoreVal().toString());

        //积分明细使用
        adminScoreOverViewVo.setMemberId(scoreAccountDTO.getId());

        model.addAttribute("adminScoreOverViewVo", adminScoreOverViewVo);

        return "member/manager/adOperaScoreViewDetail";
    }

    @RequestMapping(value = "detailList", method = RequestMethod.POST)
    @ResponseBody
    public Map detailList(String scoreAccountId, Pageable pageable, HttpServletRequest request) {
        Map returnMap = new HashMap();

        List<String> scoreAccountIdList = new ArrayList<>();
        scoreAccountIdList.add(scoreAccountId);
        ScoreDetailQueryDTO scoreDetailQueryDTO = new ScoreDetailQueryDTO();
        scoreDetailQueryDTO.setPageSize(pageable.getPageSize());
        scoreDetailQueryDTO.setPage(pageable.getPageNumber());
        scoreDetailQueryDTO.setScoreAccountIds(scoreAccountIdList);

        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        List<AdminScoreIncomeExpenseDetailVo> list = new ArrayList<>();
        PageResponseDTO<ScoreIncomeExpenseDetailDTO> scoreIncomeExpenseDetailPage = scoreApi.queryScoreIncomeExpenseDetails(scoreDetailQueryDTO);
        for (ScoreIncomeExpenseDetailDTO scoreIncomeExpenseDetail : scoreIncomeExpenseDetailPage.getContent()) {
            AdminScoreIncomeExpenseDetailVo scoreIncomeExpense = new AdminScoreIncomeExpenseDetailVo();
            scoreIncomeExpense.setBusiSource(scoreIncomeExpenseDetail.getBusiSource());
            scoreIncomeExpense.setMemo(scoreIncomeExpenseDetail.getMemo());
            if (scoreIncomeExpenseDetail.getScoreVal().intValue() > 0) {
                scoreIncomeExpense.setScoreVal("+" + scoreIncomeExpenseDetail.getScoreVal().toString());
            } else {
                scoreIncomeExpense.setScoreVal(scoreIncomeExpenseDetail.getScoreVal().toString());
            }
            if(!Lang.isEmpty(scoreIncomeExpenseDetail.getTransaTime())) {
                scoreIncomeExpense.setTransaTime(dateFormat.format(scoreIncomeExpenseDetail.getTransaTime()));
            }
            list.add(scoreIncomeExpense);
        }
        Page<AdminScoreIncomeExpenseDetailVo> page = new PageImpl<>(list, pageable, list.size());
        returnMap.put("data", page);
        returnMap.put("totalPages", scoreIncomeExpenseDetailPage.getTotalPages());
        returnMap.put(GlobalContants.ResponseString.STATUS, GlobalContants.ResponseStatus.SUCCESS);
        returnMap.put(GlobalContants.ResponseString.MESSAGE, "数据获取成功");
        return returnMap;
    }

    @RequestMapping(value = "getMemberCreditsTrans.do", method = RequestMethod.POST)
    @ResponseBody
    public Map getMemberCreditsTrans(String memberId, Pageable pageable, HttpServletRequest request) {
        Map returnMap = new HashMap();
//        Object loginMemberSession = request.getSession().getAttribute(MemberLoginInterceptor.LOGIN_USER_SESSION);
//        MemberVo memberVo    = (MemberVo) loginMemberSession;
//        Member member = memberVo.getMember();
//        Organization organization = organizationApi.findOrganizationById(member.getOrganizationId());
//        List<CoreUser> coreUsers = coreUserApi.findByUsernameAndPhoneAndEmail(username,phone,email);
        Page<MemberCreditsTranDto> memberCreditsTranPage = memberCreditsTranApi.findByMemberIdSendAndTarget(pageable, memberId);
        returnMap.put("data", memberCreditsTranPage);
//        returnMap.put("orgName",organization.getOrgName());
        returnMap.put("totalPages", getTotalPages((int) memberCreditsTranPage.getTotalElements(), pageable.getPageSize()));
        returnMap.put(GlobalContants.ResponseString.STATUS, GlobalContants.ResponseStatus.SUCCESS);
        returnMap.put(GlobalContants.ResponseString.MESSAGE, "数据获取成功");
        return returnMap;
    }

    public int getTotalPages(int total, int size) {
        int totalpage = (total + size - 1) / size;
        return totalpage;
    }

    /**
     * 创建表头
     *
     * @param row
     * @param cellStyle
     * @param cell
     */
    private void createCellHead(HSSFRow row, HSSFCellStyle cellStyle, HSSFCell cell) {
        cell.setCellValue("姓名");
        cell.setCellStyle(cellStyle);
        cell = row.createCell(1);
        cell.setCellValue("公司名");
        cell.setCellStyle(cellStyle);
        cell = row.createCell(2);
        cell.setCellValue("手机");
        cell.setCellStyle(cellStyle);
        cell = row.createCell(3);
        cell.setCellValue("邮箱");
        cell.setCellStyle(cellStyle);
        cell = row.createCell(4);
        cell.setCellValue("变动时间");
        cell.setCellStyle(cellStyle);
        cell = row.createCell(5);
        cell.setCellValue("现有积分");
        cell.setCellStyle(cellStyle);
    }

    /**
     * 创建表内容
     *
     * @param importVos
     * @param cellStyle
     * @param sheet
     */
    private void createCellContent(List<MemberCredisCheckVo> importVos, HSSFCellStyle cellStyle, HSSFSheet sheet) {
        for (int i = 0; i < importVos.size(); i++) {
            int rowCount = i + 1;
            HSSFRow row = sheet.createRow(rowCount);
            MemberCredisCheckVo credisCheckVo = importVos.get(i);
            HSSFCell theCell = row.createCell(0);
            theCell.setCellStyle(cellStyle);
            theCell.setCellValue(setContentCellValue(credisCheckVo.getName()));
            theCell = row.createCell(1);
            theCell.setCellStyle(cellStyle);
            theCell.setCellValue(setContentCellValue(credisCheckVo.getCompanyName()));
            theCell = row.createCell(2);
            theCell.setCellStyle(cellStyle);
            theCell.setCellValue(setContentCellValue(credisCheckVo.getPhone()));
            theCell = row.createCell(3);
            theCell.setCellStyle(cellStyle);
            theCell.setCellValue(setContentCellValue(credisCheckVo.getEmail()));
            theCell = row.createCell(4);
            theCell.setCellStyle(cellStyle);
            theCell.setCellValue(setContentCellValue(credisCheckVo.getChangeTime()));
            theCell = row.createCell(5);
            theCell.setCellStyle(cellStyle);
            theCell.setCellValue(setContentCellValue(credisCheckVo.getScore()));
        }
    }

    /**
     * 设置单元格宽度
     *
     * @param sheet
     */
    private void setContentColumnWidth(HSSFSheet sheet) {
        sheet.setColumnWidth(0, 5000); //姓名
        sheet.setColumnWidth(1, 5000); //公司名
        sheet.setColumnWidth(2, 5000); //手机
        sheet.setColumnWidth(3, 5000); //邮箱
        sheet.setColumnWidth(4, 5000); //积分
    }

    /**
     * 设置单元格样式
     *
     * @param wb
     * @return
     */
    private HSSFCellStyle setContentCellStyle(HSSFWorkbook wb) {
        HSSFCellStyle cellStyle = wb.createCellStyle();
        HSSFFont font = wb.createFont();
        font.setFontName("黑体");
        font.setFontHeightInPoints((short) 10);//设置字体大小
//        font.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);//粗体显示
        cellStyle.setFont(font);
        cellStyle.setBorderBottom(HSSFCellStyle.BORDER_THIN);
        cellStyle.setBorderLeft(HSSFCellStyle.BORDER_THIN);
        cellStyle.setBorderRight(HSSFCellStyle.BORDER_THIN);
        cellStyle.setBorderTop(HSSFCellStyle.BORDER_THIN);
        cellStyle.setAlignment(HSSFCellStyle.ALIGN_CENTER);
        return cellStyle;
    }

    /**
     * 设置单元格内容
     *
     * @param value
     * @return
     */
    private String setContentCellValue(String value) {
        if (Lang.isEmpty(value)) {
            return "";
        } else {
            return value;
        }
    }
}
