package ctscore.web.controller.member;

import cms.api.OrganizationApi;
import cms.api.dto.OrganizationDto;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import ctscore.api.vo.ScoreFlowDetailVO;
import ctscore.web.service.member.MemberBatchService;
import ctscore.web.service.member.MemberLoginService;
import ctscore.web.service.member.ScoreUserService;
import ctscore.web.service.member.UserCenterService;
import member.api.MemberApi;
import member.api.dto.core.CoreUserDto;
import member.api.dto.shop.MemberCreditsTranDto;
import member.api.dto.shop.MemberDto;
import member.model.repository.member.MemberRepos;
import member.model.shop.Member;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import score.api.ScoreApi;
import score.api.definition.ScoreBusinessType;
import score.api.dto.entitydto.ScoreAccountDTO;
import score.api.dto.entitydto.ScoreExpenseDetailDTO;
import score.api.dto.entitydto.ScoreGiveAwayLogDTO;
import score.api.dto.entitydto.ScoreIncomeDetailDTO;
import score.api.dto.requestdto.GetScoreGiveAwayInfoRequestDTO;
import score.api.dto.requestdto.ScoreAccountRequestDTO;
import score.api.dto.requestdto.ScoreDetailQueryDTO;
import score.api.dto.requestdto.ScoreGiveAwayRequestDTO;
import score.api.dto.responsedto.PageResponseDTO;
import score.model.ScoreIncomeDetail;
import utils.GlobalContants;
import utils.Lang;
import utils.sql.PageVo;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;


/**
 * Created by DRAGON on 2016/12/5.
 * 会员中心-积分
 */
@Controller
@RequestMapping("/credits")
public class MemberCreditsController {

    final static Logger logger = LoggerFactory.getLogger(MemberCreditsController.class);

    @Autowired
    MemberLoginService memberLoginService;
    @Autowired
    UserCenterService userCenterService;

    @MotanReferer
    OrganizationApi organizationApi;

    @MotanReferer
    ScoreApi scoreApi;

    @Value("${ctscore.organization.code}")
    String organizationCode;

    @Autowired
    MemberBatchService memberBatchService;

    @Autowired
    ScoreUserService scoreUserService;

    //提交赠送积分token
    private final static String SEND_SCORE_TOKEN = "SEND_SCORE_TOKEN";

    //====================================积分概览

    //积分概览
    @RequestMapping(value = "index", method = RequestMethod.GET)

    public String index(HttpServletRequest request, Map model) {
        logger.info("积分概览");

        //登录的session
        Object userJson = request.getSession().getAttribute(GlobalContants.SESSION_USER_JSON_ITAIPING);
        CoreUserDto tmpCoreUser = JSON.parseObject(userJson.toString(), CoreUserDto.class);
        ScoreAccountRequestDTO queryDTO = new ScoreAccountRequestDTO();
        queryDTO.setUserId(tmpCoreUser.getId());
        queryDTO.setOrganizationCode(organizationCode);
        queryDTO.setEmail(tmpCoreUser.getEmail());
        queryDTO.setPhone(tmpCoreUser.getPhone());
        ScoreAccountDTO scoreAccountDTO = scoreApi.queryScoreAccount(queryDTO);

        // 总收入积分
        BigDecimal usableScoreVal = scoreUserService.roundScore(scoreAccountDTO.getIncomeScoreVal());
        // 总消费积分
        BigDecimal expendedScoreVal = scoreUserService.roundScore(scoreAccountDTO.getExpendedScoreVal());
        // 可用积分
        BigDecimal canUseScoreVal = scoreUserService.roundScore(usableScoreVal.subtract(expendedScoreVal));


        model.put("canUseScore", canUseScoreVal);
        model.put("usableScore", usableScoreVal);
        model.put("expendedScore", expendedScoreVal);

        return "member/score/index";
    }

    //积分概览分页查询
    @RequestMapping(value = "/index/page", method = {RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public JSONObject indexPage(HttpServletRequest request, int pageIndex, int pageSize, String startDate, String endDate, String type) {
        long methodStartTime = System.currentTimeMillis();
        logger.info("积分概览分页查询");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        pageSize = pageSize == 0 ? 10 : pageSize;
        Date start = null;
        Date end = null;
        try {
            if (!Lang.isEmpty(startDate)) {
                startDate += " 00:00:00";
                start = sdf.parse(startDate);
            }
            if (!Lang.isEmpty(endDate)) {
                endDate += " 23:59:59";
                end = sdf.parse(endDate);
            }
        } catch (ParseException e) {
            e.printStackTrace();
        }

        //登录的session
        Object userJson = request.getSession().getAttribute(GlobalContants.SESSION_USER_JSON_ITAIPING);
        CoreUserDto tmpCoreUser = JSON.parseObject(userJson.toString(), CoreUserDto.class);
        ScoreAccountRequestDTO queryDTO = new ScoreAccountRequestDTO();
        queryDTO.setUserId(tmpCoreUser.getId());
        queryDTO.setOrganizationCode(organizationCode);
        queryDTO.setEmail(tmpCoreUser.getEmail());
        queryDTO.setPhone(tmpCoreUser.getPhone());
        ScoreAccountDTO scoreAccountDTO = scoreApi.queryScoreAccount(queryDTO);
        String scoreAccountId = scoreAccountDTO.getId();

        ScoreDetailQueryDTO scoreDetailsQueryDTO = new ScoreDetailQueryDTO();
        if ("income".equals(type)) {
            List list = new ArrayList<>();
            list.add(scoreAccountId);
            scoreDetailsQueryDTO.setScoreAccountIds(list);
            scoreDetailsQueryDTO.setPage(pageIndex);
            scoreDetailsQueryDTO.setPageSize(pageSize);
            scoreDetailsQueryDTO.setStartDate(start);
            scoreDetailsQueryDTO.setEndDate(end);
            PageResponseDTO<ScoreIncomeDetailDTO> result = scoreApi.queryScoreIncomeDetais(scoreDetailsQueryDTO);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("code", "0");
            jsonObject.put("mes", "分页查询收入明细结果");
            jsonObject.put("totalPage", result.getTotalPages());
            jsonObject.put("data", result);

            logger.info(jsonObject.toJSONString());
            logger.info("个人积分概览收入查询耗时 {} ms", System .currentTimeMillis() - methodStartTime);
            return jsonObject;
        } else {
            List list = new ArrayList<>();
            list.add(scoreAccountId);
            scoreDetailsQueryDTO.setScoreAccountIds(list);
            scoreDetailsQueryDTO.setPage(pageIndex);
            scoreDetailsQueryDTO.setPageSize(pageSize);
            scoreDetailsQueryDTO.setStartDate(start);
            scoreDetailsQueryDTO.setEndDate(end);
            PageResponseDTO<ScoreExpenseDetailDTO> result = scoreApi.queryScoreExpenseDetails(scoreDetailsQueryDTO);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("code", "0");
            jsonObject.put("mes", "分页查询支出明细结果");
            jsonObject.put("totalPage", result.getTotalPages());
            jsonObject.put("data", result);
            logger.info(jsonObject.toJSONString());
            logger.info("个人积分概览支出查询耗时 {} ms", System .currentTimeMillis() - methodStartTime);
            return jsonObject;
        }


    }

    //详情页
    @RequestMapping(value = "index/detail/{tranId}/{entry}", method = RequestMethod.GET)

    public String indexDetail(HttpServletRequest request, Map model, @PathVariable("tranId") String tranId, @PathVariable("entry") String entry) {
        logger.info("积分概览详情页id:{}", tranId);
        MemberCreditsTranDto memberCreditsTran = userCenterService.findMemberCreditsTranById(tranId);
        if (memberCreditsTran != null) {
            model.put("memberCreditsTran", memberCreditsTran);
        }
        if (entry.equals("1")) {//积分概览
            return "member/score/scoreGrantDetail";
        } else if (entry.equals("2")) {
            return "member/score/scoretranDetail";
        } else if (entry.equals("3")) {
            return "member/score/recetranDetail";
        } else {
            return "member/score/scoreGrantDetail";
        }
    }


    //===========================积分赠与

    //积分赠与
    @RequestMapping(value = "/give/score", method = RequestMethod.GET)
    public String giveAward(HttpServletRequest request, Map model) {
        logger.info("积分赠与");
        Object userJson = request.getSession().getAttribute(GlobalContants.SESSION_USER_JSON_ITAIPING);
        CoreUserDto CoreUser = JSON.parseObject(userJson.toString(), CoreUserDto.class);
        String email = CoreUser.getEmail();
        model.put("email", email);
        return "member/score/givescore";
    }

    //积分赠与分页查询
    @RequestMapping(value = "other/members", method = {RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public JSONObject otherMembers(HttpServletRequest request,
                                   String searchLoginId, String name, Integer pageIndex, Integer pageSize) {
        logger.info("积分赠与分页会员查询");
        Object userJson = request.getSession().getAttribute(GlobalContants.SESSION_USER_JSON_ITAIPING);
        CoreUserDto CoreUser = JSON.parseObject(userJson.toString(), CoreUserDto.class);

        String userId = CoreUser.getId();

        pageIndex = pageIndex == null ? 0 : pageIndex;
        pageSize = pageSize == null ? 10 : pageSize;

        PageVo pageVo = userCenterService.findMemberPageByUserIdAndName(pageSize, pageIndex, userId, searchLoginId, name, CoreUser.getOrganizationId());


        JSONObject jsonObject = new JSONObject();
        jsonObject.put("code", "0");
        jsonObject.put("mes", "分页查询会员结果");
        jsonObject.put("data", pageVo);

        int totalPage = getTotalPages(pageVo.getTotalCount(), pageSize);
        jsonObject.put("totalPage", totalPage);

        logger.info(jsonObject.toJSONString());
        return jsonObject;
    }


    //积分赠与--赠与第一步
    @RequestMapping(value = "give/score/first/{userLoginId}", method = RequestMethod.GET)
    public String giveScoreFirst(HttpServletRequest request, Map model, @PathVariable("userLoginId") String userLoginId) {
        logger.info("积分赠与第一步");

        Object userJson = request.getSession().getAttribute(GlobalContants.SESSION_USER_JSON_ITAIPING);
        CoreUserDto CoreUser = JSON.parseObject(userJson.toString(), CoreUserDto.class);
        String email = CoreUser.getEmail();
        if (email.indexOf("CTYSP123.com") > 0) {
            return "redirect:/credits/give/score";
        }

        OrganizationDto organizationByOrgCode = organizationApi.findOrganizationByOrgCode(organizationCode);

        CoreUserDto findCoreUser = userCenterService.findByPhoneOrEmail(userLoginId, organizationByOrgCode.getId());
        if (findCoreUser == null) {
            return "redirect:/credits/give/score";
        }
        MemberDto sendmember = userCenterService.getMemberInfoByCoreUser(findCoreUser);
//        Member sendmember = userCenterService.findMenberById(memberId);
        model.put("member", sendmember);

        String uuid = UUID.randomUUID().toString();
        request.getSession().setAttribute(SEND_SCORE_TOKEN, uuid);
        model.put("SEND_TOKEN", uuid);


        return "member/score/scoreGivingFirst";
    }

    //积分赠与--赠与第二步
    @RequestMapping(value = "give/score/second", method = RequestMethod.POST)
    public String giveScoreSecond(HttpServletRequest request, Map model,
                                  String targetMemberId, Integer score, String remark, String targetName, String SEND_TOKEN) {
        logger.info("积分赠与第二步");

        if (score < 0) {
            return "redirect:/credits/give/score";
        }

        model.put("targetMemberId", targetMemberId);
        model.put("score", score);
        model.put("remark", remark);
        model.put("targetName", targetName);


        //获取赠与的id
        Object userJson = request.getSession().getAttribute(GlobalContants.SESSION_USER_JSON_ITAIPING);
        CoreUserDto CoreUser = JSON.parseObject(userJson.toString(), CoreUserDto.class);

        //获取积分详情
        ScoreAccountRequestDTO queryDTO = new ScoreAccountRequestDTO();
        queryDTO.setUserId(CoreUser.getId());
        queryDTO.setOrganizationCode(organizationCode);
        queryDTO.setEmail(CoreUser.getEmail());
        queryDTO.setPhone(CoreUser.getPhone());
        ScoreAccountDTO scoreAccountDTO = scoreApi.queryScoreAccount(queryDTO);


        BigDecimal myScore = scoreAccountDTO.getIncomeScoreVal().subtract(scoreAccountDTO.getExpendedScoreVal());
        if (myScore != null && myScore.intValue() >= score.intValue()) {
            if (!Lang.isEmpty(SEND_TOKEN)) {
                model.put("SEND_TOKEN", SEND_TOKEN);
            }

            model.put("isError", 0);
        } else {
            model.put("errorMsg", "没有充足的积分，积分需要重新输入");
            model.put("isError", 1);
        }

        return "member/score/scoreGivingSecond";
    }

    @MotanReferer
    MemberApi memberApi;
    @Autowired
    MemberRepos memberRepos;

    //积分赠与--赠与第三步(需要定时任务)
    @RequestMapping(value = "give/score/third", method = RequestMethod.POST)
    public String giveScoreThird(HttpServletRequest request, Map model,
                                 String targetMemberId, String score, String remark, String targetName, String SEND_TOKEN) {
        logger.info("第三步成功");

        if (Integer.parseInt(score) < 0) {
            return "redirect:/credits/give/score";
        }

        score = score.replace(",", "");

        Object sendScoreToken = request.getSession().getAttribute(SEND_SCORE_TOKEN);
        if (Lang.isEmpty(SEND_TOKEN) || Lang.isEmpty(sendScoreToken) || (!SEND_TOKEN.equals(sendScoreToken.toString()))) {
            model.put("targetMemberId", targetMemberId);
            model.put("score", score);
            model.put("remark", remark);
            model.put("targetName", targetName);
            model.put("isError", 1);
            model.put("errorMsg", "非法赠送单");
            return "member/score/scoreGivingSecond";
        }

        if (Lang.isEmpty(targetMemberId) || Lang.isEmpty(targetName)) {
            model.put("targetMemberId", targetMemberId);
            model.put("score", score);
            model.put("remark", remark);
            model.put("targetName", targetName);
            model.put("isError", 1);
            model.put("errorMsg", "授予者信息异常");
            return "member/score/scoreGivingSecond";
        }
        if (Lang.isEmpty(score)) {
            model.put("targetMemberId", targetMemberId);
            model.put("score", score);
            model.put("remark", remark);
            model.put("targetName", targetName);
            model.put("isError", 1);
            model.put("errorMsg", "授予积分格式不符合");
            return "member/score/scoreGivingSecond";
        }


        if (Lang.isEmpty(remark)) {
            model.put("targetMemberId", targetMemberId);
            model.put("score", score);
            model.put("remark", remark);
            model.put("targetName", targetName);
            model.put("isError", 1);
            model.put("errorMsg", "请填写给授予者一句话");
            return "member/score/scoreGivingSecond";
        }

        //移除token
        request.getSession().removeAttribute(SEND_SCORE_TOKEN);

        Object userJson = request.getSession().getAttribute(GlobalContants.SESSION_USER_JSON_ITAIPING);
        CoreUserDto tmpCoreUser = JSON.parseObject(userJson.toString(), CoreUserDto.class);
        ScoreAccountRequestDTO queryDTO = new ScoreAccountRequestDTO();
        queryDTO.setUserId(tmpCoreUser.getId());
        queryDTO.setOrganizationCode(organizationCode);
        queryDTO.setEmail(tmpCoreUser.getEmail());
        queryDTO.setPhone(tmpCoreUser.getPhone());
        ScoreAccountDTO scoreAccountDTO = scoreApi.queryScoreAccount(queryDTO);
        String giveAccountId = scoreAccountDTO.getId();

        CoreUserDto coreUserReceive = memberApi.findMemberById(targetMemberId).getCoreUser();
        queryDTO.setUserId(coreUserReceive.getId());
        queryDTO.setOrganizationCode(organizationCode);
        queryDTO.setEmail(tmpCoreUser.getEmail());
        queryDTO.setPhone(tmpCoreUser.getPhone());
        scoreAccountDTO = scoreApi.queryScoreAccount(queryDTO);
        String receiveAccountId = scoreAccountDTO.getId();

        //调用积分赠与接口
        ScoreGiveAwayRequestDTO scoreGiveDTO = new ScoreGiveAwayRequestDTO();
        scoreGiveDTO.setGiveAwayScoreAccountId(giveAccountId);
        scoreGiveDTO.setGiveAwayTime(new Date());
        scoreGiveDTO.setMemo(remark);
        scoreGiveDTO.setReceiveScoreAccountId(receiveAccountId);
        scoreGiveDTO.setScoreVal(new BigDecimal(score));
        String status = "";
        ScoreGiveAwayLogDTO result = null;
        try {
            result = scoreApi.scoreGiveAway(scoreGiveDTO);
            status = result.getStatus();
        } catch (Exception e) {
            logger.error(JSON.toJSONString(e));
            model.put("targetMemberId", targetMemberId);
            model.put("score", score);
            model.put("remark", remark);
            model.put("targetName", targetName);
            model.put("isError", 0);
            model.put("errorMsg", "积分授予失败，请再次尝试");
            return "member/score/scoreGivingSecond";
        }

        logger.info("积分授予结果:{}", result);
        if ("success".equals(status)) {
            return "member/score/scoreGivingThird";
        } else {
            model.put("targetMemberId", targetMemberId);
            model.put("score", score);
            model.put("remark", remark);
            model.put("targetName", targetName);
            model.put("isError", 0);
            model.put("errorMsg", "积分授予失败，请再次尝试");
            return "member/score/scoreGivingSecond";
        }


    }


    //=============================赠与积分积分流动

    //赠与积分积分流动查询 (赠与)
    @RequestMapping(value = "send/tran", method = {RequestMethod.GET, RequestMethod.POST})

    public String sendScoreCreditTran() {
        logger.info("积分流动查询");
        return "member/score/sendtran";
    }


    //赠与积分积分流动 分页查询 （赠与）
    @RequestMapping(value = "send/tran/page", method = {RequestMethod.GET, RequestMethod.POST})

    @ResponseBody
    public JSONObject sendScoreCreditTranPage(HttpServletRequest request, Integer pageIndex, Integer pageSize) {
        long methodStartTime = System.currentTimeMillis();
        logger.info("赠与积分流动明细分页查询...");
        //登录的session
        Object userJson = request.getSession().getAttribute(GlobalContants.SESSION_USER_JSON_ITAIPING);
        CoreUserDto tmpCoreUser = JSON.parseObject(userJson.toString(), CoreUserDto.class);
        ScoreAccountRequestDTO scoreAccountQueryDTO = new ScoreAccountRequestDTO();
        scoreAccountQueryDTO.setPhone(tmpCoreUser.getPhone());
        scoreAccountQueryDTO.setEmail(tmpCoreUser.getEmail());
        scoreAccountQueryDTO.setOrganizationCode(organizationCode);
        scoreAccountQueryDTO.setUserId(tmpCoreUser.getId());
        ScoreAccountDTO scoreAccountDTO = scoreApi.queryScoreAccount(scoreAccountQueryDTO);

        ScoreDetailQueryDTO queryDTO = new ScoreDetailQueryDTO();
        List list = new ArrayList<>();
        list.add(scoreAccountDTO.getId());
        queryDTO.setScoreAccountIds(list);
        queryDTO.setOrganizationCode(organizationCode);
        queryDTO.setBusiCode(ScoreBusinessType.BUSI_EXPENSE_GIVE_AWAY.getBusinessCode());
        queryDTO.setPage(pageIndex);
        queryDTO.setPageSize(pageSize);
        PageResponseDTO<ScoreExpenseDetailDTO> scoreExpenseDetailDTOPageResponseDTO = scoreApi.queryScoreExpenseDetails(queryDTO);
        List<ScoreExpenseDetailDTO> listScoreEDD = scoreExpenseDetailDTOPageResponseDTO.getContent();
        List<ScoreFlowDetailVO> resultList = new ArrayList<>();

        Map<String, ScoreGiveAwayLogDTO> codeLogMap = new HashMap<>();
        Map<String, MemberDto> memberDTOMap = memberBatchService.findScoreGiveData(codeLogMap, listScoreEDD.stream().map(ScoreExpenseDetailDTO::getScoreRcptCode).collect(Collectors.toList()));

        for (int i = 0; i < listScoreEDD.size(); i++) {
            ScoreGiveAwayLogDTO scoreGiveAwayLogDTO = codeLogMap.get(listScoreEDD.get(i).getScoreRcptCode());
            ScoreFlowDetailVO result = new ScoreFlowDetailVO();
            result.setId(scoreGiveAwayLogDTO.getId());
            result.setReceiveName(memberDTOMap.get(listScoreEDD.get(i).getScoreRcptCode()).getRealName());
            result.setSendDate(scoreGiveAwayLogDTO.getGiveAwayTime());
            result.setRemark(scoreGiveAwayLogDTO.getMemo());
            result.setScore(scoreGiveAwayLogDTO.getScoreVal());
            resultList.add(result);
        }
        PageResponseDTO<ScoreFlowDetailVO> result = new PageResponseDTO<>();
        result.setContent(resultList);
        result.setTotalPages(scoreExpenseDetailDTOPageResponseDTO.getTotalPages());


        JSONObject jsonObject = new JSONObject();
        jsonObject.put("code", "0");
        jsonObject.put("mes", "分页查询结果");
        jsonObject.put("totalPage", scoreExpenseDetailDTOPageResponseDTO.getTotalPages());
        jsonObject.put("data", result);

        logger.info(jsonObject.toJSONString());


        return jsonObject;
    }


    //赠与积分积分流动查询 (被赠与)
    @RequestMapping(value = "rece/tran", method = RequestMethod.GET)

    public String receScoreCreditTran() {
        logger.info("被赠与积分流动查询");
        return "member/score/recetran";
    }

    //赠与积分积分流动 分页查询 (被赠与)
    @RequestMapping(value = "rece/tran/page", method = {RequestMethod.GET, RequestMethod.POST})

    @ResponseBody
    public JSONObject receScoreCreditTranPage(HttpServletRequest request, int pageIndex, int pageSize) {
        long methodStartTime = System.currentTimeMillis();
        logger.info("获赠积分流动明细分页查询...");

        //登录的session
        Object userJson = request.getSession().getAttribute(GlobalContants.SESSION_USER_JSON_ITAIPING);
        CoreUserDto tmpCoreUser = JSON.parseObject(userJson.toString(), CoreUserDto.class);
        ScoreAccountRequestDTO scoreAccountQueryDTO = new ScoreAccountRequestDTO();
        scoreAccountQueryDTO.setPhone(tmpCoreUser.getPhone());
        scoreAccountQueryDTO.setEmail(tmpCoreUser.getEmail());
        scoreAccountQueryDTO.setOrganizationCode(organizationCode);
        scoreAccountQueryDTO.setUserId(tmpCoreUser.getId());
        ScoreAccountDTO scoreAccountDTO = scoreApi.queryScoreAccount(scoreAccountQueryDTO);

        ScoreDetailQueryDTO queryDTO = new ScoreDetailQueryDTO();
        List list = new ArrayList<>();
        list.add(scoreAccountDTO.getId());
        queryDTO.setScoreAccountIds(list);
        queryDTO.setOrganizationCode(organizationCode);

        queryDTO.setBusiCode(ScoreBusinessType.BUSI_INCOME_RECEIVE.getBusinessCode());
        queryDTO.setPage(pageIndex);
        queryDTO.setPageSize(pageSize);
        PageResponseDTO<ScoreIncomeDetailDTO> scoreIncomeDetailDTOPageResponseDTO = scoreApi.queryScoreIncomeDetais(queryDTO);
        List<ScoreIncomeDetailDTO> listScoreEDD = scoreIncomeDetailDTOPageResponseDTO.getContent();
        List<ScoreFlowDetailVO> resultList = new ArrayList<>();

        Map<String, ScoreGiveAwayLogDTO> codeLogMap = new HashMap<>();
        Map<String, MemberDto> memberDTOMap = memberBatchService.findScoreGetData(codeLogMap, listScoreEDD.stream().map(ScoreIncomeDetailDTO::getScoreRcptCode).collect(Collectors.toList()));

        for (int i = 0; i < listScoreEDD.size(); i++) {
            ScoreGiveAwayLogDTO scoreGiveAwayLogDTO = codeLogMap.get(listScoreEDD.get(i).getScoreRcptCode());
            ScoreFlowDetailVO result = new ScoreFlowDetailVO();
            result.setId(scoreGiveAwayLogDTO.getId());
            result.setSendName(memberDTOMap.get(listScoreEDD.get(i).getScoreRcptCode()).getRealName());
            result.setSendDate(scoreGiveAwayLogDTO.getGiveAwayTime());
            result.setRemark(scoreGiveAwayLogDTO.getMemo());
            result.setScore(scoreGiveAwayLogDTO.getScoreVal());
            resultList.add(result);
        }
        PageResponseDTO<ScoreFlowDetailVO> result = new PageResponseDTO<>();
        result.setContent(resultList);
        result.setTotalPages(scoreIncomeDetailDTOPageResponseDTO.getTotalPages());

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("code", "0");
        jsonObject.put("mes", "分页查询会员结果");
        jsonObject.put("totalPage", scoreIncomeDetailDTOPageResponseDTO.getTotalPages());
        jsonObject.put("data", result);

        logger.info(jsonObject.toJSONString());
        logger.info("获赠积分流动明细分页查询耗时 {} ms", System.currentTimeMillis() - methodStartTime);
        return jsonObject;
    }


    public int getTotalPages(int total, int size) {
        int totalpage = (total + size - 1) / size;
        return totalpage;
    }


}
