package ctscore.web.controller.member;

import cms.api.OrganizationApi;
import cms.api.dto.OrganizationDto;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import ctscore.web.service.member.MemberBatchService;
import ctscore.web.vo.AdminScoreGiveVo;
import lombok.extern.slf4j.Slf4j;
import member.api.CoreUserApi;
import member.api.MemberApi;
import member.api.MemberCreditsTranApi;
import member.api.dto.core.CoreUserDto;
import member.api.dto.shop.MemberCreditsTranDto;
import member.api.dto.shop.MemberDto;
import member.api.vo.CoreUserSerachVo;
import member.api.vo.MemberCredisGiveVo;
import member.model.core.CoreUser;
import member.model.repository.core.UserRepos;
import member.model.repository.member.MemberRepos;
import member.model.shop.Member;
import org.apache.poi.hssf.usermodel.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import score.api.ScoreApi;
import score.api.definition.ScoreBusinessType;
import score.api.dto.entitydto.ScoreAccountDTO;
import score.api.dto.entitydto.ScoreExpenseDetailDTO;
import score.api.dto.entitydto.ScoreGiveAwayLogDTO;
import score.api.dto.requestdto.GetScoreGiveAwayInfoRequestDTO;
import score.api.dto.requestdto.ScoreAccountRequestDTO;
import score.api.dto.requestdto.ScoreDetailQueryDTO;
import score.api.dto.responsedto.PageResponseDTO;
import utils.GlobalContants;
import utils.Lang;
import utils.date.DateUtils;
import utils.excel.ExcelUtil;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * Created by DixonLim on 2016/12/1.
 */

@Slf4j
@Controller
@RequestMapping("memberCreditsGive")
public class MemberCreditsGiveController {

    @MotanReferer(basicReferer = "motanClientBasicConfig")
    private MemberApi memberApi;

    @MotanReferer(basicReferer = "motanClientBasicConfig")
    private CoreUserApi coreUserApi;

    @Autowired
    UserRepos userRepos;

    @Autowired
    MemberRepos memberRepos;

    @MotanReferer(basicReferer = "motanClientBasicConfig")
    private MemberCreditsTranApi memberCreditsTranApi;

    @MotanReferer(basicReferer = "motanClientBasicConfig")
    private OrganizationApi organizationApi;

    @MotanReferer
    private ScoreApi scoreApi;

    @Value("${ctscore.organization.code}")
    String organizationCode;

    @Autowired
    MemberBatchService memberBatchService;

    @RequestMapping(value = {"", "index.do", "index.htm"}, method = RequestMethod.GET)
    public String index(HttpServletRequest request, Model model) {
        return "member/manager/adOperaCheckScoreGiveNew";
    }

    @ResponseBody
    @RequestMapping(value = "list", method = RequestMethod.POST)
    public Map list(String username, String phone, String email, String dateStart, String dateEnd, Pageable pageable) throws ParseException {
        long methodStart = System.currentTimeMillis();
        log.info("积分转赠数据列表查询开始...");
        SimpleDateFormat dateFormatSec = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat dateFormatDay = new SimpleDateFormat("yyyy-MM-dd");
        Map returnMap = new HashMap();
        long getOrganizationInfoTime = System.currentTimeMillis();
        String organizationId = organizationApi.findOrganizationIdByOrgCode(organizationCode);
        String organizationName = organizationApi.findOrganizationNameByOrgCode(organizationCode);
        log.info("获取机构信息耗时 {} ms", System.currentTimeMillis() - getOrganizationInfoTime);

        List<MemberDto> members = null;
        List<CoreUserDto> coreUsers = null;
        boolean emptyResult = false;

        ScoreDetailQueryDTO scoreDetailQueryDTO = new ScoreDetailQueryDTO();
        scoreDetailQueryDTO.setPage(pageable.getPageNumber());
        scoreDetailQueryDTO.setPageSize(pageable.getPageSize());
        scoreDetailQueryDTO.setBusiCode(ScoreBusinessType.BUSI_EXPENSE_GIVE_AWAY.getBusinessCode());
        scoreDetailQueryDTO.setOrganizationCode(organizationCode);
        if (!Lang.isEmpty(dateStart)) {
            dateStart = dateStart.trim();
            scoreDetailQueryDTO.setStartDate(dateFormatDay.parse(dateStart));
        }
        if (!Lang.isEmpty(dateEnd)) {
            dateEnd = dateEnd.trim();
            dateEnd += " 23:59:59";
            scoreDetailQueryDTO.setEndDate(dateFormatSec.parse(dateEnd));
        }

        long filterTime = System.currentTimeMillis();
        if (!Lang.isEmpty(username) || !Lang.isEmpty(phone) || !Lang.isEmpty(email)) {
            List<String> scoreAccountIdList = new ArrayList<>();
            if (!Lang.isEmpty(username)) {
                /*Member memberExample = new Member();
                memberExample.setRealName(username);
                CoreUser coreUserExample = new CoreUser();
                coreUserExample.setUserType(CoreUser.USER_TYPE_MEMBER);
                coreUserExample.setOrganizationId(organization.getId());
                coreUserExample.setErrCount(null);
                coreUserExample.setLoginCount(null);
                coreUserExample.setIsDelete(null);
                if(!Lang.isEmpty(phone) || !Lang.isEmpty(email)) {
                    if(!Lang.isEmpty(phone)) {
                        coreUserExample.setPhone(phone);
                    }
                    if(!Lang.isEmpty(email)) {
                        coreUserExample.setPhone(email);
                    }
                }
                memberExample.setCoreUser(coreUserExample);
                members = memberApi.findMemberByExample(memberExample);*/
                scoreDetailQueryDTO.setNickName(username);
            } else {
                CoreUserSerachVo coreUserSerach = new CoreUserSerachVo();
                coreUserSerach.setPhone(phone);
                coreUserSerach.setEmail(email);
                coreUserSerach.setUserType(CoreUserDto.USER_TYPE_MEMBER);
                coreUserSerach.setOrganizationId(organizationId);
                coreUserSerach.setDelete(null);
                coreUsers = coreUserApi.findCoreUser(coreUserSerach);
            }

            if (!Lang.isEmpty(members)) {
                for (MemberDto member : members) {
                    //封装积分账号查询参数
                    ScoreAccountRequestDTO scoreAccountRequestDTO = new ScoreAccountRequestDTO();
                    scoreAccountRequestDTO.setOrganizationCode(organizationCode);
                    scoreAccountRequestDTO.setUserId(member.getCoreUser().getId());
                    if (!Lang.isEmpty(phone)) {
                        scoreAccountRequestDTO.setPhone(phone);
                    }
                    if (!Lang.isEmpty(email)) {
                        scoreAccountRequestDTO.setEmail(email);
                    }
                    ScoreAccountDTO scoreAccountDTO = scoreApi.queryScoreAccount(scoreAccountRequestDTO);
                    scoreAccountIdList.add(scoreAccountDTO.getId());
                }
            } else if (!Lang.isEmpty(coreUsers)) {
                for (CoreUserDto coreUser : coreUsers) {
                    //封装积分账号查询参数
                    ScoreAccountRequestDTO scoreAccountRequestDTO = new ScoreAccountRequestDTO();
                    scoreAccountRequestDTO.setOrganizationCode(organizationCode);
                    scoreAccountRequestDTO.setUserId(coreUser.getId());
                    if (!Lang.isEmpty(phone)) {
                        scoreAccountRequestDTO.setPhone(phone);
                    }
                    if (!Lang.isEmpty(email)) {
                        scoreAccountRequestDTO.setEmail(email);
                    }
                    ScoreAccountDTO scoreAccountDTO = scoreApi.queryScoreAccount(scoreAccountRequestDTO);
                    scoreAccountIdList.add(scoreAccountDTO.getId());
                }
            } else if (Lang.isEmpty(username)) {
                emptyResult = true;
            }
            scoreDetailQueryDTO.setScoreAccountIds(scoreAccountIdList);
        }

        PageResponseDTO<ScoreExpenseDetailDTO> scoreExpenseDetailsPage;
        if (!emptyResult) {
            scoreExpenseDetailsPage = scoreApi.queryScoreExpenseDetails(scoreDetailQueryDTO);
        } else {
            scoreExpenseDetailsPage = new PageResponseDTO<>(0, (long) 0, new ArrayList<>());
        }

        log.info("查询参数过滤耗时 {} ms", System.currentTimeMillis() - filterTime);

        List<String> coreUserIds = scoreExpenseDetailsPage.getContent().stream().map(ScoreExpenseDetailDTO::getScoreAccount).map(ScoreAccountDTO::getUserId).collect(Collectors.toList());
        List<String> scoreRcptCodes = scoreExpenseDetailsPage.getContent().stream().map(ScoreExpenseDetailDTO::getScoreRcptCode).collect(Collectors.toList());
        Map<String, MemberDto> memberDTOMap = memberBatchService.findScoreGiveData(coreUserIds, scoreRcptCodes);

        List<AdminScoreGiveVo> scoreGiveVoList = new ArrayList<>();
        scoreExpenseDetailsPage.getContent().forEach(scoreExpenseDetail -> {
            if (memberDTOMap.containsKey(scoreExpenseDetail.getScoreAccount().getUserId())) {
                MemberDto memberDTO = memberDTOMap.get(scoreExpenseDetail.getScoreAccount().getUserId());
                AdminScoreGiveVo scoreGiveVo = new AdminScoreGiveVo();
                scoreGiveVo.setUserName(memberDTO.getRealName());
                scoreGiveVo.setOrganizationName(organizationName);
                scoreGiveVo.setPhone(memberDTO.getCoreUser().getPhone());
                scoreGiveVo.setEmail(memberDTO.getCoreUser().getEmail());
                scoreGiveVo.setScore(scoreExpenseDetail.getScoreVal());
                scoreGiveVo.setTradeTime(dateFormatSec.format(scoreExpenseDetail.getTransaTime()));
                scoreGiveVo.setScoreRcptCode(scoreExpenseDetail.getScoreRcptCode());
                if (memberDTOMap.containsKey(scoreExpenseDetail.getScoreRcptCode())) {
                    MemberDto targetMemberDTO = memberDTOMap.get(scoreExpenseDetail.getScoreRcptCode());
                    scoreGiveVo.setTargetUserName(targetMemberDTO.getRealName());
                }
                scoreGiveVoList.add(scoreGiveVo);
            }
        });

        Page<AdminScoreGiveVo> scoreGivePage = new PageImpl<>(scoreGiveVoList, pageable, scoreExpenseDetailsPage.getTotalElements());
        returnMap.put("data", scoreGivePage);
        returnMap.put("totalPages", scoreGivePage.getTotalPages());
        returnMap.put(GlobalContants.ResponseString.STATUS, GlobalContants.ResponseStatus.SUCCESS);
        returnMap.put(GlobalContants.ResponseString.MESSAGE, "数据获取成功");

        log.info("积分转赠数据列表查询完成, 耗时 {} ms", System.currentTimeMillis() - methodStart);
        return returnMap;
    }

    @ResponseBody
    @RequestMapping(value = "listExport")
    public void listExport(String username, String phone, String email, String dateStart, String dateEnd, HttpServletResponse response) throws ParseException {
        long methodStart = System.currentTimeMillis();
        log.info("积分转赠数据导出开始...");
        SimpleDateFormat dateFormatSec = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat dateFormatDay = new SimpleDateFormat("yyyy-MM-dd");
        long getOrganizationInfoTime = System.currentTimeMillis();
        String organizationId = organizationApi.findOrganizationIdByOrgCode(organizationCode);
        String organizationName = organizationApi.findOrganizationNameByOrgCode(organizationCode);
        log.info("获取机构信息耗时 {} ms", System.currentTimeMillis() - getOrganizationInfoTime);

        int page = 0;
        int pageSize = 200;
        int totalPage;

        List<ScoreExpenseDetailDTO> scoreExpenseDetailList = new ArrayList<>();
        List<MemberDto> members = null;
        List<CoreUserDto> coreUsers = null;
        boolean emptyResult = false;

        //封装积分详情查询参数
        long filterTime = System.currentTimeMillis();
        ScoreDetailQueryDTO scoreDetailQueryDTO = new ScoreDetailQueryDTO();
        scoreDetailQueryDTO.setBusiCode(ScoreBusinessType.BUSI_EXPENSE_GIVE_AWAY.getBusinessCode());
        scoreDetailQueryDTO.setOrganizationCode(organizationCode);
        if (!Lang.isEmpty(dateStart)) {
            dateStart = dateStart.trim();
            scoreDetailQueryDTO.setStartDate(dateFormatDay.parse(dateStart));
        }
        if (!Lang.isEmpty(dateEnd)) {
            dateEnd = dateEnd.trim();
            dateEnd += " 23:59:59";
            scoreDetailQueryDTO.setEndDate(dateFormatSec.parse(dateEnd));
        }
        if (!Lang.isEmpty(username) || !Lang.isEmpty(phone) || !Lang.isEmpty(email)) {
            List<String> scoreAccountIdList = new ArrayList<>();
            if (!Lang.isEmpty(username)) {
               /* Member memberExample = new Member();
                memberExample.setRealName(username);
                CoreUser coreUserExample = new CoreUser();
                coreUserExample.setUserType(CoreUser.USER_TYPE_MEMBER);
                coreUserExample.setOrganizationId(organization.getId());
                coreUserExample.setErrCount(null);
                coreUserExample.setLoginCount(null);
                coreUserExample.setIsDelete(null);
                if(!Lang.isEmpty(phone) || !Lang.isEmpty(email)) {
                    if(!Lang.isEmpty(phone)) {
                        coreUserExample.setPhone(phone);
                    }
                    if(!Lang.isEmpty(email)) {
                        coreUserExample.setPhone(email);
                    }
                }
                memberExample.setCoreUser(coreUserExample);
                members = memberApi.findMemberByExample(memberExample);*/
                scoreDetailQueryDTO.setNickName(username);
            } else {
                CoreUserSerachVo coreUserSerach = new CoreUserSerachVo();
                coreUserSerach.setPhone(phone);
                coreUserSerach.setEmail(email);
                coreUserSerach.setUserType(CoreUserDto.USER_TYPE_MEMBER);
                coreUserSerach.setOrganizationId(organizationId);
                coreUserSerach.setDelete(null);
                coreUsers = coreUserApi.findCoreUser(coreUserSerach);
            }

            if (!Lang.isEmpty(members)) {
                for (MemberDto member : members) {
                    //封装积分账号查询参数
                    ScoreAccountRequestDTO scoreAccountRequestDTO = new ScoreAccountRequestDTO();
                    scoreAccountRequestDTO.setOrganizationCode(organizationCode);
                    scoreAccountRequestDTO.setUserId(member.getCoreUser().getId());
                    if (!Lang.isEmpty(phone)) {
                        scoreAccountRequestDTO.setPhone(phone);
                    }
                    if (!Lang.isEmpty(email)) {
                        scoreAccountRequestDTO.setEmail(email);
                    }
                    ScoreAccountDTO scoreAccountDTO = scoreApi.queryScoreAccount(scoreAccountRequestDTO);
                    scoreAccountIdList.add(scoreAccountDTO.getId());
                }
            } else if (!Lang.isEmpty(coreUsers)) {
                for (CoreUserDto coreUser : coreUsers) {
                    //封装积分账号查询参数
                    ScoreAccountRequestDTO scoreAccountRequestDTO = new ScoreAccountRequestDTO();
                    scoreAccountRequestDTO.setOrganizationCode(organizationCode);
                    scoreAccountRequestDTO.setUserId(coreUser.getId());
                    if (!Lang.isEmpty(phone)) {
                        scoreAccountRequestDTO.setPhone(phone);
                    }
                    if (!Lang.isEmpty(email)) {
                        scoreAccountRequestDTO.setEmail(email);
                    }
                    ScoreAccountDTO scoreAccountDTO = scoreApi.queryScoreAccount(scoreAccountRequestDTO);
                    scoreAccountIdList.add(scoreAccountDTO.getId());
                }
            } else if (Lang.isEmpty(username)) {
                emptyResult = true;
            }

            scoreDetailQueryDTO.setScoreAccountIds(scoreAccountIdList);
        }

        do {
            PageResponseDTO<ScoreExpenseDetailDTO> scoreExpenseDetailsPage;
            if (!emptyResult) {
                scoreDetailQueryDTO.setPage(page);
                scoreDetailQueryDTO.setPageSize(pageSize);
                scoreExpenseDetailsPage = scoreApi.queryScoreExpenseDetails(scoreDetailQueryDTO);
            } else {
                scoreExpenseDetailsPage = new PageResponseDTO<>(0, (long) 0, new ArrayList<>());
            }
            scoreExpenseDetailList.addAll(scoreExpenseDetailsPage.getContent());
            totalPage = scoreExpenseDetailsPage.getTotalPages();
            page++;
        } while (page < totalPage);
        log.info("查询参数过滤耗时 {} ms", System.currentTimeMillis() - filterTime);

        List<String> coreUserIds = scoreExpenseDetailList.stream().map(ScoreExpenseDetailDTO::getScoreAccount).map(ScoreAccountDTO::getUserId).collect(Collectors.toList());
        List<String> scoreRcptCodes = scoreExpenseDetailList.stream().map(ScoreExpenseDetailDTO::getScoreRcptCode).collect(Collectors.toList());
        Map<String, MemberDto> memberDTOMap = memberBatchService.findScoreGiveData(coreUserIds, scoreRcptCodes);

        List<List<String>> rows = new ArrayList<>();
        List<String> header = new ArrayList<>();
        header.add("姓名");
        header.add("公司");
        header.add("手机");
        header.add("邮箱");
        header.add("赠送积分 (Ct)");
        header.add("获赠人");
        header.add("日期");
        rows.add(header);

        scoreExpenseDetailList.forEach(scoreExpenseDetail -> {
            if (memberDTOMap.containsKey(scoreExpenseDetail.getScoreAccount().getUserId())) {
                MemberDto memberDTO = memberDTOMap.get(scoreExpenseDetail.getScoreAccount().getUserId());
                String rowTargetUserName = "";
                List<String> row = new ArrayList<>();
                row.add(memberDTO.getRealName());
                row.add(organizationName);
                row.add(memberDTO.getCoreUser().getPhone());
                row.add(memberDTO.getCoreUser().getEmail());
                row.add(scoreExpenseDetail.getScoreVal());
                if (memberDTOMap.containsKey(scoreExpenseDetail.getScoreRcptCode())) {
                    MemberDto targetMemberDTO = memberDTOMap.get(scoreExpenseDetail.getScoreRcptCode());
                    rowTargetUserName = targetMemberDTO.getRealName();
                }
                row.add(rowTargetUserName);
                row.add(dateFormatSec.format(scoreExpenseDetail.getTransaTime()));
                rows.add(row);
            }
        });

        try {
            response.setHeader("Content-disposition", "attachment; filename=" + "MemberCreditsTranGive" + ".xls");
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream out = response.getOutputStream();
            ExcelUtil.createHSSFWorkBook(rows, "MemberCreditsTranGive").write(out);
            out.flush();
            out.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
        log.info("转增积分导出 {} 条数据, 耗时 {} ms", rows.size() - 1, System.currentTimeMillis() - methodStart);
    }

    @RequestMapping(value = "detail", method = RequestMethod.GET)
    public String detail(String scoreRcptCode, Map model) {
        SimpleDateFormat dateFormatSec = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        GetScoreGiveAwayInfoRequestDTO getScoreGiveAwayInfoRequestDTO = new GetScoreGiveAwayInfoRequestDTO();
        getScoreGiveAwayInfoRequestDTO.setScoreExpenseRcptCode(scoreRcptCode);
        ScoreGiveAwayLogDTO scoreGiveAwayLog = scoreApi.getScoreGiveAwayInfo(getScoreGiveAwayInfoRequestDTO);
        CoreUserDto coreUser = coreUserApi.findByIdOnly(scoreGiveAwayLog.getGiveAwayScoreAccount().getUserId());
        CoreUserDto targetCoreUser = coreUserApi.findByIdOnly(scoreGiveAwayLog.getReceiveScoreAccount().getUserId());

        AdminScoreGiveVo scoreGiveVo = new AdminScoreGiveVo();

        if (!Lang.isEmpty(coreUser)) {
            //赠送者
            List<MemberDto> members = memberApi.findByCoreUserId(coreUser.getId());
            if (members.size() == 1) {
                scoreGiveVo.setUserName(members.get(0).getRealName());
            }
            scoreGiveVo.setPhone(coreUser.getPhone());
            scoreGiveVo.setEmail(coreUser.getEmail());
        }

        //接收者
        if (!Lang.isEmpty(targetCoreUser)) {
            List<MemberDto> targetsMembers = memberApi.findByCoreUserId(targetCoreUser.getId());
            if (targetsMembers.size() == 1) {
                scoreGiveVo.setTargetUserName(targetsMembers.get(0).getRealName());
            }
            scoreGiveVo.setTargetPhone(targetCoreUser.getPhone());
            scoreGiveVo.setTargetEmail(targetCoreUser.getEmail());
            scoreGiveVo.setOrganizationName(organizationApi.findOrganizationById(targetCoreUser.getOrganizationId()).getOrgName());
        }
        scoreGiveVo.setTargetScore(scoreGiveAwayLog.getReceiveScoreAccount().getIncomeScoreVal().subtract(scoreGiveAwayLog.getReceiveScoreAccount().getExpendedScoreVal()).toString());

        scoreGiveVo.setScore(scoreGiveAwayLog.getScoreVal().toString());
        scoreGiveVo.setScoreMemo(scoreGiveAwayLog.getMemo());
        scoreGiveVo.setTradeTime(dateFormatSec.format(scoreGiveAwayLog.getGiveAwayTime()));

        model.put("scoreGiveVo", scoreGiveVo);

        return "member/manager/adOperaScoreGiveDetail";
    }

    @RequestMapping(value = "exportMemberCreditsGive.do")
    @ResponseBody
    public void exportMemberCreditsGive(String username, String phone, String email, String dateStart, String dateEnd, HttpServletResponse response) throws ParseException {
        if (dateStart != "" && dateEnd != "") {
            dateStart += " 00:00:00";
            dateEnd += " 23:59:59";
        }
        Pageable pageable = null;
        Page<MemberCreditsTranDto> memberCreditsTranPage = memberCreditsTranApi.findBySendNameAndSendMobileAndSendEmailAndSendDateBetween(username, phone, email, dateStart, dateEnd, pageable);
        List<MemberCreditsTranDto> memberCreditsTrans = memberCreditsTranPage.getContent();
        List<MemberCredisGiveVo> memberCredisGiveVos = new ArrayList<>();
        for (int i = 0; i < memberCreditsTrans.size(); i++) {
            MemberCreditsTranDto memberCreditsTran = memberCreditsTrans.get(i);
//            CoreUser coreUser = member.getCoreUser();
            MemberCredisGiveVo memberCredisGiveVo = new MemberCredisGiveVo();
            memberCredisGiveVo.setSendName(memberCreditsTran.getSendName());
            memberCredisGiveVo.setSendOrganizationName(memberCreditsTran.getSendOrganizationName());
            memberCredisGiveVo.setSendMobile(memberCreditsTran.getSendMobile());
            memberCredisGiveVo.setSendEmail(memberCreditsTran.getSendEmail());
            memberCredisGiveVo.setUseScore(memberCreditsTran.getUseScore());
            memberCredisGiveVo.setTargetName(memberCreditsTran.getTargetName());
            memberCredisGiveVo.setSendDate(DateUtils.dateToStrLong(memberCreditsTran.getSendDate()));
            memberCredisGiveVos.add(memberCredisGiveVo);
        }
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet();
        wb.setSheetName(0, "MemberCreditsTranGive");
        setContentColumnWidth(sheet);
        HSSFCellStyle cellStyle = setContentCellStyle(wb);
        createCellHead(sheet.createRow(0), cellStyle, sheet.createRow(0).createCell(0));
        createCellContent(memberCredisGiveVos, cellStyle, sheet);
        // 将文件存到指定位置
        try {
            response.setHeader("Content-disposition", "attachment; filename=" + "MemberCreditsTranGive" + ".xls");
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream out = response.getOutputStream();
            wb.write(out);
            out.flush();
            out.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value = "getMemberCreditsGive.do", method = RequestMethod.POST)
    @ResponseBody
    public Map getMemberCreditsGive(String username, String phone, String email, String dateStart, String dateEnd, Pageable pageable) throws ParseException {
        Map returnMap = new HashMap();
        if (dateStart != "" && dateEnd != "") {
            dateStart += " 00:00:00";
            dateEnd += " 23:59:59";
        }
        Page<MemberCreditsTranDto> memberCreditsTranPage = memberCreditsTranApi.findBySendNameAndSendMobileAndSendEmailAndSendDateBetween(username, phone, email, dateStart, dateEnd, pageable);
        returnMap.put("data", memberCreditsTranPage);
        returnMap.put("totalPages", getTotalPages((int) memberCreditsTranPage.getTotalElements(), pageable.getPageSize()));
        returnMap.put(GlobalContants.ResponseString.STATUS, GlobalContants.ResponseStatus.SUCCESS);
        returnMap.put(GlobalContants.ResponseString.MESSAGE, "数据获取成功");
        return returnMap;
    }

    @RequestMapping(value = "memberCreditsGiveDetail.do", method = RequestMethod.GET)
    public String memberCreditsGiveDetail(String memberCreditsTranId, Model model) {
        MemberCreditsTranDto memberCreditsTran = memberCreditsTranApi.findMemberCreditsTranById(memberCreditsTranId);
//        model.addAttribute("isAdmin",true);
        model.addAttribute("memberCreditsTran", memberCreditsTran);
        return "member/manager/adOperaScoreGiveDetail";
    }

    public int getTotalPages(int total, int size) {
        int totalpage = (total + size - 1) / size;
        return totalpage;
    }

    /**
     * 创建表头
     *
     * @param row
     * @param cellStyle
     * @param cell
     */
    private void createCellHead(HSSFRow row, HSSFCellStyle cellStyle, HSSFCell cell) {
        cell.setCellValue("姓名");
        cell.setCellStyle(cellStyle);
        cell = row.createCell(1);
        cell.setCellValue("公司名");
        cell.setCellStyle(cellStyle);
        cell = row.createCell(2);
        cell.setCellValue("手机");
        cell.setCellStyle(cellStyle);
        cell = row.createCell(3);
        cell.setCellValue("邮箱");
        cell.setCellStyle(cellStyle);
        cell = row.createCell(4);
        cell.setCellValue("赠送积分");
        cell.setCellStyle(cellStyle);
        cell = row.createCell(5);
        cell.setCellValue("被赠送人");
        cell.setCellStyle(cellStyle);
        cell = row.createCell(6);
        cell.setCellValue("日期");
        cell.setCellStyle(cellStyle);
    }

    /**
     * 创建表内容
     *
     * @param credisGiveVos
     * @param cellStyle
     * @param sheet
     */
    private void createCellContent(List<MemberCredisGiveVo> credisGiveVos, HSSFCellStyle cellStyle, HSSFSheet sheet) {
        for (int i = 0; i < credisGiveVos.size(); i++) {
            int rowCount = i + 1;
            HSSFRow row = sheet.createRow(rowCount);
            MemberCredisGiveVo credisGiveVo = credisGiveVos.get(i);
            HSSFCell theCell = row.createCell(0);
            theCell.setCellStyle(cellStyle);
            theCell.setCellValue(setContentCellValue(credisGiveVo.getSendName()));
            theCell = row.createCell(1);
            theCell.setCellStyle(cellStyle);
            theCell.setCellValue(setContentCellValue(credisGiveVo.getSendOrganizationName()));
            theCell = row.createCell(2);
            theCell.setCellStyle(cellStyle);
            theCell.setCellValue(setContentCellValue(credisGiveVo.getSendMobile()));
            theCell = row.createCell(3);
            theCell.setCellStyle(cellStyle);
            theCell.setCellValue(setContentCellValue(credisGiveVo.getSendEmail()));
            theCell = row.createCell(4);
            theCell.setCellStyle(cellStyle);
            theCell.setCellValue(setContentCellValue(credisGiveVo.getUseScore().toString()));
            theCell = row.createCell(5);
            theCell.setCellStyle(cellStyle);
            theCell.setCellValue(setContentCellValue(credisGiveVo.getTargetName()));
            theCell = row.createCell(6);
            theCell.setCellStyle(cellStyle);
            theCell.setCellValue(setContentCellValue2(credisGiveVo.getSendDate()));
        }
    }

    /**
     * 设置单元格宽度
     *
     * @param sheet
     */
    private void setContentColumnWidth(HSSFSheet sheet) {
        sheet.setColumnWidth(0, 5000); //姓名
        sheet.setColumnWidth(1, 5000); //公司名
        sheet.setColumnWidth(2, 5000); //手机
        sheet.setColumnWidth(3, 5000); //邮箱
        sheet.setColumnWidth(4, 5000); //积分
        sheet.setColumnWidth(5, 5000); //被赠送人
        sheet.setColumnWidth(6, 10000); //日期
    }

    /**
     * 设置单元格样式
     *
     * @param wb
     * @return
     */
    private HSSFCellStyle setContentCellStyle(HSSFWorkbook wb) {
        HSSFCellStyle cellStyle = wb.createCellStyle();
        HSSFFont font = wb.createFont();
        font.setFontName("黑体");
        font.setFontHeightInPoints((short) 10);//设置字体大小
//        font.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);//粗体显示
        cellStyle.setFont(font);
        cellStyle.setBorderBottom(HSSFCellStyle.BORDER_THIN);
        cellStyle.setBorderLeft(HSSFCellStyle.BORDER_THIN);
        cellStyle.setBorderRight(HSSFCellStyle.BORDER_THIN);
        cellStyle.setBorderTop(HSSFCellStyle.BORDER_THIN);
        cellStyle.setAlignment(HSSFCellStyle.ALIGN_CENTER);
        return cellStyle;
    }

    /**
     * 设置单元格内容
     *
     * @param value
     * @return
     */
    private String setContentCellValue(String value) {
        if (Lang.isEmpty(value)) {
            return "";
        } else {
            return value;
        }
    }

    private String setContentCellValue2(Object value) {
        if (Lang.isEmpty(value)) {
            return "";
        } else {
            return value.toString();
        }
    }
}
