package ctscore.web.controller.member;

import cms.api.OrganizationApi;
import cms.api.definition.PrepaidDepositChangeType;
import cms.api.dto.OrganizationBatchOperateLogDTO;
import cms.api.dto.OrganizationDto;
import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import ctscore.web.service.member.MemberBatchService;
import ctscore.web.service.member.MemberLoginService;
import ctscore.web.vo.AdminImportVo;
import lombok.extern.slf4j.Slf4j;
import member.api.CoreUserApi;
import member.api.LoginApi;
import member.api.MemberApi;
import member.api.MemberCreditsTranApi;
import member.api.dto.core.CoreUserDto;
import member.api.dto.shop.MemberCreditsTranDto;
import member.api.dto.shop.MemberDto;
import member.api.vo.CoreUserSerachVo;
import member.api.vo.MemberImportVo;
import member.model.repository.member.MemberRepos;
import org.apache.poi.hssf.usermodel.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import score.api.ScoreApi;
import score.api.UniqueSequenceNoApi;
import score.api.definition.ScoreBusinessType;
import score.api.dto.entitydto.ScoreAccountDTO;
import score.api.dto.entitydto.ScoreIncomeDetailDTO;
import score.api.dto.requestdto.ScoreAccountRequestDTO;
import score.api.dto.requestdto.ScoreDetailQueryDTO;
import score.api.dto.requestdto.ScoreExpenseDetailRequestDTO;
import score.api.dto.responsedto.PageResponseDTO;
import score.api.dto.responsedto.TransactionResponseDTO;
import utils.GlobalContants;
import utils.Lang;
import utils.excel.ExcelUtil;
import utils.rpc.motan.ApiResponseVo;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;

/**
 * Created by DixonLim on 2016/12/1.
 */

@Slf4j
@Controller
@RequestMapping("memberImport")
public class MemberImportController {

    @MotanReferer(basicReferer = "motanClientBasicConfig")
    MemberApi memberApi;

    @MotanReferer(basicReferer = "motanClientBasicConfig")
    CoreUserApi coreUserApi;

    @MotanReferer(basicReferer = "motanClientBasicConfig")
    MemberCreditsTranApi memberCreditsTranApi;

    @MotanReferer(basicReferer = "motanClientBasicConfig")
    OrganizationApi organizationApi;

    @Autowired
    MemberBatchService memberBatchService;

    @Autowired
    MemberLoginService memberLoginService;

    @MotanReferer
    LoginApi loginApi;

    @Value("${ctscore.organization.code}")
    String organizationCode;

    @Value("${batchImportFolder}")
    String batchImportFolder;

    @Value("${show.updatepassword}")
    private Boolean showUpdatepassword;

    @MotanReferer
    ScoreApi scoreApi;
    @MotanReferer
    UniqueSequenceNoApi uniqueSequenceNoApi;

    @RequestMapping(value = {"", "index.do", "index.htm"}, method = RequestMethod.GET)
    public String index(HttpServletRequest request, Model model, String username, String phone, String email) {
        //登录的session
        Object memberJson = request.getSession().getAttribute(GlobalContants.SESSION_MEMBER_JSON_ITAIPING);
        MemberDto member = JSON.parseObject(memberJson.toString(), MemberDto.class);
        Object userId = request.getSession().getAttribute(GlobalContants.SESSION_USER_ID_ITAIPING);
        String id = userId.toString();
        CoreUserDto coreUser = memberLoginService.findById(id);//获取当前用户信息
        model.addAttribute("username", username);
        model.addAttribute("phone", phone);
        model.addAttribute("email", email);
        model.addAttribute("orgScore", organizationApi.findOrganizationById(coreUser.getOrganizationId()).getOrgScore());
        return "member/administrators/addMemberImportInfo";
    }

    @RequestMapping(value = "batchImport", method = RequestMethod.POST)
    public String batchImport(RedirectAttributes attributes, @RequestParam MultipartFile[] infoExcel, HttpServletRequest request) throws IOException {
        Map returnMap = new HashMap();
        //登录的session
        Object userId = request.getSession().getAttribute(GlobalContants.SESSION_USER_ID_ITAIPING);
        String id = userId.toString();
        CoreUserDto coreUser = memberLoginService.findById(id);//获取当前用户信息
        OrganizationDto organization = organizationApi.findOrganizationById(coreUser.getOrganizationId());
        for (MultipartFile excel : infoExcel) {
            if (!excel.isEmpty()) {
                boolean error = false;
                String errorMessage = null;
                try {
                    returnMap = memberCreditsTranApi.batchImport(organization.getId(), excel.getInputStream(), 0);
                    attributes.addFlashAttribute("isImportSuccess", true);
                    attributes.addFlashAttribute("isSuccess", returnMap.get("isSuccess"));
                    attributes.addFlashAttribute("message", returnMap.get("message"));
                    attributes.addFlashAttribute("successCount", returnMap.get("successCount"));
                    attributes.addFlashAttribute("failCount", returnMap.get("failCount"));
                    attributes.addFlashAttribute("failRowCount", returnMap.get("failRowCount"));
                    attributes.addFlashAttribute("successRowCount", returnMap.get("successRowCount"));
                    attributes.addFlashAttribute("scoreCount", returnMap.get("scoreCount"));
                    if (!(Boolean) returnMap.get("isSuccess")) {
                        error = true;
                    }
                } catch (Exception e) {
                    error = true;
                    errorMessage = e.getMessage();
                    if (Lang.isEmpty(errorMessage)) {
                        errorMessage = e.toString();
                    }
                    log.error("导入账号异常", e);
                    attributes.addFlashAttribute("isImportSuccess", true);
                    attributes.addFlashAttribute("isSuccess", false);
                    attributes.addFlashAttribute("message", errorMessage);
                } finally {
                    List<String> errorList = new ArrayList<>();
                    if (returnMap.containsKey("failRowCount")) {
                        errorList.addAll((List<String>) returnMap.get("failRowCount"));
                    }
                    if (!Lang.isEmpty(errorMessage)) {
                        errorList.add(errorMessage);
                        attributes.addFlashAttribute("message", "导入失败");
                        attributes.addFlashAttribute("failRowCount", errorList);
                    }
                    logBatchImport(excel, errorList, error);
                }
            }
        }
        return "redirect:uploadExcel.do";
    }

    private void logBatchImport(MultipartFile multipartFile, List<String> failList, boolean error) {
        InputStream inputStream;
        try {
            inputStream = multipartFile.getInputStream();
            OrganizationBatchOperateLogDTO fileLog = new OrganizationBatchOperateLogDTO();
            fileLog.setBatchNo(UUID.randomUUID().toString());
            SimpleDateFormat format = new SimpleDateFormat("YYYY_MM_DD_HH_mm_ss");
            fileLog.setFilePath(batchImportFolder + format.format(new Date()) + "_" + fileLog.getBatchNo() + ".xls");

            List<List<String>> rows = new ArrayList<>();
            if (!Lang.isEmpty(failList)) {
                for (int i = 0; i < failList.size(); i++) {
                    List<String> cell = new ArrayList<>();
                    cell.add(failList.get(i));
                    rows.add(cell);
                }
            }
            ExcelUtil.readAndWriteData(inputStream, fileLog.getFilePath(), rows, "错误信息");
            //fileLog.setNetFilePath("http://127.0.0.1/file/" + fileLog.getBatchNo());
            fileLog.setOperateStatus(GlobalContants.ResponseStatus.SUCCESS);
            fileLog.setOperateType(PrepaidDepositChangeType.add.getBusinessCode());
            fileLog.setOperateResult(PrepaidDepositChangeType.add.getBusinessSource() + (error ? "失败" : "成功"));
            fileLog.setOrganizationCode(organizationCode);
            ApiResponseVo apiResponseVo = organizationApi.saveOrganizationBatchOperateLog(fileLog);
            log.info("batchImportLog:" + apiResponseVo);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value = {"uploadExcel.do"})
    public String uploadExcel(HttpServletRequest request, Model model) {
        Object memberJson = request.getSession().getAttribute(GlobalContants.SESSION_MEMBER_JSON_ITAIPING);
        MemberDto member = JSON.parseObject(memberJson.toString(), MemberDto.class);
        Object userId = request.getSession().getAttribute(GlobalContants.SESSION_USER_ID_ITAIPING);
        String id = userId.toString();
        CoreUserDto coreUser = memberLoginService.findById(id);//获取当前用户信息
        model.addAttribute("orgScore", organizationApi.findOrganizationById(coreUser.getOrganizationId()).getOrgScore());
        return "member/administrators/addMemberImportInfo";
    }

    @ResponseBody
    @RequestMapping(value = "listExport")
    public void listExport(String username, String phone, String email, String startTime, String endTime, HttpServletResponse response, HttpServletRequest request) throws ParseException {
        long listExpotTime = System.currentTimeMillis();
        SimpleDateFormat dateFormatDay = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat dateFormatSec = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        long getOrganizationTime = System.currentTimeMillis();
        String organizationId = organizationApi.findOrganizationIdByOrgCode(organizationCode);
        String organizationName = organizationApi.findOrganizationNameByOrgCode(organizationCode);
        log.info("获取机构信息耗时 {} 秒", (System.currentTimeMillis() - getOrganizationTime) / 1000F);

        int page = 0;
        int pageSize = 500;
        Long totalPage;

        List<ScoreIncomeDetailDTO> scoreIncomeDetailList = new Vector<>();
        List<CoreUserDto> coreUserList = null;
        List<MemberDto> members = null;
        boolean emptyResult = false;

        //封装积分详情查询参数
        ScoreDetailQueryDTO scoreDetailQueryDTO = new ScoreDetailQueryDTO();
        scoreDetailQueryDTO.setBusiCode(ScoreBusinessType.BUSI_INCOME_AWARD.getBusinessCode());
        scoreDetailQueryDTO.setOrganizationCode(organizationCode);
        if (!Lang.isEmpty(startTime)) {
            scoreDetailQueryDTO.setStartDate(dateFormatDay.parse(startTime));
        }
        if (!Lang.isEmpty(endTime)) {
            endTime += " 23:59:59";
            scoreDetailQueryDTO.setEndDate(dateFormatSec.parse(endTime));
        }

        //查询条件处理
        if (!Lang.isEmpty(username) || !Lang.isEmpty(phone) || !Lang.isEmpty(email)) {
            List<String> scoreAccountIdList = new ArrayList<>();
            //姓名 查member表
            if (!Lang.isEmpty(username)) {
                /*Member memberExample = new Member();
                memberExample.setRealName(username);
                CoreUser coreUserExample = new CoreUser();
                coreUserExample.setUserType(CoreUser.USER_TYPE_MEMBER);
                coreUserExample.setOrganizationId(organization.getId());
                coreUserExample.setErrCount(null);
                coreUserExample.setLoginCount(null);
                coreUserExample.setIsDelete(null);
                if(!Lang.isEmpty(phone) || !Lang.isEmpty(email)) {
                    if(!Lang.isEmpty(phone)) {
                        coreUserExample.setPhone(phone);
                    }
                    if(!Lang.isEmpty(email)) {
                        coreUserExample.setPhone(email);
                    }
                }
                memberExample.setCoreUser(coreUserExample);
                members = memberApi.findMemberByExample(memberExample);*/
                scoreDetailQueryDTO.setNickName(username);
            } else {
                CoreUserSerachVo coreUserSerach = new CoreUserSerachVo();
                coreUserSerach.setPhone(phone);
                coreUserSerach.setEmail(email);
                coreUserSerach.setUserType(CoreUserDto.USER_TYPE_MEMBER);
                coreUserSerach.setOrganizationId(organizationId);
                coreUserSerach.setDelete(null);
                long findCoreUserTimer = System.currentTimeMillis();
                coreUserList = coreUserApi.findCoreUser(coreUserSerach);
                log.info("条件处理查询 CoreUserList 耗时 {} 秒", (System.currentTimeMillis() - findCoreUserTimer) / 1000F);
            }
            if (!Lang.isEmpty(members)) {
                long queryScoreAccountTimer = System.currentTimeMillis();
                for (MemberDto member : members) {
                    //封装积分账号查询参数
                    ScoreAccountRequestDTO scoreAccountRequestDTO = new ScoreAccountRequestDTO();
                    scoreAccountRequestDTO.setOrganizationCode(organizationCode);
                    scoreAccountRequestDTO.setUserId(member.getCoreUser().getId());
                    if (!Lang.isEmpty(phone)) {
                        scoreAccountRequestDTO.setPhone(phone);
                    }
                    if (!Lang.isEmpty(email)) {
                        scoreAccountRequestDTO.setEmail(email);
                    }
                    ScoreAccountDTO scoreAccountDTO = scoreApi.queryScoreAccount(scoreAccountRequestDTO);
                    scoreAccountIdList.add(scoreAccountDTO.getId());
                }
                log.info("条件处理查询 scoreAccountDTO 耗时 {} 秒", (System.currentTimeMillis() - queryScoreAccountTimer) / 1000F);
            } else if (!Lang.isEmpty(coreUserList)) {
                long queryScoreAccountTimer = System.currentTimeMillis();
                for (CoreUserDto cu : coreUserList) {
                    //封装积分账号查询参数
                    ScoreAccountRequestDTO scoreAccountRequestDTO = new ScoreAccountRequestDTO();
                    scoreAccountRequestDTO.setOrganizationCode(organizationCode);
                    scoreAccountRequestDTO.setUserId(cu.getId());
                    if (!Lang.isEmpty(phone)) {
                        scoreAccountRequestDTO.setPhone(phone);
                    }
                    if (!Lang.isEmpty(email)) {
                        scoreAccountRequestDTO.setEmail(email);
                    }
                    ScoreAccountDTO scoreAccountDTO = scoreApi.queryScoreAccount(scoreAccountRequestDTO);
                    scoreAccountIdList.add(scoreAccountDTO.getId());
                }
                log.info("条件处理查询 scoreAccountDTO 耗时 {} 秒", (System.currentTimeMillis() - queryScoreAccountTimer) / 1000F);
            } else if (Lang.isEmpty(username)) {
                emptyResult = true;
            }

            scoreDetailQueryDTO.setScoreAccountIds(scoreAccountIdList);
        }

        long queryScoreIncomeDetaisTime = System.currentTimeMillis();
        if (!emptyResult) {
            // 改用多线程加速查询, 先获得总的数据条数
            scoreDetailQueryDTO.setPage(0);
            scoreDetailQueryDTO.setPageSize(1);
            PageResponseDTO<ScoreIncomeDetailDTO> pageForCount = scoreApi.queryScoreIncomeDetais(scoreDetailQueryDTO);
            Long totalCount = pageForCount.getTotalElements();
            totalPage = totalCount / pageSize;
            if (totalCount % pageSize > 0) {
                totalPage++;
            }
            log.info("导出数据量 {} 条, 单批次查询数量 {} 条, 需查询 {} 次", totalCount, pageSize, totalPage);
            log.info("开始多线程查询积分授予数据...");
            ThreadPoolTaskExecutor threadPoolTaskExecutor = null;
            try {
                threadPoolTaskExecutor = new ThreadPoolTaskExecutor();
                threadPoolTaskExecutor.setCorePoolSize(10);
                threadPoolTaskExecutor.setMaxPoolSize(100);
                threadPoolTaskExecutor.setQueueCapacity(2000);
                threadPoolTaskExecutor.setKeepAliveSeconds(60);
                threadPoolTaskExecutor.setRejectedExecutionHandler(new ThreadPoolExecutor.AbortPolicy());
                threadPoolTaskExecutor.initialize();
                CountDownLatch countDownLatch = new CountDownLatch(totalPage.intValue());
                for (; page < totalPage; page++) {
                    // 参数需要新的实例防止并发问题
                    ScoreDetailQueryDTO scoreDetailQueryDTOTemp = new ScoreDetailQueryDTO();
                    scoreDetailQueryDTOTemp.setBusiCode(ScoreBusinessType.BUSI_INCOME_AWARD.getBusinessCode());
                    scoreDetailQueryDTOTemp.setOrganizationCode(organizationCode);
                    if (!Lang.isEmpty(startTime)) {
                        scoreDetailQueryDTOTemp.setStartDate(dateFormatDay.parse(startTime));
                    }
                    if (!Lang.isEmpty(endTime)) {
                        scoreDetailQueryDTOTemp.setEndDate(dateFormatSec.parse(endTime));
                    }
                    scoreDetailQueryDTOTemp.setPage(page);
                    scoreDetailQueryDTOTemp.setPageSize(pageSize);
                    threadPoolTaskExecutor.execute(() -> {
                        try {
                            PageResponseDTO<ScoreIncomeDetailDTO> scoreIncomeDetailDTOPage = scoreApi.queryScoreIncomeDetais(scoreDetailQueryDTOTemp);
                            scoreIncomeDetailList.addAll(scoreIncomeDetailDTOPage.getContent());
                        } catch (Exception e) {
                            log.error("分页查询积分授予数据异常", e);
                        } finally {
                            countDownLatch.countDown();
                        }
                    });
                }
                // 阻塞线程
                countDownLatch.await();
            } catch (Exception e) {
                log.error("多线程分页查询积分授予异常", e);
            } finally {
                if(!Lang.isEmpty(threadPoolTaskExecutor)) {
                    threadPoolTaskExecutor.shutdown();
                }
            }
            // 重新排序
            scoreIncomeDetailList.sort((scoreIncomeDetail1, scoreIncomeDetail2) -> {
                if (scoreIncomeDetail1.getTransaTime() == null) {
                    return 1;
                }
                if (scoreIncomeDetail2.getTransaTime() == null) {
                    return -1;
                }
                return scoreIncomeDetail2.getTransaTime().compareTo(scoreIncomeDetail1.getTransaTime());
            });
        }

        log.info("分页获取全量积分授予数据耗时 {} 秒", (System.currentTimeMillis() - queryScoreIncomeDetaisTime) / 1000F);

        Map<String, MemberDto> memberDTOMap = new HashMap<>(1);
        List<String> coreUserIds = new ArrayList<>();
        if (!Lang.isEmpty(coreUserList)) {
            coreUserList.forEach(coreUserDto -> {
                if (!Lang.isEmpty(coreUserDto.getId()) && !coreUserIds.contains(coreUserDto.getId())) {
                    coreUserIds.add(coreUserDto.getId());
                }
            });
        } else {
            scoreIncomeDetailList.forEach(scoreIncomeDetailDTO -> {
                if (!Lang.isEmpty(scoreIncomeDetailDTO.getScoreAccount().getUserId()) && !coreUserIds.contains(scoreIncomeDetailDTO.getScoreAccount().getUserId())) {
                    coreUserIds.add(scoreIncomeDetailDTO.getScoreAccount().getUserId());
                }
            });
        }
        if (!Lang.isEmpty(coreUserIds)) {
            long findMembersByCoreUserIdsTime = System.currentTimeMillis();
            memberDTOMap = memberBatchService.findMembersByCoreUserIds(coreUserIds);
            log.info("coreUserIds size {} 批量获取 memberDTO 耗时 {} 秒", coreUserIds.size(), (System.currentTimeMillis() - findMembersByCoreUserIdsTime) / 1000F);
        }

        List<List<String>> rows = new ArrayList<>();
        List<String> header = new ArrayList<>();
        header.add("姓名");
        header.add("公司");
        header.add("手机号");
        header.add("邮箱");
        header.add("身份证");
        header.add("导入时间");
        header.add("积分 (Ct)");
        header.add("积分发放原因");
        rows.add(header);

        //封装页面VO对象
        for (ScoreIncomeDetailDTO scoreIncomeDetailDTO : scoreIncomeDetailList) {
            if (!Lang.isEmpty(members)) {
                for (MemberDto member : members) {
                    CoreUserDto coreUser = member.getCoreUser();
                    if (scoreIncomeDetailDTO.getScoreAccount().getUserId().equals(coreUser.getId())) {
                        List<String> row = new ArrayList<>();
                        row.add(member.getRealName());
                        row.add(organizationName);
                        row.add(coreUser.getPhone());
                        row.add(coreUser.getEmail());
                        row.add(coreUser.getIdCard());
                        row.add(dateFormatSec.format(scoreIncomeDetailDTO.getTransaTime()));
                        row.add(scoreIncomeDetailDTO.getScoreVal());
                        row.add(scoreIncomeDetailDTO.getMemo());

                        rows.add(row);
                        break;
                    }
                }
            } else if (!Lang.isEmpty(coreUserList)) {
                for (CoreUserDto coreUser : coreUserList) {
                    if (coreUser.getId().equals(scoreIncomeDetailDTO.getScoreAccount().getUserId())) {
                        List<String> row = new ArrayList<>();
                        String rowUserName = "";
                        if (memberDTOMap.containsKey(coreUser.getId())) {
                            MemberDto member = memberDTOMap.get(coreUser.getId());
                            rowUserName = member.getRealName();
                        }
                        row.add(rowUserName);
                        row.add(organizationName);
                        row.add(coreUser.getPhone());
                        row.add(coreUser.getEmail());
                        row.add(coreUser.getIdCard());
                        row.add(dateFormatSec.format(scoreIncomeDetailDTO.getTransaTime()));
                        row.add(scoreIncomeDetailDTO.getScoreVal());
                        row.add(scoreIncomeDetailDTO.getMemo());

                        rows.add(row);
                        break;
                    }
                }
            } else {
                List<String> row = new ArrayList<>();
                String rowUserName = "";
                String rowPhone = "";
                String rowEmail = "";
                String rowIdCard = "";
                if (!Lang.isEmpty(scoreIncomeDetailDTO.getScoreAccount().getUserId()) && memberDTOMap.containsKey(scoreIncomeDetailDTO.getScoreAccount().getUserId())) {
                    MemberDto member = memberDTOMap.get(scoreIncomeDetailDTO.getScoreAccount().getUserId());
                    rowUserName = member.getRealName();
                    rowPhone = member.getCoreUser().getPhone();
                    rowEmail = member.getCoreUser().getEmail();
                    rowIdCard = member.getCoreUser().getIdCard();
                }
                row.add(rowUserName);
                row.add(organizationName);
                row.add(rowPhone);
                row.add(rowEmail);
                row.add(rowIdCard);
                row.add(dateFormatSec.format(scoreIncomeDetailDTO.getTransaTime()));
                row.add(scoreIncomeDetailDTO.getScoreVal());
                row.add(scoreIncomeDetailDTO.getMemo());

                rows.add(row);
            }
        }

        // 将文件存到指定位置
        try {
            response.setHeader("Content-disposition", "attachment; filename=" + "Member" + ".xls");
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream out = response.getOutputStream();
            ExcelUtil.createHSSFWorkBook(rows, "Member").write(out);
            out.flush();
            out.close();
        } catch (Exception e) {
            e.printStackTrace();
            log.error("Error", e);
        }

        log.info("积分授予导出 {} 条数据, 耗时 {} 秒",rows.size() - 1, (System.currentTimeMillis() - listExpotTime) / 1000F);
    }

    /**
     * 列表查询
     */
    @ResponseBody
    @RequestMapping(value = "list", method = RequestMethod.POST)
    public Map list(String username, String phone, String email, String startTime, String endTime, Pageable pageable, HttpServletRequest request) throws ParseException {
        Long timeFlag = System.currentTimeMillis();
        Map returnMap = new HashMap();
        SimpleDateFormat dateFormatDay = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat dateFormatSec = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        long getOrganizationTime = System.currentTimeMillis();
        String organizationId = organizationApi.findOrganizationIdByOrgCode(organizationCode);
        String organizationName = organizationApi.findOrganizationNameByOrgCode(organizationCode);
        log.info("获取机构信息耗时 {} 秒", (System.currentTimeMillis() - getOrganizationTime) / 1000F);

        List<CoreUserDto> coreUserList = null;
        List<MemberDto> members = null;
        boolean emptyResult = false;

        //封装积分详情查询参数
        ScoreDetailQueryDTO scoreDetailQueryDTO = new ScoreDetailQueryDTO();
        scoreDetailQueryDTO.setPage(pageable.getPageNumber());
        scoreDetailQueryDTO.setPageSize(pageable.getPageSize());
        scoreDetailQueryDTO.setBusiCode(ScoreBusinessType.BUSI_INCOME_AWARD.getBusinessCode());
        scoreDetailQueryDTO.setOrganizationCode(organizationCode);
        if (!Lang.isEmpty(startTime)) {
            scoreDetailQueryDTO.setStartDate(dateFormatDay.parse(startTime));
        }
        if (!Lang.isEmpty(endTime)) {
            endTime += " 23:59:59";
            scoreDetailQueryDTO.setEndDate(dateFormatSec.parse(endTime));
        }
        //查询条件处理
        if (!Lang.isEmpty(username) || !Lang.isEmpty(phone) || !Lang.isEmpty(email)) {
            List<String> scoreAccountIdList = new ArrayList<>();
            //姓名 查member表
            if (!Lang.isEmpty(username)) {
                /*Member memberExample = new Member();
                memberExample.setRealName(username);
                CoreUser coreUserExample = new CoreUser();
                coreUserExample.setUserType(CoreUser.USER_TYPE_MEMBER);
                coreUserExample.setOrganizationId(organization.getId());
                coreUserExample.setErrCount(null);
                coreUserExample.setLoginCount(null);
                coreUserExample.setIsDelete(null);
                if(!Lang.isEmpty(phone) || !Lang.isEmpty(email)) {
                    if(!Lang.isEmpty(phone)) {
                        coreUserExample.setPhone(phone);
                    }
                    if(!Lang.isEmpty(email)) {
                        coreUserExample.setPhone(email);
                    }
                }
                memberExample.setCoreUser(coreUserExample);
                members = memberApi.findMemberByExample(memberExample);*/
                scoreDetailQueryDTO.setNickName(username);
            } else {
                CoreUserSerachVo coreUserSerach = new CoreUserSerachVo();
                coreUserSerach.setPhone(phone);
                coreUserSerach.setEmail(email);
                coreUserSerach.setUserType(CoreUserDto.USER_TYPE_MEMBER);
                coreUserSerach.setOrganizationId(organizationId);
                coreUserSerach.setDelete(null);
                long findCoreUserTimer = System.currentTimeMillis();
                coreUserList = coreUserApi.findCoreUser(coreUserSerach);
                log.info("条件处理查询 CoreUserList 耗时 {} 秒", (System.currentTimeMillis() - findCoreUserTimer) / 1000F);
            }
            if (!Lang.isEmpty(members)) {
                long queryScoreAccountTimer = System.currentTimeMillis();
                for (MemberDto member : members) {
                    //封装积分账号查询参数
                    ScoreAccountRequestDTO scoreAccountRequestDTO = new ScoreAccountRequestDTO();
                    scoreAccountRequestDTO.setOrganizationCode(organizationCode);
                    scoreAccountRequestDTO.setUserId(member.getCoreUser().getId());
                    if (!Lang.isEmpty(phone)) {
                        scoreAccountRequestDTO.setPhone(phone);
                    }
                    if (!Lang.isEmpty(email)) {
                        scoreAccountRequestDTO.setEmail(email);
                    }
                    ScoreAccountDTO scoreAccountDTO = scoreApi.queryScoreAccount(scoreAccountRequestDTO);
                    scoreAccountIdList.add(scoreAccountDTO.getId());
                }
                log.info("条件处理查询 scoreAccountDTO 耗时 {} 秒", (System.currentTimeMillis() - queryScoreAccountTimer) / 1000F);
            } else if (!Lang.isEmpty(coreUserList)) {
                long queryScoreAccountTimer = System.currentTimeMillis();
                for (CoreUserDto cu : coreUserList) {
                    //封装积分账号查询参数
                    ScoreAccountRequestDTO scoreAccountRequestDTO = new ScoreAccountRequestDTO();
                    scoreAccountRequestDTO.setOrganizationCode(organizationCode);
                    scoreAccountRequestDTO.setUserId(cu.getId());
                    if (!Lang.isEmpty(phone)) {
                        scoreAccountRequestDTO.setPhone(phone);
                    }
                    if (!Lang.isEmpty(email)) {
                        scoreAccountRequestDTO.setEmail(email);
                    }
                    ScoreAccountDTO scoreAccountDTO = scoreApi.queryScoreAccount(scoreAccountRequestDTO);
                    scoreAccountIdList.add(scoreAccountDTO.getId());
                }
                log.info("条件处理查询 scoreAccountDTO 耗时 {} 秒", (System.currentTimeMillis() - queryScoreAccountTimer) / 1000F);
            } else if (Lang.isEmpty(username)) {
                emptyResult = true;
            }

            scoreDetailQueryDTO.setScoreAccountIds(scoreAccountIdList);
        }
        PageResponseDTO<ScoreIncomeDetailDTO> scoreIncomeDetailDTOPage;
        if (!emptyResult) {
            long queryScoreIncomeDetaisTimer = System.currentTimeMillis();
            scoreIncomeDetailDTOPage = scoreApi.queryScoreIncomeDetais(scoreDetailQueryDTO);
            log.info("分页查询查询 scoreIncomeDetailDTOPage 耗时 {} 秒", (System.currentTimeMillis() - queryScoreIncomeDetaisTimer) / 1000F);
        } else {
            scoreIncomeDetailDTOPage = new PageResponseDTO<>(0, (long) 0, new ArrayList<>());
        }

        Map<String, MemberDto> memberDTOMap = new HashMap<>(1);
        List<String> coreUserIds = new ArrayList<>();
        if (!Lang.isEmpty(coreUserList)) {
            coreUserList.forEach(coreUserDto -> {
                if (!Lang.isEmpty(coreUserDto.getId()) && !coreUserIds.contains(coreUserDto.getId())) {
                    coreUserIds.add(coreUserDto.getId());
                }
            });
        } else {
            scoreIncomeDetailDTOPage.getContent().forEach(scoreIncomeDetailDTO -> {
                if (!Lang.isEmpty(scoreIncomeDetailDTO.getScoreAccount().getUserId()) && !coreUserIds.contains(scoreIncomeDetailDTO.getScoreAccount().getUserId())) {
                    coreUserIds.add(scoreIncomeDetailDTO.getScoreAccount().getUserId());
                }
            });
        }
        if (!Lang.isEmpty(coreUserIds)) {
            memberDTOMap = memberBatchService.findMembersByCoreUserIds(coreUserIds);
        }

        //封装页面VO对象
        List<AdminImportVo> adminImportListVoList = new ArrayList<>();
        for (ScoreIncomeDetailDTO scoreIncomeDetailDTO : scoreIncomeDetailDTOPage.getContent()) {
            if (!Lang.isEmpty(members)) {
                for (MemberDto member : members) {
                    CoreUserDto coreUser = member.getCoreUser();
                    if (scoreIncomeDetailDTO.getScoreAccount().getUserId().equals(coreUser.getId())) {
                        AdminImportVo adminImportVo = new AdminImportVo();
                        adminImportVo.setEmail(coreUser.getEmail());
                        adminImportVo.setPhone(coreUser.getPhone());
                        adminImportVo.setTransaTime(dateFormatSec.format(scoreIncomeDetailDTO.getTransaTime()));
                        adminImportVo.setOrganizationName(organizationName);
                        adminImportVo.setScore(scoreIncomeDetailDTO.getScoreVal());
                        adminImportVo.setScoreReason(scoreIncomeDetailDTO.getMemo());
                        adminImportVo.setAdmin(member.getAdmin());
                        adminImportVo.setMemberId(member.getId());
                        adminImportVo.setUserName(member.getRealName());

                        adminImportListVoList.add(adminImportVo);
                        break;
                    }
                }
            } else if (!Lang.isEmpty(coreUserList)) {
                for (CoreUserDto coreUser : coreUserList) {
                    if (coreUser.getId().equals(scoreIncomeDetailDTO.getScoreAccount().getUserId())) {
                        AdminImportVo adminImportVo = new AdminImportVo();
                        adminImportVo.setEmail(coreUser.getEmail());
                        adminImportVo.setPhone(coreUser.getPhone());
                        adminImportVo.setTransaTime(dateFormatSec.format(scoreIncomeDetailDTO.getTransaTime()));
                        adminImportVo.setOrganizationName(organizationName);
                        adminImportVo.setScore(scoreIncomeDetailDTO.getScoreVal());
                        adminImportVo.setScoreReason(scoreIncomeDetailDTO.getMemo());
                        if (memberDTOMap.containsKey(coreUser.getId())) {
                            MemberDto member = memberDTOMap.get(coreUser.getId());
                            adminImportVo.setAdmin(member.getAdmin());
                            adminImportVo.setMemberId(member.getId());
                            adminImportVo.setUserName(member.getRealName());
                        }
                        adminImportListVoList.add(adminImportVo);
                        break;
                    }
                }
            } else {
                AdminImportVo adminImportVo = new AdminImportVo();
                adminImportVo.setTransaTime(dateFormatSec.format(scoreIncomeDetailDTO.getTransaTime()));
                adminImportVo.setOrganizationName(organizationName);
                adminImportVo.setScore(scoreIncomeDetailDTO.getScoreVal());
                adminImportVo.setScoreReason(scoreIncomeDetailDTO.getMemo());
                String userId = scoreIncomeDetailDTO.getScoreAccount().getUserId();
                if (!Lang.isEmpty(userId) && memberDTOMap.containsKey(userId)) {
                    MemberDto memberDTO = memberDTOMap.get(scoreIncomeDetailDTO.getScoreAccount().getUserId());
                    adminImportVo.setEmail(memberDTO.getCoreUser().getEmail());
                    adminImportVo.setPhone(memberDTO.getCoreUser().getPhone());
                    adminImportVo.setAdmin(memberDTO.getAdmin());
                    adminImportVo.setMemberId(memberDTO.getId());
                    adminImportVo.setUserName(memberDTO.getRealName());
                }
                adminImportListVoList.add(adminImportVo);
            }
        }

        Page<AdminImportVo> adminImportVoPage = new PageImpl<>(adminImportListVoList, pageable, adminImportListVoList.size());
        returnMap.put("data", adminImportVoPage);
        returnMap.put("orgName", organizationName);
        returnMap.put("totalPages", scoreIncomeDetailDTOPage.getTotalPages());
        returnMap.put(GlobalContants.ResponseString.STATUS, GlobalContants.ResponseStatus.SUCCESS);
        returnMap.put(GlobalContants.ResponseString.MESSAGE, "数据获取成功");
        log.info("积分授予查询耗时 {} 秒", (System.currentTimeMillis() - timeFlag) / 1000F);
        return returnMap;
    }

    @ResponseBody
    @RequestMapping(value = "getMember.do", method = RequestMethod.POST)
    public Map getMember(String username, String phone, String email, Pageable pageable, HttpServletRequest request) {
        Map returnMap = new HashMap();
        //登录的session
        Object memberJson = request.getSession().getAttribute(GlobalContants.SESSION_MEMBER_JSON_ITAIPING);
        MemberDto member = JSON.parseObject(memberJson.toString(), MemberDto.class);
        Object userId = request.getSession().getAttribute(GlobalContants.SESSION_USER_ID_ITAIPING);
        String id = userId.toString();
        CoreUserDto coreUser = memberLoginService.findById(id);//获取当前用户信息
        OrganizationDto organization = organizationApi.findOrganizationById(coreUser.getOrganizationId());

        CoreUserDto coreUserExp = new CoreUserDto(CoreUserDto.USER_TYPE_MEMBER, organization.getId());
        if (!Lang.isEmpty(username)) {
            coreUserExp.setUsername(username.trim());
        }

        if (!Lang.isEmpty(phone)) {
            coreUserExp.setPhone(phone.trim());
        }
        if (!Lang.isEmpty(email)) {
            coreUserExp.setEmail(email.trim());
        }
        coreUserExp.setErrCount(null);
        coreUserExp.setLoginCount(null);
        coreUserExp.setDisabled(null);
        Page<CoreUserDto> coreUsers = coreUserApi.findByExample(coreUserExp, pageable);
        List<MemberDto> members = memberApi.findByUsers(coreUsers.getContent());
        Page<MemberDto> memberPage;
        memberPage = new PageImpl<MemberDto>(members, pageable, coreUsers.getTotalElements());
//        List<CoreUser> coreUsers = coreUserApi.findByUsernameAndPhoneAndEmail(username.trim(),phone.trim(),email.trim());
//        Page<Member> memberPage = memberApi.findMemberByOrganizationIdAndCoreUsers(member.getCoreUser().getOrganizationId(),coreUsers,pageable);
        returnMap.put("data", memberPage);
        returnMap.put("orgName", organization.getOrgName());
        returnMap.put("totalPages", getTotalPages((int) memberPage.getTotalElements(), pageable.getPageSize()));
        returnMap.put(GlobalContants.ResponseString.STATUS, GlobalContants.ResponseStatus.SUCCESS);
        returnMap.put(GlobalContants.ResponseString.MESSAGE, "数据获取成功");
        return returnMap;
    }

    @RequestMapping(value = "memberDetail.do", method = RequestMethod.GET)

    public String memberDetail(String memberId, String username, String phone, String email, HttpServletRequest request, Model model) {
        /*//登录的session
        Member member = memberApi.findMemberById(memberId);

        MemberCreditsTran memberCreditsTran = null;

        CoreUser coreUser = memberLoginService.findById(member.getCoreUser().getId());//获取当前用户信息
        Organization organization = organizationApi.findOrganizationById(coreUser.getOrganizationId());

        List<MemberCreditsTran> memberCreditsTrans =  memberCreditsTranApi.findByTargetMemberId(member.getId(),null);
        if (memberCreditsTrans.size()>0){
            memberCreditsTran = memberCreditsTrans.get(0);
        }
        model.addAttribute("username",username);
        model.addAttribute("phone",phone);
        model.addAttribute("email",email);
        model.addAttribute("member",member);
        model.addAttribute("coreUser",coreUser);
        model.addAttribute("organization",organization);
        model.addAttribute("memberCreditsTran",memberCreditsTran);*/

        MemberDto member = memberApi.findMemberById(memberId);
        CoreUserDto coreUser = memberLoginService.findById(member.getCoreUser().getId());
        OrganizationDto organization = organizationApi.findOrganizationById(coreUser.getOrganizationId());

        ScoreAccountRequestDTO scoreAccountRequestDTO = new ScoreAccountRequestDTO();
        scoreAccountRequestDTO.setOrganizationCode(organizationCode);
        scoreAccountRequestDTO.setUserId(coreUser.getId());
        ScoreAccountDTO scoreAccountDTO = scoreApi.queryScoreAccount(scoreAccountRequestDTO);

        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        AdminImportVo adminImportVo = new AdminImportVo();
        adminImportVo.setUserName(coreUser.getUsername());
        adminImportVo.setPhone(coreUser.getPhone());
        adminImportVo.setEmail(coreUser.getEmail());
        adminImportVo.setOrganizationName(organization.getOrgName());
        adminImportVo.setScore(scoreAccountDTO.getIncomeScoreVal().subtract(scoreAccountDTO.getExpendedScoreVal()).toString());
        adminImportVo.setIdCard(coreUser.getIdCard());

        List<String> scoreAccountIdList = new ArrayList<>();
        ScoreDetailQueryDTO scoreDetailQueryDTO = new ScoreDetailQueryDTO();
        scoreAccountIdList.add(scoreAccountDTO.getId());
        scoreDetailQueryDTO.setScoreAccountIds(scoreAccountIdList);
        PageResponseDTO<ScoreIncomeDetailDTO> scoreIncomeDetailPage = scoreApi.queryScoreIncomeDetais(scoreDetailQueryDTO);
        for (ScoreIncomeDetailDTO scoreIncomeDetailDTO : scoreIncomeDetailPage.getContent()) {
            adminImportVo.setTransaTime(dateFormat.format(scoreIncomeDetailDTO.getTransaTime()));
            adminImportVo.setScoreReason(scoreIncomeDetailDTO.getMemo());
            break;
        }

        model.addAttribute("adminImportVo", adminImportVo);


        return "member/administrators/adOperaInfoCheck";
    }

    @RequestMapping(value = "memberDelete.do", method = RequestMethod.GET)

    public String memberDelete(String memberId, Integer numberOfElements, Integer currentPage, String username, String phone, String email, Model model) {
        MemberDto member = memberApi.findMemberById(memberId);
        if (Lang.isEmpty(currentPage)) {
            currentPage = 1;
        } else {
            if (numberOfElements == 1 && !Lang.isEmpty(member) && !Lang.isEmpty(member.getCoreUser()) && !member.getCoreUser().getIsDelete()) {
                currentPage = 1;
            }
        }
        model.addAttribute("currentPage", currentPage);
        if (!Lang.isEmpty(username)) {
            model.addAttribute("username", username);
        }
        if (!Lang.isEmpty(phone)) {
            model.addAttribute("phone", phone);
        }
        if (!Lang.isEmpty(email)) {
            model.addAttribute("email", email);
        }

        if (!Lang.isEmpty(member)) {
            if (!Lang.isEmpty(member.getCoreUser())) {
                if (!member.getCoreUser().getIsDelete()) {
                    String organizationId = member.getCoreUser().getOrganizationId();
                    CoreUserDto coreUser = member.getCoreUser();
                    coreUserApi.deleteCoreUserById(coreUser.getId());
                    model.addAttribute("isDeleteSuccess", true);
                    model.addAttribute("orgScore", organizationApi.findOrganizationById(organizationId).getOrgScore());

                    return "member/manager/adOperaCheckScoreView";
                }
            }
        }
        //String organizationId = member.getCoreUser().getOrganizationId();
        model.addAttribute("isDeleteSuccess", false);
        //model.addAttribute("orgScore", organizationApi.findOrganizationById(organizationId).getOrgScore());
        return "member/manager/adOperaCheckScoreView";
        //return "member/administrators/addMemberImportInfo";
    }

    public int getTotalPages(int total, int size) {
        int totalpage = (total + size - 1) / size;
        return totalpage;
    }

    /**
     * 创建表头
     *
     * @param row
     * @param cellStyle
     * @param cell
     */
    private void createCellHead(HSSFRow row, HSSFCellStyle cellStyle, HSSFCell cell) {
        cell.setCellStyle(cellStyle);
        cell.setCellValue("姓名");
        cell = row.createCell(1);
        cell.setCellStyle(cellStyle);
        cell.setCellValue("公司名");
        cell = row.createCell(2);
        cell.setCellStyle(cellStyle);
        cell.setCellValue("手机");
        cell = row.createCell(3);
        cell.setCellStyle(cellStyle);
        cell.setCellValue("邮箱");
        cell = row.createCell(4);
        cell.setCellStyle(cellStyle);
        cell.setCellValue("身份证");
        cell = row.createCell(5);
        cell.setCellStyle(cellStyle);
        cell.setCellValue("积分");
        cell = row.createCell(6);
        cell.setCellStyle(cellStyle);
        cell.setCellValue("积分发放原因");
    }

    /**
     * 创建表内容
     *
     * @param
     * @param cellStyle
     * @param sheet
     */
    private void createCellContent(List<AdminImportVo> adminImportVoList, HSSFCellStyle cellStyle, HSSFSheet sheet) {
        for (int i = 0; i < adminImportVoList.size(); i++) {
            int rowCount = i + 1;
            HSSFRow row = sheet.createRow(rowCount);
            AdminImportVo AdminImportVo = adminImportVoList.get(i);
            HSSFCell theCell = row.createCell(0);
            theCell.setCellStyle(cellStyle);
            theCell.setCellValue(setContentCellValue(AdminImportVo.getUserName()));
            theCell = row.createCell(1);
            theCell.setCellStyle(cellStyle);
            theCell.setCellValue(setContentCellValue(AdminImportVo.getOrganizationName()));
            theCell = row.createCell(2);
            theCell.setCellStyle(cellStyle);
            theCell.setCellValue(setContentCellValue(AdminImportVo.getPhone()));
            theCell = row.createCell(3);
            theCell.setCellStyle(cellStyle);
            theCell.setCellValue(setContentCellValue(AdminImportVo.getEmail()));
            theCell = row.createCell(4);
            theCell.setCellStyle(cellStyle);
            theCell.setCellValue(setContentCellValue(AdminImportVo.getIdCard()));
            theCell = row.createCell(5);
            theCell.setCellStyle(cellStyle);
            theCell.setCellValue(setContentCellValue(AdminImportVo.getScore()));
            theCell = row.createCell(6);
            theCell.setCellStyle(cellStyle);
            theCell.setCellValue(setContentCellValue(AdminImportVo.getScoreReason()));
        }
    }

    /**
     * 设置单元格宽度
     *
     * @param sheet
     */
    private void setContentColumnWidth(HSSFSheet sheet) {
        sheet.setColumnWidth(0, 5000); //姓名
        sheet.setColumnWidth(1, 5000); //公司名
        sheet.setColumnWidth(2, 5000); //手机
        sheet.setColumnWidth(3, 5000); //邮箱
        sheet.setColumnWidth(4, 5000); //身份证
        sheet.setColumnWidth(5, 5000); //积分
        sheet.setColumnWidth(6, 8000); //积分发放原因
    }

    /**
     * 设置单元格样式
     *
     * @param wb
     * @return
     */
    private HSSFCellStyle setContentCellStyle(HSSFWorkbook wb) {
        HSSFCellStyle cellStyle = wb.createCellStyle();
        HSSFFont font = wb.createFont();
        font.setFontName("黑体");
        font.setFontHeightInPoints((short) 10);//设置字体大小
//        font.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);//粗体显示
        cellStyle.setFont(font);
        cellStyle.setBorderBottom(HSSFCellStyle.BORDER_THIN);
        cellStyle.setBorderLeft(HSSFCellStyle.BORDER_THIN);
        cellStyle.setBorderRight(HSSFCellStyle.BORDER_THIN);
        cellStyle.setBorderTop(HSSFCellStyle.BORDER_THIN);
        cellStyle.setAlignment(HSSFCellStyle.ALIGN_CENTER);
        return cellStyle;
    }

    /**
     * 设置单元格内容
     *
     * @param value
     * @return
     */
    private String setContentCellValue(String value) {
        if (Lang.isEmpty(value)) {
            return "";
        } else {
            return value;
        }
    }


    /**
     * 管理员积分扣减
     */
    @RequestMapping(value = "adminSubScore.do", method = RequestMethod.GET)
    public String adminSubScore() {
        return "member/administrators/subScore";
    }

    /**
     * 管理员密码修改
     */
    @RequestMapping("/passwordAdmin.html")
    public String passwordAdmin(Map model) {
        if (!showUpdatepassword) {
            return "redirect:score";
        }
        model.put("showUpdatepassword", showUpdatepassword);
        return "member/administrators/updatePassword";
    }

    @RequestMapping("/updatepassword.json")
    @ResponseBody
    public Map update(HttpServletRequest request, String password, String email) {
        Map returnMap = new HashMap<>();
        if (!(email.indexOf("CTYSP123.com") > 0)) {
            returnMap.put("result", "修改失败，不允许的邮箱用户");
            return returnMap;
        }
        if (!showUpdatepassword) {
            returnMap.put("result", "false");
            return returnMap;
        }
        String newPassword = loginApi.encryptPasswd(password);
        OrganizationDto organization = organizationApi.findOrganizationByOrgCode(organizationCode);

        CoreUserDto coreUser = coreUserApi.findByPhoneOrEmail(email, organization.getId());
        if (coreUser == null) {
            returnMap.put("result", "修改失败，查询不到该用户");
            return returnMap;
        } else {
            coreUser.setPassword(newPassword);
            coreUserApi.saveCoreUser(coreUser);
            returnMap.put("result", "success");
        }
        return returnMap;
    }

    @RequestMapping(value = "subScore", method = RequestMethod.POST)
    @ResponseBody
    public Map subScore(String memberId, String score) {
        if (Integer.parseInt(score) < 0) {
            return null;
        }
        MemberDto member = memberApi.findMemberById(memberId);
        BigDecimal scoreVal = new BigDecimal(score);
        CoreUserDto coreUser = member.getCoreUser();

        ScoreAccountRequestDTO queryScoreAccount = new ScoreAccountRequestDTO();
        queryScoreAccount.setUserId(coreUser.getId());
        queryScoreAccount.setOrganizationCode(organizationCode);
        queryScoreAccount.setEmail(coreUser.getEmail());
        queryScoreAccount.setPhone(coreUser.getPhone());
        ScoreAccountDTO scoreAccountDTO = scoreApi.queryScoreAccount(queryScoreAccount);

        ScoreExpenseDetailRequestDTO request = new ScoreExpenseDetailRequestDTO();
        request.setBusiCode(ScoreBusinessType.BUSI_EXPENSE_ADMIN_DEDUCTION.getBusinessCode());
        request.setBusiSource(ScoreBusinessType.BUSI_EXPENSE_ADMIN_DEDUCTION.getBusinessSource());
        request.setMemo("管理员扣减");
        request.setScoreAccountId(scoreAccountDTO.getId());
        request.setScoreVal(scoreVal);
        request.setTransactionNo(uniqueSequenceNoApi.generateUniqueSequenceNo());
        request.setTransaTime(new Date());
        TransactionResponseDTO transactionResponseDTO = scoreApi.expenseScore(request);
        Map returnMap = new HashMap<>();
        if (("success").equals(transactionResponseDTO.getStatus())) {
            returnMap.put(GlobalContants.ResponseString.STATUS, GlobalContants.ResponseStatus.SUCCESS);
            returnMap.put(GlobalContants.ResponseString.MESSAGE, "积分扣减成功");
            return returnMap;
        } else {
            returnMap.put(GlobalContants.ResponseString.STATUS, GlobalContants.ResponseStatus.ERROR);
            returnMap.put(GlobalContants.ResponseString.MESSAGE, "积分扣减失败");
            return returnMap;
        }
    }
}
