package ctscore.web.controller.member;

import cms.api.OrganizationApi;
import cms.api.dto.OrganizationDto;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import ctscore.web.service.member.MemberLoginService;
import ctscore.web.service.member.UserCenterService;
import member.api.dto.core.CoreUserDto;
import member.api.dto.shop.MemberAddressDto;
import member.api.dto.shop.MemberDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import utils.GlobalContants;
import utils.Lang;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;


/**
 * Created by DRAGON on 2016/12/5.
 * 会员中心 默认页--我的资料
 */
@Controller
public class MemberIndexController {

    final static Logger logger = LoggerFactory.getLogger(MemberIndexController.class);

    @Autowired
    MemberLoginService memberLoginService;
    @Autowired
    UserCenterService userCenterService;

    @MotanReferer(basicReferer = "motanClientBasicConfig")
    private OrganizationApi organizationApi;


    @RequestMapping(value = {"members/index","members/index.html"})
    public String index(HttpServletRequest request, HttpServletResponse response, Map model){
        logger.info("会员中心默认页面");
        //登录的session
        Object userId = request.getSession().getAttribute(GlobalContants.SESSION_USER_ID_ITAIPING);
        Object memberJson = request.getSession().getAttribute(GlobalContants.SESSION_MEMBER_JSON_ITAIPING);
        MemberDto member = JSON.parseObject(memberJson.toString(),MemberDto.class);


        //会员信息
        String id = userId.toString();
        CoreUserDto coreUser = memberLoginService.findById(id);//获取当前用户信息
        coreUser.setPassword(null);
        coreUser.setOld_password(null);
        model.put("user",coreUser);
        model.put("member",member);
        OrganizationDto organization=null;
        if(!Lang.isEmpty(coreUser)){
            organization=organizationApi.findOrganizationById(coreUser.getOrganizationId());
        }
        if(!Lang.isEmpty(organization)) {
            model.put("companyName", organization.getOrgName());
        }


        //会员收货地址
//        model.put("isAdmin",member.getAdmin());//判断是否为管理员账户
        String memberId = member.getId();
        List<MemberAddressDto> memberAddressList = userCenterService.getMyMemberAddress(memberId);

        List<MemberAddressDto> list  =  new ArrayList<MemberAddressDto>();
        List<MemberAddressDto> list0 =  new ArrayList<MemberAddressDto>();
        if(!Lang.isEmpty(memberAddressList)) {
            for (MemberAddressDto memberAddress:memberAddressList){
                if (!Lang.isEmpty(memberAddress.getIsDefault()) && memberAddress.getIsDefault() == true){
                    list.add(memberAddress);
                }else {
                    list0.add(memberAddress);
                }
            }
        }

        list.addAll(list0);

        model.put("addressList",list);

        return "member/index";
    }

    /**
     * 设置默认地址
     * @param request
     * @return
     */
    @RequestMapping(value = "address/setDefault/{addressId}",method = RequestMethod.GET)

    public String setDefaultAddress(HttpServletRequest request,@PathVariable("addressId") String addressId){
        logger.info("设置默认地址...");
        //会员收货地址
        Object memberIdObj =  request.getSession().getAttribute(GlobalContants.SESSION_MEMBER_ID_ITAIPING);
        String memberId = memberIdObj.toString();

        if (Lang.isEmpty(addressId)){
            return "redirect:/member/index";
        }

        try {
            MemberAddressDto memberAddress = userCenterService.setDefaultAddress(memberId,addressId);
            if (Lang.isEmpty(memberAddress)){
                return "redirect:/member/index";
            }
        }catch (Exception ex){
            logger.error("ex:"+ex);
        }


        return "redirect:/members/index";
    }


    /**
     * 删除默认地址
     * @param request
     * @param addressId
     * @return
     */
    @RequestMapping(value = "address/delete",method = RequestMethod.POST)

    @ResponseBody
    public JSONObject deleteAddress(HttpServletRequest request,String addressId){
        logger.info("删除默认地址...");
        JSONObject jsonObject = new JSONObject();

        if (Lang.isEmpty(addressId)){
            jsonObject.put("code","-1");
            jsonObject.put("msg","addressId为空");
            return jsonObject;
        }
        Boolean result = userCenterService.deleteAddressById(addressId);
        if (!result){
            jsonObject.put("code","-1");
            jsonObject.put("msg","addressId为空");
        }

        jsonObject.put("code","0");
        jsonObject.put("msg","删除地址成功");
        return jsonObject;
    }

    /**
     * 添加地址
     * @param request
     * @param address
     * @return
     */
    @RequestMapping(value = "address/add",method = RequestMethod.POST)

    @ResponseBody
    public JSONObject addAddress(HttpServletRequest request,MemberAddressDto address){
        logger.info("添加地址...");

        JSONObject jsonObject = new JSONObject();

        //会员收货地址
        Object memberIdObj =  request.getSession().getAttribute(GlobalContants.SESSION_MEMBER_ID_ITAIPING);
        String memberId = memberIdObj.toString();


        MemberDto tmpMember = userCenterService.findMenberById(memberId);
        if (Lang.isEmpty(tmpMember)){
            jsonObject.put("code","-1");
            jsonObject.put("msg","网络错误");
            return jsonObject;
        }

        logger.info("address:{}",address.toString());

        address.setMember(tmpMember);
        MemberAddressDto memberAddress = userCenterService.addMemberAddress(address);
        if (Lang.isEmpty(memberAddress)){
            jsonObject.put("code","-1");
            jsonObject.put("msg","添加地址失败");
        }

        jsonObject.put("code","0");
        jsonObject.put("msg","添加地址成功");
        return jsonObject;
    }


}
