package ctscore.web.controller.member;


import aftersale.api.QueryAfterSaleDetail;
import aftersale.api.QueryReturnApi;
import aftersale.api.QueryReturnPayApi;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import goods.dto.goods.GoodsPictureDto;
import jd.api.request.aftersale.AuditCancelEntity;
import jd.api.request.aftersale.ServiceDetailInfoEntity;
import jd.api.response.aftersale.AuditCancelResp;
import jd.api.response.aftersale.ServiceDetailInfoResp;
import jd.api.service.aftersale.JdAftersaleApi;
import member.api.dto.shop.MemberAddressDto;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import utils.GlobalContants;
import utils.data.BeanMapper;
import utils.sql.PageVo;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * Created by admin on 2016/10/27.
 */
//退货/返修列表
@Controller
public class MyAfterSaleController {
    @MotanReferer
    QueryReturnApi queryReturnApi;

    @RequestMapping("/myAfterSales")
    public String myAfterSales() {
        return "myMsg/myAfterSales";
    }

    @RequestMapping("/queryReturn")
    @ResponseBody

    public PageVo queryReturn(@RequestParam Map<String, Object> params,HttpServletRequest request) {
        HttpSession session =  request.getSession();
        Object memberId = session.getAttribute(GlobalContants.SESSION_MEMBER_ID_ITAIPING);
        params.put("memberId", memberId);
        // PageVo pageVo = queryReturnApi.queryReturn(params);
        return queryReturnApi.queryReturn(params);
    }
    //退款列表
    @MotanReferer
    QueryReturnPayApi queryReturnPayApi;

    @RequestMapping("queryReturnPay")
    @ResponseBody

    public PageVo queryReturnPay(@RequestParam Map<String, Object> params,HttpServletRequest request){
        HttpSession session =  request.getSession();
        Object memberId = session.getAttribute(GlobalContants.SESSION_MEMBER_ID_ITAIPING);
        params.put("memberId", memberId);
        PageVo pageVo =   queryReturnPayApi.queryReturnPay(params)  ;
        return pageVo;
    }

    //根据服务单号查询详情serviceCode，客户发晕信息SendSkuEntity sendSku
    @MotanReferer
    JdAftersaleApi jdAftersaleApi;
    @MotanReferer
    QueryAfterSaleDetail queryAftersaleDetailApi;
    @RequestMapping("/afterSaleDetail")
    public String afterSaleDetail( String id ,String linkServiceCode , HttpServletRequest request, Map<String, Object> map){
        //获取商品图片信息
        GoodsPictureDto goodsPicture = BeanMapper.map(queryAftersaleDetailApi.queryPic(id),GoodsPictureDto.class);
        //调用京东3.7接口
        List<Integer> list = new ArrayList<Integer>();
        list.add(1);
        list.add(2);
        list.add(3);
        list.add(4);
        list.add(5);
        ServiceDetailInfoEntity serviceDetailInfoEntity = new ServiceDetailInfoEntity(
                Long.parseLong(linkServiceCode), list
        );
        ServiceDetailInfoResp serviceDetailInfoResp = jdAftersaleApi
                .getServiceDetailInfo(serviceDetailInfoEntity);

        List li = serviceDetailInfoResp.getResult().getServiceTrackInfoDTOs();
        // 反转指定列表中元素的顺序
        Collections.reverse(li);
        //获取地址信息
        aftersale.api.dto.MemberAddressDto takeMemberaddress =  queryAftersaleDetailApi.queryAddresstake(id);
        aftersale.api.dto.MemberAddressDto sendMemberaddress =  queryAftersaleDetailApi.queryAddresssend(id);

        map.put("ServiceDetailInfoVO",serviceDetailInfoResp.getResult() );
        map.put("list",li);
        map.put("id",id);
        map.put("linkServiceCode",linkServiceCode);
        map.put("goodsPicture1",goodsPicture);
        map.put("takeMemberaddress",takeMemberaddress);
        map.put("sendMemberaddress",sendMemberaddress);
        return "myMsg/myAfterSalesDetails";

    }
    // 取消售后
    @RequestMapping("/cancelAudit")
    @ResponseBody
    public AuditCancelResp cancelAudit(String linkServiceCode,String id ) {
        // 调用京东3.7接口
        List<Integer> list = new ArrayList<Integer>();
        list.add(1);
        list.add(2);
        list.add(3);
        list.add(4);
        list.add(5);
        ServiceDetailInfoEntity serviceDetailInfoEntity = new ServiceDetailInfoEntity(
                Long.parseLong(linkServiceCode), list
        );
        ServiceDetailInfoResp serviceDetailInfoResp = jdAftersaleApi
                .getServiceDetailInfo(serviceDetailInfoEntity);
        //得到审核意见
        String approveNotes = serviceDetailInfoResp.getResult().getApproveNotes();
        List<Integer> serviceIdList = new ArrayList<Integer>();
        serviceIdList.add((int) Long.parseLong(linkServiceCode));
        //调用京东3.8接口
        AuditCancelResp auditCancelResp = jdAftersaleApi.cancelAudit(new AuditCancelEntity(serviceIdList, approveNotes));
        if (auditCancelResp.getSuccess()== true) {
            queryReturnApi.cancel(id,linkServiceCode);
        } else{

            return auditCancelResp;
        }
        return auditCancelResp;
    }

}


