package ctscore.web.controller.member;

import cart.api.CartApi;
import cms.api.OrganizationApi;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import ctscore.web.service.login.LoginService;
import ctscore.web.service.member.UserCenterService;
import goods.api.SalesPriceRateQueryApi;
import goods.model.repository.GoodsRepos;
import lombok.extern.slf4j.Slf4j;
import member.api.QueryCollectionApi;
import member.api.dto.shop.MemberDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import utils.GlobalContants;
import utils.sql.PageVo;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 我的收藏
 */
@Slf4j
@Controller
@RequestMapping("order")
public class MyCollectionController {

    @MotanReferer
    OrganizationApi organizationApi;

    @MotanReferer
    QueryCollectionApi queryCollectionApi;

    @Autowired
    UserCenterService userCenterService;

    @MotanReferer
    CartApi cartApi;

    /**
     * 几分比例
     */
    @Value("${ctscore.score.proportion}")
    private BigDecimal scorePortion;

    @Autowired
    LoginService loginService;

    @MotanReferer
    SalesPriceRateQueryApi salesPriceRateQueryApi;

    /**
     * 机构代码
     */
    @Value("${ctscore.orgCode}")
    private String organizationCode;

    /**
     * 店铺代码
     */
    @Value("${ctscore.storeCode}")
    private String storeCode;

    @Autowired
    GoodsRepos goodsRepos;

    @RequestMapping("/myCollections")
    public String myCollections() {
        return "member/order/mycollection";
    }

    /**
     * 查询列表
     *
     * @param params
     * @return
     */
    @RequestMapping(value = "/queryCollections", method = {RequestMethod.GET, RequestMethod.POST})

    @ResponseBody
    public PageVo queryCollection(HttpServletRequest request, @RequestParam Map<String, Object> params) {
        Long startTimer = System.currentTimeMillis();
        log.info("### 加载我的收藏开始... ###");
        //登录的session
        Object memberJson = request.getSession().getAttribute(GlobalContants.SESSION_MEMBER_JSON_ITAIPING);
        MemberDto member = JSON.parseObject(memberJson.toString(), MemberDto.class);
        String memberId = member.getId();
        params.put("memberId", memberId);

        long queryFootPrintsTime = System.currentTimeMillis();
        PageVo pageVo = queryCollectionApi.queryCollection(params);
        log.info("查询收藏耗时 {} ms", System.currentTimeMillis() - queryFootPrintsTime);

        int totalPage = getTotalPages(pageVo.getTotalCount(), pageVo.getPageSize());
        pageVo.setTotalCount(totalPage);

        long organizationTime = System.currentTimeMillis();
        String organizationId = organizationApi.findOrganizationIdByOrgCode(organizationCode);
        log.info("查询机构信息耗时 {} ms", System.currentTimeMillis() - organizationTime);

        List<String> goodsIds = new ArrayList<>(pageVo.getResult().size());
        pageVo.getResult().forEach(obj -> {
            Map map = (Map) obj;
            goodsIds.add((String) map.get("GOODID"));
        });

        long batchQuerySalePriceTime = System.currentTimeMillis();
        Map<String, BigDecimal> salePriceMap = salesPriceRateQueryApi.getSaleRatePriceBatchByGoodsIds(goodsIds, storeCode, organizationId);
        log.info("批量查询费率价格耗时 {} ms", System.currentTimeMillis() - batchQuerySalePriceTime);

        pageVo.getResult().forEach(obj -> {
            Map map = (Map) obj;
            String goodsId = (String) map.get("GOODID");
            map.put("SALEPRICE", salePriceMap.get(goodsId));
        });
        
        log.info("### 加载我的收藏总耗时 {} ms ###", System.currentTimeMillis() - startTimer);
        return pageVo;
    }

    /**
     * 删除
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/deleteCollections", method = {RequestMethod.POST, RequestMethod.GET})
    @ResponseBody
    public String deleteCollections(String id) {
        String deleteCollection = queryCollectionApi.deleteCollection(id);
        return null;
    }

    //清空所有的收藏
    @RequestMapping(value = "/removeAll", method = {RequestMethod.POST, RequestMethod.GET})
    @ResponseBody
    public JSONObject removeAllCollection(HttpServletRequest request) {
        log.info("清空我的收藏");
        //登录的session
        Object memberJson = request.getSession().getAttribute(GlobalContants.SESSION_MEMBER_JSON_ITAIPING);
        MemberDto member = JSON.parseObject(memberJson.toString(), MemberDto.class);
        String memberId = member.getId();

        JSONObject jsonObject = new JSONObject();

        MemberDto tmpMember = userCenterService.findMenberById(memberId);

        try {
            int result = queryCollectionApi.deleteByMember(tmpMember);
        } catch (Exception ex) {
            jsonObject.put("code", "-1");
            return jsonObject;
        }

        jsonObject.put("code", "0");
        jsonObject.put("msg", "清空我的足迹");
        return jsonObject;
    }


    /**
     * @param params
     * @return
     */
    @RequestMapping(value = "/collectionToShop", method = {RequestMethod.POST, RequestMethod.GET})
    @ResponseBody
    public Map collectionToShop(@RequestParam Map<String, Object> params) {
        String targetId = "1";
        params.put("targetId", targetId);
        //Map map=queryCollectionApi.collectionToShop(params);
        Map map = new HashMap();
        return map;
    }


    //移至购物车
    @RequestMapping(value = "addCart", method = RequestMethod.POST)
    @ResponseBody

    public Map addCart(@RequestParam Map<String, Object> params, HttpServletRequest request) {
        System.out.println("Requesting /addCart");
        HashMap<String, Object> rsMap = new HashMap<String, Object>();
        rsMap.put(GlobalContants.ResponseString.STATUS, GlobalContants.ResponseStatus.SUCCESS);
        rsMap.put(GlobalContants.ResponseString.DATA, null);
        rsMap.put(GlobalContants.ResponseString.ERROR_CODE, 0);
        rsMap.put(GlobalContants.ResponseString.MESSAGE, "suc");
        rsMap.put("carts", cartApi.getCartSize((String) request.getSession().getAttribute(GlobalContants.SESSION_USER_ID_ITAIPING)));

        String userId = (String) request.getSession().getAttribute(GlobalContants.SESSION_USER_ID_ITAIPING);
        String idsStr = params.get("id").toString();

        rsMap = cartApi.addGoodsToCart(params, userId, rsMap);
        if (rsMap.get("status").equals("success")) {
            try {
                queryCollectionApi.deleteCollection(idsStr);
            } catch (Exception ex) {
                log.error("ex:{}", ex);
            }
        }

        return rsMap;
    }


    public int getTotalPages(int total, int size) {
        int totalpage = (total + size - 1) / size;
        return totalpage;
    }


}

