package ctscore.web.controller.member;

import cms.api.OrganizationApi;
import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import ctscore.web.service.login.LoginService;
import ctscore.web.service.member.UserCenterService;
import goods.api.SalesPriceRateQueryApi;
import goods.dto.goods.GoodsDto;
import goods.model.Goods;
import goods.model.GoodsPicture;
import goods.model.repository.GoodsPictureRepos;
import goods.model.repository.GoodsRepos;
import goods.vo.SalesPriceQueryVo;
import lombok.extern.slf4j.Slf4j;
import member.api.QueryFootprintsApi;
import member.api.dto.shop.MemberDto;
import member.api.dto.shop.MemberViewHisDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import utils.GlobalContants;
import utils.Lang;
import utils.lang.Copys;
import utils.sql.PageVo;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * Created by zfb on 2016/10/17.
 */
@Slf4j
@Controller
@RequestMapping("order")
public class MyFootprintsController {

    @MotanReferer
    QueryFootprintsApi queryFootprintsApi;

    @Autowired
    UserCenterService userCenterService;

    @MotanReferer
    SalesPriceRateQueryApi salesPriceRateQueryApi;

    @Autowired
    LoginService loginService;

    /**
     * 积分比例
     */
    @Value("${ctscore.score.proportion}")
    private BigDecimal scorePortion;

    /**
     * 机构代码
     */
    @Value("${ctscore.orgCode}")
    private String organizationCode;

    /**
     * 店铺代码
     */
    @Value("${ctscore.storeCode}")
    private String storeCode;

    @Autowired
    GoodsRepos goodsRepos;

    @Autowired
    GoodsPictureRepos goodsPictureRepos;

    @MotanReferer
    OrganizationApi organizationApi;

    /**
     * 我的足迹页面
     *
     * @return
     */
    @RequestMapping("/myFootprints")

    public String myFootprints() {
        return "member/order/myFootprints";
    }

    /**
     * 我的足迹页面分页查询
     *
     * @param request
     * @param params
     * @return
     */
    @RequestMapping(value = "/queryFootprints", method = {RequestMethod.GET, RequestMethod.POST})

    @ResponseBody
    public PageVo queryFootprints(HttpServletRequest request, @RequestParam Map<String, Object> params) {
        Long startTimer = System.currentTimeMillis();
        log.info("### 加载我的足迹开始... ###");
        //登录的session
        Object memberJson = request.getSession().getAttribute(GlobalContants.SESSION_MEMBER_JSON_ITAIPING);
        MemberDto member = JSON.parseObject(memberJson.toString(), MemberDto.class);
        String memberId = member.getId();
        params.put("memberId", memberId);

        long queryFootPrintsTime = System.currentTimeMillis();
        PageVo pageVo = queryFootprintsApi.queryFootPrintsNew(params);
        log.info("查询足迹耗时 {} ms", System.currentTimeMillis() - queryFootPrintsTime);

        int totalPage = getTotalPages(pageVo.getTotalCount(), pageVo.getPageSize());
        pageVo.setTotalCount(totalPage);

        long organizationTime = System.currentTimeMillis();
        String organizationId = organizationApi.findOrganizationIdByOrgCode(organizationCode);
        log.info("查询机构信息耗时 {} ms", System.currentTimeMillis() - organizationTime);

        List<String> goodsIds = new ArrayList<>(pageVo.getResult().size());
        pageVo.getResult().forEach(obj -> {
            Map map = (Map) obj;
            goodsIds.add((String) map.get("GOODID"));
        });

        long batchQuerySalePriceTime = System.currentTimeMillis();
        Map<String, BigDecimal> salePriceMap = salesPriceRateQueryApi.getSaleRatePriceBatchByGoodsIds(goodsIds, storeCode, organizationId);
        log.info("批量查询费率价格耗时 {} ms", System.currentTimeMillis() - batchQuerySalePriceTime);

        pageVo.getResult().forEach(obj -> {
            Map map = (Map) obj;
            String goodsId = (String) map.get("GOODID");
            map.put("SALEPRICE", salePriceMap.get(goodsId));
        });

        log.info("### 加载我的足迹总耗时 {} ms ###", System.currentTimeMillis() - startTimer);
        return pageVo;
    }

    @RequestMapping(value = "/deleteFootPrints", method = RequestMethod.POST)
    @ResponseBody
    public String deleteFootPrints(String id) {
        String deleteFootPrint = queryFootprintsApi.deletePrints(id);
        return deleteFootPrint;
    }

    //未实现
    @RequestMapping(value = "/footPrintsToShop", method = RequestMethod.POST)
    @ResponseBody
    public Map FootprintsToShop(@RequestParam Map<String, Object> params) {
        log.info(params.toString());
        //Map map=queryFootprintsApi.FootprintsToShop(params);
        Map map = new HashMap();
        return map;
    }


    @RequestMapping("/clearFootPrints")
    @ResponseBody
    public Map clearFootPrints(HttpSession session) {
        Map map = new HashMap();
        String memberId = (String) session.getAttribute(GlobalContants.SESSION_MEMBER_ID_ITAIPING);
        List<MemberViewHisDto> list = userCenterService.getViewHisByMemberId(memberId);
        userCenterService.clearFootPrints(list);
        map.put(GlobalContants.ResponseString.STATUS, GlobalContants.ResponseStatus.SUCCESS);
        map.put(GlobalContants.ResponseString.MESSAGE, "足迹清空成功");

        return map;
    }


    public int getTotalPages(int total, int size) {
        int totalpage = (total + size - 1) / size;
        return totalpage;
    }

}
