package ctscore.web.controller.member;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import member.api.MyInvoiceApi;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import utils.sql.PageVo;

import java.util.Map;

/**
 * Created by oracle on 2016/11/4.
 */
@Controller
public class MyInvoiceController {

    @MotanReferer
    MyInvoiceApi myInvoiceApi;

    /**
     * 陈圣融
     * 跳转我的发票页面
     * @return
     */
    @RequestMapping("/myBills.html")
    public String myBills() {
        return "myMsg/myBills";
    }

    /**
     * 陈圣融
     * 查询我的发票列表
     * @param map
     * @return
     */
    @RequestMapping("/queryInvoice")
    @ResponseBody
    public PageVo queryInvoce(@RequestParam Map<String, Object> map) {

        return myInvoiceApi.queryInvoce(map);
    }

    /**
     * 陈圣融
     * 跳转我的发票详情页面
     * @param invoiceId
     * @param map
     * @return
     */
    @RequestMapping("/myBillsDetail.html")
    public String tomyBillsDetail(String invoiceId, Map map) {
        Map<String, Object> invoceDetail = myInvoiceApi.queryInvoceDetail(invoiceId);
        map.putAll(invoceDetail);
        return "myMsg/myBillsDetail";
    }


}
