package ctscore.web.controller.member;


import aftersale.api.DiscussApi;
import cart.api.OrderMainApi;
import cart.api.PaymentApi;
import cart.api.dto.order.OrderItemDto;
import cart.api.dto.order.OrderMainDto;
import cart.model.order.OrderItem;
import cart.model.order.OrderMain;
import cart.model.payment.Payment;
import cms.api.OrganizationApi;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import ctscore.api.CtScoreApi;
import ctscore.web.service.member.MemberLoginService;
import ctscore.web.service.member.UserCenterService;
import ctscore.web.vo.EvaluateVo;
import ctscore.web.vo.SpecificationsVo;
import goods.api.ProductFashionApi;
import goods.model.ProductFashion;
import goods.model.ProductFashionSpecification;
import goods.model.ProductStandard;
import goods.model.repository.ProductFashionRepos;
import member.api.QueryOrderApi;
import member.api.dto.core.CoreUserDto;
import member.api.dto.shop.MemberDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import utils.GlobalContants;
import utils.Lang;
import utils.date.DateUtils;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.*;

/**
 * Created by oracle on 2016/10/17.
 */
@Controller
@RequestMapping("order")
public class MyOrderController {

    @MotanReferer
    QueryOrderApi queryOrderApi;

    @MotanReferer
    DiscussApi discussApi;

    @MotanReferer
    OrderMainApi orderMainApi;

    @Autowired
    UserCenterService userCenterService;

    @Autowired
    MemberLoginService memberLoginService;

    @MotanReferer
    CtScoreApi ctScoreApi;

    @MotanReferer
    PaymentApi paymentApi;
    @MotanReferer
    OrganizationApi organizationApi;

    @MotanReferer
    ProductFashionApi productFashionApi;

    @Value("${ctscore.orgCode}")
    private String organizationCode; // 合作企业代码
    final static Logger logger = LoggerFactory.getLogger(MyOrderController.class);


    @Value("${ctscore.score.proportion}")
    private BigDecimal scorePortion;//积分比例
    @Autowired
    private ProductFashionRepos productFashionRepos;

    //我的订单页面
    @RequestMapping("/myOrder.html")

    public String myOrder(Map model) {
        return "member/order/myorder";
    }

    /**
     * 订单查询
     * @param request
     * @return
     */
    @RequestMapping(value = "/queryOrder",method ={RequestMethod.POST,RequestMethod.GET})

    @ResponseBody
    public JSONObject queryOrder(HttpServletRequest request) {
        //登录的session
        Object memberJson = request.getSession().getAttribute(GlobalContants.SESSION_MEMBER_JSON_ITAIPING);
        MemberDto member = JSON.parseObject(memberJson.toString(),MemberDto.class);
        String memberId = member.getId();

        String orderNo = request.getParameter("orderNo");
        String status  = request.getParameter("status");
        List<String> statusList = new ArrayList<>();
        if (Lang.isEmpty(status) &&  status.equals("")){
            for(int i = 1; i<=8;i++){
                statusList.add(i+"");
            }
        }else if(status.equals("1")){
//            statusList.add("0");
            statusList.add("1");
        }else if(status.equals("6")){
            statusList.add(OrderMainDto.order_status_cancel);
            statusList.add(OrderMainDto.order_status_outoftime_cancel);
        }else if(status.equals("2")||status.equals("3")) {
            statusList.add(OrderMainDto.order_status_ounfilled);
            statusList.add(OrderMainDto.order_status_notdeliver);
        }else{
            statusList.add(status);
        }

        String startTime  = request.getParameter("startTime");
        String endTime    = request.getParameter("endTime");
        Date startDate = null;
        Date endDate   = null;
        if (!Lang.isEmpty(startTime) && !Lang.isEmpty(endTime)){
            try {
                startDate = DateUtils.parseToDate(startTime,"yyyy-MM-dd HH:mm:ss");
                endDate = DateUtils.parseToDate(endTime,"yyyy-MM-dd HH:mm:ss");
            } catch (ParseException e) {
                e.printStackTrace();
            }
        }else{//默认3个月前
            endDate =  DateUtils.getNow();
            Calendar cal = Calendar.getInstance();
            cal.setTime(endDate);
            cal.add(Calendar.MONTH,-3);
            startDate = cal.getTime();
        }

        Integer pageIndex = 0;
        Integer pageSize  = 10;
        String page = request.getParameter("pageIndex");
        if (!Lang.isEmpty(page)){
            pageIndex = Integer.parseInt(page);
        }
        String size = request.getParameter("pageSize");
        if (!Lang.isEmpty(page)){
            pageSize = Integer.parseInt(size);
        }
        List<Sort.Order> orderList = new ArrayList<>(); //排序列表
        Sort.Order order =new Sort.Order(Sort.Direction.DESC,"dateCreated");
        orderList.add(order);
        Sort sort =new Sort(orderList);
        Pageable pageable = new PageRequest(pageIndex,pageSize,sort);

        long getOrderInfoTime = System.currentTimeMillis();
        JSONObject jsonObject = userCenterService.findUserCenterOrders(orderNo.trim(),statusList,memberId,startDate,endDate,pageable);
        logger.info("获取订单列表数据耗时 {} ms", System.currentTimeMillis() - getOrderInfoTime);
        return jsonObject;
    }

    //查询订单详情
    @RequestMapping(value = "/myOrder/detail/{orderNo}",method = RequestMethod.GET)

    public String orderDetail(Map map, @PathVariable("orderNo")  String orderNo, Map<String,Object> model, HttpServletRequest request) {
        String memberId=(String)request.getSession().getAttribute(GlobalContants.SESSION_MEMBER_ID_ITAIPING);
        if (Lang.isEmpty(orderNo)|| Lang.isEmpty(memberId)){
            return "member/order/myorder";
        }
        model.put("scorePortion",scorePortion);
        logger.info("scorePortion:{}",scorePortion);

        long getOrderInfoTime = System.currentTimeMillis();
        JSONObject jsonObject = userCenterService.findOrderDetailByOrderNo(orderNo,memberId);
        logger.info("获取订单详情数据耗时 {} ms", System.currentTimeMillis() - getOrderInfoTime);
        model.put("orderInfo",jsonObject);

        //logger.info(JSON.toJSONString(jsonObject));
        return "member/order/myOrderDetails";
    }

    //订单详情页商品分页
    @RequestMapping(value = "/myOrder/detail/items/page",method = {RequestMethod.POST,RequestMethod.GET})
    @ResponseBody
    public JSONObject oderItemsPage(HttpServletRequest request, int pageIndex, int pageSize){
        long methodStar = System.currentTimeMillis();
        logger.info("### 开始加载订单详情数据... ###");

        JSONObject jsonObject = new JSONObject();
        pageSize = pageSize==0?10:pageSize;

        String orderNo = request.getParameter("orderNo");
        if (Lang.isEmpty(orderNo)){
            jsonObject.put("code","-1");
            jsonObject.put("mes","订单号为空");
        }
        Pageable pageable = new PageRequest(pageIndex,pageSize);
        long getOrderInfoTime = System.currentTimeMillis();
        jsonObject = userCenterService.findOrderItemsPageByOrderNo(pageable,orderNo);
        logger.info("获取订单数据耗时 {} ms", System.currentTimeMillis() - getOrderInfoTime);
        //jsonObject.get("orderList").get(0).get("tmpList").get(0).get("ITEM")

        // 2018-01 加载商品规格属性
        long getProductSpecifications = System.currentTimeMillis();
        Map<String, Object> specificationsMap = new HashMap<>();
        List<Map<String, Object>> orderList = (List<Map<String, Object>>) jsonObject.get("orderList");
        for (Map<String, Object> oneOrder : orderList) {
            List<Map<String, Object>> tmpList = (List<Map<String, Object>>) oneOrder.get("tmpList");
            for (Map<String, Object> tem: tmpList) {
                OrderItemDto orderItem = (OrderItemDto) tem.get("ITEM");
                ProductFashion productFashion = productFashionRepos.findOne(orderItem.getProductFashId());
                // 商品规格可能为空
                if(!Lang.isEmpty(productFashion.getProductFashionSpecifications())) {
                    List<SpecificationsVo> specificationsVos = new ArrayList<>();
                    // 根据规格CODE找到显示名称
                    if(!Lang.isEmpty(productFashion.getProduct()) && !Lang.isEmpty(productFashion.getProduct().getProductStandards())) {
                        productFashion.getProduct().getProductStandards().sort((productStandard1, productStandard2)->{
                            if(Lang.isEmpty(productStandard1) || Lang.isEmpty(productStandard1.getShowIndex())) {
                                return -1;
                            }
                            if(Lang.isEmpty(productStandard2) || Lang.isEmpty(productStandard2.getShowIndex())) {
                                return 1;
                            }
                            return productStandard1.getShowIndex() > productStandard2.getShowIndex() ? 1 : -1;
                        });
                        for (ProductStandard productStandard : productFashion.getProduct().getProductStandards()) {
                            // 找到有效规格数据
                            for (ProductFashionSpecification productFashionSpecification : productFashion.getProductFashionSpecifications()) {
                                if(!productStandard.getIsDelete() && productStandard.getStandardCode().equals(productFashionSpecification.getStandardCode())) {
                                    if(!Lang.isEmpty(productFashionSpecification.getIsDelete()) && !productFashionSpecification.getIsDelete()) {
                                        SpecificationsVo specificationsVo = new SpecificationsVo(productStandard.getName(), productFashionSpecification.getValue());
                                        specificationsVos.add(specificationsVo);
                                        break;
                                    }
                                }
                            }
                        }
                    }
                    specificationsMap.put(orderItem.getGoodsId(), specificationsVos);
                }
            }
        }
        logger.info("获取商品规格耗时 {} ms", System.currentTimeMillis() - getProductSpecifications);
        jsonObject.put("specificationsMap", specificationsMap);

        logger.info("### 加载订单详情数据总耗时 {} ms ###", System.currentTimeMillis() - methodStar);
        return jsonObject;
    }


    //订单评价
    @RequestMapping(value = "/myOrder/evaluate/discuss",method = RequestMethod.POST)

    @ResponseBody
    public JSONObject discuss(HttpServletRequest request,@RequestBody EvaluateVo[] evaluateVos) {
        //登录的session
        Object memberJson = request.getSession().getAttribute(GlobalContants.SESSION_MEMBER_JSON_ITAIPING);
        MemberDto member = JSON.parseObject(memberJson.toString(),MemberDto.class);
        String memberId = member.getId();
        Object userId = request.getSession().getAttribute(GlobalContants.SESSION_USER_ID_ITAIPING);


        //会员信息
        String id = userId.toString();
        CoreUserDto coreUser = memberLoginService.findById(id);//获取当前用户信息
        String organizationId = coreUser.getOrganizationId();
        String realName = member.getRealName();

        Boolean result  = userCenterService.saveDisscuccs(evaluateVos,memberId,organizationId,realName);
        JSONObject jsonObject = new JSONObject();
        if (result){
            jsonObject.put("code","0");
            jsonObject.put("msg","评论成功");

            if(evaluateVos.length > 0){
                String orderNo = evaluateVos[0].getOrderNo();
                //修改订单状态为已完成
                OrderMainDto orderMain = orderMainApi.findByOrderNo(orderNo);
                if (!Lang.isEmpty(orderMain)){
                    orderMain.setStatus(OrderMainDto.order_status_finish);
                    orderMainApi.saveOrder(orderMain);
                }
            }
        }else {
            jsonObject.put("code","-1");
            jsonObject.put("msg","评论失败");
        }
        return jsonObject;
    }


    //订单评价页面
    @RequestMapping("/myOrder/evaluate/{orderNo}")

    public String toDiscuss(@PathVariable("orderNo") String orderNo, Map map) {
        map.put("orderNo",orderNo);
        try {
            JSONObject jsonObject = userCenterService.findDisscussByOrderNo(orderNo);
            map.put("orderInfo",jsonObject);
        }catch (Exception ex){
            logger.error("ex:+"+ex);
        }
        return "member/order/myOrderEvaluate";
    }


    /**
     * 陈圣融
     * 确认收货
     *
     * @return
     */
    @RequestMapping("/sureGet")
    @ResponseBody
    public String sureGet(String orderId) {
        try {
            queryOrderApi.sureGetService(orderId);
        }catch (Exception ex){
            logger.info("ex"+ex);
            return "faile";
        }
        return "success";
    }

    //取消订单
    @RequestMapping("/cancelOrder")
    @ResponseBody
    public JSONObject cancelOrder(String orderNo) {
        JSONObject jsonObject = new JSONObject();
        try {
            orderMainApi.cancelOrder(orderNo, OrderMainApi.CancelOrderType.USER);
            jsonObject.put("code","0");
            jsonObject.put("msg","取消订单成功");
        }catch (Exception ex){
            logger.error("取消订单，异常信息",ex);
            jsonObject.put("code","-1");
            jsonObject.put("msg","取消订单失败");
        }
        return jsonObject;
    }
}
