package ctscore.web.controller.member;

import cart.api.OrderMainApi;
import cart.api.PaymentApi;
import cart.api.dto.order.OrderItemDto;
import cart.api.dto.order.OrderMainDto;
import cart.model.order.OrderMain;
import cart.model.order.specification.OrderMainSpecification;
import cart.model.payment.Payment;
import cart.model.repository.order.OrderRepos;
import cart.model.repository.payment.PaymentRepos;
import cms.api.OrganizationApi;
import cms.api.dto.OrganizationDto;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import ctscore.web.service.member.MemberLoginService;
import ctscore.web.service.member.UserCenterService;
import ctscore.web.vo.OrderQueryVo;
import lombok.extern.slf4j.Slf4j;
import member.api.CoreUserApi;
import member.api.MemberApi;
import member.api.dto.core.CoreUserDto;
import member.api.dto.shop.MemberDto;
import member.model.repository.member.MemberRepos;
import member.model.shop.Member;
import org.apache.poi.hssf.usermodel.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.*;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import utils.GlobalContants;
import utils.Lang;
import utils.date.DateUtils;
import utils.excel.ExcelUtil;
import utils.lang.Copys;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;

/**
 * Created by DixonLim on 2016/12/14.
 */

@Slf4j
@Controller
@RequestMapping("orderQuery")
public class OrderQueryController {

    @MotanReferer(basicReferer = "motanClientBasicConfig")
    OrderMainApi orderMainApi;

    @Autowired
    OrderRepos orderRepos;

    @MotanReferer(basicReferer = "motanClientBasicConfig")
    MemberApi memberApi;

    @Autowired
    MemberRepos memberRepos;

    @MotanReferer(basicReferer = "motanClientBasicConfig")
    CoreUserApi coreUserApi;

    @MotanReferer(basicReferer = "motanClientBasicConfig")
    OrganizationApi organizationApi;

    @MotanReferer(basicReferer = "motanClientBasicConfig")
    PaymentApi paymentApi;

    @Autowired
    PaymentRepos paymentRepos;

    @Autowired
    UserCenterService userCenterService;
    @Autowired
    MemberLoginService memberLoginService;

    @Value("${ctscore.score.proportion}")
    private BigDecimal scorePortion;//积分比例

    @RequestMapping(value = {"", "index.do", "index.htm"}, method = RequestMethod.GET)

    public String index(HttpServletRequest request, Model model, String orderName, String orderNo, String status, String startTime, String endTime) {
        //登录的session
        Object memberJson = request.getSession().getAttribute(GlobalContants.SESSION_MEMBER_JSON_ITAIPING);
        MemberDto member = JSON.parseObject(memberJson.toString(), MemberDto.class);
        model.addAttribute("orderName", orderName);
        model.addAttribute("orderNo", orderNo);
        model.addAttribute("status", status);
        model.addAttribute("startTime", startTime);
        model.addAttribute("endTime", endTime);
        return "member/administrators/adOperaCheckOrder";
    }

    @RequestMapping(value = "exportOrder.do")
    @ResponseBody
    public void exportOrder(String orderName, String orderNo, String status, String startTime, String endTime, Pageable pageable, HttpServletRequest request, HttpServletResponse response) {
        log.info("管理员-订单列表导出开始...");
        long methodStart = System.currentTimeMillis();
        //登录的session
        Object userId = request.getSession().getAttribute(GlobalContants.SESSION_USER_ID_ITAIPING);
        String id = userId.toString();

        // 获取当前用户信息
        long getCoreUserTime = System.currentTimeMillis();
        CoreUserDto coreUser = memberLoginService.findById(id);
        log.info("获取 coreUser 耗时 {} ms", System.currentTimeMillis() - getCoreUserTime);

        // 获取机构信息
        long getOrganizationTime = System.currentTimeMillis();
        OrganizationDto organization = organizationApi.findOrganizationById(coreUser.getOrganizationId());
        log.info("获取 organization 耗时 {} ms", System.currentTimeMillis() - getOrganizationTime);

        List<String> statusList = new ArrayList<>();
        List<String> memberIdsList = new ArrayList<>();
        Date startTimeDate;
        Date endTimeDate;
        if (!Lang.isEmpty(orderName)) {
            long memberListTime = System.currentTimeMillis();
            List<MemberDto> memberList = memberApi.findByRealNameLikeAndOrganization("%" + orderName + "%", organization.getId());
            log.info("条件处理 [下单人] 查询耗时 {} ms", System.currentTimeMillis() - memberListTime);
            if (memberList.size() > 0) {
                for (int i = 0; i < memberList.size(); i++) {
                    MemberDto theMember = memberList.get(i);
                    if (!Lang.isEmpty(theMember)) {
                        memberIdsList.add(theMember.getId());
                    }
                }
            } else {
                memberIdsList.add("0");
            }
        } else {
            memberIdsList = null;
        }

        if ("0".equals(ORDER_STATUS_STRING.get(status))) {
            statusList.add("1");
            statusList.add("2");
            statusList.add("3");
            statusList.add("4");
            statusList.add("5");
            statusList.add("6");
            statusList.add("7");
            statusList.add("8");
        } else if ("6".equals(ORDER_STATUS_STRING.get(status))) {
            statusList.add("6");
            statusList.add("8");
        } else if ("2".equals(ORDER_STATUS_STRING.get(status)) || "3".equals(ORDER_STATUS_STRING.get(status))){
            statusList.add("2");
            statusList.add("3");
        } else if("5".equals(ORDER_STATUS_STRING.get(status))) {
            statusList.add("4");
            statusList.add("5");
        } else {
            if(!Lang.isEmpty(ORDER_STATUS_STRING.get(status))) {
                statusList.add(ORDER_STATUS_STRING.get(status));
            }
        }
        if(Lang.isEmpty(statusList)) {
            statusList.add("0000");
        }

        if (Lang.isEmpty(startTime)) {
            startTimeDate = DateUtils.strToDateLong("2000-01-01 00:00:00");
        } else {
            startTimeDate = DateUtils.strToDateLong(startTime + " 00:00:00");
        }

        if (Lang.isEmpty(endTime)) {
            endTimeDate = DateUtils.strToDateLong(DateUtils.getNowDateString() + " 23:59:59");
        } else {
            endTimeDate = DateUtils.strToDateLong(endTime + " 23:59:59");
        }

        List<List<String>> rows = new ArrayList<>();
        List<String> header = new ArrayList<>();
        header.add("下单人");
        header.add("公司");
        header.add("订单号");
        header.add("下单积分 (Ct)");
        header.add("下单金额 (元)");
        header.add("订单状态");
        header.add("下单时间");
        rows.add(header);

        Long queryOrderTimer = System.currentTimeMillis();

        OrderMain orderMainQuery = new OrderMain();
        orderMainQuery.setOrganizationId(coreUser.getOrganizationId());
        orderMainQuery.setOrderNo(Lang.isEmpty(orderNo) ? orderNo : orderNo.trim());
        OrderMainSpecification<OrderMain> orderMainSpecification = new OrderMainSpecification<>(orderMainQuery);
        orderMainSpecification.setCreateTiemStart(startTimeDate);
        orderMainSpecification.setCreateTiemEnd(endTimeDate);
        orderMainSpecification.setMemberIds(memberIdsList);
        orderMainSpecification.setStatus(statusList);

        List<OrderMainDto> orderMainDTOs = new ArrayList<>();
        int page = 0;
        int pageSize = 100;

        long countTime = System.currentTimeMillis();
        Long total = orderRepos.count(orderMainSpecification);
        log.info("获取全量数据条数耗时 {} ms", System.currentTimeMillis() - countTime);

        int totalPage = total.intValue() / pageSize;
        if(total.intValue() % pageSize > 0) {
            totalPage++;
        }
        Map<Integer, List<OrderMain>> pageOrderMainMap = new ConcurrentHashMap<>();
        ThreadPoolTaskExecutor threadPoolTaskExecutor = null;
        try {
            threadPoolTaskExecutor = new ThreadPoolTaskExecutor();
            threadPoolTaskExecutor.setCorePoolSize(10);
            threadPoolTaskExecutor.setMaxPoolSize(100);
            threadPoolTaskExecutor.setQueueCapacity(2000);
            threadPoolTaskExecutor.setKeepAliveSeconds(60);
            threadPoolTaskExecutor.setRejectedExecutionHandler(new ThreadPoolExecutor.AbortPolicy());
            threadPoolTaskExecutor.initialize();
            CountDownLatch countDownLatch = new CountDownLatch(totalPage);
            Sort sort = new Sort(Sort.Direction.DESC, "createTime");
            for (; page < totalPage; page++) {
                int currentPage = page;
                threadPoolTaskExecutor.execute(() -> {
                    try {
                        Pageable thisPage = new PageRequest(currentPage, pageSize, sort);
                        Page<OrderMain> orderMainPage = orderRepos.findAll(orderMainSpecification, thisPage);
                        pageOrderMainMap.put(currentPage, orderMainPage.getContent());
                    } catch (Exception e) {
                        log.error("分页查询订单数据异常", e);
                    } finally {
                        countDownLatch.countDown();
                    }
                });
            }
            // 阻塞线程
            countDownLatch.await();
        } catch (Exception e) {
            log.error("多线程查询订单数据异常", e);
        } finally {
            if(!Lang.isEmpty(threadPoolTaskExecutor)) {
                threadPoolTaskExecutor.shutdown();
            }
        }

        // 按顺序汇总
        List<OrderMain> orderMainPOs = new ArrayList<>();
        for (int i = 0; i < pageOrderMainMap.size(); i++) {
            orderMainPOs.addAll(pageOrderMainMap.get(i));
        }

        Copys copys = Copys.create();
        orderMainPOs.forEach(orderMainPO -> {
            OrderMainDto orderMainDTO = new OrderMainDto();
            orderMainPO.setSubOrders(null);
            orderMainPO.setOrderGifts(null);
            orderMainPO.setOrderAttrs(null);
            orderMainPO.setOrderMainCoupons(null);
            copys.from(orderMainPO).excludes("orderItems", "subOrders", "orderGifts", "orderAttrs").to(orderMainDTO).clear();
            orderMainDTOs.add(orderMainDTO);
        });

        log.info("查询订单数据耗时 {} ms", (System.currentTimeMillis() - queryOrderTimer) / 1000.0);

        int batchSize = 500;
        int start;
        int end = 0;
        int allSize;
        int allPage;
        List<List<String>> idsList = new ArrayList<>();

        long memberFindOneTime= System.currentTimeMillis();
        List<String> memberIds = orderMainDTOs.stream().map(OrderMainDto::getMemberId).distinct().collect(Collectors.toList());
        allSize = memberIds.size();
        allPage = allSize / batchSize;
        if(allSize % batchSize > 0) {
            allPage++;
        }
        for(int i = 0; i < allPage; i++){
            start = i * batchSize;
            end = end + batchSize > memberIds.size() ? memberIds.size() : end + batchSize;
            idsList.add(memberIds.subList(start, end));
        }

        Vector<Member> memberVector = new Vector<>();
        idsList.parallelStream().forEach(ids -> {
            List<Member> memberPOs = memberRepos.findByIdIn(ids);
            memberVector.addAll(memberPOs);
        });

        Map<String, String> memberIdNameMap =  memberVector.stream().collect(Collectors.toMap(Member::getId, Member::getRealName));
        log.info("获取下单人名称 {} 条数据, 耗时 {} ms", memberIdNameMap.size(), System.currentTimeMillis() - memberFindOneTime);

        long findPaymentTime = System.currentTimeMillis();
        List<String> paymentIds = orderMainDTOs.stream().map(OrderMainDto::getPaymentId).distinct().collect(Collectors.toList());

        idsList.clear();
        allSize = paymentIds.size();
        allPage = allSize / batchSize;
        if(allSize % batchSize > 0) {
            allPage++;
        }
        end = 0;
        for(int i = 0; i < allPage; i++){
            start = i * batchSize;
            end = end + batchSize > paymentIds.size() ? paymentIds.size() : end + batchSize;
            idsList.add(paymentIds.subList(start, end));
        }

        Vector<Payment> vector = new Vector<>();
        idsList.parallelStream().forEach(ids -> {
            List<Payment> paymentPOs = paymentRepos.findByIdIn(ids);
            vector.addAll(paymentPOs);
        });

        Map<String, Payment> paymentIdMap =  vector.stream().collect(Collectors.toMap(Payment::getId, payment -> payment));
        log.info("查询 payment {} 条数据, 耗时 {} ms", paymentIdMap.size(), System.currentTimeMillis() - findPaymentTime);

        for (OrderMainDto orderMainDTO : orderMainDTOs) {
            List<String> row = new ArrayList<>();
            String rowRealName = "";
            if (!Lang.isEmpty(memberIdNameMap.get(orderMainDTO.getMemberId()))) {
                rowRealName = memberIdNameMap.get(orderMainDTO.getMemberId());
            }
            row.add(rowRealName);
            row.add(organization.getOrgName());
            row.add(orderMainDTO.getOrderNo());

            String orderPrice = "0";
            String orderScore = "0";
            if (!Lang.isEmpty(orderMainDTO.getScore()) || !Lang.isEmpty(orderMainDTO.getPaymentId())) {
                if (!Lang.isEmpty(orderMainDTO.getPaymentId())) {
                    if (!Lang.isEmpty(paymentIdMap.get(orderMainDTO.getPaymentId()).getScore())) {
                        orderScore = paymentIdMap.get(orderMainDTO.getPaymentId()).getScore().toString();
                    }
                    orderPrice = paymentIdMap.get(orderMainDTO.getPaymentId()).getMoney().toString();
                }
            }
            row.add(orderScore);
            row.add(orderPrice);
            row.add(OrderMainDto.order_status.get(orderMainDTO.getStatus()));
            row.add(DateUtils.dateToStrLong(orderMainDTO.getDateCreated()));

            rows.add(row);
        }
        try {
            response.setHeader("Content-disposition", "attachment; filename=" + "Order" + ".xls");
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream out = response.getOutputStream();
            ExcelUtil.createHSSFWorkBook(rows, "Order").write(out);
            out.flush();
            out.close();
        } catch (Exception e) {
            e.printStackTrace();
            log.error("Error", e);
        }
        log.info("管理员-订单导出 {} 条数据, 耗时 {} ms", orderMainDTOs.size(), System.currentTimeMillis() - methodStart);
    }

    @RequestMapping(value = "getOrder.do", method = RequestMethod.POST)
    @ResponseBody
    public Map getOrder(String orderName, String orderNo, String status, String startTime, String endTime, Pageable pageable, HttpServletRequest request) {
        log.info("管理员-订单列表查询开始...");
        long methodStart = System.currentTimeMillis();
        Map returnMap = new HashMap();
        //登录的session
        pageable = new PageRequest(pageable.getPageNumber(), pageable.getPageSize(), new Sort(Sort.Direction.DESC, "createTime"));
        Object userId = request.getSession().getAttribute(GlobalContants.SESSION_USER_ID_ITAIPING);
        String id = userId.toString();

        // 获取当前用户信息
        long getCoreUserTime = System.currentTimeMillis();
        CoreUserDto coreUser = memberLoginService.findById(id);
        log.info("获取 coreUser 耗时 {} ms", System.currentTimeMillis() - getCoreUserTime);

        // 获取机构信息
        long getOrganizationTime = System.currentTimeMillis();
        OrganizationDto organization = organizationApi.findOrganizationById(coreUser.getOrganizationId());
        log.info("获取 organization 耗时 {} ms", System.currentTimeMillis() - getOrganizationTime);

        List<String> statusList = new ArrayList<>();
        List<String> memberIdsList = new ArrayList<>();
        Date startTimeDate;
        Date endTimeDate;
        if (!Lang.isEmpty(orderName)) {
            long memberListTime = System.currentTimeMillis();
            List<MemberDto> memberList = memberApi.findByRealNameLikeAndOrganization("%" + orderName + "%", organization.getId());
            log.info("条件处理 [下单人] 查询耗时 {} ms", System.currentTimeMillis() - memberListTime);
            if (memberList.size() > 0) {
                for (int i = 0; i < memberList.size(); i++) {
                    MemberDto theMember = memberList.get(i);
                    if (!Lang.isEmpty(theMember)) {
                        memberIdsList.add(theMember.getId());
                    }
                }
            } else {
                memberIdsList.add("0");
            }
        } else {
            memberIdsList = null;
        }

        if ("0".equals(ORDER_STATUS_STRING.get(status))) {
            statusList.add("1");
            statusList.add("2");
            statusList.add("3");
            statusList.add("4");
            statusList.add("5");
            statusList.add("6");
            statusList.add("7");
            statusList.add("8");
        } else if ("6".equals(ORDER_STATUS_STRING.get(status))) {
            statusList.add("6");
            statusList.add("8");
        } else if ("2".equals(ORDER_STATUS_STRING.get(status)) || "3".equals(ORDER_STATUS_STRING.get(status))){
            statusList.add("2");
            statusList.add("3");
        } else if("5".equals(ORDER_STATUS_STRING.get(status))) {
            statusList.add("4");
            statusList.add("5");
        } else {
            if(!Lang.isEmpty(ORDER_STATUS_STRING.get(status))) {
                statusList.add(ORDER_STATUS_STRING.get(status));
            }
        }
        if(Lang.isEmpty(statusList)) {
            statusList.add("0000");
        }

        if (Lang.isEmpty(startTime)) {
            startTimeDate = DateUtils.strToDateLong("2000-01-01 00:00:00");
        } else {
            startTimeDate = DateUtils.strToDateLong(startTime + " 00:00:00");
        }

        if (Lang.isEmpty(endTime)) {
            endTimeDate = DateUtils.strToDateLong(DateUtils.getNowDateString() + " 23:59:59");
        } else {
            endTimeDate = DateUtils.strToDateLong(endTime + " 23:59:59");
        }

        Long queryOrderTimer = System.currentTimeMillis();

        OrderMain orderMainQuery = new OrderMain();
        orderMainQuery.setOrganizationId(coreUser.getOrganizationId());
        orderMainQuery.setOrderNo(orderNo.trim());
        OrderMainSpecification<OrderMain> orderMainSpecification = new OrderMainSpecification<>(orderMainQuery);
        orderMainSpecification.setCreateTiemStart(startTimeDate);
        orderMainSpecification.setCreateTiemEnd(endTimeDate);
        orderMainSpecification.setMemberIds(memberIdsList);
        orderMainSpecification.setStatus(statusList);

        List<OrderMainDto> orderMainDTOs = new ArrayList<>();
        Page<OrderMain> orderMainPOPage = orderRepos.findAll(orderMainSpecification, pageable);
        Copys copys = Copys.create();
        orderMainPOPage.forEach(orderMainPO -> {
            OrderMainDto orderMainDTO = new OrderMainDto();
            copys.from(orderMainPO).excludes("orderItems", "subOrders", "orderGifts", "orderAttrs").to(orderMainDTO).clear();
            orderMainDTOs.add(orderMainDTO);
        });

        Page<OrderMainDto> orderPage = new PageImpl<>(orderMainDTOs, pageable, orderMainPOPage.getTotalElements());

        log.info("查询订单数据耗时 {} ms", (System.currentTimeMillis() - queryOrderTimer));

        long memberFindOneTime= System.currentTimeMillis();
        List<String> memberIds = orderMainDTOs.stream().map(OrderMainDto::getMemberId).distinct().collect(Collectors.toList());
        List<Member> memberPOs = memberRepos.findByIdIn(memberIds);
        Map<String, String> memberIdNameMap =  memberPOs.stream().collect(Collectors.toMap(Member::getId, Member::getRealName));
        log.info("获取下单人名称 {} 条数据, 耗时 {} ms", memberIdNameMap.size(), System.currentTimeMillis() - memberFindOneTime);

        long findPaymentTime = System.currentTimeMillis();
        List<String> paymentIds = orderMainDTOs.stream().map(OrderMainDto::getPaymentId).distinct().collect(Collectors.toList());
        List<Payment> paymentPOs = paymentRepos.findByIdIn(paymentIds);
        Map<String, Payment> paymentIdMap =  paymentPOs.stream().collect(Collectors.toMap(Payment::getId, payment -> payment));
        log.info("查询 payment {} 条数据, 耗时 {} ms", paymentIdMap.size(), System.currentTimeMillis() - findPaymentTime);

        List<OrderMainDto> orders = orderPage.getContent();
        List<OrderQueryVo> orderQuerys = new ArrayList<>();
        for (int i = 0; i < orders.size(); i++) {
            OrderQueryVo orderQueryVo = new OrderQueryVo();
            orderQueryVo.setOrderName(memberIdNameMap.get((orders.get(i).getMemberId())));
            orderQueryVo.setOrderId(orders.get(i).getId());
            orderQueryVo.setOrgName(organization.getOrgName());
            orderQueryVo.setOrderNo(orders.get(i).getOrderNo());
            orderQueryVo.setOrderStatus(OrderMainDto.order_status.get(orders.get(i).getStatus()));
            orderQueryVo.setOrderTime(DateUtils.dateToStrLong(orders.get(i).getDateCreated()));
            String orderPrice = "0";
            String orderScore = "0";
            if (!Lang.isEmpty(orders.get(i).getScore()) || !Lang.isEmpty(orders.get(i).getPaymentId())) {
                if (!Lang.isEmpty(orders.get(i).getPaymentId())) {
                    if (!Lang.isEmpty(paymentIdMap.get(orders.get(i).getPaymentId()).getScore())) {
                        orderScore = paymentIdMap.get(orders.get(i).getPaymentId()).getScore().toString();
                    }
                    orderPrice = paymentIdMap.get(orders.get(i).getPaymentId()).getMoney().toString();
                }
            }
            orderQueryVo.setOrderScore(orderScore);
            orderQueryVo.setOrderPrice(orderPrice);
            orderQuerys.add(orderQueryVo);
        }
        returnMap.put("data", orderQuerys);
        returnMap.put("totalPages", getTotalPages((int) orderPage.getTotalElements(), pageable.getPageSize()));
        returnMap.put(GlobalContants.ResponseString.STATUS, GlobalContants.ResponseStatus.SUCCESS);
        returnMap.put(GlobalContants.ResponseString.MESSAGE, "数据获取成功");
        log.info("管理员-订单列表查询完成, 耗时 {} ms", System.currentTimeMillis() - methodStart);
        return returnMap;
    }

    @RequestMapping(value = "orderDetail.do", method = RequestMethod.GET)

    public String orderDetail(String orderId, String orderName, String orderNo, String status, String startTime, String endTime, HttpServletRequest request, Model model) {
        OrderMainDto order = orderMainApi.findById(orderId);
        Integer price = 0;
        for (OrderItemDto item : order.getOrderItems()) {
            price = price + item.getCount() * Integer.valueOf(item.getFinalPrice().toString());
        }
        model.addAttribute("orderName", orderName);
        model.addAttribute("orderNo", orderNo);
        model.addAttribute("status", status);
        model.addAttribute("startTime", startTime);
        model.addAttribute("endTime", endTime);
        model.addAttribute("price", price);
        model.addAttribute("order", order);
        model.addAttribute("orderItems", order.getOrderItems());
        model.addAttribute("orderStatus", ORDER_STATUS);

        return "member/administrators/adOperaCheckOrderDetail";
    }

    /**
     * 查询订单详情
     *
     * @param map
     * @param orderNo
     * @return
     */
    @RequestMapping("/orderDetail/{orderNo}")

    public String orderDetail(Map map, @PathVariable("orderNo") String orderNo, Map<String, Object> model, HttpServletRequest request) {

        JSONObject jsonObject = userCenterService.findOrderDetailByOrderNo(orderNo, null);

        model.put("orderInfo", jsonObject);
        model.put("scorePortion", scorePortion);
        return "member/administrators/myOrderDetails";
    }

    public int getTotalPages(int total, int size) {
        int totalpage = (total + size - 1) / size;
        return totalpage;
    }

    /**
     * 创建表头
     *
     * @param row
     * @param cellStyle
     * @param cell
     */
    private void createCellHead(HSSFRow row, HSSFCellStyle cellStyle, HSSFCell cell) {
        cell.setCellStyle(cellStyle);
        cell.setCellValue("下单人");
        cell = row.createCell(1);
        cell.setCellValue("公司名");
        cell = row.createCell(2);
        cell.setCellValue("订单号");
        cell = row.createCell(3);
        cell.setCellValue("下单金额");
        cell = row.createCell(4);
        cell.setCellValue("订单状态");
        cell = row.createCell(5);
        cell.setCellValue("下单日期");
    }

    /**
     * 创建表内容
     *
     * @param queryVos
     * @param cellStyle
     * @param sheet
     */
    private void createCellContent(List<OrderQueryVo> queryVos, HSSFCellStyle cellStyle, HSSFSheet sheet) {
        for (int i = 0; i < queryVos.size(); i++) {
            int rowCount = i + 1;
            HSSFRow row = sheet.createRow(rowCount);
            OrderQueryVo queryVo = queryVos.get(i);
            HSSFCell theCell = row.createCell(0);
            theCell.setCellStyle(cellStyle);
            theCell.setCellValue(setContentCellValue(queryVo.getOrderName()));
            theCell = row.createCell(1);
            theCell.setCellValue(setContentCellValue(queryVo.getOrgName()));
            theCell = row.createCell(2);
            theCell.setCellValue(setContentCellValue(queryVo.getOrderNo()));
            theCell = row.createCell(3);
            theCell.setCellValue(setContentCellValue(queryVo.getOrderPrice()));
            theCell = row.createCell(4);
            theCell.setCellValue(setContentCellValue(queryVo.getOrderStatus()));
            theCell = row.createCell(5);
            theCell.setCellValue(setContentCellValue(queryVo.getOrderTime()));
        }
    }

    /**
     * 设置单元格宽度
     *
     * @param sheet
     */
    private void setContentColumnWidth(HSSFSheet sheet) {
        sheet.setColumnWidth(0, 5000);
        sheet.setColumnWidth(1, 5000);
        sheet.setColumnWidth(2, 5000);
        sheet.setColumnWidth(3, 5000);
        sheet.setColumnWidth(4, 5000);
        sheet.setColumnWidth(5, 5000);
    }

    /**
     * 设置单元格样式
     *
     * @param wb
     * @return
     */
    private HSSFCellStyle setContentCellStyle(HSSFWorkbook wb) {
        HSSFCellStyle cellStyle = wb.createCellStyle();
        HSSFFont font = wb.createFont();
        font.setFontName("黑体");
        font.setFontHeightInPoints((short) 10);//设置字体大小
//        font.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);//粗体显示
        cellStyle.setFont(font);
        cellStyle.setBorderBottom(HSSFCellStyle.BORDER_THIN);
        cellStyle.setBorderLeft(HSSFCellStyle.BORDER_THIN);
        cellStyle.setBorderRight(HSSFCellStyle.BORDER_THIN);
        cellStyle.setBorderTop(HSSFCellStyle.BORDER_THIN);
        cellStyle.setAlignment(HSSFCellStyle.ALIGN_CENTER);
        return cellStyle;
    }

    /**
     * 设置单元格内容
     *
     * @param value
     * @return
     */
    private String setContentCellValue(String value) {
        if (Lang.isEmpty(value)) {
            return "";
        } else {
            return value;
        }
    }

    private static Map<String, String> ORDER_STATUS = new HashMap<String, String>() {
        {
            put("0", "");
            put("1", "待付款");
            //put("2","未发货");
            put("3", "待收货");
//            put("4", "待评价");
            put("5", "已完成");
            put("6", "已取消");
        }
    };

    private static Map<String, String> ORDER_STATUS_STRING = new HashMap<String, String>() {
        {
            put("全部", "0");
            put("待付款", "1");
            put("待收货","2");
            put("待收货", "3");
            put("待评价", "4");
            put("已完成", "5");
            put("已取消", "6");
            put("拒收", "7");
        }
    };
}
