package ctscore.web.controller.member;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import ctscore.web.service.member.MemberLoginService;
import ctscore.web.service.member.UserCenterService;
import member.api.dto.core.CoreUserDto;
import member.api.dto.shop.MemberDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import utils.GlobalContants;
import utils.Lang;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 * Created by DRAGON on 2016/12/5.
 * 会员中心修改密码
 */
@Controller
public class UpdatePasswordController {

    final static Logger logger = LoggerFactory.getLogger(UpdatePasswordController.class);

    //登录用户session
    //public static final String LOGIN_USER_SESSION = "LOGIN_USER_SESSION";

    @Autowired
    UserCenterService userCenterService;

    @Autowired
    MemberLoginService memberLoginService;

    //修改密码（会员中心）
    @RequestMapping(value = "passwd",method = RequestMethod.GET)

    public String passwd(HttpServletRequest request, Map model){

        //登录的session
        Object memberJson = request.getSession().getAttribute(GlobalContants.SESSION_MEMBER_JSON_ITAIPING);
        MemberDto member = JSON.parseObject(memberJson.toString(),MemberDto.class);
        String memberId = member.getId();

        MemberDto tmpMember = userCenterService.findMenberById(memberId);
        Integer isFirstLogin = tmpMember.getIsFirstLogin();
        if (Lang.isEmpty(isFirstLogin)){
            isFirstLogin = 0;
        }
        model.put("isFirst",isFirstLogin);

        //检测是否已经登录
        return "member/passwd";
    }

    //更新密码（会员中心）
    @RequestMapping(value = "update/passwd",method = RequestMethod.POST)
    @ResponseBody

    public JSONObject updatePasswd(HttpServletRequest request){
        logger.info("修改密码");
        JSONObject jsonObject = new JSONObject();

        String oldPwd   = request.getParameter("oldPwd");
        String newPwd   = request.getParameter("newPwd");
        String newRePwd = request.getParameter("newRePwd");

        if (Lang.isEmpty(oldPwd)){
            jsonObject.put("code","-1");
            jsonObject.put("msg","旧密码为空");
            return jsonObject;
        }
        if (Lang.isEmpty(newPwd)){
            jsonObject.put("code","-2");
            jsonObject.put("msg","新密码为空");
            return jsonObject;
        }
        if (Lang.isEmpty(newRePwd)){
            jsonObject.put("code","-3");
            jsonObject.put("msg","重复密码为空");
            return jsonObject;
        }
        if (!newPwd.equals(newRePwd)){
            jsonObject.put("code","-4");
            jsonObject.put("msg","密码不一致");
            return jsonObject;
        }

        //获取session
        Object memberObj   = request.getSession().getAttribute(GlobalContants.SESSION_MEMBER_JSON_ITAIPING);
        Object coreUserObj = request.getSession().getAttribute(GlobalContants.SESSION_USER_JSON_ITAIPING);
        MemberDto member      = JSON.parseObject( memberObj.toString(),MemberDto.class);
        CoreUserDto tmpCoreUser =  JSON.parseObject( coreUserObj.toString(),CoreUserDto.class);
        String id = tmpCoreUser.getId();

        CoreUserDto coreUser = memberLoginService.findById(id);
        if (Lang.isEmpty(coreUser)|| Lang.isEmpty(member)){//查询失败
            jsonObject.put("code","1");
            jsonObject.put("msg","登录信息错误");
            return jsonObject;
        }

        //修改密码
        String password = coreUser.getPassword();
        String encryptPasswd = memberLoginService.encryptPasswd(oldPwd);
        if (!password.equals(encryptPasswd)){
            jsonObject.put("code","2");
            jsonObject.put("msg","旧密码错误");
            return jsonObject;
        }

        //设置新密码
        String encryptNewPasswd = memberLoginService.encryptPasswd(newPwd);
        coreUser.setPassword(encryptNewPasswd);
        CoreUserDto user = memberLoginService.updateCoreUser(coreUser);
        if (Lang.isEmpty(user)){
            jsonObject.put("code","3");
            jsonObject.put("msg","修改密码失败");
            return jsonObject;
        }
        member.setIsFirstLogin(1);
        member.setCoreUser(coreUser);
        memberLoginService.updateMember(member);
        if (Lang.isEmpty(member)){
            jsonObject.put("code","3");
            jsonObject.put("msg","修改密码失败");
            return jsonObject;
        }

        //移除session
        //request.getSession().removeAttribute(LOGIN_USER_SESSION);
        jsonObject.put("code","0");
        jsonObject.put("msg","修改密码成功");
        return jsonObject;
    }

}
