package ctscore.web.controller.payment.controller.product;

import cart.api.OrderMainApi;
import cart.api.PaymentApi;
import cart.api.dto.order.OrderMainDto;
import com.alibaba.fastjson.JSON;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.common.BitMatrix;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import payment.api.TpPaymentApi;
import payment.api.vo.PayMentInfoVo;
import payment.api.vo.PrePayRequestVo;
import payment.api.vo.PrePayResultVo;
import utils.GlobalContants;
import utils.Lang;
import utils.picture.MatrixToImageWriter;

import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.io.OutputStream;
import java.util.*;

/**
 * Created by xujingfeng on 2016/12/6.
 * <p/>
 * 真实支付调用的controller
 */
//@Profile("product")
@Controller
public class PaymentController {

    @MotanReferer
    TpPaymentApi tpPaymentApi;
    @Value("${pay.partnerUrl}")
    private String payPartnerUrl;

    //ctscore 个人中心 我的商品 url
    @Value("${itaiping.usercenter.goods}")
    private String itaipingUserCenterGoods;

    //ctscore 个人中心 订单详情 url
    @Value("${itaiping.usercenter.order}")
    private String itaipingUserCenterOrder;

    Logger logger = LoggerFactory.getLogger(getClass());
    @MotanReferer
    OrderMainApi orderMainApi;
    @MotanReferer
    PaymentApi paymentApi;

    /**
     * 需要传入
     * orderNo 订单编号
     * orderTotalFare 订单总金额 "0.01"=0.0.1元
     *
     * @return
     */
    @RequestMapping("/showPayGateWay")
    public String showPayGateWay(String orderNo, Map map, HttpSession session) {
        map.put("orderNo", orderNo);
        String payUid = UUID.randomUUID().toString();
        map.put("payUid", payUid);
        session.setAttribute("payUid", payUid);
        String memberId = (String) session.getAttribute(GlobalContants.SESSION_MEMBER_ID_ITAIPING);
        PayMentInfoVo payMentInfo = tpPaymentApi.getPayMentInfo(orderNo, memberId);
        map.put("payMoney", payMentInfo.getSumPrice());
        map.put("payLogId", payMentInfo.getPayLodId());
        return "payment/wechatPay";
    }

    @RequestMapping("/paymentQRCode")
    public void getQRCode(String payUid, String orderNo, HttpSession session, HttpServletResponse response) {
        String memberId = (String) session.getAttribute(GlobalContants.SESSION_MEMBER_ID_ITAIPING);
        PrePayRequestVo prePayRequestVo = new PrePayRequestVo();
        prePayRequestVo.setPayPartnerUrl(payPartnerUrl);
        prePayRequestVo.setOrderNos(orderNo);
        prePayRequestVo.setMemberId(memberId);
        PrePayResultVo prePayResultVo = null;
        Object sessionPayUid = session.getAttribute("payUid");
        logger.info("===payUid={}", payUid);
        logger.info("===sessionPayUid={}", sessionPayUid);
        logger.info("===orderNo={}", orderNo);
        try {
            if (!StringUtils.isEmpty(sessionPayUid) && ((String) sessionPayUid).equals(payUid)) {
                prePayResultVo = tpPaymentApi.prePayment(prePayRequestVo);
                String payUrl = prePayResultVo.getPayUrl();
                //每次刷新验证码附上uuid使其变化
                if (payUrl.indexOf("?") > 0) {
                    payUrl = payUrl + "&payUid=" + payUid;
                } else {
                    payUrl = payUrl + "?payUid=" + payUid;
                }
                logger.info("getQRCode pay url :{}", payUrl);
                String content = payUrl;
                MultiFormatWriter multiFormatWriter = new MultiFormatWriter();
                Map hints = new HashMap();
                hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
                BitMatrix bitMatrix = multiFormatWriter.encode(content, BarcodeFormat.QR_CODE, 400, 400, hints);
                response.setContentType("image/png");
                OutputStream os = response.getOutputStream();
                MatrixToImageWriter.writeToStream(bitMatrix, "png", os);
                os.flush();
                os.close();
                logger.info("获取支付二维码成功");

            } else {
                response.getWriter().println("验签失败，请重新获取支付二维码");
            }
        } catch (Exception e) {
            logger.info("获取支付二维码失败");
            logger.error("==prePayRequestVo={}", JSON.toJSONString(prePayRequestVo));
            logger.error("==prePayResultVo={}", JSON.toJSONString(prePayResultVo));
            logger.error(e.getMessage(), e);
        }
    }

    @RequestMapping("/judgePayLogState.json")
    @ResponseBody
    public Map judgePayLogState(Integer payLogId) {
        return tpPaymentApi.judgePayLogState(payLogId);
    }

    /**
     * 支付成功后的手机端跳转页面
     *
     * @return
     */
    @RequestMapping("/paySuccess")
    // @ResponseBody
    public String paySuccess(String payLogId) {
        System.out.println("支付编号PayLogId" + payLogId + "=====paySuccess=====");
        //return "支付编号PayLogId" + payLogId + "=====paySuccess=====";
        return "cart/payment/phonePayResult";
    }

    @RequestMapping("/pcPaySuccess.html")
    public String sd(Map map,String orderNos) {
        if(!Lang.isEmpty(orderNos)) {
            String[] orderNoArray = orderNos.split(",");
            List list = new LinkedList();
            for(String no :orderNoArray) {
                OrderMainDto orderMain = orderMainApi.findByOrderNo(no);
                list.add(orderMain);
                map.put("data",list);
            }
        }
        map.put("itaipingUserCenterOrder", itaipingUserCenterOrder);
        map.put("itaipingUserCenterGoods", itaipingUserCenterGoods);

        return "cart/order/orderSubmitResult";
    }
}
