package ctscore.web.interceptor;

import com.alibaba.fastjson.JSON;
import member.api.dto.core.CoreUserDto;
import member.api.vo.MemberVo;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import utils.GlobalContants;
import utils.Lang;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 诚通活动用户拦截
 *
 * @author FatAss
 * @date 2018-09-05
 */
@Component
public class ActivityUserInterceptor extends HandlerInterceptorAdapter {

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        MemberVo memberVo = JSON.parseObject((String) request.getSession().getAttribute(GlobalContants.SESSION_MEMBER_VO_JSON_ITAIPING), MemberVo.class);
        if (!Lang.isEmpty(memberVo) && !Lang.isEmpty(memberVo.getUser()) && CoreUserDto.USER_TYPE_CT_SCORE_ACTIVITY.equals(memberVo.getUser().getUserType())) {
            response.sendRedirect("../activities-web/control.html");
            return false;
        }
        return super.preHandle(request, response, handler);
    }
}
