package ctscore.web.service.area;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import member.api.AddressCommonApi;
import member.api.dto.common.AddressDto;
import org.springframework.stereotype.Component;
import utils.GlobalContants;
import utils.Lang;
import utils.ip.IPtoLong;
import utils.log.Log;
import utils.log.Logs;
import utils.web.Webs;

import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Map;

@Component
public class AreaService {

    @MotanReferer
    AddressCommonApi addressCommonApi;

    private final static Log log = Logs.getLog(AreaService.class.getName());

    public Map<String, Object> getAddressIdSByParams(HttpServletRequest request, String proviceId) {
        Map<String, Object> returnAddressIdMap = new HashMap<>();

        String returnProvoiceId = null;
        String returnCityId = null;
        String returnAreaId = null;
        String returnTownId = null;

        String sessionProvoiceId = (String) request.getSession().getAttribute(GlobalContants.AREA_LEVEL_PROVINCE_ID);
        String cityId = (String) request.getSession().getAttribute(GlobalContants.AREA_LEVEL_CITY_ID);
        String areaId = (String) request.getSession().getAttribute(GlobalContants.AREA_LEVEL_AREA_ID);
        String townId = (String) request.getSession().getAttribute(GlobalContants.AREA_LEVEL_TOWN_ID);

        if(Lang.isEmpty(proviceId)){
            if(!Lang.isEmpty(sessionProvoiceId)){
                returnProvoiceId=sessionProvoiceId;
            }else{
                String remoteIp = Webs.getIp(request);
                log.info("getAddressIdsByParams -> remoteIp: " + remoteIp);
                if(!Lang.isEmpty(remoteIp)) {
                    Long ipL = IPtoLong.ipToLong(remoteIp);
                    AddressDto currentAaddress = null;
                    currentAaddress = addressCommonApi.findAreaByIp(ipL, GlobalContants.AREA_LEVEL_PROVINCE);
                    if(!Lang.isEmpty(currentAaddress)){
                        returnProvoiceId=currentAaddress.getId();
                    }else{
                        returnProvoiceId = "110000";
                        /**LWX 2017/1/10修改： 当省份改变时，修改已保存的2级3级4级地区 START */
                        request.getSession().setAttribute(GlobalContants.AREA_LEVEL_CITY_ID, null);
                        request.getSession().setAttribute(GlobalContants.AREA_LEVEL_AREA_ID, null);
                        request.getSession().setAttribute(GlobalContants.AREA_LEVEL_TOWN_ID, null);
                        /**LWX 2017/1/10修改： 当省份改变时，修改已保存的2级3级4级地区 END */
                    }

                }else {
                    returnProvoiceId = "110000";
                    /**LWX 2017/1/10修改： 当省份改变时，修改已保存的2级3级4级地区 START */
                    request.getSession().setAttribute(GlobalContants.AREA_LEVEL_CITY_ID, null);
                    request.getSession().setAttribute(GlobalContants.AREA_LEVEL_AREA_ID, null);
                    request.getSession().setAttribute(GlobalContants.AREA_LEVEL_TOWN_ID, null);
                    /**LWX 2017/1/10修改： 当省份改变时，修改已保存的2级3级4级地区 END */
                }
            }
        }else{
            if(!Lang.isEmpty(sessionProvoiceId)) {
                if (!proviceId.equals(sessionProvoiceId)) {
                    returnProvoiceId=proviceId;
                    /**LWX 2017/1/10修改： 当省份改变时，修改已保存的2级3级4级地区 START */
                    request.getSession().setAttribute(GlobalContants.AREA_LEVEL_CITY_ID, null);
                    request.getSession().setAttribute(GlobalContants.AREA_LEVEL_AREA_ID, null);
                    request.getSession().setAttribute(GlobalContants.AREA_LEVEL_TOWN_ID, null);
                    /**LWX 2017/1/10修改： 当省份改变时，修改已保存的2级3级4级地区 END */
                }else{
                    returnProvoiceId=sessionProvoiceId;

                }
            }else{
                returnProvoiceId=proviceId;
                /**LWX 2017/1/10修改： 当省份改变时，修改已保存的2级3级4级地区 START */
                request.getSession().setAttribute(GlobalContants.AREA_LEVEL_CITY_ID, null);
                request.getSession().setAttribute(GlobalContants.AREA_LEVEL_AREA_ID, null);
                request.getSession().setAttribute(GlobalContants.AREA_LEVEL_TOWN_ID, null);
                /**LWX 2017/1/10修改： 当省份改变时，修改已保存的2级3级4级地区 END */
            }
        }
        if(Lang.isEmpty(areaId)) {
            Map<String, Object> areaMap = getAddressId(request, areaId, returnProvoiceId);
            returnCityId = (String) areaMap.get("cityId");
            returnAreaId = (String) areaMap.get("areaId");
            returnTownId = (String) areaMap.get("townId");
        } else {
            returnCityId = cityId;
            returnAreaId = areaId;
            returnTownId = townId;
        }

        returnAddressIdMap.put("provoiceId",returnProvoiceId);
        returnAddressIdMap.put("cityId",returnCityId);
        returnAddressIdMap.put("areaId",returnAreaId);
        returnAddressIdMap.put("townId",returnTownId);

        return returnAddressIdMap;
    }

    private Map<String, Object> getAddressId(HttpServletRequest request, String areaId, String provoiceId){
        Map<String, Object> returnAddressIdMap = new HashMap<>();
        String returnCityId = null;
        String returnAreaId = null;
        String returnTownId = null;
        String remoteIp = Webs.getIp(request);
        if(!Lang.isEmpty(remoteIp)) {
            Long ipL = IPtoLong.ipToLong(remoteIp);
            AddressDto currentAaddress = null;
            if (Lang.isEmpty(areaId)) {//直接定位到当前位置所在的第三级
                currentAaddress = addressCommonApi.findAreaByIp(ipL, GlobalContants.AREA_LEVEL_AREA);
                if (!Lang.isEmpty(currentAaddress)) {//查询第2级
                    returnAreaId = currentAaddress.getId();
                    returnCityId = currentAaddress.getParent().getId();
                }
            }
        }

        // 从上级往下级取值
        if(Lang.isEmpty(returnAreaId)){
            AddressDto cityAddress = addressCommonApi.findFirstChild(provoiceId, true);
            if(!Lang.isEmpty(cityAddress)) {
                returnCityId = cityAddress.getId();
                AddressDto areaAddress = addressCommonApi.findFirstChild(returnCityId, true);
                if(!Lang.isEmpty(areaAddress)) {
                    returnAreaId = areaAddress.getId();
                    AddressDto townAddress = addressCommonApi.findFirstChild(returnAreaId, false);
                    if(!Lang.isEmpty(townAddress)) {
                        returnTownId = townAddress.getId();
                    }
                }
            }
            //returnCityId = "110100";
            //returnAreaId = "110101";
            //returnTownId = "d8a15c70-9c8a-44b6-bc34-06b457ecfaaf";
        }

        request.getSession().setAttribute(GlobalContants.AREA_LEVEL_PROVINCE_ID, provoiceId);
        request.getSession().setAttribute(GlobalContants.AREA_LEVEL_CITY_ID, returnCityId);
        request.getSession().setAttribute(GlobalContants.AREA_LEVEL_AREA_ID, returnAreaId);
        request.getSession().setAttribute(GlobalContants.AREA_LEVEL_TOWN_ID, returnTownId);

        returnAddressIdMap.put("cityId",returnCityId);
        returnAddressIdMap.put("areaId",returnAreaId);
        returnAddressIdMap.put("townId", returnTownId);
        return returnAddressIdMap;
    }
}
