package ctscore.web.service.cart.service;

import com.alibaba.fastjson.JSONObject;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import org.springframework.stereotype.Component;
import sysmg.api.SystemLogApi;
import sysmg.dto.SystemLogDto;
import utils.Lang;
import utils.log.Log;
import utils.log.Logs;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by Roney on 2017-04-09.
 */
@Component
public class CartSystemLogService {
    private final static Log log = Logs.getLog(CartSystemLogService.class.getName());

    @MotanReferer
    SystemLogApi systemLogApi;

    public SystemLogDto saveBean(String serverUrl, Object request, Object response, String systemLogId , String errorMes){
        Map logMap= new HashMap();
        logMap.put("serverUrl",serverUrl);
        SystemLogDto systemLog=null;
        if(Lang.isEmpty(systemLogId)) {
            logMap.put("request", request);
            logMap.put("response", response);
            logMap.put("error", errorMes);
            systemLog = new SystemLogDto(serverUrl,SystemLogDto.LOG_SOURCE_PAYMENT, SystemLogDto.LOG_TYPE_INFO, JSONObject.toJSONString(logMap));
            if(!Lang.isEmpty(errorMes)){
                systemLog.setLogType(SystemLogDto.LOG_TYPE_ERROR);
            }
            systemLog = systemLogApi.saveBean(systemLog);
        }else {
            //更新的时候，保留返回结果即可
            systemLog=systemLogApi.findById(systemLogId);
            if(!Lang.isEmpty(systemLog)) {
                logMap.put("request", request);
                logMap.put("response", response);
                logMap.put("error", errorMes);
                systemLog.setReturnDesc(JSONObject.toJSONString(logMap));
                systemLog = systemLogApi.saveBean(systemLog);
            }
        }
        return systemLog;
    }
}
