package ctscore.web.service.cart.service;

import cart.api.OrderMainApi;
import cart.api.vo.CartItemVo;
import cart.api.vo.TempOrderItemVo;
import cart.api.vo.TempOrderVo;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import member.api.dto.shop.MemberAddressDto;
import member.api.vo.MemberVo;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 封装订单前端相关数据操作
 * Created by Liang Wenxu on 2016/11/10.
 */
@Component
public class OrderWebService {

    /**
     * 查询运费
     * @param storeId : String
     * @param tempOrderItemVos : List<CartItemVo>
     * @param addressId : MemberAddress表ID
     * @return
     */
    public BigDecimal queryShippingFee(String storeId, List<TempOrderItemVo> tempOrderItemVos, String addressId) {
        return orderMainApi.queryShippingFee(storeId, tempOrderItemVos, addressId);
    }

    /**
     * 查询运费
     * @param storeId : String
     * @param cartItemVoList : List<CartItemVo>
     * @param addressId : MemberAddress表ID
     * @return
     */
    public BigDecimal queryCartShippingFee(String storeId, List<CartItemVo> cartItemVoList, String addressId) {
        return orderMainApi.queryCartShippingFee(storeId, cartItemVoList, addressId);
    }


    @MotanReferer
    OrderMainApi orderMainApi;



}
