package ctscore.web.service.goods;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import goods.api.ProductCategoryApi;
import goods.dto.product.ProductCategoryDto;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * Created by xiaoqian on 2016/11/23.
 */
@Component
@Transactional(readOnly = true)
public class CategroyService {

    //@Autowired
    //private ProductCategoryRepos productCategoryRepos;

    @MotanReferer
    ProductCategoryApi productCategoryApi;

    public ProductCategoryDto findCategory(String category) {
        ProductCategoryDto category1 = productCategoryApi.findOne(category);
        if (category1 != null) {
            return category1;
        }
        category1 = productCategoryApi.findByName(category);
        if (category1 != null) {
            return category1;
        }
        category1 = productCategoryApi.findByPath(category);
        return category1;
    }

    public List<ProductCategoryDto> getByIds(List<String> categoryIdList) {
        return productCategoryApi.findByIdInOrderByShowIndexAsc(categoryIdList);
    }
}
