package ctscore.web.service.goods;

import activities.api.ActivityGoodsApi;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import goods.api.GoodsApi;
import goods.dto.goods.GoodsDto;
import goods.dto.goods.GoodsPictureDto;
import goods.model.Goods;
import goods.model.GoodsPicture;
import goods.model.repository.GoodsRepos;
import member.api.MemberApi;
import member.api.vo.MemberVo;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import search.vo.CommonDoc;
import store.api.StoreApi;
import utils.GlobalContants;
import utils.Lang;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by Roney on 2016/11/24.
 */

@Component
public class GoodWebService {
    @Resource(name = "redisTemplate")
    private ZSetOperations<String, String> zSetOperations;

    /**
     * 获取用户信息
     *
     * @param request
     * @return
     */
    public MemberVo findMemberVo(HttpServletRequest request) {
        String memberId = (String) request.getSession().getAttribute(GlobalContants.SESSION_MEMBER_ID_ITAIPING);
        String userId = (String) request.getSession().getAttribute(GlobalContants.SESSION_USER_ID_ITAIPING);

        /** 优先使用memberID获取 */
        MemberVo memberVo = null;
        if (StringUtils.isNotBlank(memberId)) {
            System.out.println("memberId" + memberId);
            memberVo = memberApi.getMemberInfo(memberId);
        } else if (StringUtils.isNotBlank(userId)) {
            System.out.println("userId" + userId);
            memberVo = memberApi.getMemberInfoByUserId(userId);

        }

        /** 开发用： 当前未登录用户直接获取测试用户数据 */
        // memberVo = memberVo == null ? memberApi.getMemberInfo("27d23064-9b2a-4bd9-ba63-6174a041e671") : memberVo;

        return memberVo;
    }

    @Autowired
    GoodsRepos goodsRepos;

    @MotanReferer
    GoodsApi goodsApi;
    @MotanReferer
    MemberApi memberApi;
    @MotanReferer
    ActivityGoodsApi activityGoodsApi;
    @MotanReferer
    StoreApi storeApi;

    @Value("${ctscore.orgCode}")
    private String organizationCode;//机构code值

    Logger log = LoggerFactory.getLogger(getClass());

    @Transactional(readOnly = true)
    public List<CommonDoc> setCommonDocList(List<String> goodsIds) {
        long time2 = System.currentTimeMillis();
        long start = System.currentTimeMillis();
        List<Goods> goodses = findGoodsByIds(goodsIds);
        log.info("加载goodsDto耗时:{}", System.currentTimeMillis() - start);
        List<CommonDoc> returnCommonDocs = new ArrayList<>();
//        log.info("查询我的足迹1==={}秒", (System.currentTimeMillis() - time2) / 1000.00);
        time2 = System.currentTimeMillis();
        for (Goods goods : goodses) {
            CommonDoc commonDoc = new CommonDoc();
            commonDoc.setId(goods.getId());
            if (!Lang.isEmpty(goods)) {
                List<GoodsPicture> goodsPictures = goods.getGoodsPictures();
                for (int i = 0; i < goodsPictures.size(); i++) {
                    if (goodsPictures.get(i).getShowIndex() == 0) {
                        commonDoc.setLogoUrl(goodsPictures.get(i).getBigPicturePath());
                    } else {
                        continue;
                    }
                }
                if (Lang.isEmpty(commonDoc.getLogoUrl()) && !Lang.isEmpty(goodsPictures)) {
                    commonDoc.setLogoUrl(goodsPictures.get(0).getBigPicturePath());
                }

                String storeCode = storeApi.getStoreCode(goods.getStoreId());
                start = System.currentTimeMillis();
                BigDecimal price = activityGoodsApi.getActivityPrice(goods.getId(), organizationCode, storeCode);
                log.info("获取活动价price耗时:{}", System.currentTimeMillis() - start);
                price = new BigDecimal(price.toString()).setScale(2, BigDecimal.ROUND_UP);
                commonDoc.setPrice(price.doubleValue());
                commonDoc.setTitle(goods.getName());
            }
            returnCommonDocs.add(commonDoc);
        }
//        log.info("查询我的足迹2===={}秒", (System.currentTimeMillis() - time2) / 1000.00);
        return returnCommonDocs;
    }

    public List<Goods> findGoodsByIds(List<String> idList) {
        return goodsRepos.findByIdIn(idList);

//        return goodsApi.findByIdIn(idList);
    }

    public void putKeyWords(String type, String keyWord) {
        zSetOperations.incrementScore(type, keyWord, 1);
    }
}
