package ctscore.web.service.goods.excel;

import cms.api.OrganizationApi;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import goods.api.SalesPriceRateApi;
import goods.dto.goods.SalesPriceRateDto;
import goods.vo.SalesPriceRateQueryVo;
import org.apache.poi.hssf.usermodel.*;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import store.api.StoreApi;
import store.api.dto.modeldto.core.StoreDto;
import utils.Lang;
import utils.log.Log;
import utils.log.Logs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Created by Roney on 2017/1/17.
 */
@Component
@Transactional(readOnly = true)
public class RateExcelService {

    private static final String[] titleEns = {"organizationId", "storeId",
            "rangeUpper", "rangeLower", "rangeUpperOpertor", "rangeLowerOpertor",
            "rateNumerator", "rateDenominator", "mode", "expression", "remark"};
    private static final String[] titles = {"机构", "店铺", "费率适用区间上限", "费率适用区间下限",
            "费率适用区间上限边界", "费率适用区间下限边界", "费率分子", "费率分母", "费率配置模式",
            "费率表达式", "备注"};
    private final static Log log = Logs.getLog();


    private HSSFWorkbook hwb;

    @MotanReferer
    OrganizationApi organizationApi;

    @MotanReferer
    StoreApi storeApi;

    @MotanReferer
    SalesPriceRateApi salesPriceRateApi;

    @Autowired
    ExcelService excelService;

    /**
     * 生成费率EXCEL
     * @param out
     */
    public void officeExcelOut(OutputStream out) {
        try {
            hwb = new HSSFWorkbook();
            hwb =rateDown();
            hwb.write(out);
            out.flush();
            out.close();
            hwb.close();
        } catch (IOException e) {
            e.printStackTrace();
        }

    }

    public HSSFWorkbook rateDown() {// EXcle生成
        HSSFWorkbook hwb = new HSSFWorkbook();
        HSSFSheet sheet = hwb.createSheet("费率表");
        HSSFRow firstrow = sheet.createRow(0);

        int countColumnNum = titles.length;
        for (int i = 0; i < countColumnNum; i++) {
            HSSFCell firstcell = firstrow.createCell(i);
            HSSFCellStyle style = hwb.createCellStyle();
            style.setAlignment(HSSFCellStyle.ALIGN_CENTER);
            style.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);
            style.setWrapText(true);
            firstcell.setCellStyle(style);
            // sheet.setColumnWidth(i, 6000);
            try {
                sheet.setColumnWidth(i,
                        titles[i].getBytes("utf-8").length * 256);
            } catch (UnsupportedEncodingException e) {
                sheet.setColumnWidth(i, titles[i].getBytes().length * 256);
            }
            sheet.setDefaultColumnStyle(i, style);
            firstcell.setCellValue(new HSSFRichTextString(titles[i]));
        }

        List<String> organizationMapList = new ArrayList<String>(
                organizationApi.listToMap().values());

        String[] organizationMapArray = new String[organizationMapList.size()];
        organizationMapList.toArray(organizationMapArray);
        HSSFDataValidation organizationMapValidation = ExcelReader
                .createListBox(organizationMapArray, 1, 10000, 0, 0);
        sheet.addValidationData(organizationMapValidation);

        List<String> storeMapList = new ArrayList<String>(storeApi
                .listToMap().values());
        String[] storeMapArray = new String[storeMapList.size()];
        storeMapList.toArray(storeMapArray);
        HSSFDataValidation storeMapValidation = ExcelReader.createListBox(
                storeMapArray, 1, 10000, 1, 1);
        sheet.addValidationData(storeMapValidation);

        List<String> RangeUpperOpertorMapList = new ArrayList<String>(
                SalesPriceRateDto.RangeUpperOpertorMap.values());
        String[] RangeUpperOpertorMapArray = new String[RangeUpperOpertorMapList.size()];
        RangeUpperOpertorMapList.toArray(RangeUpperOpertorMapArray);
        HSSFDataValidation RangeUpperOpertorMapValidation = ExcelReader
                .createListBox(RangeUpperOpertorMapArray, 1, 1000, 4, 4);
        sheet.addValidationData(RangeUpperOpertorMapValidation);

        List<String> RangeLowerOpertorMapList = new ArrayList<String>(
                SalesPriceRateDto.RangeLowerOpertorMap.values());
        String[] RangeLowerOpertorMapArray = new String[RangeLowerOpertorMapList.size()];
        RangeLowerOpertorMapList.toArray(RangeLowerOpertorMapArray);
        HSSFDataValidation RangeLowerOpertorMapValidation = ExcelReader
                .createListBox(RangeLowerOpertorMapArray, 1, 1000, 5, 5);
        sheet.addValidationData(RangeLowerOpertorMapValidation);

        List<String> RateDenominatorMapList = new ArrayList<String>(
                SalesPriceRateDto.RateDenominatorMap.values());
        String[] RateDenominatorMapArray = new String[RateDenominatorMapList.size()];
        RateDenominatorMapList.toArray(RateDenominatorMapArray);
        HSSFDataValidation RateDenominatorMapValidation = ExcelReader
                .createListBox(RateDenominatorMapArray, 1, 1000, 7, 7);
        sheet.addValidationData(RateDenominatorMapValidation);


            List<String> ModeMapList = new ArrayList<String>(
                SalesPriceRateDto.ModelMap.values());
        String[] ModeMapArray = new String[ModeMapList.size()];
        ModeMapList.toArray(ModeMapArray);
        HSSFDataValidation ModeMapValidation = ExcelReader
                .createListBox(ModeMapArray, 1, 1000, 8, 8);
        sheet.addValidationData(ModeMapValidation);


        List<String> ExpressionMapList = new ArrayList<String>(
                SalesPriceRateDto.ExpressionMap.values());
        String[] ExpressionMapArray = new String[ExpressionMapList.size()];
        ExpressionMapList.toArray(ExpressionMapArray);
        HSSFDataValidation ExpressionMapValidation = ExcelReader
                .createListBox(ExpressionMapArray, 1, 1000, 9, 9);
        sheet.addValidationData(ExpressionMapValidation);


        return hwb;
    }

    public void officeExcelRead(InputStream inputStream) throws Exception {
        // TODO Auto-generated method stub
        HSSFWorkbook wb;
        HSSFSheet sheet;
        HSSFRow row;

        wb = new HSSFWorkbook(new POIFSFileSystem(inputStream));

        sheet = wb.getSheetAt(0);
        // 得到总行数
        int rowNum = sheet.getLastRowNum();
        row = sheet.getRow(0);
        String message = "";
        int colNum = titles.length;
        List<SalesPriceRateDto> salesPriceRates = new ArrayList<SalesPriceRateDto>();


        Map  organizationApiMaps = organizationApi.listToMap();
        String[] organizationMaps = new String[organizationApiMaps.size()];
        organizationApiMaps.values().toArray(organizationMaps);

        String[] organizationMapEns = new String[organizationApiMaps.size()];
        organizationApiMaps.keySet().toArray(organizationMapEns);

        Map storeServiceMaps = storeApi
                .listToMap();
        String[] storeMaps = new String[storeServiceMaps.size()];
        storeServiceMaps.values().toArray(storeMaps);

        String[] storeMapEns = new String[storeServiceMaps.size()];
        storeServiceMaps.keySet().toArray(storeMapEns);


        String[] RangeUpperOpertorMaps = new String[SalesPriceRateDto.RangeUpperOpertorMap
                .size()];
        SalesPriceRateDto.RangeUpperOpertorMap.values().toArray(RangeUpperOpertorMaps);


        String[] RangeUpperOpertorMapEns = new String[SalesPriceRateDto.RangeUpperOpertorMap
                .size()];
        SalesPriceRateDto.RangeUpperOpertorMap.keySet().toArray(RangeUpperOpertorMapEns);

        String[] RangeLowerOpertorMaps = new String[SalesPriceRateDto.RangeLowerOpertorMap
                .size()];
        SalesPriceRateDto.RangeLowerOpertorMap.values().toArray(RangeLowerOpertorMaps);


        String[] RangeLowerOpertorMapEns = new String[SalesPriceRateDto.RangeLowerOpertorMap
                .size()];
        SalesPriceRateDto.RangeLowerOpertorMap.keySet().toArray(RangeLowerOpertorMapEns);


        String[] RateDenominatorMaps = new String[SalesPriceRateDto.RateDenominatorMap
                .size()];
        SalesPriceRateDto.RateDenominatorMap.values().toArray(RateDenominatorMaps);


        String[] RateDenominatorMapEns = new String[SalesPriceRateDto.RateDenominatorMap
                .size()];
        SalesPriceRateDto.RateDenominatorMap.keySet().toArray(RateDenominatorMapEns);

        String[] ModelMaps = new String[SalesPriceRateDto.ModelMap
                .size()];
        SalesPriceRateDto.ModelMap.values().toArray(ModelMaps);


        String[] ModelMapEns = new String[SalesPriceRateDto.ModelMap
                .size()];
        SalesPriceRateDto.ModelMap.keySet().toArray(ModelMapEns);

        String[] ExpressionMaps = new String[SalesPriceRateDto.ExpressionMap
                .size()];
        SalesPriceRateDto.ExpressionMap.values().toArray(ExpressionMaps);


        String[] ExpressionMapEns = new String[SalesPriceRateDto.ExpressionMap
                .size()];
        SalesPriceRateDto.ExpressionMap.keySet().toArray(ExpressionMapEns);

        List<SalesPriceRateDto> salesPriceRatesTemp=new ArrayList<>();

        if (row.getPhysicalNumberOfCells() == colNum) {
            // 正文内容应该从第二行开始,第一行为表头的标题
            for (int i = 1; i <= rowNum; i++) {
                row = sheet.getRow(i);
                SalesPriceRateDto salesPriceRate=new SalesPriceRateDto();

                for (int j = 0; j < colNum; j++) {
                    String value = String.valueOf(excelService
                            .getCellFormatValue(row.getCell(j)));
                    if (j != 10) {// 最后一列，不需要判断
                        if (Lang.isEmpty(value)) {
                            throw new Exception("第" + (i + 1) + "行,第" + (j + 1)
                                    + "列值不能为空");
                        }
                   }

                    switch (titleEns[j]) {

                        case "organizationId":

                            boolean flagOrganizationId = false;
                            for (int k = 0; k < organizationMaps.length; k++) {
                                if (organizationMaps[k].equals(value)) {
                                    salesPriceRate.setOrganizationId(organizationMapEns[k]);
                                    flagOrganizationId = true;
                                    break;
                                }
                            }
                            if (!flagOrganizationId) {
                                throw new Exception("第" + (i + 1) + "行,第" + (j + 1)
                                        + "列机构值不对");
                            }
                            break;

                        case "storeId":
                            boolean flagStoreId = false;
                            for (int k = 0; k < storeMaps.length; k++) {
                                if (storeMaps[k].equals(value)) {
                                    salesPriceRate.setStoreId(storeMapEns[k]);
                                    log.info("店铺ID="+storeMapEns[k]);
                                    StoreDto store=storeApi.getStoreInfo(storeMapEns[k]);
                                    if(!Lang.isEmpty(store)){
                                        salesPriceRate.setStoreCode(store.getStoreExt().getCode());
                                    }
                                    flagStoreId = true;
                                    break;
                                }
                            }
                            if (!flagStoreId) {
                                throw new Exception("第" + (i + 1) + "行,第" + (j + 1)
                                        + "列店铺值不对");
                            }
                            break;
                        case "rangeUpper":
                            // value = value.substring(0, value.length() - 2);
                            salesPriceRate.setRangeUpper(new BigDecimal(value));
                            break;
                        case "rangeLower":
                            // value = value.substring(0, value.length() - 2);
                            salesPriceRate.setRangeLower(new BigDecimal(value));
                            break;
                        case "rangeUpperOpertor":
                            boolean flag1 = false;
                            for (int k = 0; k < RangeUpperOpertorMaps.length; k++) {
                                if (RangeUpperOpertorMaps[k].equals(value)) {
                                    salesPriceRate.setRangeUpperOpertor(RangeUpperOpertorMapEns[k]);
                                    flag1 = true;
                                    break;
                                }
                            }
                            if (!flag1) {
                                throw new Exception("第" + (i + 1) + "行,第" + (j + 1)
                                        + "列费率适用区间上限边界值不对");
                            }
                            break;

                        case "rangeLowerOpertor":
                            boolean flag2 = false;
                            for (int k = 0; k < RangeLowerOpertorMaps.length; k++) {
                                if (RangeLowerOpertorMaps[k].equals(value)) {
                                    salesPriceRate.setRangeLowerOpertor(RangeLowerOpertorMapEns[k]);
                                    flag2 = true;
                                    break;
                                }
                            }
                            if (!flag2) {
                                throw new Exception("第" + (i + 1) + "行,第" + (j + 1)
                                        + "列费率适用区间下限边界值不对");
                            }
                            break;

                        case "rateNumerator":
                            // value = value.substring(0, value.length() - 2);
                            salesPriceRate.setRateNumerator(new BigDecimal(value));
                            break;

                        case "rateDenominator":
                            value = value.substring(0, value.length() - 2);
                            boolean flag3 = false;
                            for (int k = 0; k < RateDenominatorMaps.length; k++) {
                                if (RateDenominatorMaps[k].equals(value)) {
                                    salesPriceRate.setRateDenominator(Integer.parseInt(RateDenominatorMapEns[k]));
                                    flag3 = true;
                                    break;
                                }
                            }
                            if (!flag3) {
                                throw new Exception("第" + (i + 1) + "行,第" + (j + 1)
                                        + "列费率分母值不对");
                            }
                            break;

                        case "mode":
                            boolean flag4= false;
                            for (int k = 0; k < ModelMaps.length; k++) {
                                if (ModelMaps[k].equals(value)) {
                                    salesPriceRate.setMode(ModelMapEns[k]);
                                    flag4 = true;
                                    break;
                                }
                            }
                            if (!flag4) {
                                throw new Exception("第" + (i + 1) + "行,第" + (j + 1)
                                        + "列费率配置模式值不对");
                            }
                            break;

                        case "expression":
                            boolean flag5= false;
                            for (int k = 0; k < ExpressionMaps.length; k++) {
                                if (ExpressionMaps[k].equals(value)) {
                                    salesPriceRate.setExpression(ExpressionMapEns[k]);
                                    flag5 = true;
                                    break;
                                }
                            }
                            if (!flag5) {
                                throw new Exception("第" + (i + 1) + "行,第" + (j + 1)
                                        + "列费率表达式值不对");
                            }
                            break;

                        case "remark":
                            // value = value.substring(0, value.length() - 2);
                            salesPriceRate.setRemark(value);
                            break;
                    }

                }
                //进行查询，将之前存在的版本去除，然后在加新的版本
                SalesPriceRateQueryVo salesPriceRateQueryVo=new SalesPriceRateQueryVo(salesPriceRate.getStoreCode(),salesPriceRate.getStoreId(),salesPriceRate.getOrganizationId());
                List<SalesPriceRateDto> salesPriceRateList=salesPriceRateApi.getSalesPriceRate(salesPriceRateQueryVo);


                for(SalesPriceRateDto salesPrice:salesPriceRateList){
                    salesPrice.setEnabled(false);
                    salesPrice.setIsDelete(true);
                    salesPriceRatesTemp.add(salesPrice);
                }
                salesPriceRates.add(salesPriceRate);
            }
        } else {
            message = "格式不对,请重新下载模版";
        }
        wb.close();
        if (message != null & !"".equals(message)) {
            throw new Exception(message);
        }

        if (salesPriceRates.size() > 0) {
            salesPriceRateApi.saveSalesPriceRateList(salesPriceRatesTemp);//去除就版本
            salesPriceRateApi.saveSalesPriceRateList(salesPriceRates);

        } else {
            throw new Exception("数据为空，保存失败");
        }
    }


}
