package ctscore.web.service.login;

import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import member.api.CoreUserApi;
import member.api.LoginApi;
import member.api.MemberApi;
import member.api.PeripheryApi;
import member.api.dto.core.CoreUserDto;
import member.api.dto.shop.MemberDto;
import member.api.vo.MemberVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import utils.GlobalContants;
import utils.Lang;

import javax.servlet.http.HttpServletRequest;


/**
 * Created by xiaoqian on 2016/10/20.
 */
@Component
public class LoginService {

    @MotanReferer(basicReferer = "motanClientBasicConfig")
    LoginApi loginApi;
    @MotanReferer
    MemberApi memberApi;
    @MotanReferer
    PeripheryApi peripheryApi;
    @MotanReferer
    CoreUserApi coreUserApi;
    @Value("${ctscore.orgCode}")
    private String organizationCode;//机构code值

    public CoreUserDto findById(String id) {
        return loginApi.findById(id);
    }

    public MemberDto findByCoreUser(CoreUserDto coreUser) {
        return loginApi.findByCoreUser(coreUser);
    }

    public CoreUserDto updateCoreUser(CoreUserDto coreUser) {
        return loginApi.updateCoreUser(coreUser);
    }

    public MemberDto updateMember(MemberDto member) {
        return loginApi.updateMember(member);
    }

    public String encryptPasswd(String orginPasswd) {
        return loginApi.encryptPasswd(orginPasswd);
    }

    public MemberVo loadMemberVo(CoreUserDto coreUser) {
        return loginApi.loadMemberVo(coreUser);
    }

    public CoreUserDto findByPhoneAndOrganizationIdAndUserType(String account, String id, String userTypeMember, boolean b) {
        return loginApi.findByPhoneAndOrganizationIdAndUserType(account, id, userTypeMember, b);
    }

    public CoreUserDto findByEmailAndOrganizationIdAndUserType(String account, String id, String userTypeMember, boolean b) {
        return loginApi.findByEmailAndOrganizationIdAndUserType(account, id, userTypeMember, b);
    }

    public CoreUserDto findByUsernameAndIsDeleteAndOrganizationIdAndUserType(String account, boolean b, String id, String userTypeMember) {
        return loginApi.findByUsernameAndIsDeleteAndOrganizationIdAndUserType(account, b, id, userTypeMember);
    }


    /**
     * 获取用户信息
     *
     * @param request
     * @return
     */
    public MemberVo findMemberVo(HttpServletRequest request) {
        String memberId = (String) request.getSession().getAttribute(GlobalContants.SESSION_MEMBER_ID_ITAIPING);
        String userId = (String) request.getSession().getAttribute(GlobalContants.SESSION_USER_ID_ITAIPING);

        /** 优先使用memberID获取 */
        MemberVo memberVo = null;
        if (StringUtils.isNotBlank(memberId)) {
            System.out.println("memberId" + memberId);
            memberVo = memberApi.getMemberInfo(memberId);
        } else if (StringUtils.isNotBlank(userId)) {
            System.out.println("userId" + userId);
            memberVo = memberApi.getMemberInfoByUserId(userId);

        }

        /** 开发用： 当前未登录用户直接获取测试用户数据 */
        //  memberVo = memberVo == null ? memberApi.getMemberInfo("27d23064-9b2a-4bd9-ba63-6174a041e671") : memberVo;

        return memberVo;
    }

    public boolean saveInfotoSession(HttpServletRequest request, MemberVo memberVo) {
        request.getSession().invalidate();
        request.getSession().setAttribute(GlobalContants.SESSION_MEMBER_ID_ITAIPING, memberVo.getMember().getId());
        request.getSession().setAttribute(GlobalContants.SESSION_USER_ID_ITAIPING, memberVo.getUser().getId());
        if (!Lang.isEmpty(memberVo.getUser().getUsername())) {
            request.getSession().setAttribute(GlobalContants.SESSION_USER_NAME_ITAIPING, memberVo.getUser().getUsername());
        } else if (!Lang.isEmpty(memberVo.getUser().getPhone())) {
            request.getSession().setAttribute(GlobalContants.SESSION_USER_NAME_ITAIPING, memberVo.getUser().getPhone());
        } else if (!Lang.isEmpty(memberVo.getUser().getEmail())) {
            request.getSession().setAttribute(GlobalContants.SESSION_USER_NAME_ITAIPING, memberVo.getUser().getEmail());
        }
        request.getSession().setAttribute(GlobalContants.SESSION_MEMBER_VO_JSON_ITAIPING, JSON.toJSONString(memberVo));

        MemberDto member = memberVo.getMember();
        CoreUserDto coreUser = memberVo.getUser();
        request.getSession().setAttribute(GlobalContants.SESSION_MEMBER_JSON_ITAIPING, JSON.toJSONString(member));
        request.getSession().setAttribute(GlobalContants.SESSION_USER_JSON_ITAIPING, JSON.toJSONString(coreUser));


        Boolean isAdmin = memberVo.getMember().getAdmin();
        if (!Lang.isEmpty(isAdmin)) {
            request.getSession().setAttribute(GlobalContants.SESSION_MEMBER_ROLE_ITAIPING, isAdmin);
        } else {
            request.getSession().setAttribute(GlobalContants.SESSION_MEMBER_ROLE_ITAIPING, false);
        }
        return true;
    }


    public CoreUserDto changeUserInfo(CoreUserDto coreUser, CoreUserDto incomeCoreUser) {
        if (incomeCoreUser.getUsername() != null && !incomeCoreUser.getUsername().equals(coreUser.getUsername())
                || incomeCoreUser.getPhone() != null && !incomeCoreUser.getPhone().equals(coreUser.getPhone())
                || incomeCoreUser.getEmail() != null && !incomeCoreUser.getEmail().equals(coreUser.getEmail())) {
            return coreUserApi.updateUserInfo(incomeCoreUser);
        }
        return coreUser;
    }

    public void removeLoginAttr(HttpServletRequest request) {
        request.getSession().removeAttribute(GlobalContants.SESSION_MEMBER_ID_ITAIPING);
        request.getSession().removeAttribute(GlobalContants.PERIPHERY_THIRD_USER_ID);
        request.getSession().removeAttribute(GlobalContants.SESSION_USER_ID_ITAIPING);
        request.getSession().removeAttribute(GlobalContants.SESSION_USER_NAME_ITAIPING);
        request.getSession().removeAttribute(GlobalContants.SESSION_MEMBER_VO_JSON_ITAIPING);
        request.getSession().removeAttribute(GlobalContants.SESSION_USER_NAME_LOGOUT_ITAIPING);
    }

    public CoreUserDto getSessionCoreUser(HttpServletRequest request) {
        Object coreUserObj = request.getSession().getAttribute(GlobalContants.SESSION_USER_JSON_ITAIPING);
        return JSON.parseObject(coreUserObj.toString(), CoreUserDto.class);
    }
}
