package ctscore.web.service.member;

import lombok.extern.slf4j.Slf4j;
import member.api.dto.core.CoreUserDto;
import member.api.dto.shop.MemberDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import score.model.ScoreAccount;
import score.model.repository.ScoreAccountRepos;
import utils.Lang;

import java.util.List;
import java.util.Map;


/**
 * @author Drury
 * @date 2018/4/3
 */
@Slf4j
@Service
@Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = Exception.class)
public class MemberBatchTransactionalService {

    @Autowired
    ScoreAccountRepos scoreAccountRepos;

    /**
     * 更新积分账号信息若 ScoreAccount 的 nickName 或 phone 或 email 数据需要更新
     *
     * @param scoreAccountPOs List<ScoreAccount>
     * @param memberDTOMap Map<String, MemberDto> key = coreUserId, value = memberDTO
     */
    public void updateScoreAccountIfNeed(List<ScoreAccount> scoreAccountPOs, Map<String, MemberDto> memberDTOMap) {
        try {
            scoreAccountPOs.forEach(scoreAccountPO -> {
                String userId = scoreAccountPO.getUserId();
                if(!Lang.isEmpty(userId)) {
                    MemberDto memberDTO = memberDTOMap.get(userId);
                    CoreUserDto coreUserDTO = memberDTO.getCoreUser();
                    String nickName = memberDTO.getRealName();
                    String phone = coreUserDTO.getPhone();
                    String email = coreUserDTO.getEmail();
                    boolean update = false;
                    if(!Lang.isEmpty(nickName) && !nickName.equals(scoreAccountPO.getNickName())) {
                        update = true;
                        scoreAccountPO.setNickName(nickName);
                    }
                    if(!Lang.isEmpty(phone) && !phone.equals(scoreAccountPO.getPhone())) {
                        update = true;
                        scoreAccountPO.setPhone(phone);
                    }
                    if(!Lang.isEmpty(email) && !email.equals(scoreAccountPO.getEmail())) {
                        update = true;
                        scoreAccountPO.setEmail(email);
                    }
                    if(update) {
                        log.info("更新积分账号 UserId : {}", scoreAccountPO.getUserId());
                        scoreAccountRepos.saveAndFlush(scoreAccountPO);
                    }
                }
            });
        } catch (Exception e) {
            log.error("更新积分账号信息异常", e);
            throw e;
        }
    }
}
