package ctscore.web.service.member;

import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import member.api.LoginApi;
import member.api.dto.core.CoreUserDto;
import member.api.dto.shop.MemberDto;
import member.api.vo.MemberVo;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import utils.GlobalContants;

import javax.servlet.http.HttpServletRequest;


/**
 * Created by xiaoqian on 2016/10/20.
 */
@Component
public class MemberLoginService {

    @MotanReferer(basicReferer = "motanClientBasicConfig")
    LoginApi loginApi;

    public MemberVo loginUsingPassword(String username, String email,  String phone,  String password,String remoteIp) {
        MemberDto member =new MemberDto();
        MemberDto member1 =new MemberDto();
        if(StringUtils.hasText(username)){
            return loginApi.checkByUsername(username,password,remoteIp);
        }else if(StringUtils.hasText(email)){
            return loginApi.checkByEmail(email, password,remoteIp);
        }else if(StringUtils.hasText(phone)){
            return loginApi.checkByPhone(phone,password,remoteIp);
        }
        return null;
    }

    public boolean saveInfotoSession(HttpServletRequest request, MemberVo memberVo) {
        request.getSession().setAttribute(GlobalContants.SESSION_MEMBER_ID_ITAIPING,memberVo.getMember().getId());
        request.getSession().setAttribute(GlobalContants.SESSION_USER_ID_ITAIPING,memberVo.getUser().getId());
        request.getSession().setAttribute(GlobalContants.SESSION_MEMBER_VO_JSON_ITAIPING, JSON.toJSONString(memberVo));
        return true;
    }

    public MemberVo loginUsingSms(String phone, String smsCheckCode) {
        return loginApi.loginBySms(phone,smsCheckCode);
    }




    public CoreUserDto findById(String  id){
        return loginApi.findById(id);
    }



    public MemberDto findByCoreUser(CoreUserDto coreUser){
        return loginApi.findByCoreUser(coreUser);
    }

    public CoreUserDto updateCoreUser(CoreUserDto coreUser){
        return loginApi.updateCoreUser(coreUser);
    }

    public MemberDto updateMember(MemberDto member){
        return loginApi.updateMember(member);
    }

    public String encryptPasswd(String orginPasswd){
        return loginApi.encryptPasswd(orginPasswd);
    }

    public MemberVo loadMemberVo(CoreUserDto coreUser){
        return loginApi.loadMemberVo(coreUser);
    }

}
