package ctscore.web.service.member;

import member.api.dto.core.CoreUserDto;
import score.api.dto.entitydto.ScoreAccountDTO;
import score.api.dto.requestdto.ScoreAccountRequestDTO;

import java.math.BigDecimal;

/**
 * @author ChenShengRong
 */
public interface ScoreUserService {

    /**
     * 根据商城用户获取积分用户请求dto
     * @param coreUser CoreUserDto
     * @return ScoreAccountRequestDTO
     */
    ScoreAccountRequestDTO getScoreAccountRequestDto(CoreUserDto coreUser);

    BigDecimal getUsebleScore(CoreUserDto coreUser);

    ScoreAccountDTO getScoreAccount(CoreUserDto coreUser);

    /**
     * 诚通积分位数控制
     *
     * @param score BigDecimal
     * @return BigDecimal
     */
    BigDecimal roundScore(BigDecimal score);
}
