package ctscore.web.service.member;

import aftersale.api.DiscussApi;
import aftersale.api.dto.DiscussDto;
import cart.api.CartApi;
import cart.api.OrderMainApi;
import cms.api.OrganizationApi;
import cms.api.dto.OrganizationDto;
import com.alibaba.fastjson.JSONObject;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import ctscore.web.vo.EvaluateVo;
import member.api.*;
import member.api.dto.core.CoreUserDto;
import member.api.dto.shop.MemberCreditsTranDto;
import member.api.dto.shop.MemberDto;
import member.api.dto.shop.MemberViewHisDto;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import utils.sql.PageVo;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by DRAGON on 2016/12/5.
 */
@Component
public class UserCenterService {

    @MotanReferer(basicReferer = "motanClientBasicConfig")
    MemberAddressApi memberAddressApi;

    @MotanReferer(basicReferer = "motanClientBasicConfig")
    MemberCreditsTranApi memberCreditsTranApi;

    @MotanReferer(basicReferer = "motanClientBasicConfig")
    CoreUserApi coreUserApi;

    @MotanReferer(basicReferer = "motanClientBasicConfig")
    MemberApi memberApi;

    @MotanReferer(basicReferer = "motanClientBasicConfig")
    OrganizationApi organizationApi;

    @MotanReferer(basicReferer = "motanClientBasicConfig")
    OrderMainApi orderMainApi;

    @MotanReferer(basicReferer = "motanClientBasicConfig")
    CartApi cartApi;

    @MotanReferer(basicReferer = "motanClientBasicConfig")
    ViewHistoryApi viewHistoryApi;

    @MotanReferer(basicReferer = "motanClientBasicConfig")
    DiscussApi discussApi;


    //获取会员地址
    public List<member.api.dto.shop.MemberAddressDto> getMyMemberAddress(String memberId){
        return  memberAddressApi.list(memberId);
    }


    public MemberDto findMenberById(String id){
       return memberApi.findMemberById(id);
    }

    public MemberDto getMemberInfoByCoreUser(CoreUserDto coreUser){
        return memberApi.getMemberInfoByCoreUser(coreUser);
    }

    public CoreUserDto findByPhoneOrEmail(String userLoginId, String organizationId){
        return coreUserApi.findByPhoneOrEmail(userLoginId, organizationId);
    }

    /**
     * 设置会员默认地址
     * @param memberId
     * @param addressId
     * @return
     */
    public member.api.dto.shop.MemberAddressDto setDefaultAddress(String memberId, String addressId){
        return memberAddressApi.setDefaultAddress(memberId,addressId);
    }

    /**
     * 删除地址ID
     * @param addressId
     * @return
     */
    public Boolean deleteAddressById(String addressId){
        return memberAddressApi.delete(addressId);
    }

    /**
     * 添加默认地址
     * @param address
     * @return
     */
    public member.api.dto.shop.MemberAddressDto addMemberAddress(member.api.dto.shop.MemberAddressDto address){
        return memberAddressApi.saveOrUpdateAddress(address);
    }

    public MemberCreditsTranDto findMemberCreditsTranById(String id){
        return memberCreditsTranApi.findMemberCreditsTranById(id);
    }

    public PageVo findMemberPageByUserIdAndName(int pageSize, int pageNum, String userId, String searchLoginId, String memberName, String organizationId){
        return memberApi.findMemberPageByUserIdAndName(pageSize,pageNum,userId,searchLoginId,memberName, organizationId);
    }

    public JSONObject findUserCenterOrders(String orderNo, List<String> status, String memberId, Date startDate, Date endDate, Pageable pageable){
        return orderMainApi.findUserCenterOrders(orderNo,status,memberId,startDate,endDate,pageable);
    }

    public JSONObject findOrderDetailByOrderNo(String orderNo,String memberId){
        return orderMainApi.findOrderDetail(orderNo,memberId);
    }

    public JSONObject findOrderItemsPageByOrderNo(Pageable pageable, String orderNo){
        return orderMainApi.findOrderItemsPageByOrderNo(pageable,orderNo);
    }

    public JSONObject findDisscussByOrderNo(String orderNo){
        return orderMainApi.findDisscussByOrderNo(orderNo);
    }


    public List<MemberViewHisDto> getViewHisByMemberId(String memberId){
        return viewHistoryApi.getViewHisByMemberId(memberId);
    }

    public void clearFootPrints(List<MemberViewHisDto> list){
        viewHistoryApi.clearFootPrints(list);
    }


    public Boolean saveDisscuccs(EvaluateVo[] evaluateVos, String memberId, String organizationId, String realName) {

        List<DiscussDto> discussList = new ArrayList<DiscussDto>();
        DiscussDto discuss = null;
        EvaluateVo eva  = null;
        for (int i = 0 ; i < evaluateVos.length ; i++){
            discuss = new DiscussDto();
            eva  = evaluateVos[i];
            discuss.setOrganizationId(organizationId);
            discuss.setMemberId(memberId);
            discuss.setStoreId(eva.getStoreId());
            discuss.setProductId(eva.getProductId());
            discuss.setProductName(eva.getProductName());
            discuss.setOrderItemId(eva.getOrderItemId());
            discuss.setGoodsId(eva.getGoodsId());
            discuss.setType(eva.getType());
            discuss.setDiscussPerson(realName);
            discuss.setOrderNo(eva.getOrderNo());
            discuss.setProductName(eva.getProductName());
            discuss.setContent(eva.getContent());
            String marks = eva.getMarks();
            if (marks == null || marks.equals("")){
                marks = "0";
            }
            int startLevel = Integer.parseInt(marks);
            discuss.setStarLevel(startLevel);

            discussList.add(discuss);
        }

        return discussApi.saveDisscuccs(discussList);
    }
}
