package ctscore.web.service.member.impl;

import cms.api.OrganizationApi;
import cms.api.dto.OrganizationDto;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import ctscore.web.service.member.ScoreUserService;
import member.api.dto.core.CoreUserDto;
import org.springframework.stereotype.Service;
import score.api.ScoreApi;
import score.api.dto.entitydto.ScoreAccountDTO;
import score.api.dto.requestdto.ScoreAccountRequestDTO;
import utils.Lang;

import java.math.BigDecimal;

@Service
public class ScoreUserServiceImpl implements ScoreUserService {

    @MotanReferer
    OrganizationApi organizationApi;
    @MotanReferer
    ScoreApi scoreApi;

    @Override
    public ScoreAccountRequestDTO getScoreAccountRequestDto(CoreUserDto coreUser) {
        String organizationCode = organizationApi.findOrganizationCodeById(coreUser.getOrganizationId());
        return new ScoreAccountRequestDTO(organizationCode, coreUser.getId(), coreUser.getPhone(), coreUser.getEmail());
    }

    @Override
    public BigDecimal getUsebleScore(CoreUserDto coreUser) {
        ScoreAccountDTO scoreAccountDTO = getScoreAccount(coreUser);
        return roundScore(scoreAccountDTO.getIncomeScoreVal().subtract(scoreAccountDTO.getExpendedScoreVal()));
    }

    @Override
    public ScoreAccountDTO getScoreAccount(CoreUserDto coreUser) {
        return scoreApi.queryScoreAccount(getScoreAccountRequestDto(coreUser));
    }

    @Override
    public BigDecimal roundScore(BigDecimal score) {
        if (!Lang.isEmpty(score)) {
            return score.setScale(2, BigDecimal.ROUND_HALF_UP);
        }
        return new BigDecimal("0.00").setScale(2, BigDecimal.ROUND_HALF_UP);
    }
}
